/*
 * Decompiled with CFR 0.152.
 */
package android.util;

public class TypedValue {
    public static final int TYPE_NULL = 0;
    public static final int TYPE_REFERENCE = 1;
    public static final int TYPE_ATTRIBUTE = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_DIMENSION = 5;
    public static final int TYPE_FRACTION = 6;
    public static final int TYPE_DYNAMIC_REFERENCE = 7;
    public static final int TYPE_DYNAMIC_ATTRIBUTE = 8;
    public static final int TYPE_FIRST_INT = 16;
    public static final int TYPE_INT_DEC = 16;
    public static final int TYPE_INT_HEX = 17;
    public static final int TYPE_INT_BOOLEAN = 18;
    public static final int TYPE_FIRST_COLOR_INT = 28;
    public static final int TYPE_INT_COLOR_ARGB8 = 28;
    public static final int TYPE_INT_COLOR_RGB8 = 29;
    public static final int TYPE_INT_COLOR_ARGB4 = 30;
    public static final int TYPE_INT_COLOR_RGB4 = 31;
    public static final int TYPE_LAST_COLOR_INT = 31;
    public static final int TYPE_LAST_INT = 31;
    public static final int COMPLEX_UNIT_SHIFT = 0;
    public static final int COMPLEX_UNIT_MASK = 15;
    public static final int COMPLEX_UNIT_PX = 0;
    public static final int COMPLEX_UNIT_DIP = 1;
    public static final int COMPLEX_UNIT_SP = 2;
    public static final int COMPLEX_UNIT_PT = 3;
    public static final int COMPLEX_UNIT_IN = 4;
    public static final int COMPLEX_UNIT_MM = 5;
    public static final int COMPLEX_UNIT_FRACTION = 0;
    public static final int COMPLEX_UNIT_FRACTION_PARENT = 1;
    public static final int COMPLEX_RADIX_SHIFT = 4;
    public static final int COMPLEX_RADIX_MASK = 3;
    public static final int COMPLEX_RADIX_23p0 = 0;
    public static final int COMPLEX_RADIX_16p7 = 1;
    public static final int COMPLEX_RADIX_8p15 = 2;
    public static final int COMPLEX_RADIX_0p23 = 3;
    public static final int COMPLEX_MANTISSA_SHIFT = 8;
    public static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
    public static final int DATA_NULL_UNDEFINED = 0;
    public static final int DATA_NULL_EMPTY = 1;
    public static final int DENSITY_DEFAULT = 0;
    public static final int DENSITY_NONE = 65535;
    public int type;
    private static final float MANTISSA_MULT = 0.00390625f;
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};
    private static final String[] DIMENSION_UNIT_STRS = new String[]{"px", "dip", "sp", "pt", "in", "mm"};
    private static final String[] FRACTION_UNIT_STRS = new String[]{"%", "%p"};

    public static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }

    public static String coerceToString(int type, int data) {
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return "@" + data;
            }
            case 2: {
                return "?" + data;
            }
            case 4: {
                return Float.toString(Float.intBitsToFloat(data));
            }
            case 5: {
                return TypedValue.complexToFloat(data) + DIMENSION_UNIT_STRS[data >> 0 & 0xF];
            }
            case 6: {
                return TypedValue.complexToFloat(data) * 100.0f + FRACTION_UNIT_STRS[data >> 0 & 0xF];
            }
            case 17: {
                return String.format("0x%08X", data);
            }
            case 18: {
                return data != 0 ? "true" : "false";
            }
        }
        if (type >= 28 && type <= 31) {
            String res = String.format("%08x", data);
            char[] vals = res.toCharArray();
            switch (type) {
                default: {
                    break;
                }
                case 29: {
                    res = res.substring(2);
                    break;
                }
                case 30: {
                    res = String.valueOf(vals[0]) + vals[2] + vals[4] + vals[6];
                    break;
                }
                case 31: {
                    res = String.valueOf(vals[2]) + vals[4] + vals[6];
                }
            }
            return "#" + res;
        }
        if (type >= 16 && type <= 31) {
            String res = null;
            if (type == 16) {
                res = Integer.toString(data);
            }
            return res;
        }
        return null;
    }
}

