/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.apk;

import brut.androlib.ApktoolProperties;
import brut.androlib.apk.PackageInfo;
import brut.androlib.apk.UsesFramework;
import brut.androlib.apk.VersionInfo;
import brut.androlib.apk.YamlLine;
import brut.androlib.apk.YamlReader;
import brut.androlib.apk.YamlSerializable;
import brut.androlib.apk.YamlWriter;
import brut.androlib.exceptions.AndrolibException;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ApkInfo
implements YamlSerializable {
    public static final String[] RESOURCES_DIRNAMES = new String[]{"res", "r", "R"};
    public static final String[] RAW_DIRNAMES = new String[]{"assets", "lib"};
    public static final Pattern ORIGINAL_FILENAMES_PATTERN = Pattern.compile("AndroidManifest\\.xml|META-INF/[^/]+\\.(RSA|SF|MF)|stamp-cert-sha256");
    public static final Pattern STANDARD_FILENAMES_PATTERN = Pattern.compile("[^/]+\\.dex|resources\\.arsc|(" + String.join((CharSequence)"|", RESOURCES_DIRNAMES) + "|" + String.join((CharSequence)"|", RAW_DIRNAMES) + ")/.*|" + ORIGINAL_FILENAMES_PATTERN.pattern());
    private transient ExtFile mApkFile;
    public String version;
    public String apkFileName;
    public boolean isFrameworkApk;
    public UsesFramework usesFramework;
    public Map<String, String> sdkInfo = new LinkedHashMap<String, String>();
    public PackageInfo packageInfo = new PackageInfo();
    public VersionInfo versionInfo = new VersionInfo();
    public Map<String, Boolean> featureFlags = new LinkedHashMap<String, Boolean>();
    public boolean sharedLibrary;
    public boolean sparseResources;
    public boolean compactEntries;
    public List<String> doNotCompress = new ArrayList<String>();

    public ApkInfo() {
        this.version = ApktoolProperties.getVersion();
    }

    public ApkInfo(ExtFile apkFile) {
        this();
        this.setApkFile(apkFile);
    }

    public ExtFile getApkFile() {
        return this.mApkFile;
    }

    public void setApkFile(ExtFile apkFile) {
        this.mApkFile = apkFile;
        if (this.apkFileName == null) {
            this.apkFileName = apkFile.getName();
        }
    }

    public boolean hasSources() throws AndrolibException {
        if (this.mApkFile == null) {
            return false;
        }
        try {
            return this.mApkFile.getDirectory().containsFile("classes.dex");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasManifest() throws AndrolibException {
        if (this.mApkFile == null) {
            return false;
        }
        try {
            return this.mApkFile.getDirectory().containsFile("AndroidManifest.xml");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasResources() throws AndrolibException {
        if (this.mApkFile == null) {
            return false;
        }
        try {
            return this.mApkFile.getDirectory().containsFile("resources.arsc");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public String checkTargetSdkVersionBounds() {
        int target = this.mapSdkShorthandToVersion(this.getTargetSdkVersion());
        int min2 = this.getMinSdkVersion() != null ? this.mapSdkShorthandToVersion(this.getMinSdkVersion()) : 0;
        int max = this.getMaxSdkVersion() != null ? this.mapSdkShorthandToVersion(this.getMaxSdkVersion()) : target;
        return Integer.toString(Math.max(min2, Math.min(max, target)));
    }

    public String getMinSdkVersion() {
        return this.sdkInfo.get("minSdkVersion");
    }

    public void setMinSdkVersion(String minSdkVersion) {
        this.sdkInfo.put("minSdkVersion", minSdkVersion);
    }

    public String getMaxSdkVersion() {
        return this.sdkInfo.get("maxSdkVersion");
    }

    public void setMaxSdkVersion(String maxSdkVersion) {
        this.sdkInfo.put("maxSdkVersion", maxSdkVersion);
    }

    public String getTargetSdkVersion() {
        return this.sdkInfo.get("targetSdkVersion");
    }

    public void setTargetSdkVersion(String targetSdkVersion) {
        this.sdkInfo.put("targetSdkVersion", targetSdkVersion);
    }

    public int getMinSdkVersionFromAndroidCodename(String sdkVersion) {
        int sdkNumber = this.mapSdkShorthandToVersion(sdkVersion);
        if (sdkNumber == 1) {
            return Integer.parseInt(this.getMinSdkVersion());
        }
        return sdkNumber;
    }

    private int mapSdkShorthandToVersion(String sdkVersion) {
        switch (sdkVersion.toUpperCase()) {
            case "M": {
                return 23;
            }
            case "N": {
                return 24;
            }
            case "O": {
                return 26;
            }
            case "P": {
                return 28;
            }
            case "Q": {
                return 29;
            }
            case "R": {
                return 30;
            }
            case "S": {
                return 31;
            }
            case "SV2": {
                return 32;
            }
            case "T": 
            case "TIRAMISU": {
                return 33;
            }
            case "UPSIDEDOWNCAKE": 
            case "UPSIDE_DOWN_CAKE": {
                return 34;
            }
            case "VANILLAICECREAM": 
            case "VANILLA_ICE_CREAM": {
                return 35;
            }
            case "BAKLAVA": {
                return 36;
            }
            case "SDK_CUR_DEVELOPMENT": {
                return 10000;
            }
        }
        return Integer.parseInt(sdkVersion);
    }

    public void addFeatureFlag(String flag, boolean value) {
        this.featureFlags.put(flag, value);
    }

    public void save(File file) throws AndrolibException {
        try (YamlWriter writer = new YamlWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            this.write(writer);
        }
        catch (FileNotFoundException ex) {
            throw new AndrolibException("File not found");
        }
        catch (Exception ex) {
            throw new AndrolibException(ex);
        }
    }

    public static ApkInfo load(InputStream in) throws AndrolibException {
        YamlReader reader = new YamlReader(in);
        ApkInfo apkInfo = new ApkInfo();
        reader.readRoot(apkInfo);
        return apkInfo;
    }

    public static ApkInfo load(ExtFile apkDir) throws AndrolibException {
        ApkInfo apkInfo;
        block8: {
            InputStream in = apkDir.getDirectory().getFileInput("apktool.yml");
            try {
                ApkInfo apkInfo2 = ApkInfo.load(in);
                apkInfo2.setApkFile(apkDir);
                apkInfo = apkInfo2;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DirectoryException | IOException ex) {
                    throw new AndrolibException(ex);
                }
            }
            in.close();
        }
        return apkInfo;
    }

    @Override
    public void readItem(YamlReader reader) throws AndrolibException {
        YamlLine line = reader.getLine();
        switch (line.getKey()) {
            case "version": {
                this.version = line.getValue();
                break;
            }
            case "apkFileName": {
                this.apkFileName = line.getValue();
                break;
            }
            case "isFrameworkApk": {
                this.isFrameworkApk = line.getValueBool();
                break;
            }
            case "usesFramework": {
                this.usesFramework = new UsesFramework();
                reader.readObject(this.usesFramework);
                break;
            }
            case "sdkInfo": {
                this.sdkInfo.clear();
                reader.readStringMap(this.sdkInfo);
                break;
            }
            case "packageInfo": {
                this.packageInfo = new PackageInfo();
                reader.readObject(this.packageInfo);
                break;
            }
            case "versionInfo": {
                this.versionInfo = new VersionInfo();
                reader.readObject(this.versionInfo);
                break;
            }
            case "featureFlags": {
                this.featureFlags.clear();
                reader.readBoolMap(this.featureFlags);
                break;
            }
            case "sharedLibrary": {
                this.sharedLibrary = line.getValueBool();
                break;
            }
            case "sparseResources": {
                this.sparseResources = line.getValueBool();
                break;
            }
            case "compactEntries": {
                this.compactEntries = line.getValueBool();
                break;
            }
            case "doNotCompress": {
                this.doNotCompress.clear();
                reader.readStringList(this.doNotCompress);
            }
        }
    }

    @Override
    public void write(YamlWriter writer) {
        writer.writeString("version", this.version);
        writer.writeString("apkFileName", this.apkFileName);
        writer.writeBool("isFrameworkApk", this.isFrameworkApk);
        writer.writeObject("usesFramework", this.usesFramework);
        writer.writeMap("sdkInfo", this.sdkInfo);
        writer.writeObject("packageInfo", this.packageInfo);
        writer.writeObject("versionInfo", this.versionInfo);
        if (!this.featureFlags.isEmpty()) {
            writer.writeMap("featureFlags", this.featureFlags);
        }
        writer.writeBool("sharedLibrary", this.sharedLibrary);
        writer.writeBool("sparseResources", this.sparseResources);
        writer.writeBool("compactEntries", this.compactEntries);
        if (!this.doNotCompress.isEmpty()) {
            writer.writeList("doNotCompress", this.doNotCompress);
        }
    }
}

