/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.Config;
import brut.androlib.apk.ApkInfo;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.CantFindFrameworkResException;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.arsc.ARSCData;
import brut.androlib.res.data.arsc.FlagsOffset;
import brut.androlib.res.decoder.ARSCDecoder;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Framework {
    private static final Logger LOGGER = Logger.getLogger(Framework.class.getName());
    private final Config mConfig;
    private File mDirectory;

    public Framework(Config config) {
        this.mConfig = config;
    }

    public void install(File frameFile) throws AndrolibException {
        this.install(frameFile, this.mConfig.getFrameworkTag());
    }

    public void install(File frameFile, String tag) throws AndrolibException {
        try (ZipFile zip = new ZipFile(frameFile);){
            ZipEntry entry = zip.getEntry("resources.arsc");
            if (entry == null) {
                throw new AndrolibException("Could not find resources.arsc file");
            }
            byte[] data = BrutIO.readAndClose(zip.getInputStream(entry));
            ResTable resTable = new ResTable(new ApkInfo(), this.mConfig);
            ARSCDecoder decoder = new ARSCDecoder(new ByteArrayInputStream(data), resTable, true, true);
            ARSCData arsc = decoder.decode();
            this.publicizeResources(data, arsc.getFlagsOffsets());
            File outFile = new File(this.getDirectory(), arsc.getOnePackage().getId() + (tag != null ? "-" + tag : "") + ".apk");
            try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));){
                out.setMethod(0);
                CRC32 crc = new CRC32();
                crc.update(data);
                entry = new ZipEntry("resources.arsc");
                entry.setSize(data.length);
                entry.setMethod(0);
                entry.setCrc(crc.getValue());
                out.putNextEntry(entry);
                out.write(data);
                out.closeEntry();
                entry = zip.getEntry("AndroidManifest.xml");
                if (entry != null) {
                    byte[] manifest = BrutIO.readAndClose(zip.getInputStream(entry));
                    CRC32 manifestCrc = new CRC32();
                    manifestCrc.update(manifest);
                    entry.setSize(manifest.length);
                    entry.setCompressedSize(-1L);
                    entry.setCrc(manifestCrc.getValue());
                    out.putNextEntry(entry);
                    out.write(manifest);
                    out.closeEntry();
                }
            }
            LOGGER.info("Framework installed to: " + outFile);
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void listDirectory() throws AndrolibException {
        File dir = this.getDirectory();
        if (dir == null) {
            LOGGER.severe("No framework directory found. Nothing to list.");
            return;
        }
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".apk")) continue;
            LOGGER.info(file.getName());
        }
    }

    public void publicizeResources(File arscFile) throws AndrolibException {
        byte[] data = new byte[(int)arscFile.length()];
        try (InputStream in = Files.newInputStream(arscFile.toPath(), new OpenOption[0]);
             OutputStream out = Files.newOutputStream(arscFile.toPath(), new OpenOption[0]);){
            in.read(data);
            this.publicizeResources(data);
            out.write(data);
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void publicizeResources(byte[] data) throws AndrolibException {
        ResTable resTable = new ResTable(new ApkInfo(), this.mConfig);
        ARSCDecoder decoder = new ARSCDecoder(new ByteArrayInputStream(data), resTable, true, true);
        ARSCData arsc = decoder.decode();
        this.publicizeResources(data, arsc.getFlagsOffsets());
    }

    public void publicizeResources(byte[] data, FlagsOffset[] flagsOffsets) {
        for (FlagsOffset flags : flagsOffsets) {
            int offset;
            int end = offset + 4 * flags.count;
            for (offset = flags.offset + 3; offset < end; offset += 4) {
                int n = offset;
                data[n] = (byte)(data[n] | 0x40);
            }
        }
    }

    public File getDirectory() throws AndrolibException {
        if (this.mDirectory == null) {
            File dir = new File(this.mConfig.getFrameworkDirectory());
            if (dir.exists() && !dir.isDirectory()) {
                throw new AndrolibException("Framework path is not a directory: " + dir);
            }
            File parent = dir.getParentFile();
            if (parent != null && parent.exists() && !parent.isDirectory()) {
                throw new AndrolibException("Framework path's parent is not a directory: " + parent);
            }
            if (!dir.exists() && !dir.mkdirs()) {
                throw new AndrolibException("Could not create framework directory: " + dir);
            }
            this.mDirectory = dir;
        }
        return this.mDirectory;
    }

    public File getApkFile(int id, String frameTag) throws AndrolibException {
        File apk;
        File dir = this.getDirectory();
        if (frameTag != null && (apk = new File(dir, id + "-" + frameTag + ".apk")).exists()) {
            return apk;
        }
        apk = new File(dir, id + ".apk");
        if (apk.exists()) {
            return apk;
        }
        if (id == 1) {
            try {
                BrutIO.copyAndClose(this.getAndroidFrameworkAsStream(), Files.newOutputStream(apk.toPath(), new OpenOption[0]));
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
            return apk;
        }
        throw new CantFindFrameworkResException(id);
    }

    private InputStream getAndroidFrameworkAsStream() {
        return this.getClass().getResourceAsStream("/prebuilt/android-framework.jar");
    }

    public void emptyDirectory() throws AndrolibException {
        File dir = this.getDirectory();
        File apk = new File(dir, "1.apk");
        if (!apk.exists()) {
            LOGGER.warning("Could not empty framework directory, no file found at: " + apk);
            return;
        }
        File[] files = dir.listFiles();
        if (apk.exists() && files.length > 1 && !this.mConfig.isForceDeleteFramework()) {
            LOGGER.warning("More than default framework detected. Please run command with `--force` parameter to wipe framework directory.");
            return;
        }
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".apk")) continue;
            LOGGER.info("Removing framework file: " + file.getName());
            OS.rmfile(file);
        }
    }
}

