/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.ResTypeSpec;
import brut.androlib.res.data.ResValuesFile;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResValueFactory;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Pair;

public class ResPackage {
    private static final Logger LOGGER = Logger.getLogger(ResPackage.class.getName());
    private final ResTable mResTable;
    private final int mId;
    private final String mName;
    private final Map<ResID, ResResSpec> mResSpecs;
    private final Map<ResConfigFlags, ResType> mConfigs;
    private final Map<String, ResTypeSpec> mTypes;
    private final Set<ResID> mSynthesizedRes;
    private ResValueFactory mValueFactory;

    public ResPackage(ResTable resTable, int id, String name) {
        this.mResTable = resTable;
        this.mId = id;
        this.mName = name;
        this.mResSpecs = new LinkedHashMap<ResID, ResResSpec>();
        this.mConfigs = new LinkedHashMap<ResConfigFlags, ResType>();
        this.mTypes = new LinkedHashMap<String, ResTypeSpec>();
        this.mSynthesizedRes = new HashSet<ResID>();
    }

    public Config getConfig() {
        return this.mResTable.getConfig();
    }

    public List<ResResSpec> listResSpecs() {
        return new ArrayList<ResResSpec>(this.mResSpecs.values());
    }

    public boolean hasResSpec(ResID resId) {
        return this.mResSpecs.containsKey(resId);
    }

    public ResResSpec getResSpec(ResID resId) throws UndefinedResObjectException {
        ResResSpec spec = this.mResSpecs.get(resId);
        if (spec == null) {
            throw new UndefinedResObjectException("resource spec: " + resId);
        }
        return spec;
    }

    public int getResSpecCount() {
        return this.mResSpecs.size();
    }

    public ResType getOrCreateConfig(ResConfigFlags flags) {
        ResType config = this.mConfigs.get(flags);
        if (config == null) {
            config = new ResType(flags);
            this.mConfigs.put(flags, config);
        }
        return config;
    }

    public ResTypeSpec getType(String typeName) throws AndrolibException {
        ResTypeSpec type = this.mTypes.get(typeName);
        if (type == null) {
            throw new UndefinedResObjectException("type: " + typeName);
        }
        return type;
    }

    public Collection<ResResource> listFiles() {
        HashSet<ResResource> ret = new HashSet<ResResource>();
        for (ResResSpec spec : this.mResSpecs.values()) {
            for (ResResource res : spec.listResources()) {
                if (!(res.getValue() instanceof ResFileValue)) continue;
                ret.add(res);
            }
        }
        return ret;
    }

    public Collection<ResValuesFile> listValuesFiles() {
        HashMap<Pair<ResTypeSpec, ResType>, ResValuesFile> ret = new HashMap<Pair<ResTypeSpec, ResType>, ResValuesFile>();
        for (ResResSpec spec : this.mResSpecs.values()) {
            for (ResResource res : spec.listResources()) {
                ResType config;
                if (!(res.getValue() instanceof ResValuesXmlSerializable)) continue;
                ResTypeSpec type = res.getResSpec().getType();
                Pair<ResTypeSpec, ResType> key = Pair.of(type, config = res.getConfig());
                ResValuesFile values = (ResValuesFile)ret.get(key);
                if (values == null) {
                    values = new ResValuesFile(this, type, config);
                    ret.put(key, values);
                }
                values.addResource(res);
            }
        }
        return ret.values();
    }

    public ResTable getResTable() {
        return this.mResTable;
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    boolean isSynthesized(ResID resId) {
        return this.mSynthesizedRes.contains(resId);
    }

    public void addResSpec(ResResSpec spec) throws AndrolibException {
        if (this.mResSpecs.put(spec.getId(), spec) != null) {
            throw new AndrolibException("Multiple resource specs: " + spec);
        }
    }

    public void addType(ResTypeSpec type) {
        if (this.mTypes.containsKey(type.getName())) {
            LOGGER.warning("Multiple types detected! " + type + " ignored!");
        } else {
            this.mTypes.put(type.getName(), type);
        }
    }

    public void addSynthesizedRes(int resId) {
        this.mSynthesizedRes.add(new ResID(resId));
    }

    public String toString() {
        return this.mName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResPackage) {
            ResPackage other = (ResPackage)obj;
            return Objects.equals(this.mResTable, other.mResTable) && this.mId == other.mId;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mResTable, this.mId);
    }

    public ResValueFactory getValueFactory() {
        if (this.mValueFactory == null) {
            this.mValueFactory = new ResValueFactory(this);
        }
        return this.mValueFactory;
    }
}

