/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.BrutException;
import brut.util.Jar;
import brut.util.OS;
import brut.util.OSDetection;
import java.io.File;
import java.util.ArrayList;

public final class AaptManager {
    private AaptManager() {
    }

    public static String getAaptName(int version) {
        switch (version) {
            case 2: {
                return "aapt2";
            }
        }
        return "aapt";
    }

    public static File getAaptBinary(int version) throws BrutException {
        String aaptName = AaptManager.getAaptName(version);
        if (!OSDetection.is64Bit() && OSDetection.isMacOSX()) {
            throw new BrutException(aaptName + " binary is not available for 32-bit platform: " + OSDetection.returnOS());
        }
        StringBuilder aaptPath = new StringBuilder("/prebuilt/");
        if (OSDetection.isUnix()) {
            aaptPath.append("linux");
        } else if (OSDetection.isMacOSX()) {
            aaptPath.append("macosx");
        } else if (OSDetection.isWindows()) {
            aaptPath.append("windows");
        } else {
            throw new BrutException("Could not identify platform: " + OSDetection.returnOS());
        }
        aaptPath.append("/");
        aaptPath.append(aaptName);
        if (OSDetection.is64Bit()) {
            aaptPath.append("_64");
        }
        if (OSDetection.isWindows()) {
            aaptPath.append(".exe");
        }
        File aaptBinary = Jar.getResourceAsFile(AaptManager.class, aaptPath.toString());
        AaptManager.setAaptBinaryExecutable(aaptBinary);
        return aaptBinary;
    }

    public static int getAaptVersion(File aaptBinary) throws BrutException {
        AaptManager.setAaptBinaryExecutable(aaptBinary);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(aaptBinary.getPath());
        cmd.add("version");
        String versionStr = OS.execAndReturn(cmd.toArray(new String[0]));
        if (versionStr == null) {
            throw new BrutException("Could not execute aapt binary at location: " + aaptBinary.getPath());
        }
        return AaptManager.getAaptVersionFromString(versionStr);
    }

    public static int getAaptVersionFromString(String versionStr) throws BrutException {
        if (versionStr.startsWith("Android Asset Packaging Tool (aapt) 2:")) {
            return 2;
        }
        if (versionStr.startsWith("Android Asset Packaging Tool (aapt) 2.")) {
            return 2;
        }
        if (versionStr.startsWith("Android Asset Packaging Tool, v0.")) {
            return 1;
        }
        throw new BrutException("aapt version could not be identified: " + versionStr);
    }

    private static void setAaptBinaryExecutable(File aaptBinary) throws BrutException {
        if (!aaptBinary.isFile() || !aaptBinary.canRead()) {
            throw new BrutException("Could not read aapt binary: " + aaptBinary.getPath());
        }
        if (!aaptBinary.setExecutable(true)) {
            throw new BrutException("Could not set aapt binary as executable: " + aaptBinary.getPath());
        }
    }
}

