/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.antlr.misc.IntSet;
import org.antlr.misc.Interval;
import org.antlr.misc.Utils;
import org.antlr.runtime.BitSet;
import org.antlr.tool.Grammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalSet
implements IntSet {
    public static final IntervalSet COMPLETE_SET = IntervalSet.of(0, 65535);
    protected List<Interval> intervals;

    public IntervalSet() {
        this.intervals = new ArrayList<Interval>(2);
    }

    public IntervalSet(List<Interval> intervals) {
        this.intervals = intervals;
    }

    public static IntervalSet of(int a) {
        IntervalSet s2 = new IntervalSet();
        s2.add(a);
        return s2;
    }

    public static IntervalSet of(int a, int b) {
        IntervalSet s2 = new IntervalSet();
        s2.add(a, b);
        return s2;
    }

    @Override
    public void add(int el) {
        this.add(el, el);
    }

    public void add(int a, int b) {
        this.add(Interval.create(a, b));
    }

    protected void add(Interval addition) {
        if (addition.b < addition.a) {
            return;
        }
        ListIterator<Interval> iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval r = iter.next();
            if (addition.equals(r)) {
                return;
            }
            if (addition.adjacent(r) || !addition.disjoint(r)) {
                Interval next;
                Interval bigger = addition.union(r);
                iter.set(bigger);
                while (iter.hasNext() && (bigger.adjacent(next = iter.next()) || !bigger.disjoint(next))) {
                    iter.remove();
                    iter.previous();
                    iter.set(bigger.union(next));
                    iter.next();
                }
                return;
            }
            if (!addition.startsBeforeDisjoint(r)) continue;
            iter.previous();
            iter.add(addition);
            return;
        }
        this.intervals.add(addition);
    }

    @Override
    public void addAll(IntSet set) {
        if (set == null) {
            return;
        }
        if (!(set instanceof IntervalSet)) {
            throw new IllegalArgumentException("can't add non IntSet (" + set.getClass().getName() + ") to IntervalSet");
        }
        IntervalSet other = (IntervalSet)set;
        int n = other.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = other.intervals.get(i);
            this.add(I.a, I.b);
        }
    }

    public IntervalSet complement(int minElement, int maxElement) {
        return this.complement(IntervalSet.of(minElement, maxElement));
    }

    @Override
    public IntervalSet complement(IntSet vocabulary) {
        if (vocabulary == null) {
            return null;
        }
        if (!(vocabulary instanceof IntervalSet)) {
            throw new IllegalArgumentException("can't complement with non IntervalSet (" + vocabulary.getClass().getName() + ")");
        }
        IntervalSet vocabularyIS = (IntervalSet)vocabulary;
        int maxElement = vocabularyIS.getMaxElement();
        IntervalSet compl = new IntervalSet();
        int n = this.intervals.size();
        if (n == 0) {
            return compl;
        }
        Interval first = this.intervals.get(0);
        if (first.a > 0) {
            IntervalSet s2 = IntervalSet.of(0, first.a - 1);
            IntervalSet a = s2.and(vocabularyIS);
            compl.addAll(a);
        }
        for (int i = 1; i < n; ++i) {
            Interval previous = this.intervals.get(i - 1);
            Interval current = this.intervals.get(i);
            IntervalSet s3 = IntervalSet.of(previous.b + 1, current.a - 1);
            IntervalSet a = s3.and(vocabularyIS);
            compl.addAll(a);
        }
        Interval last = this.intervals.get(n - 1);
        if (last.b < maxElement) {
            IntervalSet s4 = IntervalSet.of(last.b + 1, maxElement);
            IntervalSet a = s4.and(vocabularyIS);
            compl.addAll(a);
        }
        return compl;
    }

    @Override
    public IntervalSet subtract(IntSet other) {
        return this.and(((IntervalSet)other).complement(COMPLETE_SET));
    }

    @Override
    public IntSet or(IntSet a) {
        IntervalSet o = new IntervalSet();
        o.addAll(this);
        o.addAll(a);
        return o;
    }

    @Override
    public IntervalSet and(IntSet other) {
        if (other == null) {
            return null;
        }
        List<Interval> myIntervals = this.intervals;
        List<Interval> theirIntervals = ((IntervalSet)other).intervals;
        IntervalSet intersection = null;
        int mySize = myIntervals.size();
        int theirSize = theirIntervals.size();
        int i = 0;
        int j = 0;
        while (i < mySize && j < theirSize) {
            Interval theirs;
            Interval mine = myIntervals.get(i);
            if (mine.startsBeforeDisjoint(theirs = theirIntervals.get(j))) {
                ++i;
                continue;
            }
            if (theirs.startsBeforeDisjoint(mine)) {
                ++j;
                continue;
            }
            if (mine.properlyContains(theirs)) {
                if (intersection == null) {
                    intersection = new IntervalSet();
                }
                intersection.add(mine.intersection(theirs));
                ++j;
                continue;
            }
            if (theirs.properlyContains(mine)) {
                if (intersection == null) {
                    intersection = new IntervalSet();
                }
                intersection.add(mine.intersection(theirs));
                ++i;
                continue;
            }
            if (mine.disjoint(theirs)) continue;
            if (intersection == null) {
                intersection = new IntervalSet();
            }
            intersection.add(mine.intersection(theirs));
            if (mine.startsAfterNonDisjoint(theirs)) {
                ++j;
                continue;
            }
            if (!theirs.startsAfterNonDisjoint(mine)) continue;
            ++i;
        }
        if (intersection == null) {
            return new IntervalSet();
        }
        return intersection;
    }

    @Override
    public boolean member(int el) {
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            if (el < a) break;
            if (el < a || el > b) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNil() {
        return this.intervals == null || this.intervals.isEmpty();
    }

    @Override
    public int getSingleElement() {
        if (this.intervals != null && this.intervals.size() == 1) {
            Interval I = this.intervals.get(0);
            if (I.a == I.b) {
                return I.a;
            }
        }
        return -7;
    }

    public int getMaxElement() {
        if (this.isNil()) {
            return -7;
        }
        Interval last = this.intervals.get(this.intervals.size() - 1);
        return last.b;
    }

    public int getMinElement() {
        if (this.isNil()) {
            return -7;
        }
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            for (int v = a; v <= b; ++v) {
                if (v < 0) continue;
                return v;
            }
        }
        return -7;
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IntervalSet)) {
            return false;
        }
        IntervalSet other = (IntervalSet)obj;
        return this.intervals.equals(other.intervals);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Grammar g2) {
        StringBuilder buf = new StringBuilder();
        if (this.intervals == null || this.intervals.isEmpty()) {
            return "{}";
        }
        if (this.intervals.size() > 1) {
            buf.append("{");
        }
        Iterator<Interval> iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval I = iter.next();
            int a = I.a;
            int b = I.b;
            if (a == b) {
                if (g2 != null) {
                    buf.append(g2.getTokenDisplayName(a));
                } else {
                    buf.append(a);
                }
            } else if (g2 != null) {
                buf.append(g2.getTokenDisplayName(a)).append("..").append(g2.getTokenDisplayName(b));
            } else {
                buf.append(a).append("..").append(b);
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        if (this.intervals.size() > 1) {
            buf.append("}");
        }
        return buf.toString();
    }

    @Override
    public int size() {
        int n = 0;
        int numIntervals = this.intervals.size();
        if (numIntervals == 1) {
            Interval firstInterval = this.intervals.get(0);
            return firstInterval.b - firstInterval.a + 1;
        }
        for (int i = 0; i < numIntervals; ++i) {
            Interval I = this.intervals.get(i);
            n += I.b - I.a + 1;
        }
        return n;
    }

    @Override
    public List<Integer> toList() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            for (int v = a; v <= b; ++v) {
                values.add(Utils.integer(v));
            }
        }
        return values;
    }

    public int get(int i) {
        int n = this.intervals.size();
        int index = 0;
        for (int j = 0; j < n; ++j) {
            Interval I = this.intervals.get(j);
            int a = I.a;
            int b = I.b;
            for (int v = a; v <= b; ++v) {
                if (index == i) {
                    return v;
                }
                ++index;
            }
        }
        return -1;
    }

    public int[] toArray() {
        int[] values = new int[this.size()];
        int n = this.intervals.size();
        int j = 0;
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            int v = a;
            while (v <= b) {
                values[j] = v++;
                ++j;
            }
        }
        return values;
    }

    public BitSet toRuntimeBitSet() {
        BitSet s2 = new BitSet(this.getMaxElement() + 1);
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            for (int v = a; v <= b; ++v) {
                s2.add(v);
            }
        }
        return s2;
    }

    @Override
    public void remove(int el) {
        throw new NoSuchMethodError("IntervalSet.remove() unimplemented");
    }
}

