/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.Utils;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FASerializer {
    protected Set<State> markedStates;
    protected int stateCounter = 0;
    protected Map<State, Integer> stateNumberTranslator;
    protected Grammar grammar;

    public FASerializer(Grammar grammar) {
        this.grammar = grammar;
    }

    public String serialize(State s2) {
        if (s2 == null) {
            return "<no automaton>";
        }
        return this.serialize(s2, true);
    }

    public String serialize(State s2, boolean renumber) {
        this.markedStates = new HashSet<State>();
        this.stateCounter = 0;
        if (renumber) {
            this.stateNumberTranslator = new HashMap<State, Integer>();
            this.walkFANormalizingStateNumbers(s2);
        }
        ArrayList<String> lines = new ArrayList<String>();
        if (s2.getNumberOfTransitions() > 0) {
            this.walkSerializingFA(lines, s2);
        } else {
            String s0 = this.getStateString(0, s2);
            lines.add(s0 + "\n");
        }
        StringBuilder buf = new StringBuilder(0);
        Collections.sort(lines);
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            buf.append(line);
        }
        return buf.toString();
    }

    protected void walkFANormalizingStateNumbers(State s2) {
        if (s2 == null) {
            ErrorManager.internalError("null state s");
            return;
        }
        if (this.stateNumberTranslator.get(s2) != null) {
            return;
        }
        this.stateNumberTranslator.put(s2, Utils.integer(this.stateCounter));
        ++this.stateCounter;
        for (int i = 0; i < s2.getNumberOfTransitions(); ++i) {
            Transition edge = s2.transition(i);
            this.walkFANormalizingStateNumbers(edge.target);
            if (!(edge instanceof RuleClosureTransition)) continue;
            this.walkFANormalizingStateNumbers(((RuleClosureTransition)edge).followState);
        }
    }

    protected void walkSerializingFA(List<String> lines, State s2) {
        if (this.markedStates.contains(s2)) {
            return;
        }
        this.markedStates.add(s2);
        int normalizedStateNumber = s2.stateNumber;
        if (this.stateNumberTranslator != null) {
            Integer normalizedStateNumberI = this.stateNumberTranslator.get(s2);
            normalizedStateNumber = normalizedStateNumberI;
        }
        String stateStr = this.getStateString(normalizedStateNumber, s2);
        for (int i = 0; i < s2.getNumberOfTransitions(); ++i) {
            Transition edge = s2.transition(i);
            StringBuilder buf = new StringBuilder();
            buf.append(stateStr);
            if (edge.isAction()) {
                buf.append("-{}->");
            } else if (edge.isEpsilon()) {
                buf.append("->");
            } else if (edge.isSemanticPredicate()) {
                buf.append("-{").append(edge.label.getSemanticContext()).append("}?->");
            } else {
                SemanticContext preds;
                String predsStr = "";
                if (edge.target instanceof DFAState && (preds = ((DFAState)edge.target).getGatedPredicatesInNFAConfigurations()) != null) {
                    predsStr = "&&{" + preds.genExpr(this.grammar.generator, this.grammar.generator.getTemplates(), null).render() + "}?";
                }
                buf.append("-").append(edge.label.toString(this.grammar)).append(predsStr).append("->");
            }
            int normalizedTargetStateNumber = edge.target.stateNumber;
            if (this.stateNumberTranslator != null) {
                Integer normalizedTargetStateNumberI = this.stateNumberTranslator.get(edge.target);
                normalizedTargetStateNumber = normalizedTargetStateNumberI;
            }
            buf.append(this.getStateString(normalizedTargetStateNumber, edge.target));
            buf.append("\n");
            lines.add(buf.toString());
            this.walkSerializingFA(lines, edge.target);
            if (!(edge instanceof RuleClosureTransition)) continue;
            this.walkSerializingFA(lines, ((RuleClosureTransition)edge).followState);
        }
    }

    private String getStateString(int n, State s2) {
        String stateStr = ".s" + n;
        if (s2.isAcceptState()) {
            stateStr = s2 instanceof DFAState ? ":s" + n + "=>" + ((DFAState)s2).getUniquelyPredictedAlt() : ":s" + n;
        }
        return stateStr;
    }
}

