/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.google.common.base.MoreObjects;
import java.io.Serializable;

public class Result
implements Serializable {
    private final Status mStatus;
    private final String mErrorMessage;
    private final Throwable mThrowable;
    private Object mData;

    private Result(Status status) {
        this(status, null, null);
    }

    private Result(Status status, String errorMessage, Throwable t) {
        assert (status != null);
        this.mStatus = status;
        this.mErrorMessage = errorMessage;
        this.mThrowable = t;
    }

    private Result(Result result) {
        this.mStatus = result.mStatus;
        this.mErrorMessage = result.mErrorMessage;
        this.mThrowable = result.mThrowable;
    }

    public Result getCopyWithData(Object data) {
        Result r = new Result(this);
        r.mData = data;
        return r;
    }

    public boolean isSuccess() {
        return this.mStatus == Status.SUCCESS;
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public Throwable getException() {
        return this.mThrowable;
    }

    public Object getData() {
        return this.mData;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.mStatus).add("errorMessage", (Object)this.mErrorMessage).add("throwable", (Object)this.mThrowable).add("data", this.mData).toString();
    }

    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status SUCCESS = new Status();
        public static final /* enum */ Status NOT_IMPLEMENTED = new Status();
        public static final /* enum */ Status ERROR_TIMEOUT = new Status();
        public static final /* enum */ Status ERROR_LOCK_INTERRUPTED = new Status();
        public static final /* enum */ Status ERROR_INFLATION = new Status();
        public static final /* enum */ Status ERROR_VIEWGROUP_NO_CHILDREN = new Status();
        public static final /* enum */ Status ERROR_NOT_INFLATED = new Status();
        public static final /* enum */ Status ERROR_RENDER = new Status();
        public static final /* enum */ Status ERROR_ANIM_NOT_FOUND = new Status();
        public static final /* enum */ Status ERROR_NOT_A_DRAWABLE = new Status();
        public static final /* enum */ Status ERROR_REFLECTION = new Status();
        public static final /* enum */ Status ERROR_RENDER_TASK = new Status();
        public static final /* enum */ Status ERROR_UNKNOWN = new Status();
        private Result mResult;
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String name) {
            return Enum.valueOf(Status.class, name);
        }

        public Result createResult() {
            assert (this != ERROR_UNKNOWN);
            if (this.mResult == null) {
                this.mResult = new Result(this);
            }
            return this.mResult;
        }

        public Result createResult(Object data) {
            Result res = this.createResult();
            if (data != null) {
                res = res.getCopyWithData(data);
            }
            return res;
        }

        public Result createResult(String errorMessage, Throwable throwable) {
            return new Result(this, errorMessage, throwable);
        }

        public Result createResult(String errorMessage) {
            return new Result(this, errorMessage, null);
        }

        private static /* synthetic */ Status[] $values() {
            return new Status[]{SUCCESS, NOT_IMPLEMENTED, ERROR_TIMEOUT, ERROR_LOCK_INTERRUPTED, ERROR_INFLATION, ERROR_VIEWGROUP_NO_CHILDREN, ERROR_NOT_INFLATED, ERROR_RENDER, ERROR_ANIM_NOT_FOUND, ERROR_NOT_A_DRAWABLE, ERROR_REFLECTION, ERROR_RENDER_TASK, ERROR_UNKNOWN};
        }

        static {
            $VALUES = Status.$values();
        }
    }
}

