/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.BooleanOption;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UJumpExpression;
import org.jetbrains.uast.ULoopExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UastEmptyExpression;
import org.jetbrains.uast.UastErrorType;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0002\r\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/IndentationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "Issues", "IndentationVisitor", "lint-checks"})
public final class IndentationDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(IndentationDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final BooleanOption ALWAYS_RUN_OPTION = new BooleanOption("always-run", "Whether this check should be included while editing", false, "\n                While you're editing, it's common to have a temporary situation where \\\n                you have suspicious indentation scenarios -- e.g. you start typing an \\\n                `if` statement on the line above something you want to make conditional, and \\\n                you haven't indented it yet. It can be distracting and misleading to \\\n                suddenly have both statements light up as errors. Therefore, lint will \\\n                avoid including this check when running on the fly in the editor, unless \\\n                it looks like the file has not been recently edited. With this option, you \\\n                can turn it on in all cases.\n                ");
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("SuspiciousIndentation", "Suspicious indentation", "\n                This check looks for cases where the indentation suggests a grouping that isn't actually \\\n                there in the code. A common example of this would be something like\n                ```kotlin\n                if (column > width)\n                    line++\n                    column = 0\n                ```\n                Here, the `column = 0` line will be executed every single time, not just if the condition \\\n                is true.\n                ", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION).setAliases(CollectionsKt.listOf((Object)"SuspiciousIndentAfterControlStatement")).setOptions(CollectionsKt.listOf((Object)ALWAYS_RUN_OPTION));

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UBlockExpression.class);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (LintClient.Companion.isStudio() && !ALWAYS_RUN_OPTION.getValue((Context)context).booleanValue() && Scope.Companion.checkSingleFile(context.getDriver().getScope()) && LintClient.isEdited$default((LintClient)context.getClient(), (File)context.file, (boolean)true, (long)0L, (int)4, null)) {
            return null;
        }
        return new IndentationVisitor(context);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\r*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\r*\u00020\u0016H\u0002J\u001e\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\f\u0010\u001c\u001a\u00020\u0012*\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000fH\u0002J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/lint/checks/IndentationDetector$IndentationVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "<init>", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "contents", "", "visitBlockExpression", "", "node", "Lorg/jetbrains/uast/UBlockExpression;", "conditionCommentedOut", "", "lineStart", "", "prevIndent", "describeElement", "", "expression", "Lorg/jetbrains/uast/UExpression;", "isControlExpression", "Lorg/jetbrains/uast/UElement;", "isClosedWithBraces", "hasBenignPredecessor", "expressions", "", "index", "describe", "", "getLineLocation", "Lcom/android/tools/lint/detector/api/Location;", "sourcePsi", "Lcom/intellij/psi/PsiElement;", "findLineBeginBackwards", "offset", "findLineBegin", "getIndentationDeltaOffset", "prevLineOffset", "currLineOffset", "indentationLength", "lint-checks"})
    private static final class IndentationVisitor
    extends UElementHandler {
        @NotNull
        private final JavaContext context;
        @NotNull
        private final CharSequence contents;

        public IndentationVisitor(@NotNull JavaContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            CharSequence charSequence = this.context.getContents();
            if (charSequence == null) {
                charSequence = "";
            }
            this.contents = charSequence;
        }

        public void visitBlockExpression(@NotNull UBlockExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List expressions = node.getExpressions();
            int prevStart = -1;
            int prevIndent = -1;
            int n = ((Collection)expressions).size();
            for (int i = 0; i < n; ++i) {
                int delta;
                UExpression body;
                UExpression elseExpression;
                UExpression statement = (UExpression)expressions.get(i);
                PsiElement sourcePsi = statement.getSourcePsi();
                if (sourcePsi == null) {
                    prevIndent = -1;
                    prevStart = -1;
                    continue;
                }
                int startOffset = PsiUtilsKt.getStartOffset((PsiElement)sourcePsi);
                int lineStart = this.findLineBeginBackwards(startOffset);
                if (lineStart == -1) {
                    prevIndent = -1;
                    prevStart = -1;
                    continue;
                }
                int indent = startOffset - lineStart;
                UExpression uExpression = statement;
                UExpression uExpression2 = uExpression instanceof UIfExpression ? ((elseExpression = ((UIfExpression)statement).getElseExpression()) != null && !(elseExpression instanceof UastEmptyExpression) ? elseExpression : ((UIfExpression)statement).getThenExpression()) : (body = uExpression instanceof ULoopExpression ? ((ULoopExpression)statement).getBody() : null);
                if (!(body == null || body instanceof UBlockExpression || body.getSourcePsi() == null || statement instanceof UIfExpression && body instanceof UIfExpression || body instanceof UJumpExpression && (i >= expressions.size() - 1 || expressions.get(i + 1) instanceof UJumpExpression))) {
                    PsiElement psiElement = body.getSourcePsi();
                    Intrinsics.checkNotNull((Object)psiElement);
                    int nestedStart = PsiUtilsKt.getStartOffset((PsiElement)psiElement);
                    int nestedLineStart = this.findLineBeginBackwards(nestedStart);
                    int nestedIndent = nestedStart - nestedLineStart;
                    if (nestedIndent == indent) {
                        Location secondary = this.getLineLocation(sourcePsi);
                        Location location = Location.withSecondary$default((Location)this.getLineLocation((UElement)body), (Location)secondary, (String)"Previous statement here", (boolean)false, (int)4, null);
                        JavaContext.report$default((JavaContext)this.context, (Issue)ISSUE, (UElement)((UElement)node), (Location)location, (String)"Suspicious indentation: This is conditionally executed; expected it to be indented", null, (int)16, null);
                    }
                }
                if (prevIndent == -1 || indent == -1) {
                    prevIndent = indent;
                    prevStart = lineStart;
                    continue;
                }
                if (indent > prevIndent + 1 && prevIndent != 0) {
                    UExpression prevExpression = (UExpression)expressions.get(i - 1);
                    if (!this.hasBenignPredecessor(expressions, i) && !this.conditionCommentedOut(lineStart, prevIndent)) {
                        Location secondary = this.getLineLocation((UElement)prevExpression);
                        Location location = Location.withSecondary$default((Location)this.getLineLocation((UElement)statement), (Location)secondary, (String)"Previous statement here", (boolean)false, (int)4, null);
                        String prevSummary = this.describeElement(prevExpression);
                        boolean controlExpression = this.isControlExpression((UElement)UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)expressions.get(i - 1))));
                        String nestedUnder = controlExpression ? "nested under" : "continuing";
                        String message2 = "Suspicious indentation: This is indented but is not " + nestedUnder + " the previous expression (`" + prevSummary + "`...)";
                        JavaContext.report$default((JavaContext)this.context, (Issue)ISSUE, (UElement)((UElement)node), (Location)location, (String)message2, null, (int)16, null);
                        return;
                    }
                } else if (indent <= prevIndent && (delta = this.getIndentationDeltaOffset(prevStart, lineStart, indent)) != -1) {
                    Location prevLineLoc = Location.Companion.create(this.context.file, this.contents, prevStart + delta, prevStart + indent);
                    Location location = Location.withSecondary$default((Location)Location.Companion.create(this.context.file, this.contents, lineStart + delta, lineStart + indent), (Location)prevLineLoc, (String)"Previous line indentation here", (boolean)false, (int)4, null);
                    String prevChar = this.describe(this.contents.charAt(prevStart + delta));
                    String currChar = this.describe(this.contents.charAt(lineStart + delta));
                    Incident incident = new Incident(ISSUE, (Object)node, location, "The indentation string here is different from on the previous line (`" + prevChar + "` vs `" + currChar + "`)").overrideSeverity(Severity.WARNING);
                    this.context.report(incident);
                    return;
                }
                prevIndent = indent;
                prevStart = lineStart;
            }
        }

        private final boolean conditionCommentedOut(int lineStart, int prevIndent) {
            int prevContentStart;
            int prevLineIndent;
            if (lineStart < 2) {
                return false;
            }
            int prevLineStart = StringsKt.lastIndexOf$default((CharSequence)this.contents, (char)'\n', (int)(lineStart - 2), (boolean)false, (int)4, null) + 1;
            return prevLineStart != -1 && (prevLineIndent = (prevContentStart = this.findLineBegin(prevLineStart)) - prevLineStart) == prevIndent && StringsKt.regionMatches$default((CharSequence)this.contents, (int)prevContentStart, (CharSequence)"//", (int)0, (int)2, (boolean)false, (int)16, null);
        }

        private final String describeElement(UExpression expression) {
            int end;
            int min = 10;
            int max = 20;
            Object object = expression.getSourcePsi();
            if (object == null || (object = object.getText()) == null) {
                object = "";
            }
            Object text = object;
            for (end = Math.min(max, ((String)text).length() - 1); end < max && end != min; --end) {
                if (!Character.isJavaIdentifierPart(((String)text).charAt(end))) continue;
                ++end;
                break;
            }
            String string = ((String)text).substring(0, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return StringsKt.replace$default((String)string, (char)'\n', (char)' ', (boolean)false, (int)4, null);
        }

        private final boolean isControlExpression(UElement $this$isControlExpression) {
            return $this$isControlExpression instanceof UIfExpression || $this$isControlExpression instanceof ULoopExpression && !($this$isControlExpression instanceof UDoWhileExpression);
        }

        private final boolean isClosedWithBraces(UElement $this$isClosedWithBraces) {
            Object object = $this$isClosedWithBraces.getSourcePsi();
            return object != null && (object = object.getText()) != null ? StringsKt.endsWith$default((String)object, (String)"}", (boolean)false, (int)2, null) : false;
        }

        private final boolean hasBenignPredecessor(List<? extends UExpression> expressions, int index2) {
            boolean bl;
            boolean bl2 = bl = index2 > 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)expressions.get(index2 - 1));
            if (uExpression == null) {
                return true;
            }
            UExpression prev = uExpression;
            if (this.isControlExpression((UElement)prev)) {
                return this.isClosedWithBraces((UElement)prev);
            }
            if (prev instanceof UDeclarationsExpression || UastExpressionUtils.isAssignment((UElement)((UElement)prev))) {
                UExpression curr = expressions.get(index2);
                if (UastExpressionUtils.isAssignment((UElement)((UElement)curr)) || curr instanceof UPrefixExpression && (Intrinsics.areEqual((Object)((UPrefixExpression)curr).getOperator(), (Object)UastPrefixOperator.INC) || Intrinsics.areEqual((Object)((UPrefixExpression)curr).getOperator(), (Object)UastPrefixOperator.DEC))) {
                    return true;
                }
                PsiType type = curr.getExpressionType();
                if (type == null || Intrinsics.areEqual((Object)type, (Object)PsiTypes.voidType()) || Intrinsics.areEqual((Object)type, (Object)UastErrorType.INSTANCE)) {
                    return true;
                }
                return this.isClosedWithBraces((UElement)prev);
            }
            return !(prev instanceof UBinaryExpression);
        }

        private final String describe(char $this$describe) {
            String string;
            if ($this$describe == '\t') {
                string = "\\t";
            } else if ($this$describe == '\r') {
                string = "\\r";
            } else if ($this$describe == ' ') {
                string = "\" \"";
            } else if (Intrinsics.compare((int)$this$describe, (int)255) <= 0) {
                String string2 = "\\u%02X";
                Object[] objectArray = new Object[]{(int)$this$describe};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            } else {
                String string4 = "\\u%04X";
                Object[] objectArray = new Object[]{(int)$this$describe};
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            }
            return string;
        }

        private final Location getLineLocation(UElement node) {
            PsiElement psiElement = node.getSourcePsi();
            Intrinsics.checkNotNull((Object)psiElement);
            return this.getLineLocation(psiElement);
        }

        private final Location getLineLocation(PsiElement sourcePsi) {
            int startOffset = PsiUtilsKt.getStartOffset((PsiElement)sourcePsi);
            int lineEnd = StringsKt.indexOf$default((CharSequence)this.contents, (char)'\n', (int)startOffset, (boolean)false, (int)4, null);
            if (lineEnd == -1) {
                lineEnd = this.contents.length();
            }
            while (lineEnd > 0 && CharsKt.isWhitespace((char)this.contents.charAt(lineEnd - 1))) {
                --lineEnd;
            }
            int endOffset = PsiUtilsKt.getEndOffset((PsiElement)sourcePsi);
            return Location.Companion.create(this.context.file, this.contents, startOffset, Math.min(endOffset, lineEnd));
        }

        private final int findLineBeginBackwards(int offset) {
            if (offset > this.contents.length()) {
                return -1;
            }
            for (int i = offset - 1; -1 < i; --i) {
                char c = this.contents.charAt(i);
                if (c == '\n') {
                    return i + 1;
                }
                if (CharsKt.isWhitespace((char)c)) continue;
                return -1;
            }
            return 0;
        }

        private final int findLineBegin(int lineStart) {
            int length = this.contents.length();
            for (int offset = lineStart; offset < length; ++offset) {
                if (CharsKt.isWhitespace((char)this.contents.charAt(offset))) continue;
                return offset;
            }
            return length;
        }

        private final int getIndentationDeltaOffset(int prevLineOffset, int currLineOffset, int indentationLength) {
            for (int i = 0; i < indentationLength; ++i) {
                if (this.contents.charAt(prevLineOffset + i) == this.contents.charAt(currLineOffset + i)) continue;
                return i;
            }
            return -1;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/IndentationDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ALWAYS_RUN_OPTION", "Lcom/android/tools/lint/detector/api/BooleanOption;", "getALWAYS_RUN_OPTION", "()Lcom/android/tools/lint/detector/api/BooleanOption;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        @NotNull
        public final BooleanOption getALWAYS_RUN_OPTION() {
            return ALWAYS_RUN_OPTION;
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

