/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Device;
import com.google.common.base.CharMatcher;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0007J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0007J\b\u0010\u000f\u001a\u00020\nH\u0007J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0007J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J*\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\u001bR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/sdklib/internal/avd/AvdNames;", "", "<init>", "()V", "ALLOWED_FILENAME_CHARS", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "Lcom/google/common/base/CharMatcher;", "ALLOWED_DISPLAY_NAME_CHARS", "ALLOWED_CHARS_READABLE", "", "isValid", "", "candidateName", "cleanDisplayName", "humanReadableAllowedCharacters", "cleanAvdName", "avdName", "getDefaultDeviceDisplayName", "device", "Lcom/android/sdklib/devices/Device;", "version", "Lcom/android/sdklib/AndroidVersion;", "uniquify", "name", "separator", "isPresent", "Lkotlin/Function1;", "sdklib"})
@SourceDebugExtension(value={"SMAP\nAvdNames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvdNames.kt\ncom/android/sdklib/internal/avd/AvdNames\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class AvdNames {
    @NotNull
    public static final AvdNames INSTANCE = new AvdNames();
    private static final CharMatcher ALLOWED_FILENAME_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)".-"));
    private static final CharMatcher ALLOWED_DISPLAY_NAME_CHARS = ALLOWED_FILENAME_CHARS.or(CharMatcher.anyOf((CharSequence)"_ ()"));
    @NotNull
    private static final String ALLOWED_CHARS_READABLE = "a-z A-Z 0-9 . _ - ( )";

    private AvdNames() {
    }

    @JvmStatic
    public static final boolean isValid(@NotNull String candidateName) {
        Intrinsics.checkNotNullParameter((Object)candidateName, (String)"candidateName");
        return ((CharSequence)candidateName).length() > 0 && ALLOWED_DISPLAY_NAME_CHARS.matchesAllOf((CharSequence)candidateName);
    }

    @JvmStatic
    @NotNull
    public static final String cleanDisplayName(@NotNull String candidateName) {
        Intrinsics.checkNotNullParameter((Object)candidateName, (String)"candidateName");
        String string = ALLOWED_DISPLAY_NAME_CHARS.negate().or(CharMatcher.is((char)' ')).trimAndCollapseFrom((CharSequence)candidateName, ' ');
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimAndCollapseFrom(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String humanReadableAllowedCharacters() {
        return ALLOWED_CHARS_READABLE;
    }

    @JvmStatic
    @NotNull
    public static final String cleanAvdName(@NotNull String avdName) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        CharSequence charSequence2 = ALLOWED_FILENAME_CHARS.negate().trimAndCollapseFrom((CharSequence)avdName, '_');
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = "myavd";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @JvmStatic
    @NotNull
    public static final String getDefaultDeviceDisplayName(@NotNull Device device, @NotNull AndroidVersion version) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return AvdNames.cleanDisplayName(string) + " API " + version.getApiStringWithExtension();
    }

    @NotNull
    public final String uniquify(@NotNull String name, @NotNull String separator, @NotNull Function1<? super String, Boolean> isPresent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter(isPresent, (String)"isPresent");
        int suffix = 1;
        Object candidate = name;
        while (((Boolean)isPresent.invoke(candidate)).booleanValue()) {
            candidate = name + separator + ++suffix;
        }
        return candidate;
    }
}

