/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.GradientStop;
import com.android.ide.common.vectordrawable.PathParser;
import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.SvgGroupNode;
import com.android.ide.common.vectordrawable.SvgLeafNode;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import com.android.ide.common.vectordrawable.VdNodeRender;
import com.android.ide.common.vectordrawable.VdPath;
import com.android.ide.common.vectordrawable.VdUtil;
import com.android.utils.DecimalUtils;
import com.google.common.collect.ImmutableMap;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

class SvgGradientNode
extends SvgNode {
    private static final Logger logger = Logger.getLogger(SvgGroupNode.class.getSimpleName());
    private final List<GradientStop> mGradientStops = new ArrayList<GradientStop>();
    private SvgLeafNode mSvgLeafNode;
    private Rectangle2D mBoundingBox;
    private GradientUsage mGradientUsage;
    private static final ImmutableMap<String, Integer> vectorCoordinateMap = ImmutableMap.builder().put((Object)"x1", (Object)0).put((Object)"y1", (Object)1).put((Object)"x2", (Object)2).put((Object)"y2", (Object)3).build();

    SvgGradientNode(SvgTree svgTree, Element element, String nodeName) {
        super(svgTree, element, nodeName);
    }

    @Override
    public SvgGradientNode deepCopy() {
        SvgGradientNode newInstance = new SvgGradientNode(this.getTree(), this.mDocumentElement, this.getName());
        newInstance.copyFrom(this);
        return newInstance;
    }

    @Override
    public boolean isGroupNode() {
        return false;
    }

    protected void copyFrom(SvgGradientNode from) {
        super.copyFrom(from);
        if (this.mGradientStops.isEmpty()) {
            for (GradientStop g : from.mGradientStops) {
                this.addGradientStop(g.getColor(), g.getOffset(), g.getOpacity());
            }
        }
    }

    public boolean resolveHref(SvgTree svgTree) {
        SvgNode referencedNode;
        String id = this.getHrefId();
        SvgNode svgNode = referencedNode = id.isEmpty() ? null : svgTree.getSvgNodeFromId(id);
        if (referencedNode instanceof SvgGradientNode) {
            if (svgTree.getPendingUseSet().contains(referencedNode)) {
                return false;
            }
            this.copyFrom((SvgGradientNode)referencedNode);
        } else if (referencedNode == null) {
            if (id.isEmpty() || !svgTree.isIdIgnored(id)) {
                svgTree.logError("Referenced id not found", this.mDocumentElement);
            }
        } else {
            svgTree.logError("Referenced element is not a gradient", this.mDocumentElement);
        }
        return true;
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + "current gradient is :" + this.getName());
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
    }

    @Override
    public void flatten(AffineTransform transform) {
        this.mStackedTransform.setTransform(transform);
        this.mStackedTransform.concatenate(this.mLocalTransform);
    }

    private GradientCoordResult getGradientCoordinate(String x, double defaultValue) {
        if (!this.mVdAttributesMap.containsKey(x)) {
            return new GradientCoordResult(defaultValue, false);
        }
        double val = defaultValue;
        String vdValue = ((String)this.mVdAttributesMap.get(x)).trim();
        if (x.equals("r") && vdValue.startsWith("-")) {
            return new GradientCoordResult(defaultValue, false);
        }
        boolean isPercentage = false;
        try {
            if (vdValue.endsWith("%")) {
                val = Double.parseDouble(vdValue.substring(0, vdValue.length() - 1)) / 100.0;
                isPercentage = true;
            } else {
                val = Double.parseDouble(vdValue);
            }
        }
        catch (NumberFormatException e) {
            this.logError("Unsupported coordinate value");
        }
        return new GradientCoordResult(val, isPercentage);
    }

    @Override
    public void writeXml(OutputStreamWriter writer, String indent) throws IOException {
        double[] transformedBounds;
        double[] gradientBounds;
        if (this.mGradientStops.isEmpty()) {
            this.logError("Gradient has no stop info");
            return;
        }
        this.setBoundingBox();
        double height = this.mBoundingBox.getHeight();
        double width = this.mBoundingBox.getWidth();
        double startX = this.mBoundingBox.getX();
        double startY = this.mBoundingBox.getY();
        String gradientUnit = (String)this.mVdAttributesMap.get("gradientUnits");
        boolean isUserSpaceOnUse = "userSpaceOnUse".equals(gradientUnit);
        if (isUserSpaceOnUse) {
            startX = 0.0;
            startY = 0.0;
            height = this.getTree().getHeight();
            width = this.getTree().getWidth();
        }
        if (width == 0.0 || height == 0.0) {
            return;
        }
        writer.write(indent);
        if (this.mGradientUsage == GradientUsage.FILL) {
            writer.write("<aapt:attr name=\"android:fillColor\">");
        } else {
            writer.write("<aapt:attr name=\"android:strokeColor\">");
        }
        writer.write(System.lineSeparator());
        writer.write(indent);
        writer.write("  ");
        writer.write("<gradient ");
        if (this.mVdAttributesMap.containsKey("gradientTransform")) {
            String transformValue = (String)this.mVdAttributesMap.get("gradientTransform");
            this.parseLocalTransform(transformValue);
            if (!isUserSpaceOnUse) {
                AffineTransform tr = new AffineTransform(width, 0.0, 0.0, height, 0.0, 0.0);
                this.mLocalTransform.preConcatenate(tr);
                try {
                    tr.invert();
                }
                catch (NoninvertibleTransformException e) {
                    throw new Error(e);
                }
                this.mLocalTransform.concatenate(tr);
            }
        }
        if (isUserSpaceOnUse) {
            this.mLocalTransform.preConcatenate(this.mSvgLeafNode.mStackedTransform);
        }
        String gradientType = "linear";
        if (this.mVdAttributesMap.containsKey("gradientType")) {
            gradientType = (String)this.mVdAttributesMap.get("gradientType");
        }
        if (gradientType.equals("linear")) {
            gradientBounds = new double[4];
            transformedBounds = new double[4];
            for (Map.Entry entry : vectorCoordinateMap.entrySet()) {
                String s = (String)entry.getKey();
                int index = (Integer)entry.getValue();
                double defaultValue = 0.0;
                if (index == 2) {
                    defaultValue = 1.0;
                }
                GradientCoordResult result2 = this.getGradientCoordinate(s, defaultValue);
                double coordValue = result2.getValue();
                if (!isUserSpaceOnUse || result2.isPercentage()) {
                    coordValue = index % 2 == 0 ? coordValue * width + startX : coordValue * height + startY;
                }
                gradientBounds[index] = coordValue;
                transformedBounds[index] = coordValue;
                if (this.mVdAttributesMap.containsKey(s)) continue;
                this.mVdAttributesMap.put(s, "");
            }
            this.mLocalTransform.transform(gradientBounds, 0, transformedBounds, 0, 2);
        } else {
            gradientBounds = new double[2];
            transformedBounds = new double[2];
            GradientCoordResult cxResult = this.getGradientCoordinate("cx", 0.5);
            double cx = cxResult.getValue();
            if (!isUserSpaceOnUse || cxResult.isPercentage()) {
                cx = width * cx + startX;
            }
            GradientCoordResult cyResult = this.getGradientCoordinate("cy", 0.5);
            double cy = cyResult.getValue();
            if (!isUserSpaceOnUse || cyResult.isPercentage()) {
                cy = height * cy + startY;
            }
            GradientCoordResult rResult = this.getGradientCoordinate("r", 0.5);
            double r = rResult.getValue();
            if (!isUserSpaceOnUse || rResult.isPercentage()) {
                r *= Math.max(height, width);
            }
            gradientBounds[0] = cx;
            transformedBounds[0] = cx;
            gradientBounds[1] = cy;
            transformedBounds[1] = cy;
            this.mLocalTransform.transform(gradientBounds, 0, transformedBounds, 0, 1);
            Point2D.Double radius = new Point2D.Double(r, 0.0);
            Point2D.Double transformedRadius = new Point2D.Double(r, 0.0);
            this.mLocalTransform.deltaTransform(radius, transformedRadius);
            this.mVdAttributesMap.put("cx", this.mSvgTree.formatCoordinate(transformedBounds[0]));
            this.mVdAttributesMap.put("cy", this.mSvgTree.formatCoordinate(transformedBounds[1]));
            this.mVdAttributesMap.put("r", this.mSvgTree.formatCoordinate(transformedRadius.distance(0.0, 0.0)));
        }
        for (Map.Entry entry : Svg2Vector.gradientMap.entrySet()) {
            String svgAttribute = (String)entry.getKey();
            String gradientAttr = (String)entry.getValue();
            String svgValue = (String)this.mVdAttributesMap.get(svgAttribute);
            if (gradientAttr.isEmpty() || svgValue == null) continue;
            String vdValue = this.colorSvg2Vd(svgValue = svgValue.trim(), "#000000");
            if (vdValue == null) {
                Integer coordinateIndex = (Integer)vectorCoordinateMap.get((Object)svgAttribute);
                if (coordinateIndex != null) {
                    double x = transformedBounds[coordinateIndex];
                    vdValue = this.mSvgTree.formatCoordinate(x);
                } else if (svgAttribute.equals("spreadMethod")) {
                    switch (svgValue) {
                        case "pad": {
                            vdValue = "clamp";
                            break;
                        }
                        case "reflect": {
                            vdValue = "mirror";
                            break;
                        }
                        case "repeat": {
                            vdValue = "repeat";
                            break;
                        }
                        default: {
                            this.logError("Unsupported spreadMethod " + svgValue);
                            vdValue = "clamp";
                            break;
                        }
                    }
                } else if (svgValue.endsWith("%")) {
                    double coordinate = this.getGradientCoordinate(svgAttribute, 0.0).getValue();
                    vdValue = this.mSvgTree.formatCoordinate(coordinate);
                } else {
                    vdValue = svgValue;
                }
            }
            writer.write(System.lineSeparator());
            writer.write(indent);
            writer.write("  ");
            writer.write("    ");
            writer.write(gradientAttr);
            writer.write("=\"");
            writer.write(vdValue);
            writer.write("\"");
        }
        writer.write(62);
        writer.write(System.lineSeparator());
        this.writeGradientStops(writer, indent + "    ");
        writer.write(indent);
        writer.write("  ");
        writer.write("</gradient>");
        writer.write(System.lineSeparator());
        writer.write(indent);
        writer.write("</aapt:attr>");
        writer.write(System.lineSeparator());
    }

    private void writeGradientStops(OutputStreamWriter writer, String indent) throws IOException {
        for (GradientStop g : this.mGradientStops) {
            float opacity;
            String color = g.getColor();
            try {
                opacity = Float.parseFloat(g.getOpacity());
            }
            catch (NumberFormatException e) {
                this.logWarning("Unsupported opacity value");
                opacity = 1.0f;
            }
            int color1 = VdPath.applyAlpha(VdUtil.parseColorValue(color), opacity);
            color = String.format("#%08X", color1);
            writer.write(indent);
            writer.write("<item android:offset=\"");
            writer.write(DecimalUtils.trimInsignificantZeros((String)g.getOffset()));
            writer.write("\"");
            writer.write(" android:color=\"");
            writer.write(color);
            writer.write("\"/>");
            writer.write(System.lineSeparator());
            if (this.mGradientStops.size() != 1) continue;
            this.logWarning("Gradient has only one color stop");
            writer.write(indent);
            writer.write("<item android:offset=\"1\"");
            writer.write(" android:color=\"");
            writer.write(color);
            writer.write("\"/>");
            writer.write(System.lineSeparator());
        }
    }

    public void addGradientStop(String color, String offset, String opacity) {
        GradientStop stop = new GradientStop(color, offset);
        stop.setOpacity(opacity);
        this.mGradientStops.add(stop);
    }

    public void setGradientUsage(GradientUsage gradientUsage) {
        this.mGradientUsage = gradientUsage;
    }

    public void setSvgLeafNode(SvgLeafNode svgLeafNode) {
        this.mSvgLeafNode = svgLeafNode;
    }

    private void setBoundingBox() {
        Path2D.Double svgPath = new Path2D.Double();
        VdPath.Node[] nodes = PathParser.parsePath(this.mSvgLeafNode.getPathData(), PathParser.ParseMode.SVG);
        VdNodeRender.createPath(nodes, svgPath);
        this.mBoundingBox = svgPath.getBounds2D();
    }

    private static class GradientCoordResult {
        private final double mValue;
        private final boolean mIsPercentage;

        GradientCoordResult(double value, boolean isPercentage) {
            this.mValue = value;
            this.mIsPercentage = isPercentage;
        }

        double getValue() {
            return this.mValue;
        }

        boolean isPercentage() {
            return this.mIsPercentage;
        }
    }

    protected static enum GradientUsage {
        FILL,
        STROKE;

    }
}

