/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.openapi.util.text.Strings;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class LineOffsetsImpl
implements LineOffsets {
    private final int[] myLineEnds;
    private final int myTextLength;

    @NotNull
    public static LineOffsets create(@NotNull CharSequence text) {
        int lineEnd;
        if (text == null) {
            LineOffsetsImpl.$$$reportNull$$$0(0);
        }
        IntArrayList ends = new IntArrayList();
        int index = 0;
        while ((lineEnd = Strings.indexOf(text, '\n', index)) != -1) {
            ends.add(lineEnd);
            index = lineEnd + 1;
        }
        ends.add(text.length());
        return new LineOffsetsImpl(ends.toIntArray(), text.length());
    }

    private LineOffsetsImpl(int[] lineEnds, int textLength) {
        this.myLineEnds = lineEnds;
        this.myTextLength = textLength;
    }

    @Override
    public int getLineStart(int line) {
        this.checkLineIndex(line);
        if (line == 0) {
            return 0;
        }
        return this.myLineEnds[line - 1] + 1;
    }

    @Override
    public int getLineEnd(int line) {
        this.checkLineIndex(line);
        return this.myLineEnds[line];
    }

    @Override
    public int getLineEnd(int line, boolean includeNewline) {
        this.checkLineIndex(line);
        return this.myLineEnds[line] + (includeNewline && line != this.myLineEnds.length - 1 ? 1 : 0);
    }

    @Override
    public int getLineNumber(int offset) {
        if (offset < 0 || offset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + ". Available text length: " + this.getTextLength());
        }
        if (offset == 0) {
            return 0;
        }
        if (offset == this.getTextLength()) {
            return this.getLineCount() - 1;
        }
        int bsResult = Arrays.binarySearch(this.myLineEnds, offset);
        return bsResult >= 0 ? bsResult : -bsResult - 1;
    }

    @Override
    public int getLineCount() {
        return this.myLineEnds.length;
    }

    @Override
    public int getTextLength() {
        return this.myTextLength;
    }

    private void checkLineIndex(int index) {
        if (index < 0 || index >= this.getLineCount()) {
            throw new IndexOutOfBoundsException("Wrong line: " + index + ". Available lines count: " + this.getLineCount());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/text/LineOffsetsImpl", "create"));
    }
}

