/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.JpsMetrics;
import com.intellij.platform.workspace.jps.entities.DependenciesKt;
import com.intellij.platform.workspace.jps.entities.ExcludeUrlEntity;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntity;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.LibraryTypeId;
import com.intellij.platform.workspace.jps.entities.Library_extensionsKt;
import com.intellij.platform.workspace.jps.serialization.impl.ErrorReporter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsLibraryEntitiesSerializerKt;
import com.intellij.platform.workspace.jps.serialization.impl.JpsProjectSerializersImplKt;
import com.intellij.platform.workspace.jps.serialization.impl.LibraryNameGenerator;
import com.intellij.platform.workspace.jps.serialization.impl.LoadingResult;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 82\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00018B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJH\u0010\u0018\u001a*\u0012&\u0012$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u0015\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001d0\u001c0\u001a0\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016JB\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2(\u0010)\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u0015\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001d0\u001c0\u001aH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0014JH\u0010.\u001a\u00020%2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2 \u00100\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b010\u001a2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000207H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00069"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsLibraryEntitiesSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntitiesSerializer;", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "fileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "internalEntitySource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "libraryTableId", "Lcom/intellij/platform/workspace/jps/entities/LibraryTableId;", "<init>", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;Lcom/intellij/platform/workspace/jps/entities/LibraryTableId;)V", "getFileUrl", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getInternalEntitySource", "()Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "getLibraryTableId", "()Lcom/intellij/platform/workspace/jps/entities/LibraryTableId;", "isExternalStorage", "", "()Z", "mainEntityClass", "Ljava/lang/Class;", "getMainEntityClass", "()Ljava/lang/Class;", "loadEntities", "Lcom/intellij/platform/workspace/jps/serialization/impl/LoadingResult;", "", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;", "reader", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "errorReporter", "Lcom/intellij/platform/workspace/jps/serialization/impl/ErrorReporter;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "checkAndAddToBuilder", "", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "orphanage", "newEntities", "createEntitySource", "Lcom/intellij/platform/workspace/storage/EntitySource;", "libraryTag", "Lorg/jdom/Element;", "saveEntities", "mainEntities", "entities", "", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "toString", "", "Companion", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nJpsLibraryEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsLibraryEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsLibraryEntitiesSerializer\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 LoadingResult.kt\ncom/intellij/platform/workspace/jps/serialization/impl/LoadingResultKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,341:1\n44#2,2:342\n46#2:403\n44#2,2:409\n46#2:420\n17#3,5:344\n22#3:402\n17#3,5:411\n22#3:419\n24#4,8:349\n24#4,8:358\n24#4,8:376\n1#5:357\n1#5:384\n1#5:397\n1611#6,9:366\n1863#6:375\n1864#6:385\n1620#6:386\n1611#6,9:387\n1863#6:396\n1864#6:398\n1620#6:399\n295#6,2:400\n1863#6:404\n1864#6:406\n1863#6,2:407\n1053#6:416\n1863#6,2:417\n24#7:405\n*S KotlinDebug\n*F\n+ 1 JpsLibraryEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsLibraryEntitiesSerializer\n*L\n138#1:342,2\n138#1:403\n188#1:409,2\n188#1:420\n138#1:344,5\n138#1:402\n188#1:411,5\n188#1:419\n139#1:349,8\n142#1:358,8\n146#1:376,8\n145#1:384\n154#1:397\n145#1:366,9\n145#1:375\n145#1:385\n145#1:386\n154#1:387,9\n154#1:396\n154#1:398\n154#1:399\n155#1:400,2\n164#1:404\n164#1:406\n177#1:407,2\n192#1:416\n192#1:417,2\n167#1:405\n*E\n"})
public class JpsLibraryEntitiesSerializer
implements JpsFileEntitiesSerializer<LibraryEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFileUrl fileUrl;
    @NotNull
    private final JpsFileEntitySource internalEntitySource;
    @NotNull
    private final LibraryTableId libraryTableId;
    @NotNull
    private static final AtomicLong loadEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
    @NotNull
    private static final AtomicLong saveEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);

    public JpsLibraryEntitiesSerializer(@NotNull VirtualFileUrl fileUrl, @NotNull JpsFileEntitySource internalEntitySource, @NotNull LibraryTableId libraryTableId) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)internalEntitySource, (String)"internalEntitySource");
        Intrinsics.checkNotNullParameter((Object)libraryTableId, (String)"libraryTableId");
        this.fileUrl = fileUrl;
        this.internalEntitySource = internalEntitySource;
        this.libraryTableId = libraryTableId;
    }

    @Override
    @NotNull
    public VirtualFileUrl getFileUrl() {
        return this.fileUrl;
    }

    @Override
    @NotNull
    public JpsFileEntitySource getInternalEntitySource() {
        return this.internalEntitySource;
    }

    @NotNull
    protected final LibraryTableId getLibraryTableId() {
        return this.libraryTableId;
    }

    public boolean isExternalStorage() {
        return false;
    }

    @Override
    @NotNull
    public Class<LibraryEntity> getMainEntityClass() {
        return LibraryEntity.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity.Builder<? extends WorkspaceEntity>>>> loadEntities(@NotNull JpsFileContentReader reader, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        LoadingResult<Object> loadingResult;
        Object object;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        AtomicLong arg0$iv = loadEntitiesTimeMs;
        boolean bl = false;
        LoadingResult<Object> value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        Object $this$runCatchingXmlIssues$iv = this;
        boolean $i$f$runCatchingXmlIssues = false;
        try {
            boolean bl4 = false;
            String string = this.getFileUrl().getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            object = Result.constructor-impl((Object)JpsFileContentReader.loadComponent$default(reader, string, "libraryTable", null, 4, null));
        }
        catch (JDOMException e$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
        }
        catch (IOException e$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
        }
        $this$runCatchingXmlIssues$iv = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)$this$runCatchingXmlIssues$iv);
        if (throwable != null) {
            Throwable it = $i$f$runCatchingXmlIssues = throwable;
            boolean bl5 = false;
            loadingResult = new LoadingResult<Object>(MapsKt.emptyMap(), null);
        } else {
            ResultKt.throwOnFailure((Object)$this$runCatchingXmlIssues$iv);
            Element element = (Element)$this$runCatchingXmlIssues$iv;
            if (element == null) {
                loadingResult = new LoadingResult<Object>(MapsKt.emptyMap(), null);
            } else {
                Object e$iv;
                Element libraryTableTag = element;
                Object $this$runCatchingXmlIssues$iv2 = this;
                boolean $i$f$runCatchingXmlIssues22 = false;
                try {
                    boolean bl6 = false;
                    e$iv = Result.constructor-impl(libraryTableTag.getChildren("library"));
                }
                catch (JDOMException e$iv2) {
                    e$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv2));
                }
                catch (IOException e$iv3) {
                    e$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv3));
                }
                $this$runCatchingXmlIssues$iv2 = e$iv;
                Throwable throwable2 = Result.exceptionOrNull-impl((Object)$this$runCatchingXmlIssues$iv2);
                if (throwable2 != null) {
                    Throwable it = $i$f$runCatchingXmlIssues22 = throwable2;
                    boolean bl7 = false;
                    loadingResult = new LoadingResult<Object>(MapsKt.emptyMap(), null);
                } else {
                    Object v7;
                    Object object2;
                    block20: {
                        void $this$firstOrNull$iv;
                        boolean bl8;
                        Object element$iv$iv;
                        Object element$iv$iv$iv;
                        Iterable $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv;
                        ResultKt.throwOnFailure((Object)$this$runCatchingXmlIssues$iv2);
                        Object object3 = $this$runCatchingXmlIssues$iv2;
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getOrThrow(...)");
                        $this$runCatchingXmlIssues$iv = (Iterable)object3;
                        boolean $i$f$mapNotNull = false;
                        void $i$f$runCatchingXmlIssues22 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            Result result2;
                            block19: {
                                Object object4;
                                element$iv$iv = element$iv$iv$iv = iterator2.next();
                                bl8 = false;
                                Element libraryTag = (Element)element$iv$iv;
                                boolean bl9 = false;
                                JpsFileEntitiesSerializer $this$runCatchingXmlIssues$iv3 = this;
                                boolean $i$f$runCatchingXmlIssues3 = false;
                                try {
                                    EntitySource source;
                                    boolean bl10 = false;
                                    Intrinsics.checkNotNull((Object)libraryTag);
                                    if (this.createEntitySource(libraryTag) == null) {
                                        result2 = null;
                                        break block19;
                                    }
                                    String name = JpsProjectSerializersImplKt.getAttributeValueStrict(libraryTag, "name");
                                    object4 = Result.constructor-impl((Object)Companion.loadLibrary(name, libraryTag, this.libraryTableId, source, virtualFileManager));
                                }
                                catch (JDOMException e$iv4) {
                                    object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv4));
                                }
                                catch (IOException e$iv5) {
                                    object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv5));
                                }
                                result2 = Result.box-impl((Object)object4);
                            }
                            if (result2 == null) continue;
                            Result it$iv$iv = result2;
                            boolean bl11 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List libs = (List)destination$iv$iv;
                        $this$mapNotNull$iv = libs;
                        object2 = LibraryEntity.class;
                        $i$f$mapNotNull = false;
                        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                        destination$iv$iv = new ArrayList();
                        $i$f$mapNotNullTo = false;
                        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        $i$f$forEach = false;
                        iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            LibraryEntity.Builder it$iv$iv;
                            element$iv$iv = element$iv$iv$iv = iterator2.next();
                            bl8 = false;
                            Object it = ((Result)element$iv$iv).unbox-impl();
                            boolean bl12 = false;
                            if ((LibraryEntity.Builder)(Result.isFailure-impl((Object)it) ? null : it) == null) continue;
                            boolean bl13 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        Iterable $i$f$mapNotNull2 = libs;
                        object2 = MapsKt.mapOf((Pair)TuplesKt.to(object2, (Object)((List)destination$iv$iv)));
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Object it = ((Result)element$iv).unbox-impl();
                            boolean bl14 = false;
                            if (!Result.isFailure-impl((Object)it)) continue;
                            v7 = element$iv;
                            break block20;
                        }
                        v7 = null;
                    }
                    Result result3 = v7;
                    Throwable throwable3 = result3 != null ? Result.exceptionOrNull-impl((Object)result3.unbox-impl()) : null;
                    Object object5 = object2;
                    loadingResult = new LoadingResult<Object>(object5, throwable3);
                }
            }
        }
        value$iv = loadingResult;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    @Override
    public void checkAndAddToBuilder(@NotNull MutableEntityStorage builder, @NotNull MutableEntityStorage orphanage, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>>> newEntities) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)orphanage, (String)"orphanage");
        Intrinsics.checkNotNullParameter(newEntities, (String)"newEntities");
        Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>> collection = newEntities.get(LibraryEntity.class);
        List list = collection instanceof List ? (List)collection : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List libraries = list;
        Iterable $this$forEach$iv = libraries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryEntity.Builder it = (LibraryEntity.Builder)element$iv;
            boolean bl = false;
            LibraryId symbolicId = new LibraryId(it.getName(), it.getTableId());
            if (!builder.contains(symbolicId)) continue;
            JpsLibraryEntitiesSerializer $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JpsLibraryEntitiesSerializer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(StringsKt.trimMargin$default((String)("Error during entities loading\n            |Entity with this library id already exists.\n            |Library id: " + symbolicId + "\n            |fileUrl: " + this.getFileUrl().getPresentableUrl() + "\n            |library table id: " + it.getTableId() + "\n            |internal entity source: " + this.getInternalEntitySource() + "\n          "), null, (int)1, null));
        }
        $this$forEach$iv = newEntities.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection lists = (Collection)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = lists;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                WorkspaceEntity.Builder it = (WorkspaceEntity.Builder)element$iv2;
                boolean bl2 = false;
                builder.addEntity(it);
            }
        }
    }

    @Nullable
    protected EntitySource createEntitySource(@NotNull Element libraryTag) {
        Intrinsics.checkNotNullParameter((Object)libraryTag, (String)"libraryTag");
        String externalSystemId = libraryTag.getAttributeValue("external-system-id");
        return externalSystemId == null ? (EntitySource)this.getInternalEntitySource() : (EntitySource)new JpsImportedEntitySource(this.getInternalEntitySource(), externalSystemId, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveEntities(@NotNull Collection<? extends LibraryEntity> mainEntities, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> entities, @NotNull EntityStorage storage, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter(mainEntities, (String)"mainEntities");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        AtomicLong arg0$iv = saveEntitiesTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!mainEntities.isEmpty()) {
            void $this$forEach$iv;
            Element componentTag2 = JDomSerializationUtil.createComponentElement("libraryTable");
            Iterable $this$sortedBy$iv = mainEntities;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    LibraryEntity it = (LibraryEntity)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (LibraryEntity)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LibraryEntity it = (LibraryEntity)element$iv;
                boolean bl4 = false;
                EntitySource entitySource = it.getEntitySource();
                JpsImportedEntitySource jpsImportedEntitySource = entitySource instanceof JpsImportedEntitySource ? (JpsImportedEntitySource)entitySource : null;
                String externalSystemId = jpsImportedEntitySource != null ? jpsImportedEntitySource.getExternalSystemId() : null;
                componentTag2.addContent(Companion.saveLibrary(it, externalSystemId, this.isExternalStorage()));
            }
            String string = this.getFileUrl().getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            writer.saveComponent(string, "libraryTable", componentTag2);
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null) + "(" + this.getFileUrl() + ")";
    }

    static {
        Meter meter = JpsMetrics.getInstance().getMeter();
        Intrinsics.checkNotNullExpressionValue((Object)meter, (String)"getMeter(...)");
        JpsLibraryEntitiesSerializer.Companion.setupOpenTelemetryReporting(meter);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0010\u0010\u0019\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsLibraryEntitiesSerializer$Companion;", "", "<init>", "()V", "saveLibrary", "Lorg/jdom/Element;", "library", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "externalSystemId", "", "isExternalStorage", "", "loadLibrary", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity$Builder;", "name", "libraryElement", "libraryTableId", "Lcom/intellij/platform/workspace/jps/entities/LibraryTableId;", "source", "Lcom/intellij/platform/workspace/storage/EntitySource;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "loadEntitiesTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "saveEntitiesTimeMs", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.workspace.jps"})
    @SourceDebugExtension(value={"SMAP\nJpsLibraryEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsLibraryEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsLibraryEntitiesSerializer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,341:1\n1510#2,3:342\n1513#2,3:352\n1863#2,2:355\n1863#2:357\n1863#2,2:358\n1863#2,2:360\n1864#2:362\n1863#2,2:363\n1863#2,2:365\n1216#2,2:367\n1246#2,4:369\n1557#2:373\n1628#2,3:374\n1557#2:377\n1628#2,3:378\n1557#2:381\n1628#2,3:382\n381#3,7:345\n1#4:385\n*S KotlinDebug\n*F\n+ 1 JpsLibraryEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsLibraryEntitiesSerializer$Companion\n*L\n223#1:342,3\n223#1:352,3\n224#1:355,2\n228#1:357\n230#1:358,2\n233#1:360,2\n228#1:362\n250#1:363,2\n255#1:365,2\n265#1:367,2\n265#1:369,4\n282#1:373\n282#1:374,3\n283#1:377\n283#1:378,3\n305#1:381\n305#1:382,3\n223#1:345,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Element saveLibrary(@NotNull LibraryEntity library, @Nullable String externalSystemId, boolean isExternalStorage) {
            void $this$groupByTo$iv;
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            Element libraryTag = new Element("library");
            String legacyName = LibraryNameGenerator.INSTANCE.getLegacyLibraryName(library.getSymbolicId());
            if (legacyName != null) {
                libraryTag.setAttribute("name", legacyName);
            }
            LibraryTypeId libraryTypeId = library.getTypeId();
            LibraryPropertiesEntity customProperties = Library_extensionsKt.getLibraryProperties(library);
            if (customProperties != null && libraryTypeId != null) {
                libraryTag.setAttribute("type", libraryTypeId.getName());
                String propertiesXmlTag = customProperties.getPropertiesXmlTag();
                if (propertiesXmlTag != null) {
                    libraryTag.addContent(JDOMUtil.load(propertiesXmlTag));
                }
            }
            if (externalSystemId != null) {
                String attributeName = isExternalStorage ? "__external-system-id" : "external-system-id";
                libraryTag.setAttribute(attributeName, externalSystemId);
            }
            Iterable iterable = library.getRoots();
            Map destination$iv = new HashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv : $this$groupByTo$iv) {
                Object object;
                LibraryRoot it = (LibraryRoot)element$iv;
                boolean bl = false;
                LibraryRootTypeId key$iv = it.getType();
                Map $this$getOrPut$iv$iv = destination$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
                if (value$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                List list$iv = (List)object;
                list$iv.add(element$iv);
            }
            HashMap rootsMap = (HashMap)destination$iv;
            Iterable $this$forEach$iv = JpsLibraryEntitiesSerializerKt.access$getROOT_TYPES_TO_WRITE_EMPTY_TAG$p();
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                LibraryRootTypeId it = (LibraryRootTypeId)element$iv;
                boolean bl = false;
                rootsMap.putIfAbsent(it, new ArrayList());
            }
            ArrayList<Element> jarDirectoriesTags = new ArrayList<Element>();
            Set set = rootsMap.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Comparator $i$f$forEach22 = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
            Iterable $this$forEach$iv2 = CollectionsKt.sortedWith((Iterable)set, (Comparator)new Comparator($i$f$forEach22){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    Map.Entry entry = (Map.Entry)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)b;
                    String string = ((LibraryRootTypeId)it.getKey()).getName();
                    bl = false;
                    String string2 = ((LibraryRootTypeId)it.getKey()).getName();
                    return comparator.compare(string, string2);
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                LibraryRoot it;
                Object element$iv2;
                Map.Entry bl = (Map.Entry)element$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)bl);
                Object k = bl.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                LibraryRootTypeId rootType = (LibraryRootTypeId)k;
                Object v = bl.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
                List roots = (List)v;
                Element rootTypeTag = new Element(rootType.getName());
                Object $this$forEach$iv3 = roots;
                boolean $i$f$forEach3 = false;
                Iterator iterator2 = $this$forEach$iv3.iterator();
                while (iterator2.hasNext()) {
                    element$iv2 = iterator2.next();
                    it = (LibraryRoot)element$iv2;
                    boolean bl4 = false;
                    rootTypeTag.addContent(new Element("root").setAttribute("url", it.getUrl().getUrl()));
                }
                $this$forEach$iv3 = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
                $this$forEach$iv3 = CollectionsKt.sortedWith((Iterable)roots, (Comparator)new Comparator((Comparator)$this$forEach$iv3){
                    final /* synthetic */ Comparator $comparator;
                    {
                        this.$comparator = $comparator;
                    }

                    public final int compare(T a, T b) {
                        LibraryRoot libraryRoot = (LibraryRoot)a;
                        Comparator comparator = this.$comparator;
                        boolean bl = false;
                        LibraryRoot it = (LibraryRoot)b;
                        String string = it.getUrl().getUrl();
                        bl = false;
                        String string2 = it.getUrl().getUrl();
                        return comparator.compare(string, string2);
                    }
                });
                $i$f$forEach3 = false;
                iterator2 = $this$forEach$iv3.iterator();
                while (iterator2.hasNext()) {
                    element$iv2 = iterator2.next();
                    it = (LibraryRoot)element$iv2;
                    boolean bl5 = false;
                    if (it.getInclusionOptions() == LibraryRoot.InclusionOptions.ROOT_ITSELF) continue;
                    Element jarDirectoryTag = new Element("jarDirectory");
                    jarDirectoryTag.setAttribute("url", it.getUrl().getUrl());
                    jarDirectoryTag.setAttribute("recursive", String.valueOf(it.getInclusionOptions() == LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT_RECURSIVELY));
                    if (!Intrinsics.areEqual((Object)rootType.getName(), (Object)"CLASSES")) {
                        jarDirectoryTag.setAttribute("type", rootType.getName());
                    }
                    jarDirectoriesTags.add(jarDirectoryTag);
                }
                libraryTag.addContent(rootTypeTag);
            }
            List<ExcludeUrlEntity> excludedRoots = library.getExcludedRoots();
            if (!((Collection)excludedRoots).isEmpty()) {
                Element excludedTag = new Element("excluded");
                Iterable $this$forEach$iv4 = excludedRoots;
                boolean $i$f$forEach4 = false;
                for (Object element$iv : $this$forEach$iv4) {
                    ExcludeUrlEntity it = (ExcludeUrlEntity)element$iv;
                    boolean bl = false;
                    excludedTag.addContent(new Element("root").setAttribute("url", it.getUrl().getUrl()));
                }
                libraryTag.addContent(excludedTag);
            }
            Iterable $this$forEach$iv5 = jarDirectoriesTags;
            boolean $i$f$forEach5 = false;
            for (Object element$iv : $this$forEach$iv5) {
                Element it = (Element)element$iv;
                boolean bl = false;
                libraryTag.addContent(it);
            }
            return libraryTag;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final LibraryEntity.Builder loadLibrary(@NotNull String name, @NotNull Element libraryElement, @NotNull LibraryTableId libraryTableId, @NotNull EntitySource source, @NotNull VirtualFileUrlManager virtualFileManager) {
            void $this$mapTo$iv$iv;
            LibraryPropertiesEntity.Builder builder;
            Object object;
            Object object2;
            void $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)libraryElement, (String)"libraryElement");
            Intrinsics.checkNotNullParameter((Object)libraryTableId, (String)"libraryTableId");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
            ArrayList<LibraryRoot> roots = new ArrayList<LibraryRoot>();
            ArrayList excludedRoots = new ArrayList();
            List<Element> list = libraryElement.getChildren("jarDirectory");
            Intrinsics.checkNotNullExpressionValue(list, (String)"getChildren(...)");
            Iterable $this$associateBy$iv = list;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Object destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Element it;
                Element element = (Element)element$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                String string = it.getAttributeValue("type");
                if (string == null) {
                    string = "CLASSES";
                }
                Intrinsics.checkNotNull((Object)it);
                it = (Element)element$iv$iv;
                object = new Pair((Object)string, (Object)JpsProjectSerializersImplKt.getAttributeValueStrict(it, "url"));
                boolean bl2 = false;
                String string2 = it.getAttributeValue("recursive");
                LibraryRoot.InclusionOptions inclusionOptions = (string2 != null ? Boolean.parseBoolean(string2) : false) ? LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT_RECURSIVELY : LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT;
                object2.put(object, inclusionOptions);
            }
            Map jarDirectories = destination$iv$iv;
            String type = libraryElement.getAttributeValue("type");
            Ref.ObjectRef properties = new Ref.ObjectRef();
            block11: for (Element childElement : libraryElement.getChildren()) {
                block23: {
                    destination$iv$iv = childElement.getName();
                    if (destination$iv$iv == null) break block23;
                    int n = -1;
                    switch (((String)destination$iv$iv).hashCode()) {
                        case 1994055114: {
                            if (((String)destination$iv$iv).equals("excluded")) {
                                n = 1;
                            }
                            break;
                        }
                        case -926053069: {
                            if (((String)destination$iv$iv).equals("properties")) {
                                n = 2;
                            }
                            break;
                        }
                        case -1594043758: {
                            if (((String)destination$iv$iv).equals("jarDirectory")) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 3: {
                            continue block11;
                        }
                        case 1: {
                            String it;
                            Iterable $this$mapTo$iv$iv2;
                            Iterable $this$map$iv;
                            Object element$iv$iv;
                            List<Element> list2 = childElement.getChildren("root");
                            Intrinsics.checkNotNullExpressionValue(list2, (String)"getChildren(...)");
                            Iterable $i$f$associateByTo2 = list2;
                            object2 = excludedRoots;
                            boolean $i$f$map = false;
                            element$iv$iv = $this$map$iv;
                            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (VirtualFileUrl item$iv$iv2 : $this$mapTo$iv$iv2) {
                                Element element = (Element)((Object)item$iv$iv2);
                                object = destination$iv$iv2;
                                boolean bl = false;
                                Intrinsics.checkNotNull((Object)it);
                                object.add(JpsProjectSerializersImplKt.getAttributeValueStrict((Element)((Object)it), "url"));
                            }
                            $this$map$iv = (List)destination$iv$iv2;
                            $i$f$map = false;
                            $this$mapTo$iv$iv2 = $this$map$iv;
                            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (VirtualFileUrl item$iv$iv2 : $this$mapTo$iv$iv2) {
                                it = (String)((Object)item$iv$iv2);
                                object = destination$iv$iv2;
                                boolean bl = false;
                                object.add(virtualFileManager.getOrCreateFromUrl(it));
                            }
                            ((ArrayList)object2).addAll((List)destination$iv$iv2);
                            continue block11;
                        }
                        case 2: {
                            properties.element = JDOMUtil.write(childElement);
                            continue block11;
                        }
                    }
                }
                String rootType = childElement.getName();
                for (Element rootTag : childElement.getChildren("root")) {
                    Intrinsics.checkNotNull((Object)rootTag);
                    String url = JpsProjectSerializersImplKt.getAttributeValueStrict(rootTag, "url");
                    LibraryRoot.InclusionOptions inclusionOptions = (LibraryRoot.InclusionOptions)((Object)jarDirectories.get(new Pair((Object)rootType, (Object)url)));
                    if (inclusionOptions == null) {
                        inclusionOptions = LibraryRoot.InclusionOptions.ROOT_ITSELF;
                    }
                    LibraryRoot.InclusionOptions inclusionOptions2 = inclusionOptions;
                    VirtualFileUrl virtualFileUrl = virtualFileManager.getOrCreateFromUrl(url);
                    Object v = JpsLibraryEntitiesSerializerKt.access$getLibraryRootTypes$p().get(rootType);
                    Intrinsics.checkNotNull(v);
                    roots.add(new LibraryRoot(virtualFileUrl, (LibraryRootTypeId)v, inclusionOptions2));
                }
            }
            String string = type;
            if (string != null) {
                String it = string;
                boolean bl = false;
                builder = LibraryPropertiesEntity.Companion.create(source, (Function1<? super LibraryPropertiesEntity.Builder, Unit>)((Function1)arg_0 -> Companion.loadLibrary$lambda$14$lambda$13(properties, arg_0)));
            } else {
                builder = null;
            }
            LibraryPropertiesEntity.Builder libProperties = builder;
            Iterable $this$map$iv = excludedRoots;
            boolean $i$f$map = false;
            Iterable $i$f$map2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFileUrl item$iv$iv2;
                item$iv$iv2 = (VirtualFileUrl)item$iv$iv;
                object2 = destination$iv$iv3;
                boolean bl = false;
                object2.add(ExcludeUrlEntity.Companion.create$default(ExcludeUrlEntity.Companion, (VirtualFileUrl)it, source, null, 4, null));
            }
            List excludes = (List)destination$iv$iv3;
            LibraryEntity.Builder libraryEntity = LibraryEntity.Companion.create(name, libraryTableId, (List<LibraryRoot>)roots, source, (Function1<? super LibraryEntity.Builder, Unit>)((Function1)arg_0 -> Companion.loadLibrary$lambda$17(type, excludes, libProperties, arg_0)));
            return libraryEntity;
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement loadEntitiesTimeCounter = meter.counterBuilder("jps.library.entities.serializer.load.entities.ms").buildObserver();
            ObservableLongMeasurement saveEntitiesTimeCounter = meter.counterBuilder("jps.library.entities.serializer.save.entities.ms").buildObserver();
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{saveEntitiesTimeCounter};
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$18(loadEntitiesTimeCounter, saveEntitiesTimeCounter), loadEntitiesTimeCounter, observableMeasurementArray);
        }

        private static final Unit loadLibrary$lambda$14$lambda$13(Ref.ObjectRef $properties, LibraryPropertiesEntity.Builder $this$LibraryPropertiesEntity) {
            Intrinsics.checkNotNullParameter((Object)$this$LibraryPropertiesEntity, (String)"$this$LibraryPropertiesEntity");
            $this$LibraryPropertiesEntity.setPropertiesXmlTag((String)$properties.element);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit loadLibrary$lambda$17(String $type, List $excludes, LibraryPropertiesEntity.Builder $libProperties, LibraryEntity.Builder $this$LibraryEntity) {
            LibraryTypeId libraryTypeId;
            Intrinsics.checkNotNullParameter((Object)$this$LibraryEntity, (String)"$this$LibraryEntity");
            LibraryEntity.Builder builder = $this$LibraryEntity;
            String string = $type;
            if (string != null) {
                void it;
                String string2 = string;
                LibraryEntity.Builder builder2 = builder;
                boolean bl = false;
                libraryTypeId = new LibraryTypeId((String)it);
                builder = builder2;
            } else {
                libraryTypeId = null;
            }
            builder.setTypeId(libraryTypeId);
            $this$LibraryEntity.setExcludedRoots($excludes);
            DependenciesKt.setLibraryProperties($this$LibraryEntity, $libProperties);
            return Unit.INSTANCE;
        }

        private static final void setupOpenTelemetryReporting$lambda$18(ObservableLongMeasurement $loadEntitiesTimeCounter, ObservableLongMeasurement $saveEntitiesTimeCounter) {
            $loadEntitiesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(loadEntitiesTimeMs));
            $saveEntitiesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(saveEntitiesTimeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

