/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.jdwp.chunkhandler;

import com.android.ddmlib.ByteBufferUtil;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.Log;
import com.android.ddmlib.internal.ClientImpl;
import com.android.ddmlib.internal.MonitorThread;
import com.android.ddmlib.internal.jdwp.chunkhandler.ChunkHandler;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public final class HandleAppName
extends ChunkHandler {
    public static final int CHUNK_APNM = ChunkHandler.type("APNM");
    private static final HandleAppName mInst = new HandleAppName();

    private HandleAppName() {
    }

    public static void register(MonitorThread mt) {
        mt.registerChunkHandler(CHUNK_APNM, mInst);
    }

    @Override
    public void clientReady(ClientImpl client) {
    }

    @Override
    public void clientDisconnected(ClientImpl client) {
    }

    @Override
    public void handleChunk(ClientImpl client, int type, ByteBuffer data, boolean isReply, int msgId) {
        Log.d("ddm-appname", "handling " + ChunkHandler.name(type));
        if (type == CHUNK_APNM) {
            assert (!isReply);
            HandleAppName.handleAPNM(client, data);
        } else {
            this.handleUnknownChunk(client, type, data, isReply, msgId);
        }
    }

    private static void handleAPNM(ClientImpl client, ByteBuffer data) {
        int appNameLen = data.getInt();
        String appName = ByteBufferUtil.getString(data, appNameLen);
        Integer userId = null;
        if (data.hasRemaining()) {
            int dataRemaining = data.remaining();
            try {
                userId = data.getInt();
            }
            catch (BufferUnderflowException e) {
                Log.e("ddm-appname", "Insufficient data in APNM chunk to retrieve user id.");
                Log.e("ddm-appname", "Actual chunk length: " + dataRemaining);
                Log.e("ddm-appname", "Expected chunk length: 4");
            }
        }
        String packageName = "";
        if (data.hasRemaining()) {
            int dataRemaining = data.remaining();
            int packageNameLength = 0;
            try {
                packageNameLength = data.getInt();
                packageName = ByteBufferUtil.getString(data, packageNameLength);
            }
            catch (BufferUnderflowException e) {
                int expectedChunkLength = 4 + packageNameLength * 2;
                Log.e("ddm-appname", "Insufficient data in APNM chunk to retrieve package name.");
                Log.e("ddm-appname", "Actual chunk length: " + dataRemaining);
                Log.e("ddm-appname", "Expected chunk length: " + expectedChunkLength);
            }
        }
        Log.d("ddm-appname", "APNM: app='" + appName + "'");
        ClientData.Names names = new ClientData.Names(appName, userId, packageName);
        ClientData cd = client.getClientData();
        cd.setNames(names);
        if (client != null) {
            client.update(1);
        }
    }
}

