/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.lang.makefile.MakeSettings;
import com.jetbrains.lang.makefile.MakefileLangBundle;
import com.jetbrains.lang.makefile.MakefileProjectSettings;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\f0\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/lang/makefile/MakeConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "settings", "Lcom/jetbrains/lang/makefile/MakefileProjectSettings;", "pathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "cygwinField", "Lcom/intellij/ui/components/JBCheckBox;", "getCygwinField$annotations", "()V", "isModified", "", "getDisplayName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "reset", "getHelpTopic", "intellij.makefile"})
public final class MakeConfigurable
implements Configurable {
    @Nullable
    private final MakefileProjectSettings settings;
    @NotNull
    private final TextFieldWithBrowseButton pathField;
    @NotNull
    private final JBCheckBox cygwinField;

    public MakeConfigurable(@Nullable Project project) {
        Project project2 = project;
        this.settings = project2 != null ? (MakefileProjectSettings)project2.getService(MakefileProjectSettings.class) : null;
        this.pathField = new TextFieldWithBrowseButton();
        Object[] objectArray = new Object[]{!SystemInfo.isWindows ? 0 : 1};
        this.cygwinField = new JBCheckBox(MakefileLangBundle.message("configurable.use.cygwin.checkbox", objectArray));
        this.pathField.addBrowseFolderListener(project, new FileChooserDescriptor(true, false, false, false, false, false).withTitle(MakefileLangBundle.message("make.file.chooser.title", new Object[0])).withDescription(MakefileLangBundle.message("make.file.chooser.description", new Object[0])));
    }

    private static /* synthetic */ void getCygwinField$annotations() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        Object object = this.settings;
        if (!Intrinsics.areEqual((Object)(object != null && (object = ((MakefileProjectSettings)object).getSettings()) != null ? ((MakeSettings)object).getPath() : null), (Object)this.pathField.getText())) return true;
        MakeSettings makeSettings = this.settings.getSettings();
        if (makeSettings == null) return true;
        if (makeSettings.getUseCygwin() != this.cygwinField.isSelected()) return true;
        return false;
    }

    @NotNull
    public String getDisplayName() {
        String string = MakefileLangBundle.message("configurable.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void apply() {
        block1: {
            Object object;
            Object object2 = this.settings;
            if (object2 != null && (object2 = ((MakefileProjectSettings)object2).getSettings()) != null) {
                ((MakeSettings)object2).setPath(this.pathField.getText());
            }
            if ((object = this.settings) == null || (object = ((MakefileProjectSettings)object).getSettings()) == null) break block1;
            ((MakeSettings)object).setUseCygwin(this.cygwinField.isSelected());
        }
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(MakefileLangBundle.message("configurable.path.field.label", new Object[0]), (JComponent)this.pathField).addComponent((JComponent)this.cygwinField).addComponentFillVertically((JComponent)new Spacer(), 0).getPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getPanel(...)");
        return jPanel;
    }

    public void reset() {
        Object object = this.settings;
        if (object == null || (object = ((MakefileProjectSettings)object).getSettings()) == null || (object = ((MakeSettings)object).getPath()) == null) {
            object = "";
        }
        this.pathField.setText((String)object);
        Object object2 = this.settings;
        this.cygwinField.setSelected(object2 != null && (object2 = ((MakefileProjectSettings)object2).getSettings()) != null ? ((MakeSettings)object2).getUseCygwin() : false);
    }

    @NotNull
    public String getHelpTopic() {
        return "settings.buildtools.make";
    }
}

