/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.elevation;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.elevation.ElevationBundle;
import com.intellij.execution.process.elevation.ElevationLogger;
import com.intellij.execution.process.mediator.client.ProcessMediatorClient;
import com.intellij.execution.process.mediator.client.launcher.DaemonHandshakeTransport;
import com.intellij.execution.process.mediator.client.launcher.DaemonHandshakeTransportKt;
import com.intellij.execution.process.mediator.client.launcher.DaemonProcessLauncher;
import com.intellij.execution.process.mediator.common.DaemonLaunchOptions;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.processHandshake.ProcessHandshakeTransport;
import com.sun.jna.platform.unix.LibC;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0014J-\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u000b\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/execution/process/elevation/ElevationDaemonProcessLauncher;", "Lcom/intellij/execution/process/mediator/client/launcher/DaemonProcessLauncher;", "clientBuilder", "Lcom/intellij/execution/process/mediator/client/ProcessMediatorClient$Builder;", "<init>", "(Lcom/intellij/execution/process/mediator/client/ProcessMediatorClient$Builder;)V", "createHandshakeTransport", "Lcom/intellij/execution/process/mediator/client/launcher/DaemonHandshakeTransport;", "openUnixHandshakeTransport", "createBaseLaunchOptions", "Lcom/intellij/execution/process/mediator/common/DaemonLaunchOptions;", "createProcessHandler", "Lcom/intellij/execution/process/BaseOSProcessHandler;", "transport", "handshakeFailed", "", "processHandler", "output", "Lcom/intellij/execution/process/ProcessOutput;", "reason", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "Companion", "intellij.execution.process.elevation"})
public final class ElevationDaemonProcessLauncher
extends DaemonProcessLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Path> SUDO_PATH_KEY;

    public ElevationDaemonProcessLauncher(@NotNull ProcessMediatorClient.Builder clientBuilder) {
        Intrinsics.checkNotNullParameter((Object)clientBuilder, (String)"clientBuilder");
        super(clientBuilder);
    }

    @NotNull
    protected DaemonHandshakeTransport createHandshakeTransport() {
        DaemonHandshakeTransport daemonHandshakeTransport;
        if (SystemInfo.isWindows) {
            daemonHandshakeTransport = super.createHandshakeTransport();
        } else {
            DaemonHandshakeTransport daemonHandshakeTransport2;
            try {
                daemonHandshakeTransport2 = this.openUnixHandshakeTransport();
            }
            catch (IOException e) {
                throw new ExecutionException(ElevationBundle.message("dialog.message.handshake.init.failed", new Object[0]), (Throwable)e);
            }
            daemonHandshakeTransport = daemonHandshakeTransport2;
        }
        return daemonHandshakeTransport;
    }

    private final DaemonHandshakeTransport openUnixHandshakeTransport() {
        DaemonHandshakeTransport daemonHandshakeTransport;
        DaemonLaunchOptions launchOptions = this.createBaseLaunchOptions();
        try {
            Path path = FileUtil.generateRandomTemporaryPath().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            daemonHandshakeTransport = DaemonHandshakeTransportKt.createUnixFifoTransport((DaemonHandshakeTransport.Companion)DaemonHandshakeTransport.Companion, (DaemonLaunchOptions)launchOptions, (Path)path);
        }
        catch (IOException e0) {
            DaemonHandshakeTransport daemonHandshakeTransport2;
            ElevationLogger.INSTANCE.getLOG().warn("Unable to create file-based handshake channel; falling back to socket streams", (Throwable)e0);
            try {
                daemonHandshakeTransport2 = DaemonHandshakeTransportKt.createSocketTransport$default((DaemonHandshakeTransport.Companion)DaemonHandshakeTransport.Companion, (DaemonLaunchOptions)launchOptions, (int)0, (int)2, null);
            }
            catch (IOException e1) {
                ExceptionsKt.addSuppressed((Throwable)e1, (Throwable)e0);
                throw e1;
            }
            daemonHandshakeTransport = daemonHandshakeTransport2;
        }
        return DaemonHandshakeTransportKt.encrypted((DaemonHandshakeTransport)daemonHandshakeTransport);
    }

    @NotNull
    protected DaemonLaunchOptions createBaseLaunchOptions() {
        DaemonLaunchOptions it = super.createBaseLaunchOptions();
        boolean bl = false;
        return SystemInfo.isWindows ? it : DaemonLaunchOptions.copy$default((DaemonLaunchOptions)it, (boolean)true, (boolean)true, null, (Integer)(SystemInfo.isMac ? Integer.valueOf(LibC.INSTANCE.getuid()) : null), null, null, (int)52, null);
    }

    @NotNull
    protected BaseOSProcessHandler createProcessHandler(@NotNull DaemonHandshakeTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        GeneralCommandLine commandLine = this.createCommandLine(transport);
        Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()};
        String string = ElevationBundle.message("dialog.title.sudo.prompt.product.elevation.daemon", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GeneralCommandLine sudoCommandLine = ExecUtil.sudoCommand((GeneralCommandLine)commandLine, (String)string);
        Path sudoPath = sudoCommandLine != commandLine ? Path.of(sudoCommandLine.getExePath(), new String[0]) : null;
        Object[] $this$createProcessHandler_u24lambda_u241 = objectArray = this.createProcessHandler((ProcessHandshakeTransport)transport, sudoCommandLine);
        boolean bl = false;
        $this$createProcessHandler_u24lambda_u241.putUserData(SUDO_PATH_KEY, (Object)sudoPath);
        return objectArray;
    }

    @NotNull
    protected Void handshakeFailed(@NotNull DaemonHandshakeTransport transport, @NotNull BaseOSProcessHandler processHandler, @NotNull ProcessOutput output, @NotNull String reason) {
        String string;
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Path sudoPath = (Path)processHandler.getUserData(SUDO_PATH_KEY);
        if (SystemInfo.isMac && output.isExitCodeSet() && output.getExitCode() == 1 && sudoPath != null && StringsKt.contains$default((CharSequence)((Object)sudoPath.getFileName()).toString(), (CharSequence)"osascript", (boolean)false, (int)2, null)) {
            String string2 = output.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStderr(...)");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"execution error: User cancelled", (boolean)false, (int)2, null)) {
                throw new ProcessCanceledException();
            }
        }
        if (sudoPath == null) {
            var8_6 = new Object[]{reason};
            string = ElevationBundle.message("dialog.message.failed.to.launch.daemon", var8_6);
        } else {
            var8_6 = new Object[]{sudoPath.getFileName(), reason};
            string = ElevationBundle.message("dialog.message.failed.to.launch.daemon.with.sudo", var8_6);
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        String message = string3;
        throw new ExecutionException(message);
    }

    static {
        Key key = Key.create((String)"SUDO_PATH_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SUDO_PATH_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/execution/process/elevation/ElevationDaemonProcessLauncher$Companion;", "", "<init>", "()V", "SUDO_PATH_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/nio/file/Path;", "intellij.execution.process.elevation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

