/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n25#3:393\n25#3:394\n25#3:395\n25#3:396\n25#3:397\n25#3:398\n25#3:399\n25#3:400\n25#3:401\n25#3:402\n25#3:403\n25#3:404\n25#3:405\n25#3:406\n25#3:407\n25#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 72983322190204L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1057079550 - 14059, 1057079550 + 11608, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1057079550 - 14060, -1057079550 + -10466, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 121378356790209L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.U();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1714002390 - (char)-20182, 1714002390 - (char)-17520, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1714002390 - (char)-20183, -1714002390 - -((char)-14013), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1714002390 - (char)-20180, -1714002390 - -((char)-10497), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                int[] nArray;
                l2 = 38214368120329L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    nArray = SshAgentIpcService.U();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-2044036650 + -((char)-11149), -2044036650 + -((char)-27261), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2044036650 + -((char)-11146), 2044036650 + (char)-16294, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (nArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-2044036650 + -((char)-11147), -2044036650 + -((char)-9031), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2044036650 + -((char)-11160), 2044036650 + (char)-30407, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2044036650 + -((char)-11161), -2044036650 + -((char)-24500), (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-2044036650 + -((char)-11147), -2044036650 + -((char)-9031), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2044036650 + -((char)-11158), 2044036650 + (char)-15687, (int)l2));
            if (ActionTimestamp.U() != null) {
                SshAgentIpcService.U(new int[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 8931220437561L;
                    nArray = SshAgentIpcService.U();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int[] nArray;
        long l2;
        block27: {
            block28: {
                l2 = 101258227272643L;
                int[] nArray2 = SshAgentIpcService.U();
                this.assertConnectionThread();
                nArray = nArray2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7165), 78248790 + (char)-8641, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7169), -78248790 + -((char)-5165), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7158), 78248790 + (char)-25475, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7169), -78248790 + -((char)-5165), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7159), 78248790 + (char)-17418, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7165), 78248790 + (char)-8641, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7169), -78248790 + -((char)-5165), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7160), 78248790 + (char)-2641, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (nArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7165), 78248790 + (char)-8641, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7169), -78248790 + -((char)-5165), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7161), -78248790 + -((char)-15707), (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7169), -78248790 + -((char)-5165), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7186), -78248790 + -((char)-19361), (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7169), -78248790 + -((char)-5165), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7159), 78248790 + (char)-17418, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7165), 78248790 + (char)-8641, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7169), -78248790 + -((char)-5165), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-78248790 + -((char)-7187), -78248790 + -((char)-8486), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 54430565156L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1404021840 - (char)-29443, 1404021840 - (char)-22679, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 43258917206749L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-6553500 + -((char)-9799), -6553500 + -((char)-31637), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00b5\u00cd\u009f~\u008bn\u00fdm\u00f7\u00de\u00f2\u00cb\u00b2\u0087\u0099\u00de\u00cdY\u00f4\u0014,\u008d\u00acp\u00f6m/\u0088/d,H\u00ab\u000e{d|\u00c8\u00c5j";
                        var4_3 = "\u00b5\u00cd\u009f~\u008bn\u00fdm\u00f7\u00de\u00f2\u00cb\u00b2\u0087\u0099\u00de\u00cdY\u00f4\u0014,\u008d\u00acp\u00f6m/\u0088/d,H\u00ab\u000e{d|\u00c8\u00c5j".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 42;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 46;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 33;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 87;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 12;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 10;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 95;
                                        break;
                                    }
                                    default: {
                                        v11 = 116;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFF9C77) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 110;
                            case 1 -> 217;
                            case 2 -> 81;
                            case 3 -> 95;
                            case 4 -> 177;
                            case 5 -> 187;
                            case 6 -> 230;
                            case 7 -> 19;
                            case 8 -> 231;
                            case 9 -> 167;
                            case 10 -> 93;
                            case 11 -> 197;
                            case 12 -> 38;
                            case 13 -> 112;
                            case 14 -> 242;
                            case 15 -> 172;
                            case 16 -> 147;
                            case 17 -> 9;
                            case 18 -> 146;
                            case 19 -> 88;
                            case 20 -> 225;
                            case 21 -> 32;
                            case 22 -> 176;
                            case 23 -> 135;
                            case 24 -> 162;
                            case 25 -> 52;
                            case 26 -> 133;
                            case 27 -> 224;
                            case 28 -> 190;
                            case 29 -> 50;
                            case 30 -> 11;
                            case 31 -> 30;
                            case 32 -> 25;
                            case 33 -> 4;
                            case 34 -> 142;
                            case 35 -> 120;
                            case 36 -> 181;
                            case 37 -> 241;
                            case 38 -> 113;
                            case 39 -> 122;
                            case 40 -> 222;
                            case 41 -> 71;
                            case 42 -> 13;
                            case 43 -> 164;
                            case 44 -> 84;
                            case 45 -> 59;
                            case 46 -> 53;
                            case 47 -> 165;
                            case 48 -> 150;
                            case 49 -> 196;
                            case 50 -> 207;
                            case 51 -> 139;
                            case 52 -> 211;
                            case 53 -> 209;
                            case 54 -> 200;
                            case 55 -> 89;
                            case 56 -> 28;
                            case 57 -> 103;
                            case 58 -> 156;
                            case 59 -> 155;
                            case 60 -> 82;
                            case 61 -> 183;
                            case 62 -> 106;
                            case 63 -> 90;
                            case 64 -> 184;
                            case 65 -> 45;
                            case 66 -> 62;
                            case 67 -> 192;
                            case 68 -> 158;
                            case 69 -> 203;
                            case 70 -> 145;
                            case 71 -> 116;
                            case 72 -> 61;
                            case 73 -> 160;
                            case 74 -> 29;
                            case 75 -> 236;
                            case 76 -> 212;
                            case 77 -> 130;
                            case 78 -> 215;
                            case 79 -> 194;
                            case 80 -> 2;
                            case 81 -> 91;
                            case 82 -> 78;
                            case 83 -> 54;
                            case 84 -> 148;
                            case 85 -> 233;
                            case 86 -> 210;
                            case 87 -> 240;
                            case 88 -> 86;
                            case 89 -> 75;
                            case 90 -> 49;
                            case 91 -> 204;
                            case 92 -> 173;
                            case 93 -> 114;
                            case 94 -> 223;
                            case 95 -> 170;
                            case 96 -> 83;
                            case 97 -> 182;
                            case 98 -> 152;
                            case 99 -> 77;
                            case 100 -> 180;
                            case 101 -> 136;
                            case 102 -> 51;
                            case 103 -> 23;
                            case 104 -> 126;
                            case 105 -> 47;
                            case 106 -> 153;
                            case 107 -> 73;
                            case 108 -> 102;
                            case 109 -> 67;
                            case 110 -> 189;
                            case 111 -> 41;
                            case 112 -> 56;
                            case 113 -> 101;
                            case 114 -> 216;
                            case 115 -> 85;
                            case 116 -> 17;
                            case 117 -> 151;
                            case 118 -> 108;
                            case 119 -> 107;
                            case 120 -> 121;
                            case 121 -> 220;
                            case 122 -> 246;
                            case 123 -> 70;
                            case 124 -> 193;
                            case 125 -> 123;
                            case 126 -> 100;
                            case 127 -> 1;
                            case 128 -> 221;
                            case 129 -> 105;
                            case 130 -> 35;
                            case 131 -> 229;
                            case 132 -> 40;
                            case 133 -> 64;
                            case 134 -> 141;
                            case 135 -> 195;
                            case 136 -> 138;
                            case 137 -> 237;
                            case 138 -> 163;
                            case 139 -> 159;
                            case 140 -> 131;
                            case 141 -> 37;
                            case 142 -> 134;
                            case 143 -> 97;
                            case 144 -> 255;
                            case 145 -> 22;
                            case 146 -> 171;
                            case 147 -> 26;
                            case 148 -> 186;
                            case 149 -> 219;
                            case 150 -> 214;
                            case 151 -> 15;
                            case 152 -> 94;
                            case 153 -> 213;
                            case 154 -> 44;
                            case 155 -> 115;
                            case 156 -> 169;
                            case 157 -> 21;
                            case 158 -> 0;
                            case 159 -> 247;
                            case 160 -> 104;
                            case 161 -> 36;
                            case 162 -> 128;
                            case 163 -> 201;
                            case 164 -> 57;
                            case 165 -> 8;
                            case 166 -> 227;
                            case 167 -> 31;
                            case 168 -> 109;
                            case 169 -> 254;
                            case 170 -> 12;
                            case 171 -> 69;
                            case 172 -> 60;
                            case 173 -> 245;
                            case 174 -> 34;
                            case 175 -> 63;
                            case 176 -> 185;
                            case 177 -> 228;
                            case 178 -> 118;
                            case 179 -> 252;
                            case 180 -> 7;
                            case 181 -> 42;
                            case 182 -> 125;
                            case 183 -> 119;
                            case 184 -> 137;
                            case 185 -> 27;
                            case 186 -> 174;
                            case 187 -> 179;
                            case 188 -> 117;
                            case 189 -> 48;
                            case 190 -> 244;
                            case 191 -> 66;
                            case 192 -> 235;
                            case 193 -> 87;
                            case 194 -> 74;
                            case 195 -> 16;
                            case 196 -> 202;
                            case 197 -> 161;
                            case 198 -> 175;
                            case 199 -> 39;
                            case 200 -> 168;
                            case 201 -> 72;
                            case 202 -> 154;
                            case 203 -> 144;
                            case 204 -> 218;
                            case 205 -> 191;
                            case 206 -> 111;
                            case 207 -> 206;
                            case 208 -> 80;
                            case 209 -> 5;
                            case 210 -> 226;
                            case 211 -> 249;
                            case 212 -> 178;
                            case 213 -> 250;
                            case 214 -> 166;
                            case 215 -> 208;
                            case 216 -> 18;
                            case 217 -> 238;
                            case 218 -> 99;
                            case 219 -> 188;
                            case 220 -> 33;
                            case 221 -> 149;
                            case 222 -> 129;
                            case 223 -> 24;
                            case 224 -> 253;
                            case 225 -> 239;
                            case 226 -> 6;
                            case 227 -> 55;
                            case 228 -> 251;
                            case 229 -> 199;
                            case 230 -> 58;
                            case 231 -> 127;
                            case 232 -> 143;
                            case 233 -> 68;
                            case 234 -> 14;
                            case 235 -> 65;
                            case 236 -> 140;
                            case 237 -> 205;
                            case 238 -> 20;
                            case 239 -> 234;
                            case 240 -> 198;
                            case 241 -> 3;
                            case 242 -> 157;
                            case 243 -> 79;
                            case 244 -> 243;
                            case 245 -> 46;
                            case 246 -> 124;
                            case 247 -> 76;
                            case 248 -> 248;
                            case 249 -> 92;
                            case 250 -> 96;
                            case 251 -> 132;
                            case 252 -> 43;
                            case 253 -> 232;
                            case 254 -> 10;
                            default -> 98;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (nArray == null) {
                ActionTimestamp.U(new ActionTimestamp[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 56027613412108L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.U();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(235008510 - (char)-24170, -235008510 - -((char)-25768), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(235008510 - (char)-24166, 235008510 - (char)-30234, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(235008510 - (char)-24179, -235008510 - -((char)-11947), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(235008510 - (char)-24170, -235008510 - -((char)-25768), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(235008510 - (char)-24166, 235008510 - (char)-30234, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(235008510 - (char)-24178, 235008510 - (char)-15126, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 56329297070385L;
                        int[] nArray2 = SshAgentIpcService.U();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-800968770 + -19828, 800968770 + 26143, (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-800968770 + -19827, -800968770 + -17098, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 28676010698633L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    nArray = SshAgentIpcService.U();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1485940590 - 6785, -1485940590 - -7501, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1485940590 - 6797, 1485940590 + 3375, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1485940590 - 6782, 1485940590 + 18593, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1485940590 - 6797, 1485940590 + 3375, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1485940590 - 6787, -1485940590 + -15756, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1485940590 - 6785, -1485940590 - -7501, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1485940590 - 6797, 1485940590 + 3375, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1485940590 - 6781, 1485940590 + 20787, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1485940590 - 6785, -1485940590 - -7501, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1485940590 - 6797, 1485940590 + 3375, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1485940590 - 6768, -1485940590 + -16551, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1485940590 - 6785, -1485940590 - -7501, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1485940590 - 6797, 1485940590 + 3375, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1485940590 - 6767, 1485940590 - 338, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 70520437542849L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                nArray = SshAgentIpcService.U();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27901), 1369550430 - (char)-28473, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27897), -1369550430 - -((char)-29901), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27886), 1369550430 - 15359, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27885), -1369550430 - -31603, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27901), 1369550430 - (char)-28473, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27897), -1369550430 - -((char)-29901), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27888), -1369550430 - -28824, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27901), 1369550430 - (char)-28473, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27897), -1369550430 - -((char)-29901), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27887), 1369550430 - 14115, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27901), 1369550430 - (char)-28473, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27897), -1369550430 - -((char)-29901), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27890), -1369550430 - -30846, (int)l2));
                    if (nArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27901), 1369550430 - (char)-28473, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27897), -1369550430 - -((char)-29901), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1369550430 - -((char)-27889), 1369550430 - (char)-22077, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u000b\u00bb\u00d5\u00ba\u009d\u0014Oz\u0014n\u0006A\u00ea\u00f1\u0096m0\u00d5IY\r\u000b\u00fa&\u0018\u008b?D\u008c\u0006\u00e1\u0094\u0088_\\\u00e9\u0018x\u00ad\u00e3\u00af'\u00fb\u00b5]\u0006\u0099,g\u00c3Hm\u00ccK\u00ccro!ZF\u0005\t\"V6a\u00f6\u00bd\u0097\u00dd~\u0005\u009f4GK\u00bf\b\u0081\u001c\u0084?\u00e5\u0082FJ\u0005y\u00a3\u009b\u00b9$\u001e<\u00cf&P\u000e\u00c02@S.\u00cd\u0016\u00b3F\u00c1i?\u00e9.?\u0006\u007f\u00aela\fX\u0000\u0098C\u0010\u00c1\u00b5}\u00da2\u00a3C\u00d5\u0000.*\u00ebI\u00ac1\u00ab\t\u0013o\u00c6W\u00bb\\\u0018~a\u0010U\u0091\u00ef^`3\t\u00c7Il\u0003\u00a3l\u00a5\u0095\u008a?1]\u008f\u00026\u0083\u00b0Dr\u007f\u00ac\u00c7 \u008a\u008e\u00c9\u0013\u0098\u00d6\u00d4\u0097P\u00e7\u00efX\u0094r\u00a7\u00ea\u00e1`\u0086\u00a7dn1\u00a3w\u00eb\u00c4\u0019\u00e14\u0085]\u007fn\u00d3\u00bd<\f\u0013\u0007\u0014\u00b6\u0000\u00d1d\u00d0\u001c\u009d@\u00a6\b\u00d1\u00da\u008e\u00e7\u00a4\u0099n)\fx\u00ec\u00ab:\u001d@\u00b7\u0015\u00b7~\u008e\u00e5Fx\u001f\u00abD\u001d\u008f\u00b7\u00ec\u00b7M\u0084G\u00b3\u0092\u00e3\u00ecB[\u00fc\u0003\u00c0\u00f8\u000e\u00c8S[\u00e0U\u0007\u0096\u00e7Tk\u00885\u008d\u0012\u00adv[9\u0007\u00bb\u00a2r\u001e\u00df\u0082l\u00eeP\u00e3c\u009c,\n\u001dQ\u00df\u0006Oj\u00a0z\u00c0Qm\u00a2l\u00a7\u001f\u00a4\u00ab5\u00dclQ~r\u00dah\u00fc\u00de\u0095B\u000eX\u00bd'\u0003,h\u009d\u00b4\u009bC\"\u000b\t\u00ef\u0093\u00f8\u000b\u00f6\u0095z\u0015'\u00a5\u00f0\u00a9_\u00e5\u0099\u0015 1\u00a0\u0082{?\u0097\u0087\u008d\u00c0\u000b\u0000\u00d55\u001b\u00e0\u00e4\u00a4\u00f5%\u0080)\u00e9s\u009c\u00c7Y2\u00d8\u001e\u000e\u00e5fo\u00c2~z\u00dal\u00ff\u00e2\u0090\u00a4r\u00eb~\u00c7\u00d7L\u00cf(\u00bf\u0082O9N\u0019\u00d8\u0089\u001a\u008e\u0004\u0085\u0007\u00e2\u0011\u00f7\u0091\u0010\u00a5j\u0007\u009c~\\\u0010\u0082z.(C\u00e7\u0085t\u00ca.\\\u00ba\u00ee\u00a6P1'4\u0084\u0010\u00b4\u000bWMs\u00f7~\u0005\u00e5\u0004\u00be\u00ceA\u00fft^\u001c\u0007#\\t\u00f7\u00a2J\u000f\u00fdl\u001c,\u0011I\u0082\u0095@\u00ce$m\t\u00eb\u00df\"\u0005\u000f\u0001H\u00ea\u00c3\u00ae \u00c0\"\u00bf\u0097\u00fam\u0019v\u00ebC\u0098E\u0001\u00c8\u00ffy\u00d6c\u00a3\u0087\u00f1\u0084\u001b/$\u00b1\u000e\u00af\u008bV\u00d0X\u00d6\u00abfe\u00b0\u0080\u00a2\u0091\u0018\u001b\\g/H\u008cp\u00a4\u00ee\u00d3&\u00dbq\u00aaT5G\u00c6\u00cf\u0080H9]\u008bm\u0013\u008cN\n\u00db\u00e7\u001b_\u001ev%\u0004H\u0019\u0018\u0018.\u00a7l\u009cH\u0087\u00b7\u00a9\u00c4V\u00b2\u00a2\u007f\u00c8\u0003\u000eFN\u0000\u0098\u001f\u00e4v))\u00b3\u0084\u00dfZ1\u00b8~\u0002\u00e9\u00e7\u00ee\u00f6Gc\u00861\u0001\u0096\u008a\u0010!4\u0018I\u0089\u0000\u00e8\u00f2\u0007b\u00c9\u0000@\u00eb\u008d\t\u0094\u009e\u00d5\u0087";
                var4_3 = "\u000b\u00bb\u00d5\u00ba\u009d\u0014Oz\u0014n\u0006A\u00ea\u00f1\u0096m0\u00d5IY\r\u000b\u00fa&\u0018\u008b?D\u008c\u0006\u00e1\u0094\u0088_\\\u00e9\u0018x\u00ad\u00e3\u00af'\u00fb\u00b5]\u0006\u0099,g\u00c3Hm\u00ccK\u00ccro!ZF\u0005\t\"V6a\u00f6\u00bd\u0097\u00dd~\u0005\u009f4GK\u00bf\b\u0081\u001c\u0084?\u00e5\u0082FJ\u0005y\u00a3\u009b\u00b9$\u001e<\u00cf&P\u000e\u00c02@S.\u00cd\u0016\u00b3F\u00c1i?\u00e9.?\u0006\u007f\u00aela\fX\u0000\u0098C\u0010\u00c1\u00b5}\u00da2\u00a3C\u00d5\u0000.*\u00ebI\u00ac1\u00ab\t\u0013o\u00c6W\u00bb\\\u0018~a\u0010U\u0091\u00ef^`3\t\u00c7Il\u0003\u00a3l\u00a5\u0095\u008a?1]\u008f\u00026\u0083\u00b0Dr\u007f\u00ac\u00c7 \u008a\u008e\u00c9\u0013\u0098\u00d6\u00d4\u0097P\u00e7\u00efX\u0094r\u00a7\u00ea\u00e1`\u0086\u00a7dn1\u00a3w\u00eb\u00c4\u0019\u00e14\u0085]\u007fn\u00d3\u00bd<\f\u0013\u0007\u0014\u00b6\u0000\u00d1d\u00d0\u001c\u009d@\u00a6\b\u00d1\u00da\u008e\u00e7\u00a4\u0099n)\fx\u00ec\u00ab:\u001d@\u00b7\u0015\u00b7~\u008e\u00e5Fx\u001f\u00abD\u001d\u008f\u00b7\u00ec\u00b7M\u0084G\u00b3\u0092\u00e3\u00ecB[\u00fc\u0003\u00c0\u00f8\u000e\u00c8S[\u00e0U\u0007\u0096\u00e7Tk\u00885\u008d\u0012\u00adv[9\u0007\u00bb\u00a2r\u001e\u00df\u0082l\u00eeP\u00e3c\u009c,\n\u001dQ\u00df\u0006Oj\u00a0z\u00c0Qm\u00a2l\u00a7\u001f\u00a4\u00ab5\u00dclQ~r\u00dah\u00fc\u00de\u0095B\u000eX\u00bd'\u0003,h\u009d\u00b4\u009bC\"\u000b\t\u00ef\u0093\u00f8\u000b\u00f6\u0095z\u0015'\u00a5\u00f0\u00a9_\u00e5\u0099\u0015 1\u00a0\u0082{?\u0097\u0087\u008d\u00c0\u000b\u0000\u00d55\u001b\u00e0\u00e4\u00a4\u00f5%\u0080)\u00e9s\u009c\u00c7Y2\u00d8\u001e\u000e\u00e5fo\u00c2~z\u00dal\u00ff\u00e2\u0090\u00a4r\u00eb~\u00c7\u00d7L\u00cf(\u00bf\u0082O9N\u0019\u00d8\u0089\u001a\u008e\u0004\u0085\u0007\u00e2\u0011\u00f7\u0091\u0010\u00a5j\u0007\u009c~\\\u0010\u0082z.(C\u00e7\u0085t\u00ca.\\\u00ba\u00ee\u00a6P1'4\u0084\u0010\u00b4\u000bWMs\u00f7~\u0005\u00e5\u0004\u00be\u00ceA\u00fft^\u001c\u0007#\\t\u00f7\u00a2J\u000f\u00fdl\u001c,\u0011I\u0082\u0095@\u00ce$m\t\u00eb\u00df\"\u0005\u000f\u0001H\u00ea\u00c3\u00ae \u00c0\"\u00bf\u0097\u00fam\u0019v\u00ebC\u0098E\u0001\u00c8\u00ffy\u00d6c\u00a3\u0087\u00f1\u0084\u001b/$\u00b1\u000e\u00af\u008bV\u00d0X\u00d6\u00abfe\u00b0\u0080\u00a2\u0091\u0018\u001b\\g/H\u008cp\u00a4\u00ee\u00d3&\u00dbq\u00aaT5G\u00c6\u00cf\u0080H9]\u008bm\u0013\u008cN\n\u00db\u00e7\u001b_\u001ev%\u0004H\u0019\u0018\u0018.\u00a7l\u009cH\u0087\u00b7\u00a9\u00c4V\u00b2\u00a2\u007f\u00c8\u0003\u000eFN\u0000\u0098\u001f\u00e4v))\u00b3\u0084\u00dfZ1\u00b8~\u0002\u00e9\u00e7\u00ee\u00f6Gc\u00861\u0001\u0096\u008a\u0010!4\u0018I\u0089\u0000\u00e8\u00f2\u0007b\u00c9\u0000@\u00eb\u008d\t\u0094\u009e\u00d5\u0087".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 41;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0016*\u0014\u0093\u0099yx\u00f3\u00a2\u001d#j\u00b7\u0096NjHgn\u00b8\u0018\u00b6{>\u00a0\u00db;\u00d4\u00f5\u00c6[\u00e5\u00dc,\u008da{\u00c2\u007f";
                    var4_3 = "\u0016*\u0014\u0093\u0099yx\u00f3\u00a2\u001d#j\u00b7\u0096NjHgn\u00b8\u0018\u00b6{>\u00a0\u00db;\u00d4\u00f5\u00c6[\u00e5\u00dc,\u008da{\u00c2\u007f".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 112;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 53;
                            break;
                        }
                        case 1: {
                            v15 = 55;
                            break;
                        }
                        case 2: {
                            v15 = 16;
                            break;
                        }
                        case 3: {
                            v15 = 6;
                            break;
                        }
                        case 4: {
                            v15 = 7;
                            break;
                        }
                        case 5: {
                            v15 = 39;
                            break;
                        }
                        default: {
                            v15 = 62;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFEB6F) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 239;
                case 1 -> 9;
                case 2 -> 182;
                case 3 -> 191;
                case 4 -> 189;
                case 5 -> 208;
                case 6 -> 153;
                case 7 -> 13;
                case 8 -> 53;
                case 9 -> 105;
                case 10 -> 51;
                case 11 -> 177;
                case 12 -> 101;
                case 13 -> 17;
                case 14 -> 167;
                case 15 -> 181;
                case 16 -> 54;
                case 17 -> 166;
                case 18 -> 31;
                case 19 -> 35;
                case 20 -> 213;
                case 21 -> 82;
                case 22 -> 224;
                case 23 -> 195;
                case 24 -> 140;
                case 25 -> 63;
                case 26 -> 146;
                case 27 -> 41;
                case 28 -> 15;
                case 29 -> 56;
                case 30 -> 30;
                case 31 -> 173;
                case 32 -> 80;
                case 33 -> 142;
                case 34 -> 20;
                case 35 -> 39;
                case 36 -> 203;
                case 37 -> 218;
                case 38 -> 46;
                case 39 -> 206;
                case 40 -> 83;
                case 41 -> 151;
                case 42 -> 48;
                case 43 -> 211;
                case 44 -> 126;
                case 45 -> 249;
                case 46 -> 165;
                case 47 -> 163;
                case 48 -> 68;
                case 49 -> 219;
                case 50 -> 164;
                case 51 -> 193;
                case 52 -> 139;
                case 53 -> 235;
                case 54 -> 172;
                case 55 -> 168;
                case 56 -> 19;
                case 57 -> 138;
                case 58 -> 121;
                case 59 -> 136;
                case 60 -> 85;
                case 61 -> 97;
                case 62 -> 214;
                case 63 -> 38;
                case 64 -> 36;
                case 65 -> 144;
                case 66 -> 156;
                case 67 -> 22;
                case 68 -> 242;
                case 69 -> 34;
                case 70 -> 21;
                case 71 -> 2;
                case 72 -> 8;
                case 73 -> 40;
                case 74 -> 45;
                case 75 -> 26;
                case 76 -> 118;
                case 77 -> 251;
                case 78 -> 65;
                case 79 -> 162;
                case 80 -> 89;
                case 81 -> 79;
                case 82 -> 109;
                case 83 -> 120;
                case 84 -> 248;
                case 85 -> 108;
                case 86 -> 122;
                case 87 -> 0;
                case 88 -> 11;
                case 89 -> 102;
                case 90 -> 207;
                case 91 -> 88;
                case 92 -> 184;
                case 93 -> 245;
                case 94 -> 247;
                case 95 -> 7;
                case 96 -> 72;
                case 97 -> 69;
                case 98 -> 171;
                case 99 -> 110;
                case 100 -> 104;
                case 101 -> 255;
                case 102 -> 254;
                case 103 -> 160;
                case 104 -> 198;
                case 105 -> 128;
                case 106 -> 16;
                case 107 -> 100;
                case 108 -> 252;
                case 109 -> 47;
                case 110 -> 179;
                case 111 -> 94;
                case 112 -> 123;
                case 113 -> 27;
                case 114 -> 33;
                case 115 -> 212;
                case 116 -> 23;
                case 117 -> 183;
                case 118 -> 231;
                case 119 -> 119;
                case 120 -> 59;
                case 121 -> 223;
                case 122 -> 117;
                case 123 -> 187;
                case 124 -> 91;
                case 125 -> 14;
                case 126 -> 60;
                case 127 -> 58;
                case 128 -> 210;
                case 129 -> 176;
                case 130 -> 145;
                case 131 -> 103;
                case 132 -> 37;
                case 133 -> 49;
                case 134 -> 113;
                case 135 -> 52;
                case 136 -> 240;
                case 137 -> 133;
                case 138 -> 192;
                case 139 -> 200;
                case 140 -> 225;
                case 141 -> 154;
                case 142 -> 87;
                case 143 -> 5;
                case 144 -> 129;
                case 145 -> 157;
                case 146 -> 238;
                case 147 -> 197;
                case 148 -> 215;
                case 149 -> 222;
                case 150 -> 205;
                case 151 -> 62;
                case 152 -> 112;
                case 153 -> 44;
                case 154 -> 106;
                case 155 -> 25;
                case 156 -> 92;
                case 157 -> 230;
                case 158 -> 246;
                case 159 -> 220;
                case 160 -> 18;
                case 161 -> 180;
                case 162 -> 76;
                case 163 -> 161;
                case 164 -> 99;
                case 165 -> 199;
                case 166 -> 170;
                case 167 -> 234;
                case 168 -> 227;
                case 169 -> 29;
                case 170 -> 237;
                case 171 -> 74;
                case 172 -> 61;
                case 173 -> 130;
                case 174 -> 57;
                case 175 -> 124;
                case 176 -> 78;
                case 177 -> 217;
                case 178 -> 84;
                case 179 -> 12;
                case 180 -> 149;
                case 181 -> 169;
                case 182 -> 81;
                case 183 -> 32;
                case 184 -> 6;
                case 185 -> 98;
                case 186 -> 137;
                case 187 -> 185;
                case 188 -> 243;
                case 189 -> 70;
                case 190 -> 229;
                case 191 -> 216;
                case 192 -> 3;
                case 193 -> 96;
                case 194 -> 86;
                case 195 -> 28;
                case 196 -> 95;
                case 197 -> 147;
                case 198 -> 66;
                case 199 -> 233;
                case 200 -> 90;
                case 201 -> 55;
                case 202 -> 64;
                case 203 -> 125;
                case 204 -> 131;
                case 205 -> 152;
                case 206 -> 116;
                case 207 -> 143;
                case 208 -> 150;
                case 209 -> 190;
                case 210 -> 158;
                case 211 -> 10;
                case 212 -> 209;
                case 213 -> 253;
                case 214 -> 228;
                case 215 -> 42;
                case 216 -> 196;
                case 217 -> 148;
                case 218 -> 132;
                case 219 -> 244;
                case 220 -> 159;
                case 221 -> 201;
                case 222 -> 226;
                case 223 -> 178;
                case 224 -> 93;
                case 225 -> 77;
                case 226 -> 204;
                case 227 -> 202;
                case 228 -> 107;
                case 229 -> 24;
                case 230 -> 236;
                case 231 -> 241;
                case 232 -> 50;
                case 233 -> 115;
                case 234 -> 67;
                case 235 -> 75;
                case 236 -> 43;
                case 237 -> 175;
                case 238 -> 141;
                case 239 -> 155;
                case 240 -> 232;
                case 241 -> 1;
                case 242 -> 71;
                case 243 -> 111;
                case 244 -> 174;
                case 245 -> 73;
                case 246 -> 221;
                case 247 -> 135;
                case 248 -> 186;
                case 249 -> 4;
                case 250 -> 127;
                case 251 -> 188;
                case 252 -> 134;
                case 253 -> 250;
                case 254 -> 194;
                default -> 114;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 57360891496928L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1603248240 + -16657, -1603248240 + -5857, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 41172864886573L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.U();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1308340740 + -((char)-25271), -1308340740 + -((char)-17755), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1308340740 + -((char)-25268), 1308340740 + 21957, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1308340740 + -((char)-25269), 1308340740 + 24107, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00c8U\u0095/\u00f6\u00da2\u00c7\u0010\u00dc\u001e\u00e6\u00e7\"xQ\u00caf\u00f5\u00ae\u00f3\u00a5\u00bf\u00c8\u00ed";
                    var4_3 = "\u00c8U\u0095/\u00f6\u00da2\u00c7\u0010\u00dc\u001e\u00e6\u00e7\"xQ\u00caf\u00f5\u00ae\u00f3\u00a5\u00bf\u00c8\u00ed".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 24;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u000b\u00a4\f\u00f0T5r\u00b94?\u0081\u00bb\u00dc\u00f8A\u00e99QA\u00e0\u00b0m\u0013l\u00c3F\u00d8\u0002g(\u0080A\u00eb\u00c6\u00cc8\u00acS@\u00ffg\u0086\u0082r\"\u008d\r\u0016\u00a4V\u00c3G\u00cd\u00db\u008cN\u00fc\u00a1\u00f5";
                        var4_3 = "\u000b\u00a4\f\u00f0T5r\u00b94?\u0081\u00bb\u00dc\u00f8A\u00e99QA\u00e0\u00b0m\u0013l\u00c3F\u00d8\u0002g(\u0080A\u00eb\u00c6\u00cc8\u00acS@\u00ffg\u0086\u0082r\"\u008d\r\u0016\u00a4V\u00c3G\u00cd\u00db\u008cN\u00fc\u00a1\u00f5".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 116;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 79;
                                break;
                            }
                            case 1: {
                                v15 = 5;
                                break;
                            }
                            case 2: {
                                v15 = 112;
                                break;
                            }
                            case 3: {
                                v15 = 31;
                                break;
                            }
                            case 4: {
                                v15 = 127;
                                break;
                            }
                            case 5: {
                                v15 = 111;
                                break;
                            }
                            default: {
                                v15 = 54;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFD79F) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 104;
                    case 1 -> 60;
                    case 2 -> 206;
                    case 3 -> 172;
                    case 4 -> 97;
                    case 5 -> 110;
                    case 6 -> 14;
                    case 7 -> 246;
                    case 8 -> 141;
                    case 9 -> 151;
                    case 10 -> 140;
                    case 11 -> 194;
                    case 12 -> 36;
                    case 13 -> 231;
                    case 14 -> 28;
                    case 15 -> 135;
                    case 16 -> 227;
                    case 17 -> 170;
                    case 18 -> 3;
                    case 19 -> 173;
                    case 20 -> 196;
                    case 21 -> 180;
                    case 22 -> 54;
                    case 23 -> 47;
                    case 24 -> 111;
                    case 25 -> 119;
                    case 26 -> 51;
                    case 27 -> 158;
                    case 28 -> 212;
                    case 29 -> 125;
                    case 30 -> 108;
                    case 31 -> 241;
                    case 32 -> 95;
                    case 33 -> 37;
                    case 34 -> 92;
                    case 35 -> 73;
                    case 36 -> 56;
                    case 37 -> 176;
                    case 38 -> 77;
                    case 39 -> 193;
                    case 40 -> 249;
                    case 41 -> 232;
                    case 42 -> 190;
                    case 43 -> 222;
                    case 44 -> 12;
                    case 45 -> 63;
                    case 46 -> 149;
                    case 47 -> 121;
                    case 48 -> 164;
                    case 49 -> 175;
                    case 50 -> 168;
                    case 51 -> 16;
                    case 52 -> 120;
                    case 53 -> 30;
                    case 54 -> 161;
                    case 55 -> 49;
                    case 56 -> 20;
                    case 57 -> 146;
                    case 58 -> 218;
                    case 59 -> 6;
                    case 60 -> 102;
                    case 61 -> 171;
                    case 62 -> 69;
                    case 63 -> 223;
                    case 64 -> 115;
                    case 65 -> 44;
                    case 66 -> 248;
                    case 67 -> 76;
                    case 68 -> 64;
                    case 69 -> 79;
                    case 70 -> 9;
                    case 71 -> 66;
                    case 72 -> 211;
                    case 73 -> 143;
                    case 74 -> 245;
                    case 75 -> 179;
                    case 76 -> 78;
                    case 77 -> 203;
                    case 78 -> 98;
                    case 79 -> 197;
                    case 80 -> 243;
                    case 81 -> 235;
                    case 82 -> 34;
                    case 83 -> 150;
                    case 84 -> 17;
                    case 85 -> 184;
                    case 86 -> 43;
                    case 87 -> 19;
                    case 88 -> 38;
                    case 89 -> 182;
                    case 90 -> 155;
                    case 91 -> 31;
                    case 92 -> 126;
                    case 93 -> 32;
                    case 94 -> 209;
                    case 95 -> 88;
                    case 96 -> 8;
                    case 97 -> 242;
                    case 98 -> 21;
                    case 99 -> 253;
                    case 100 -> 67;
                    case 101 -> 55;
                    case 102 -> 201;
                    case 103 -> 178;
                    case 104 -> 105;
                    case 105 -> 2;
                    case 106 -> 116;
                    case 107 -> 225;
                    case 108 -> 35;
                    case 109 -> 144;
                    case 110 -> 220;
                    case 111 -> 254;
                    case 112 -> 198;
                    case 113 -> 57;
                    case 114 -> 186;
                    case 115 -> 183;
                    case 116 -> 229;
                    case 117 -> 205;
                    case 118 -> 18;
                    case 119 -> 192;
                    case 120 -> 68;
                    case 121 -> 75;
                    case 122 -> 152;
                    case 123 -> 107;
                    case 124 -> 200;
                    case 125 -> 99;
                    case 126 -> 134;
                    case 127 -> 129;
                    case 128 -> 87;
                    case 129 -> 255;
                    case 130 -> 136;
                    case 131 -> 22;
                    case 132 -> 138;
                    case 133 -> 236;
                    case 134 -> 4;
                    case 135 -> 90;
                    case 136 -> 89;
                    case 137 -> 157;
                    case 138 -> 228;
                    case 139 -> 142;
                    case 140 -> 25;
                    case 141 -> 118;
                    case 142 -> 147;
                    case 143 -> 24;
                    case 144 -> 74;
                    case 145 -> 52;
                    case 146 -> 185;
                    case 147 -> 10;
                    case 148 -> 154;
                    case 149 -> 23;
                    case 150 -> 162;
                    case 151 -> 124;
                    case 152 -> 210;
                    case 153 -> 167;
                    case 154 -> 160;
                    case 155 -> 221;
                    case 156 -> 216;
                    case 157 -> 244;
                    case 158 -> 163;
                    case 159 -> 96;
                    case 160 -> 169;
                    case 161 -> 159;
                    case 162 -> 82;
                    case 163 -> 5;
                    case 164 -> 114;
                    case 165 -> 238;
                    case 166 -> 86;
                    case 167 -> 239;
                    case 168 -> 181;
                    case 169 -> 189;
                    case 170 -> 226;
                    case 171 -> 165;
                    case 172 -> 15;
                    case 173 -> 45;
                    case 174 -> 240;
                    case 175 -> 80;
                    case 176 -> 50;
                    case 177 -> 195;
                    case 178 -> 230;
                    case 179 -> 233;
                    case 180 -> 213;
                    case 181 -> 215;
                    case 182 -> 133;
                    case 183 -> 11;
                    case 184 -> 61;
                    case 185 -> 65;
                    case 186 -> 234;
                    case 187 -> 188;
                    case 188 -> 237;
                    case 189 -> 7;
                    case 190 -> 100;
                    case 191 -> 83;
                    case 192 -> 166;
                    case 193 -> 148;
                    case 194 -> 130;
                    case 195 -> 145;
                    case 196 -> 26;
                    case 197 -> 106;
                    case 198 -> 1;
                    case 199 -> 27;
                    case 200 -> 91;
                    case 201 -> 139;
                    case 202 -> 93;
                    case 203 -> 123;
                    case 204 -> 224;
                    case 205 -> 101;
                    case 206 -> 71;
                    case 207 -> 81;
                    case 208 -> 204;
                    case 209 -> 128;
                    case 210 -> 103;
                    case 211 -> 29;
                    case 212 -> 94;
                    case 213 -> 199;
                    case 214 -> 174;
                    case 215 -> 62;
                    case 216 -> 207;
                    case 217 -> 127;
                    case 218 -> 40;
                    case 219 -> 131;
                    case 220 -> 187;
                    case 221 -> 84;
                    case 222 -> 72;
                    case 223 -> 117;
                    case 224 -> 251;
                    case 225 -> 177;
                    case 226 -> 48;
                    case 227 -> 58;
                    case 228 -> 137;
                    case 229 -> 53;
                    case 230 -> 247;
                    case 231 -> 208;
                    case 232 -> 59;
                    case 233 -> 202;
                    case 234 -> 219;
                    case 235 -> 156;
                    case 236 -> 250;
                    case 237 -> 70;
                    case 238 -> 113;
                    case 239 -> 39;
                    case 240 -> 132;
                    case 241 -> 191;
                    case 242 -> 0;
                    case 243 -> 109;
                    case 244 -> 85;
                    case 245 -> 214;
                    case 246 -> 13;
                    case 247 -> 153;
                    case 248 -> 41;
                    case 249 -> 217;
                    case 250 -> 42;
                    case 251 -> 252;
                    case 252 -> 33;
                    case 253 -> 122;
                    case 254 -> 46;
                    default -> 112;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 86055673348104L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\b\u0001 LIvrQ\t\u000f\u000b3F\u00044oMM";
                    var5_4 = "\b\u0001 LIvrQ\t\u000f\u000b3F\u00044oMM".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 94;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 61;
                                    break;
                                }
                                case 1: {
                                    v11 = 58;
                                    break;
                                }
                                case 2: {
                                    v11 = 12;
                                    break;
                                }
                                case 3: {
                                    v11 = 124;
                                    break;
                                }
                                case 4: {
                                    v11 = 114;
                                    break;
                                }
                                case 5: {
                                    v11 = 68;
                                    break;
                                }
                                default: {
                                    v11 = 31;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 22736028049671L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "`y0ft\u0000\r\u0004fg<|\njx7|x\u0002\u0015@y>\tjx7|x\u0002\u0015Ls\rm~*qr\u000f\u000fLt-{s\u0006";
                    var5_4 = "`y0ft\u0000\r\u0004fg<|\njx7|x\u0002\u0015@y>\tjx7|x\u0002\u0015Ls\rm~*qr\u000f\u000fLt-{s\u0006".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 114;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u0006\u0017Z\r\u0018cj\u0006\u0006\u0017Z\r\u0014i";
                        var5_4 = "\u0006\u0017Z\r\u0018cj\u0006\u0006\u0017Z\r\u0014i".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 30;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 91;
                                break;
                            }
                            case 1: {
                                v15 = 101;
                                break;
                            }
                            case 2: {
                                v15 = 43;
                                break;
                            }
                            case 3: {
                                v15 = 96;
                                break;
                            }
                            case 4: {
                                v15 = 111;
                                break;
                            }
                            case 5: {
                                v15 = 19;
                                break;
                            }
                            default: {
                                v15 = 19;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n25#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 134804920943264L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1217509230 + -((char)-2392), -1217509230 + -((char)-6574), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 97226874562503L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00den\u0007&e\u0003\u0096k\u00ba\u0005\u00fe\u00d8%4\u00c2\rc\u00c9\u00a0\\\u0087\u00fb\u00b1\u00b5\u0012\u00e8iO\u00da\u0010\u001e\u00d4\u00c8\u0014\u00b5g\u00dc\u001bv\u00b9\u0006(\u00d1\u00bbt\u00cc\u0005\u00e7\u0001\u0006\u000f\u00a63\u00fay\u00b4w\u00efO\u00a7\ndf\u00cf\u00fa.\u00b0\u00a7\u00b2V\u00c7\u00af\u00b3li\u00d7Z\u0016#PB\u00d6\\G\u00c9O\u008a\u00f8\u0090\u00cbe\u00f0\u00d6J\u00b9\u008e\u00d1`\u008edH\u00ae\u00df\b";
                    var4_3 = "\u00den\u0007&e\u0003\u0096k\u00ba\u0005\u00fe\u00d8%4\u00c2\rc\u00c9\u00a0\\\u0087\u00fb\u00b1\u00b5\u0012\u00e8iO\u00da\u0010\u001e\u00d4\u00c8\u0014\u00b5g\u00dc\u001bv\u00b9\u0006(\u00d1\u00bbt\u00cc\u0005\u00e7\u0001\u0006\u000f\u00a63\u00fay\u00b4w\u00efO\u00a7\ndf\u00cf\u00fa.\u00b0\u00a7\u00b2V\u00c7\u00af\u00b3li\u00d7Z\u0016#PB\u00d6\\G\u00c9O\u008a\u00f8\u0090\u00cbe\u00f0\u00d6J\u00b9\u008e\u00d1`\u008edH\u00ae\u00df\b".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 43;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "Y\u00c6O9*\u00ad@-\u008a\u0010\u00f6r\u00a0\u009f5'L\t\u00bd\u00b2\u009c\u00bf\u00d1\u009c\u00cc\u0098\u00bf\u0018>s\u0098\u00dc\u00beS\u00f8\u009f\u00cdm\u00ad\u00b2\u000f\u00f6\r\u0006.\u0089\u00f7,\u00bc]\u00a5\u00a4\u0006\u001d\u0006\u007f\u00b3\u00e2\u0087;\u0004\u00ac\u0085Y~\u0094B\u00c8L=x|\u007f\u00b5\u00b5\u00b2\u0092\u00bb\u009b\u00ca\b\u0012>@p\u0012\u00aa\u00a6(\u00f3\u0015\u0086\u00e7";
                        var4_3 = "Y\u00c6O9*\u00ad@-\u008a\u0010\u00f6r\u00a0\u009f5'L\t\u00bd\u00b2\u009c\u00bf\u00d1\u009c\u00cc\u0098\u00bf\u0018>s\u0098\u00dc\u00beS\u00f8\u009f\u00cdm\u00ad\u00b2\u000f\u00f6\r\u0006.\u0089\u00f7,\u00bc]\u00a5\u00a4\u0006\u001d\u0006\u007f\u00b3\u00e2\u0087;\u0004\u00ac\u0085Y~\u0094B\u00c8L=x|\u007f\u00b5\u00b5\u00b2\u0092\u00bb\u009b\u00ca\b\u0012>@p\u0012\u00aa\u00a6(\u00f3\u0015\u0086\u00e7".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 1;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 79;
                                break;
                            }
                            case 1: {
                                v15 = 57;
                                break;
                            }
                            case 2: {
                                v15 = 83;
                                break;
                            }
                            case 3: {
                                v15 = 103;
                                break;
                            }
                            case 4: {
                                v15 = 28;
                                break;
                            }
                            case 5: {
                                v15 = 84;
                                break;
                            }
                            default: {
                                v15 = 112;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x134A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 227;
                    case 1 -> 162;
                    case 2 -> 113;
                    case 3 -> 10;
                    case 4 -> 98;
                    case 5 -> 104;
                    case 6 -> 167;
                    case 7 -> 137;
                    case 8 -> 221;
                    case 9 -> 108;
                    case 10 -> 95;
                    case 11 -> 250;
                    case 12 -> 230;
                    case 13 -> 30;
                    case 14 -> 210;
                    case 15 -> 6;
                    case 16 -> 8;
                    case 17 -> 74;
                    case 18 -> 126;
                    case 19 -> 183;
                    case 20 -> 206;
                    case 21 -> 207;
                    case 22 -> 153;
                    case 23 -> 34;
                    case 24 -> 188;
                    case 25 -> 13;
                    case 26 -> 72;
                    case 27 -> 150;
                    case 28 -> 102;
                    case 29 -> 128;
                    case 30 -> 211;
                    case 31 -> 224;
                    case 32 -> 92;
                    case 33 -> 112;
                    case 34 -> 143;
                    case 35 -> 93;
                    case 36 -> 67;
                    case 37 -> 175;
                    case 38 -> 220;
                    case 39 -> 225;
                    case 40 -> 16;
                    case 41 -> 158;
                    case 42 -> 20;
                    case 43 -> 157;
                    case 44 -> 68;
                    case 45 -> 180;
                    case 46 -> 177;
                    case 47 -> 234;
                    case 48 -> 83;
                    case 49 -> 90;
                    case 50 -> 82;
                    case 51 -> 123;
                    case 52 -> 4;
                    case 53 -> 200;
                    case 54 -> 44;
                    case 55 -> 37;
                    case 56 -> 218;
                    case 57 -> 21;
                    case 58 -> 47;
                    case 59 -> 114;
                    case 60 -> 248;
                    case 61 -> 229;
                    case 62 -> 228;
                    case 63 -> 172;
                    case 64 -> 86;
                    case 65 -> 125;
                    case 66 -> 147;
                    case 67 -> 181;
                    case 68 -> 48;
                    case 69 -> 195;
                    case 70 -> 79;
                    case 71 -> 184;
                    case 72 -> 146;
                    case 73 -> 155;
                    case 74 -> 107;
                    case 75 -> 191;
                    case 76 -> 166;
                    case 77 -> 42;
                    case 78 -> 52;
                    case 79 -> 97;
                    case 80 -> 233;
                    case 81 -> 135;
                    case 82 -> 106;
                    case 83 -> 194;
                    case 84 -> 169;
                    case 85 -> 99;
                    case 86 -> 45;
                    case 87 -> 59;
                    case 88 -> 161;
                    case 89 -> 50;
                    case 90 -> 119;
                    case 91 -> 121;
                    case 92 -> 120;
                    case 93 -> 129;
                    case 94 -> 151;
                    case 95 -> 122;
                    case 96 -> 55;
                    case 97 -> 46;
                    case 98 -> 140;
                    case 99 -> 49;
                    case 100 -> 246;
                    case 101 -> 38;
                    case 102 -> 179;
                    case 103 -> 29;
                    case 104 -> 136;
                    case 105 -> 23;
                    case 106 -> 75;
                    case 107 -> 190;
                    case 108 -> 249;
                    case 109 -> 87;
                    case 110 -> 247;
                    case 111 -> 94;
                    case 112 -> 31;
                    case 113 -> 51;
                    case 114 -> 11;
                    case 115 -> 58;
                    case 116 -> 236;
                    case 117 -> 130;
                    case 118 -> 127;
                    case 119 -> 81;
                    case 120 -> 196;
                    case 121 -> 118;
                    case 122 -> 32;
                    case 123 -> 33;
                    case 124 -> 199;
                    case 125 -> 62;
                    case 126 -> 203;
                    case 127 -> 0;
                    case 128 -> 168;
                    case 129 -> 171;
                    case 130 -> 110;
                    case 131 -> 88;
                    case 132 -> 142;
                    case 133 -> 144;
                    case 134 -> 9;
                    case 135 -> 103;
                    case 136 -> 235;
                    case 137 -> 219;
                    case 138 -> 223;
                    case 139 -> 232;
                    case 140 -> 115;
                    case 141 -> 149;
                    case 142 -> 18;
                    case 143 -> 205;
                    case 144 -> 61;
                    case 145 -> 176;
                    case 146 -> 242;
                    case 147 -> 252;
                    case 148 -> 201;
                    case 149 -> 231;
                    case 150 -> 105;
                    case 151 -> 241;
                    case 152 -> 25;
                    case 153 -> 69;
                    case 154 -> 226;
                    case 155 -> 12;
                    case 156 -> 39;
                    case 157 -> 41;
                    case 158 -> 165;
                    case 159 -> 216;
                    case 160 -> 186;
                    case 161 -> 133;
                    case 162 -> 238;
                    case 163 -> 245;
                    case 164 -> 251;
                    case 165 -> 213;
                    case 166 -> 141;
                    case 167 -> 173;
                    case 168 -> 215;
                    case 169 -> 189;
                    case 170 -> 116;
                    case 171 -> 208;
                    case 172 -> 54;
                    case 173 -> 202;
                    case 174 -> 91;
                    case 175 -> 131;
                    case 176 -> 24;
                    case 177 -> 209;
                    case 178 -> 57;
                    case 179 -> 174;
                    case 180 -> 22;
                    case 181 -> 164;
                    case 182 -> 117;
                    case 183 -> 222;
                    case 184 -> 56;
                    case 185 -> 77;
                    case 186 -> 5;
                    case 187 -> 253;
                    case 188 -> 187;
                    case 189 -> 185;
                    case 190 -> 73;
                    case 191 -> 163;
                    case 192 -> 255;
                    case 193 -> 85;
                    case 194 -> 43;
                    case 195 -> 193;
                    case 196 -> 3;
                    case 197 -> 96;
                    case 198 -> 138;
                    case 199 -> 132;
                    case 200 -> 60;
                    case 201 -> 212;
                    case 202 -> 27;
                    case 203 -> 2;
                    case 204 -> 14;
                    case 205 -> 134;
                    case 206 -> 100;
                    case 207 -> 217;
                    case 208 -> 254;
                    case 209 -> 101;
                    case 210 -> 80;
                    case 211 -> 19;
                    case 212 -> 71;
                    case 213 -> 237;
                    case 214 -> 36;
                    case 215 -> 160;
                    case 216 -> 124;
                    case 217 -> 1;
                    case 218 -> 78;
                    case 219 -> 7;
                    case 220 -> 152;
                    case 221 -> 243;
                    case 222 -> 156;
                    case 223 -> 65;
                    case 224 -> 76;
                    case 225 -> 154;
                    case 226 -> 214;
                    case 227 -> 15;
                    case 228 -> 66;
                    case 229 -> 197;
                    case 230 -> 239;
                    case 231 -> 70;
                    case 232 -> 28;
                    case 233 -> 244;
                    case 234 -> 84;
                    case 235 -> 89;
                    case 236 -> 182;
                    case 237 -> 63;
                    case 238 -> 53;
                    case 239 -> 170;
                    case 240 -> 109;
                    case 241 -> 35;
                    case 242 -> 145;
                    case 243 -> 178;
                    case 244 -> 17;
                    case 245 -> 26;
                    case 246 -> 64;
                    case 247 -> 148;
                    case 248 -> 139;
                    case 249 -> 40;
                    case 250 -> 198;
                    case 251 -> 204;
                    case 252 -> 111;
                    case 253 -> 159;
                    case 254 -> 240;
                    default -> 192;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 105303671314662L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-336849900 - -16508, 336849900 - 9891, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 6354401471107L;
                    int[] nArray = SshAgentIpcService.U();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(2144829480 + 26316, -2144829480 + -7697, (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 124253297087821L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u007f\u00e6 \u00fc\u00d6\u0003\u001c\u00c5\u001a";
                var4_3 = "\u007f\u00e6 \u00fc\u00d6\u0003\u001c\u00c5\u001a".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 37;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 83;
                                break;
                            }
                            case 1: {
                                v11 = 50;
                                break;
                            }
                            case 2: {
                                v11 = 12;
                                break;
                            }
                            case 3: {
                                v11 = 2;
                                break;
                            }
                            case 4: {
                                v11 = 111;
                                break;
                            }
                            case 5: {
                                v11 = 54;
                                break;
                            }
                            default: {
                                v11 = 103;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x4C76) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 117;
                    case 1 -> 28;
                    case 2 -> 254;
                    case 3 -> 207;
                    case 4 -> 87;
                    case 5 -> 6;
                    case 6 -> 170;
                    case 7 -> 165;
                    case 8 -> 217;
                    case 9 -> 71;
                    case 10 -> 128;
                    case 11 -> 21;
                    case 12 -> 37;
                    case 13 -> 68;
                    case 14 -> 186;
                    case 15 -> 97;
                    case 16 -> 179;
                    case 17 -> 216;
                    case 18 -> 4;
                    case 19 -> 113;
                    case 20 -> 218;
                    case 21 -> 192;
                    case 22 -> 149;
                    case 23 -> 50;
                    case 24 -> 33;
                    case 25 -> 27;
                    case 26 -> 72;
                    case 27 -> 250;
                    case 28 -> 136;
                    case 29 -> 246;
                    case 30 -> 42;
                    case 31 -> 224;
                    case 32 -> 190;
                    case 33 -> 48;
                    case 34 -> 2;
                    case 35 -> 206;
                    case 36 -> 143;
                    case 37 -> 191;
                    case 38 -> 59;
                    case 39 -> 205;
                    case 40 -> 158;
                    case 41 -> 74;
                    case 42 -> 22;
                    case 43 -> 47;
                    case 44 -> 105;
                    case 45 -> 183;
                    case 46 -> 96;
                    case 47 -> 208;
                    case 48 -> 62;
                    case 49 -> 9;
                    case 50 -> 157;
                    case 51 -> 114;
                    case 52 -> 162;
                    case 53 -> 171;
                    case 54 -> 200;
                    case 55 -> 10;
                    case 56 -> 19;
                    case 57 -> 111;
                    case 58 -> 248;
                    case 59 -> 107;
                    case 60 -> 65;
                    case 61 -> 227;
                    case 62 -> 35;
                    case 63 -> 235;
                    case 64 -> 110;
                    case 65 -> 108;
                    case 66 -> 210;
                    case 67 -> 7;
                    case 68 -> 3;
                    case 69 -> 242;
                    case 70 -> 92;
                    case 71 -> 153;
                    case 72 -> 53;
                    case 73 -> 212;
                    case 74 -> 80;
                    case 75 -> 137;
                    case 76 -> 156;
                    case 77 -> 12;
                    case 78 -> 73;
                    case 79 -> 0;
                    case 80 -> 104;
                    case 81 -> 93;
                    case 82 -> 118;
                    case 83 -> 140;
                    case 84 -> 126;
                    case 85 -> 177;
                    case 86 -> 84;
                    case 87 -> 142;
                    case 88 -> 8;
                    case 89 -> 167;
                    case 90 -> 99;
                    case 91 -> 175;
                    case 92 -> 41;
                    case 93 -> 221;
                    case 94 -> 20;
                    case 95 -> 85;
                    case 96 -> 103;
                    case 97 -> 122;
                    case 98 -> 182;
                    case 99 -> 44;
                    case 100 -> 90;
                    case 101 -> 145;
                    case 102 -> 141;
                    case 103 -> 38;
                    case 104 -> 69;
                    case 105 -> 199;
                    case 106 -> 43;
                    case 107 -> 163;
                    case 108 -> 16;
                    case 109 -> 100;
                    case 110 -> 196;
                    case 111 -> 112;
                    case 112 -> 135;
                    case 113 -> 17;
                    case 114 -> 34;
                    case 115 -> 220;
                    case 116 -> 184;
                    case 117 -> 49;
                    case 118 -> 98;
                    case 119 -> 24;
                    case 120 -> 174;
                    case 121 -> 211;
                    case 122 -> 201;
                    case 123 -> 36;
                    case 124 -> 14;
                    case 125 -> 52;
                    case 126 -> 51;
                    case 127 -> 81;
                    case 128 -> 121;
                    case 129 -> 144;
                    case 130 -> 194;
                    case 131 -> 45;
                    case 132 -> 202;
                    case 133 -> 132;
                    case 134 -> 46;
                    case 135 -> 180;
                    case 136 -> 164;
                    case 137 -> 176;
                    case 138 -> 146;
                    case 139 -> 25;
                    case 140 -> 229;
                    case 141 -> 247;
                    case 142 -> 193;
                    case 143 -> 18;
                    case 144 -> 226;
                    case 145 -> 219;
                    case 146 -> 188;
                    case 147 -> 178;
                    case 148 -> 168;
                    case 149 -> 148;
                    case 150 -> 88;
                    case 151 -> 30;
                    case 152 -> 231;
                    case 153 -> 204;
                    case 154 -> 151;
                    case 155 -> 152;
                    case 156 -> 83;
                    case 157 -> 173;
                    case 158 -> 237;
                    case 159 -> 56;
                    case 160 -> 166;
                    case 161 -> 15;
                    case 162 -> 233;
                    case 163 -> 209;
                    case 164 -> 63;
                    case 165 -> 225;
                    case 166 -> 160;
                    case 167 -> 5;
                    case 168 -> 39;
                    case 169 -> 243;
                    case 170 -> 181;
                    case 171 -> 82;
                    case 172 -> 236;
                    case 173 -> 241;
                    case 174 -> 13;
                    case 175 -> 23;
                    case 176 -> 106;
                    case 177 -> 125;
                    case 178 -> 60;
                    case 179 -> 134;
                    case 180 -> 78;
                    case 181 -> 232;
                    case 182 -> 215;
                    case 183 -> 1;
                    case 184 -> 203;
                    case 185 -> 26;
                    case 186 -> 213;
                    case 187 -> 253;
                    case 188 -> 116;
                    case 189 -> 147;
                    case 190 -> 95;
                    case 191 -> 198;
                    case 192 -> 130;
                    case 193 -> 169;
                    case 194 -> 115;
                    case 195 -> 57;
                    case 196 -> 228;
                    case 197 -> 187;
                    case 198 -> 79;
                    case 199 -> 222;
                    case 200 -> 154;
                    case 201 -> 245;
                    case 202 -> 101;
                    case 203 -> 251;
                    case 204 -> 32;
                    case 205 -> 86;
                    case 206 -> 252;
                    case 207 -> 139;
                    case 208 -> 197;
                    case 209 -> 64;
                    case 210 -> 55;
                    case 211 -> 124;
                    case 212 -> 31;
                    case 213 -> 67;
                    case 214 -> 11;
                    case 215 -> 244;
                    case 216 -> 94;
                    case 217 -> 127;
                    case 218 -> 161;
                    case 219 -> 138;
                    case 220 -> 77;
                    case 221 -> 240;
                    case 222 -> 119;
                    case 223 -> 58;
                    case 224 -> 123;
                    case 225 -> 239;
                    case 226 -> 230;
                    case 227 -> 214;
                    case 228 -> 133;
                    case 229 -> 54;
                    case 230 -> 75;
                    case 231 -> 120;
                    case 232 -> 76;
                    case 233 -> 223;
                    case 234 -> 91;
                    case 235 -> 70;
                    case 236 -> 195;
                    case 237 -> 129;
                    case 238 -> 234;
                    case 239 -> 89;
                    case 240 -> 172;
                    case 241 -> 66;
                    case 242 -> 150;
                    case 243 -> 185;
                    case 244 -> 29;
                    case 245 -> 159;
                    case 246 -> 131;
                    case 247 -> 102;
                    case 248 -> 238;
                    case 249 -> 40;
                    case 250 -> 109;
                    case 251 -> 249;
                    case 252 -> 255;
                    case 253 -> 61;
                    case 254 -> 189;
                    default -> 155;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

