/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IconProvider;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.KubernetesYamlDetector;
import com.intellij.kubernetes.api.settings.KubeConfig;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartLocator;
import com.intellij.kubernetes.helm.chart.ChartPresence;
import com.intellij.kubernetes.helm.tgz.TgzFileSystem;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLLanguage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/KubernetesFileIconProvider;", "Lcom/intellij/ide/IconProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "element", "Lcom/intellij/psi/PsiElement;", "flags", "", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesFileIconProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesFileIconProvider.kt\ncom/intellij/kubernetes/KubernetesFileIconProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,140:1\n40#2,3:141\n*S KotlinDebug\n*F\n+ 1 KubernetesFileIconProvider.kt\ncom/intellij/kubernetes/KubernetesFileIconProvider\n*L\n82#1:141,3\n*E\n"})
public final class KubernetesFileIconProvider
extends IconProvider
implements DumbAware {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiFile) {
            VirtualFile file = ((PsiFile)element).getVirtualFile();
            if (file != null) {
                CharSequence charSequence = file.getNameSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
                CharSequence fileName = charSequence;
                if (Chart.Companion.isChartsTemplateFile(file)) {
                    Icon icon;
                    if (Chart.Companion.isNotesTxtName(fileName)) {
                        icon = KubernetesIcons.HelmNotes;
                    } else {
                        Character c = StringsKt.firstOrNull((CharSequence)fileName);
                        char c2 = '_';
                        icon = c != null && c.charValue() == c2 ? KubernetesIcons.HelmUndeployable : KubernetesIcons.Helm;
                    }
                    return icon;
                }
                ChartLocator chartLocator = ChartLocator.Companion.instance();
                VirtualFile parentDir = file.getParent();
                if (parentDir != null) {
                    ChartPresence chartPresence = chartLocator.locateChartByChartDir(parentDir);
                    if (chartPresence != null) {
                        if (Intrinsics.areEqual((Object)file, (Object)chartPresence.getChartFile())) {
                            return KubernetesIcons.HelmChart;
                        }
                        if (Chart.Companion.isChartLockName(fileName)) {
                            return KubernetesIcons.HelmChartLock;
                        }
                        if (Chart.Companion.isValuesYamlName(fileName)) {
                            return KubernetesIcons.HelmValues;
                        }
                        if (Chart.Companion.isRequirementsYamlName(fileName)) {
                            return KubernetesIcons.HelmRequirementsYaml;
                        }
                        if (Chart.Companion.isRequirementsLockName(fileName)) {
                            return KubernetesIcons.HelmRequirementsLock;
                        }
                        if (Chart.Companion.isValuesSchemaJson(fileName)) {
                            return KubernetesIcons.HelmValuesSchemaJson;
                        }
                    } else if (chartLocator.locateChartByValuesFile(file) != null) {
                        return KubernetesIcons.HelmValues;
                    }
                }
                if (KubernetesUtilKt.isKustomizationYamlName(file)) {
                    return KubernetesIcons.Kustomize;
                }
                if (Intrinsics.areEqual((Object)file.getFileType(), (Object)YAMLFileType.YML)) {
                    Project project = ((PsiFile)element).getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    if (KubeConfig.isKubeConfig(file, project)) {
                        return KubernetesIcons.Kubernetes_Y;
                    }
                }
            }
            if (file != null && Intrinsics.areEqual((Object)((PsiFile)element).getFileType(), (Object)YAMLFileType.YML)) {
                boolean $i$f$service = false;
                Class<KubernetesYamlDetector> serviceClass$iv = KubernetesYamlDetector.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                KubernetesYamlDetector kubernetesYamlDetector = (KubernetesYamlDetector)object;
                Project project = ((PsiFile)element).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (kubernetesYamlDetector.looksLikeKubernetesYaml(project, file)) {
                    return KubernetesIcons.Kubernetes_Y;
                }
            } else {
                PsiFile yamlPsi = ((PsiFile)element).getViewProvider().getPsi((Language)YAMLLanguage.INSTANCE);
                if (yamlPsi != null && KubernetesUtilKt.isKubernetesYaml(yamlPsi)) {
                    return KubernetesIcons.Kubernetes_Y;
                }
            }
        } else if (element instanceof PsiDirectory) {
            ChartLocator chartLocator = ChartLocator.Companion.instance();
            VirtualFile virtualFile = ((PsiDirectory)element).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            if (chartLocator.locateChartByChartDir(virtualFile) != null) {
                return KubernetesIcons.HelmDirectory;
            }
            if (((PsiDirectory)element).getVirtualFile().getParent() == null && ((PsiDirectory)element).getVirtualFile().getFileSystem() == TgzFileSystem.Companion.getInstance()) {
                return KubernetesIcons.HelmArchive;
            }
        }
        return null;
    }
}

