/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.kubernetes.wsl.WslOrNativePath;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001aJ\u001f\u0010-\u001a\u00020+2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0.\"\u00020\u001a\u00a2\u0006\u0002\u0010/J\u0016\u00100\u001a\u00020+2\u0006\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R!\u0010!\u001a\t\u0018\u00010\u001a\u00a2\u0006\u0002\b\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u000f\"\u0004\b)\u0010\u0011\u00a8\u00063"}, d2={"Lcom/intellij/kubernetes/api/FlowProcessBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "exePath", "Lcom/intellij/kubernetes/wsl/WslOrNativePath;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/kubernetes/wsl/WslOrNativePath;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getExePath", "()Lcom/intellij/kubernetes/wsl/WslOrNativePath;", "disableProcessInput", "", "getDisableProcessInput", "()Z", "setDisableProcessInput", "(Z)V", "pty", "getPty", "setPty", "sudo", "getSudo", "setSudo", "parameters", "", "", "getParameters", "()Ljava/util/List;", "environment", "", "getEnvironment", "()Ljava/util/Map;", "title", "Lcom/intellij/openapi/util/NlsContexts$ProgressTitle;", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "withProgress", "getWithProgress", "setWithProgress", "addParameter", "", "parameter", "addParameters", "", "([Ljava/lang/String;)V", "withEnvironment", "name", "value", "intellij.clouds.kubernetes"})
public final class FlowProcessBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private final WslOrNativePath exePath;
    private boolean disableProcessInput;
    private boolean pty;
    private boolean sudo;
    @NotNull
    private final List<String> parameters;
    @NotNull
    private final Map<String, String> environment;
    @Nullable
    private String title;
    private boolean withProgress;

    public FlowProcessBuilder(@NotNull Project project, @NotNull WslOrNativePath exePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
        this.project = project;
        this.exePath = exePath;
        this.disableProcessInput = true;
        this.parameters = new ArrayList();
        this.environment = new LinkedHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final WslOrNativePath getExePath() {
        return this.exePath;
    }

    public final boolean getDisableProcessInput() {
        return this.disableProcessInput;
    }

    public final void setDisableProcessInput(boolean bl) {
        this.disableProcessInput = bl;
    }

    public final boolean getPty() {
        return this.pty;
    }

    public final void setPty(boolean bl) {
        this.pty = bl;
    }

    public final boolean getSudo() {
        return this.sudo;
    }

    public final void setSudo(boolean bl) {
        this.sudo = bl;
    }

    @NotNull
    public final List<String> getParameters() {
        return this.parameters;
    }

    @NotNull
    public final Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@Nullable String string) {
        this.title = string;
    }

    public final boolean getWithProgress() {
        return this.withProgress;
    }

    public final void setWithProgress(boolean bl) {
        this.withProgress = bl;
    }

    public final void addParameter(@NotNull String parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        this.parameters.add(parameter);
    }

    public final void addParameters(String ... parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        CollectionsKt.addAll((Collection)this.parameters, (Object[])parameter);
    }

    public final void withEnvironment(@NotNull String name, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.environment.put(name, value2);
    }
}

