/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api.settings;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/api/settings/KubernetesConfigFileManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "saveConfigFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "", "getStoredConfigFiles", "", "cleanupStoredConfigFiles", "", "configs", "", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesConfigFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesConfigFileManager.kt\ncom/intellij/kubernetes/api/settings/KubernetesConfigFileManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,119:1\n3829#2:120\n4344#2,2:121\n3829#2:123\n4344#2,2:124\n1863#3,2:126\n15#4:128\n*S KotlinDebug\n*F\n+ 1 KubernetesConfigFileManager.kt\ncom/intellij/kubernetes/api/settings/KubernetesConfigFileManager\n*L\n75#1:120\n75#1:121,2\n98#1:123\n98#1:124,2\n101#1:126,2\n18#1:128\n*E\n"})
public final class KubernetesConfigFileManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String CONFIG_DIR = ".idea/kubernetes/configs";
    private static final DateTimeFormatter DATE_FORMAT;

    public KubernetesConfigFileManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final VirtualFile saveConfigFile(@NotNull String content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        return (VirtualFile)WriteAction.computeAndWait(() -> KubernetesConfigFileManager.saveConfigFile$lambda$0(this, content2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualFile> getStoredConfigFiles() {
        try {
            void $this$filterTo$iv$iv;
            String string = this.project.getBasePath();
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String projectBasePath = string;
            String configDirPath = projectBasePath + "/.idea/kubernetes/configs";
            File configDirFile = new File(configDirPath);
            if (!configDirFile.exists()) {
                return CollectionsKt.emptyList();
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(configDirFile);
            if (virtualFile == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile configDir = virtualFile;
            VirtualFile[] virtualFileArray = configDir.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getExtension(), (Object)"yaml") || Intrinsics.areEqual((Object)it.getExtension(), (Object)"yml"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            LOG.warn("Failed to get stored config files", (Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void cleanupStoredConfigFiles(@NotNull Set<? extends VirtualFile> configs) {
        Intrinsics.checkNotNullParameter(configs, (String)"configs");
        try {
            void $this$filterTo$iv$iv;
            String string = this.project.getBasePath();
            if (string == null) {
                return;
            }
            String projectBasePath = string;
            String configDirPath = projectBasePath + "/.idea/kubernetes/configs";
            File configDirFile = new File(configDirPath);
            if (!configDirFile.exists()) {
                return;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(configDirFile);
            if (virtualFile == null) {
                return;
            }
            VirtualFile configDir = virtualFile;
            VirtualFile[] virtualFileArray = configDir.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getExtension(), (Object)"yaml") || Intrinsics.areEqual((Object)it.getExtension(), (Object)"yml"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List storedFiles = (List)destination$iv$iv;
            WriteAction.runAndWait(() -> KubernetesConfigFileManager.cleanupStoredConfigFiles$lambda$4(storedFiles, configs, this));
        }
        catch (Exception e) {
            LOG.warn("Failed to cleanup stored config files", (Throwable)e);
        }
    }

    private static final VirtualFile saveConfigFile$lambda$0(KubernetesConfigFileManager this$0, String $content) {
        VirtualFile virtualFile;
        try {
            String string = this$0.project.getBasePath();
            if (string == null) {
                throw new IOException("Project base path is null");
            }
            String projectBasePath = string;
            String configDirPath = projectBasePath + "/.idea/kubernetes/configs";
            File configDirFile = new File(configDirPath);
            if (!configDirFile.exists()) {
                configDirFile.mkdirs();
            }
            String timestamp = LocalDateTime.now().format(DATE_FORMAT);
            String random = StringsKt.padStart((String)String.valueOf(RangesKt.random((IntRange)new IntRange(1, 999), (Random)((Random)Random.Default))), (int)3, (char)'0');
            String fileName = "kubeconfig_" + timestamp + "_" + random + ".yaml";
            File configFile = new File(configDirFile, fileName);
            FilesKt.writeText$default((File)configFile, (String)$content, null, (int)2, null);
            LocalFileSystem.getInstance().refreshAndFindFileByIoFile(configDirFile);
            virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(configFile);
        }
        catch (IOException e) {
            LOG.warn("Failed to save config file", (Throwable)e);
            virtualFile = null;
        }
        return virtualFile;
    }

    private static final void cleanupStoredConfigFiles$lambda$4(List $storedFiles, Set $configs, KubernetesConfigFileManager this$0) {
        Iterable $this$forEach$iv = $storedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file = (VirtualFile)element$iv;
            boolean bl = false;
            if ($configs.contains(file)) continue;
            try {
                file.delete((Object)this$0);
                LOG.info("Removed unused config file: " + file.getPath());
            }
            catch (IOException e) {
                LOG.warn("Failed to remove config file: " + file.getPath(), (Throwable)e);
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final KubernetesConfigFileManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesConfigFileManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/api/settings/KubernetesConfigFileManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "CONFIG_DIR", "", "DATE_FORMAT", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "Ljava/time/format/DateTimeFormatter;", "getInstance", "Lcom/intellij/kubernetes/api/settings/KubernetesConfigFileManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesConfigFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesConfigFileManager.kt\ncom/intellij/kubernetes/api/settings/KubernetesConfigFileManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,119:1\n31#2,2:120\n*S KotlinDebug\n*F\n+ 1 KubernetesConfigFileManager.kt\ncom/intellij/kubernetes/api/settings/KubernetesConfigFileManager$Companion\n*L\n23#1:120,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KubernetesConfigFileManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KubernetesConfigFileManager> serviceClass$iv = KubernetesConfigFileManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KubernetesConfigFileManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

