/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.kubernetes.EventuallyConsistentExpiringLazy;
import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettings;
import com.intellij.kubernetes.helm.HelmExecutionManager;
import com.intellij.kubernetes.helm.chart.EffectiveHelmParameters;
import com.intellij.kubernetes.helm.install.HelmInstallAction;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.HelmConsoleManager;
import com.intellij.kubernetes.ui.NotificationsKt;
import com.intellij.kubernetes.ui.actions.QuickHelmActionBase;
import com.intellij.kubernetes.util.ConsoleUtilitiesKt;
import com.intellij.kubernetes.wsl.WslOrNativePath;
import com.intellij.kubernetes.wsl.WslOrNativePathKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.text.SemVer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 K2\u00020\u0001:\u0003IJKB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001b\u001a\u00020\u0017J\u001e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J;\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010 \u001a\u00020\u000b2!\u0010!\u001a\u001d\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020\u00170\"J;\u0010'\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u000b2!\u0010!\u001a\u001d\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020\u00170\"H\u0002J9\u0010(\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u000b2!\u0010*\u001a\u001d\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020\u00170\"J\u001e\u0010-\u001a\u0004\u0018\u00010+2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u00101\u001a\u000202J(\u00103\u001a\u00020+2\b\u00104\u001a\u0004\u0018\u0001052\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u00101\u001a\u000202H\u0002J\u001c\u0010>\u001a\u00020\u00172\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002000@H\u0007J3\u0010A\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\t2!\u0010*\u001a\u001d\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020\u00170\"H\u0002J\u0010\u0010B\u001a\u00020\u00172\u0006\u0010C\u001a\u00020DH\u0002J\u0012\u0010E\u001a\u0004\u0018\u00010\u001a2\u0006\u00101\u001a\u000202H\u0002J\u001a\u0010F\u001a\u0004\u0018\u00010;2\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00101\u001a\u000202J\u0006\u0010G\u001a\u00020\u0017J\u0006\u0010H\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R&\u0010\u0013\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0004\u0012\u00020\t0\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u00106\u001a\u0004\u0018\u0001078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0013\u0010:\u001a\u0004\u0018\u00010;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006L"}, d2={"Lcom/intellij/kubernetes/helm/HelmExecutionManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "executionLock", "Ljava/lang/Object;", "lastRequestRef", "Lcom/intellij/kubernetes/helm/HelmExecutionManager$ExecutionRequest;", "busyFlag", "", "lastRequest", "getLastRequest", "()Lcom/intellij/kubernetes/helm/HelmExecutionManager$ExecutionRequest;", "lastRepeatableRequest", "getLastRepeatableRequest", "isBusy", "()Z", "lastRepeatableCommand", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Pair;", "Lkotlin/Function0;", "", "helmConfig", "Lcom/intellij/kubernetes/EventuallyConsistentExpiringLazy;", "Lcom/intellij/kubernetes/helm/HelmExecutionManager$HelmConfig;", "executeLastCommand", "executeAndStoreCommand", "request", "command", "executeSlowCommand", "showConsole", "onProcessFinished", "Lkotlin/Function1;", "Lcom/intellij/execution/process/ProcessHandler;", "Lkotlin/ParameterName;", "name", "processHandler", "doExecuteSlowCommand", "executeQuickCommand", "isRepeatable", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "output", "executeServiceCommand", "helmParameters", "", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "executeHelm", "helmPath", "Lcom/intellij/kubernetes/wsl/WslOrNativePath;", "repositoryCachePath", "Ljava/nio/file/Path;", "getRepositoryCachePath", "()Ljava/nio/file/Path;", "helmVersion", "Lcom/intellij/util/text/SemVer;", "getHelmVersion", "()Lcom/intellij/util/text/SemVer;", "setHelmEnv", "env", "", "doExecuteQuickCommand", "processAndNotify", "e", "Lcom/intellij/execution/ExecutionException;", "calculateHelmConfig", "executeHelmVersion", "forceUpdateConfigAndWait", "resetConfig", "ExecutionRequest", "HelmConfig", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmExecutionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmExecutionManager.kt\ncom/intellij/kubernetes/helm/HelmExecutionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,321:1\n1#2:322\n121#3,5:323\n1557#4:328\n1628#4,3:329\n37#5:332\n36#5,3:333\n*S KotlinDebug\n*F\n+ 1 HelmExecutionManager.kt\ncom/intellij/kubernetes/helm/HelmExecutionManager\n*L\n164#1:323,5\n236#1:328\n236#1:329,3\n238#1:332\n238#1:333,3\n*E\n"})
public final class HelmExecutionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Object executionLock;
    @Nullable
    private ExecutionRequest lastRequestRef;
    private volatile boolean busyFlag;
    @NotNull
    private final AtomicReference<Pair<Function0<Unit>, ExecutionRequest>> lastRepeatableCommand;
    @NotNull
    private final EventuallyConsistentExpiringLazy<HelmConfig> helmConfig;
    private static final long HELM_CONFIG_UPDATE_TIMEOUT = 60000L;
    @NotNull
    private static final Logger log;

    public HelmExecutionManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.executionLock = new Object();
        this.lastRepeatableCommand = new AtomicReference();
        String string = KubernetesBundle.message("HelmIndex.refresh.helm.configuration.task.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.helmConfig = MiscUtilKt.eventuallyUpdatedInBackgroundLazy(60000L, this.project, string, arg_0 -> HelmExecutionManager.helmConfig$lambda$0(this, arg_0));
    }

    @Nullable
    public final ExecutionRequest getLastRequest() {
        return this.lastRequestRef;
    }

    @Nullable
    public final ExecutionRequest getLastRepeatableRequest() {
        Pair<Function0<Unit>, ExecutionRequest> pair = this.lastRepeatableCommand.get();
        return pair != null ? (ExecutionRequest)pair.getSecond() : null;
    }

    public final boolean isBusy() {
        return this.busyFlag;
    }

    public final void executeLastCommand() {
        block0: {
            Function0 function0;
            if (this.isBusy() || (function0 = this.lastRepeatableCommand.get()) == null || (function0 = (Function0)function0.getFirst()) == null) break block0;
            function0.invoke();
        }
    }

    private final void executeAndStoreCommand(ExecutionRequest request, Function0<Unit> command2) {
        command2.invoke();
        this.lastRepeatableCommand.set((Pair<Function0<Unit>, ExecutionRequest>)new Pair(command2, (Object)request));
    }

    public final void executeSlowCommand(@NotNull ExecutionRequest request, boolean showConsole, @NotNull Function1<? super ProcessHandler, Unit> onProcessFinished) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onProcessFinished, (String)"onProcessFinished");
        this.executeAndStoreCommand(request, (Function0<Unit>)((Function0)() -> HelmExecutionManager.executeSlowCommand$lambda$1(this, request, showConsole, onProcessFinished)));
    }

    public static /* synthetic */ void executeSlowCommand$default(HelmExecutionManager helmExecutionManager, ExecutionRequest executionRequest, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        helmExecutionManager.executeSlowCommand(executionRequest, bl, (Function1<? super ProcessHandler, Unit>)function1);
    }

    private final void doExecuteSlowCommand(ExecutionRequest request, boolean showConsole, Function1<? super ProcessHandler, Unit> onProcessFinished) {
        Project project = this.project;
        String string = request.getTaskTitle();
        new Task.Backgroundable(request, this, onProcessFinished, showConsole, project, string){
            final /* synthetic */ ExecutionRequest $request;
            final /* synthetic */ HelmExecutionManager this$0;
            final /* synthetic */ Function1<ProcessHandler, Unit> $onProcessFinished;
            final /* synthetic */ boolean $showConsole;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                this.$onProcessFinished = $onProcessFinished;
                this.$showConsole = $showConsole;
                super($super_call_param$1, $super_call_param$2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GeneralCommandLine commandLine = HelmExecutionManager.Companion.createCommandLine$intellij_clouds_kubernetes(this.$request);
                Ref.ObjectRef processHandler2 = new Ref.ObjectRef();
                Object object = HelmExecutionManager.access$getExecutionLock$p(this.this$0);
                HelmExecutionManager helmExecutionManager = this.this$0;
                ExecutionRequest executionRequest = this.$request;
                boolean bl = this.$showConsole;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl2 = false;
                    HelmExecutionManager.access$setLastRequestRef$p(helmExecutionManager, executionRequest);
                    HelmExecutionManager.access$setBusyFlag$p(helmExecutionManager, true);
                    try {
                        processHandler2.element = com.intellij.kubernetes.helm.HelmExecutionManager$Companion.access$createProcessHandler(HelmExecutionManager.Companion, commandLine, executionRequest.getStdin());
                        Project project = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> doExecuteSlowCommand.1.run$lambda$2$lambda$0(this, processHandler2, bl));
                        ((CapturingProcessHandler)processHandler2.element).waitFor();
                        if (this.getProject().isDisposed()) {
                            return;
                        }
                        Project project2 = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                        AppUIUtil.invokeLaterIfProjectAlive((Project)project2, () -> doExecuteSlowCommand.1.run$lambda$2$lambda$1(this));
                    }
                    catch (ExecutionException e) {
                        HelmExecutionManager.access$processAndNotify(helmExecutionManager, e);
                        return;
                    }
                    finally {
                        HelmExecutionManager.access$setBusyFlag$p(helmExecutionManager, false);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                Integer n = ((ProcessHandler)processHandler2.element).getExitCode();
                if (n == null || n != 0) {
                    Project project = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    HelmConsoleManager.Companion.getInstance(project).activate();
                }
                this.$onProcessFinished.invoke(processHandler2.element);
            }

            private static final void run$lambda$2$lambda$0(doExecuteSlowCommand.1 this$0, Ref.ObjectRef $processHandler, boolean $showConsole) {
                Project project = this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                HelmConsoleManager consoleManager = HelmConsoleManager.Companion.getInstance(project);
                consoleManager.getHelmConsole().attachToProcess((ProcessHandler)$processHandler.element);
                if ($showConsole) {
                    consoleManager.activate();
                }
                ((CapturingProcessHandler)$processHandler.element).startNotify();
            }

            private static final void run$lambda$2$lambda$1(doExecuteSlowCommand.1 this$0) {
                Project project = this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                HelmConsoleManager.Companion.getInstance(project).getHelmConsole().print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
        }.queue();
    }

    public final void executeQuickCommand(@NotNull ExecutionRequest request, boolean isRepeatable, @NotNull Function1<? super ProcessOutput, Unit> processOutput2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(processOutput2, (String)"processOutput");
        if (isRepeatable) {
            this.executeAndStoreCommand(request, (Function0<Unit>)((Function0)() -> HelmExecutionManager.executeQuickCommand$lambda$2(this, request, processOutput2)));
        } else {
            this.doExecuteQuickCommand(request, processOutput2);
        }
    }

    @Nullable
    public final ProcessOutput executeServiceCommand(@NotNull List<String> helmParameters, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter(helmParameters, (String)"helmParameters");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        try {
            return this.executeHelm(null, helmParameters, progressIndicator);
        }
        catch (ExecutionException e) {
            log.warn("Couldn't execute Helm command " + helmParameters, (Throwable)e);
            return null;
        }
    }

    private final ProcessOutput executeHelm(WslOrNativePath helmPath, List<String> helmParameters, ProgressIndicator progressIndicator) {
        WslOrNativePath wslOrNativePath = helmPath;
        if (wslOrNativePath == null) {
            wslOrNativePath = KubernetesApiGlobalSettings.Companion.getInstance().getHelmPath$intellij_clouds_kubernetes();
        }
        WslOrNativePath effectiveHelmPath = wslOrNativePath;
        GeneralCommandLine commandLine = WslOrNativePathKt.toGeneralCommandLine$default(effectiveHelmPath, helmParameters, null, 2, null);
        ProcessOutput processOutput2 = new CapturingProcessHandler(commandLine).runProcessWithProgressIndicator(progressIndicator);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"runProcessWithProgressIndicator(...)");
        return processOutput2;
    }

    @Nullable
    public final Path getRepositoryCachePath() {
        Path path;
        Object object = (HelmConfig)this.helmConfig.getValue();
        if (object != null && (object = ((HelmConfig)object).getEnv()) != null && (object = (String)object.get("HELM_REPOSITORY_CACHE")) != null) {
            Path path2;
            Object it = object;
            boolean bl = false;
            boolean $i$f$unexceptionize = false;
            try {
                boolean bl2 = false;
                path2 = Paths.get((String)it, new String[0]);
            }
            catch (Exception e$iv) {
                path2 = null;
            }
            path = path2;
        } else {
            path = null;
        }
        return path;
    }

    @Nullable
    public final SemVer getHelmVersion() {
        HelmConfig helmConfig = (HelmConfig)this.helmConfig.getValue();
        return helmConfig != null ? helmConfig.getVersion() : null;
    }

    @TestOnly
    public final void setHelmEnv(@NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter(env, (String)"env");
        this.helmConfig.setNeverExpiringValue(new HelmConfig(env, null));
    }

    private final void doExecuteQuickCommand(ExecutionRequest request, Function1<? super ProcessOutput, Unit> processOutput2) {
        Project project = this.project;
        String string = request.getTaskTitle();
        new Task.Backgroundable(request, this, processOutput2, project, string){
            final /* synthetic */ ExecutionRequest $request;
            final /* synthetic */ HelmExecutionManager this$0;
            final /* synthetic */ Function1<ProcessOutput, Unit> $processOutput;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                this.$processOutput = $processOutput;
                super($super_call_param$1, $super_call_param$2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GeneralCommandLine commandLine = HelmExecutionManager.Companion.createCommandLine$intellij_clouds_kubernetes(this.$request);
                Ref.ObjectRef output = new Ref.ObjectRef();
                Object object = HelmExecutionManager.access$getExecutionLock$p(this.this$0);
                HelmExecutionManager helmExecutionManager = this.this$0;
                ExecutionRequest executionRequest = this.$request;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    HelmExecutionManager.access$setLastRequestRef$p(helmExecutionManager, executionRequest);
                    HelmExecutionManager.access$setBusyFlag$p(helmExecutionManager, true);
                    try {
                        CapturingProcessHandler processHandler2 = com.intellij.kubernetes.helm.HelmExecutionManager$Companion.access$createProcessHandler(HelmExecutionManager.Companion, commandLine, executionRequest.getStdin());
                        output.element = processHandler2.runProcessWithProgressIndicator(indicator);
                        AppUIUtil.invokeLaterIfProjectAlive((Project)HelmExecutionManager.access$getProject$p(helmExecutionManager), () -> doExecuteQuickCommand.1.run$lambda$1$lambda$0(this, commandLine, output));
                    }
                    catch (ExecutionException e) {
                        Project project = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        ConsoleView consoleView = HelmConsoleManager.Companion.getInstance(project).getHelmConsole();
                        String string = e.getMessage();
                        if (string == null) {
                            string = e.toString();
                        }
                        ConsoleUtilitiesKt.printError(consoleView, string + "\n");
                        HelmExecutionManager.access$processAndNotify(helmExecutionManager, e);
                        return;
                    }
                    finally {
                        HelmExecutionManager.access$setBusyFlag$p(helmExecutionManager, false);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                if (((ProcessOutput)output.element).isExitCodeSet()) {
                    this.$processOutput.invoke(output.element);
                }
            }

            private static final void run$lambda$1$lambda$0(doExecuteQuickCommand.1 this$0, GeneralCommandLine $commandLine, Ref.ObjectRef $output) {
                Project project = this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                HelmConsoleManager consoleManager = HelmConsoleManager.Companion.getInstance(project);
                ConsoleView helmConsole = consoleManager.getHelmConsole();
                ConsoleUtilitiesKt.printSystem(helmConsole, $commandLine.getCommandLineString() + "\n");
                if (((ProcessOutput)$output.element).isExitCodeSet() && ((ProcessOutput)$output.element).getExitCode() != 0) {
                    ConsoleUtilitiesKt.printError(helmConsole, ((ProcessOutput)$output.element).getStderr() + "\n");
                    helmConsole.requestScrollingToEnd();
                    consoleManager.activate();
                }
            }
        }.queue();
    }

    private final void processAndNotify(ExecutionException e) {
        log.warn("Couldn't execute Helm command", (Throwable)e);
        NotificationGroup notificationGroup = NotificationsKt.getKubernetesNotificationGroup();
        String string = KubernetesBundle.message("HelmActionBase.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = KubernetesBundle.message("HelmActionBase.notification.error.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Notification notification = notificationGroup.createNotification(string, string2, NotificationType.ERROR).addAction((AnAction)new HelmInstallAction());
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"addAction(...)");
        Notification notification2 = notification;
        notification2.notify(this.project);
    }

    /*
     * WARNING - void declaration
     */
    private final HelmConfig calculateHelmConfig(ProgressIndicator progressIndicator) {
        try {
            ProcessOutput processOutput2;
            block9: {
                block8: {
                    Map map2;
                    processOutput2 = this.executeServiceCommand(CollectionsKt.listOf((Object)"env"), progressIndicator);
                    if (processOutput2 == null) break block8;
                    ProcessOutput $this$calculateHelmConfig_u24lambda_u246 = processOutput2;
                    boolean bl = false;
                    if ($this$calculateHelmConfig_u24lambda_u246.isExitCodeSet() && $this$calculateHelmConfig_u24lambda_u246.getExitCode() != 0) {
                        log.warn("error executing \"helm env\": " + $this$calculateHelmConfig_u24lambda_u246.getStderr());
                        map2 = null;
                    } else {
                        void $this$toTypedArray$iv;
                        void $this$mapTo$iv$iv;
                        List list2 = FileUtil.loadLines((BufferedReader)new BufferedReader(new StringReader($this$calculateHelmConfig_u24lambda_u246.getStdout())));
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"loadLines(...)");
                        Iterable $this$map$iv = list2;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)it);
                            collection.add(TuplesKt.to((Object)StringsKt.substringBefore$default((String)it, (char)'=', null, (int)2, null), (Object)StringUtil.unquoteString((String)StringsKt.substringAfter$default((String)it, (char)'=', null, (int)2, null))));
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
                        map2 = MapsKt.mapOf((Pair[])Arrays.copyOf(pairArray, pairArray.length));
                    }
                    processOutput2 = map2;
                    if (map2 != null) break block9;
                }
                return null;
            }
            ProcessOutput env = processOutput2;
            SemVer version = this.executeHelmVersion(null, progressIndicator);
            return new HelmConfig((Map<String, String>)env, version);
        }
        catch (ExecutionException e) {
            log.warn("Couldn't execute Helm command", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final SemVer executeHelmVersion(@Nullable WslOrNativePath helmPath, @NotNull ProgressIndicator progressIndicator) {
        SemVer semVer;
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Object[] objectArray = new String[]{"version", "--template", "{{.Version}}"};
        ProcessOutput $this$executeHelmVersion_u24lambda_u247 = this.executeHelm(helmPath, CollectionsKt.listOf((Object[])objectArray), progressIndicator);
        boolean bl = false;
        if ($this$executeHelmVersion_u24lambda_u247.isExitCodeSet() && $this$executeHelmVersion_u24lambda_u247.getExitCode() != 0) {
            log.warn("error executing \"helm version\": " + $this$executeHelmVersion_u24lambda_u247.getStderr());
            semVer = null;
        } else {
            semVer = SemVer.parseFromText((String)StringUtil.trimLeading((String)$this$executeHelmVersion_u24lambda_u247.getStdout(), (char)'v'));
        }
        return semVer;
    }

    public final void forceUpdateConfigAndWait() {
        this.helmConfig.requestUpdateAndWait(1000L);
    }

    public final void resetConfig() {
        this.helmConfig.reset();
    }

    private static final HelmConfig helmConfig$lambda$0(HelmExecutionManager this$0, ProgressIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.calculateHelmConfig(it);
    }

    private static final Unit executeSlowCommand$lambda$1(HelmExecutionManager this$0, ExecutionRequest $request, boolean $showConsole, Function1 $onProcessFinished) {
        this$0.doExecuteSlowCommand($request, $showConsole, (Function1<? super ProcessHandler, Unit>)$onProcessFinished);
        return Unit.INSTANCE;
    }

    private static final Unit executeQuickCommand$lambda$2(HelmExecutionManager this$0, ExecutionRequest $request, Function1 $processOutput) {
        this$0.doExecuteQuickCommand($request, (Function1<? super ProcessOutput, Unit>)$processOutput);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$getExecutionLock$p(HelmExecutionManager $this) {
        return $this.executionLock;
    }

    public static final /* synthetic */ void access$setLastRequestRef$p(HelmExecutionManager $this, ExecutionRequest executionRequest) {
        $this.lastRequestRef = executionRequest;
    }

    public static final /* synthetic */ void access$setBusyFlag$p(HelmExecutionManager $this, boolean bl) {
        $this.busyFlag = bl;
    }

    public static final /* synthetic */ void access$processAndNotify(HelmExecutionManager $this, ExecutionException e) {
        $this.processAndNotify(e);
    }

    public static final /* synthetic */ Project access$getProject$p(HelmExecutionManager $this) {
        return $this.project;
    }

    static {
        Logger logger = Logger.getInstance(QuickHelmActionBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0015\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/kubernetes/helm/HelmExecutionManager$Companion;", "", "<init>", "()V", "HELM_CONFIG_UPDATE_TIMEOUT", "", "getInstance", "Lcom/intellij/kubernetes/helm/HelmExecutionManager;", "project", "Lcom/intellij/openapi/project/Project;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createProcessHandler", "Lcom/intellij/execution/process/CapturingProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "stdin", "", "createCommandLine", "request", "Lcom/intellij/kubernetes/helm/HelmExecutionManager$ExecutionRequest;", "createCommandLine$intellij_clouds_kubernetes", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nHelmExecutionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmExecutionManager.kt\ncom/intellij/kubernetes/helm/HelmExecutionManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,321:1\n1454#2,2:322\n1456#2,3:325\n1557#2:328\n1628#2,3:329\n774#2:332\n865#2,2:333\n1#3:324\n*S KotlinDebug\n*F\n+ 1 HelmExecutionManager.kt\ncom/intellij/kubernetes/helm/HelmExecutionManager$Companion\n*L\n300#1:322,2\n300#1:325,3\n308#1:328\n308#1:329,3\n309#1:332\n309#1:333,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HelmExecutionManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(HelmExecutionManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (HelmExecutionManager)object;
        }

        private final CapturingProcessHandler createProcessHandler(GeneralCommandLine commandLine, String stdin) {
            CapturingProcessHandler capturingProcessHandler;
            block0: {
                CapturingProcessHandler $this$createProcessHandler_u24lambda_u241 = capturingProcessHandler = new CapturingProcessHandler(commandLine);
                boolean bl = false;
                String string = stdin;
                if (string == null) break block0;
                String stdin2 = string;
                boolean bl2 = false;
                $this$createProcessHandler_u24lambda_u241.addProcessListener((ProcessListener)new ProcessAdapter($this$createProcessHandler_u24lambda_u241, commandLine, stdin2){
                    final /* synthetic */ CapturingProcessHandler $this_apply;
                    final /* synthetic */ GeneralCommandLine $commandLine;
                    final /* synthetic */ String $stdin;
                    {
                        this.$this_apply = $receiver;
                        this.$commandLine = $commandLine;
                        this.$stdin = $stdin;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void startNotified(ProcessEvent event2) {
                        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                        OutputStream outputStream = this.$this_apply.getProcessInput();
                        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getProcessInput(...)");
                        Closeable closeable = outputStream;
                        Charset charset = this.$commandLine.getCharset();
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
                        Object object = charset;
                        closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
                        object = this.$stdin;
                        Throwable throwable = null;
                        try {
                            OutputStreamWriter it = (OutputStreamWriter)closeable;
                            boolean bl = false;
                            it.write((String)object);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                });
            }
            return capturingProcessHandler;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final GeneralCommandLine createCommandLine$intellij_clouds_kubernetes(@NotNull ExecutionRequest request) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            boolean bl2 = bl = !((Collection)request.getHelmCommand()).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            List parameters = new ArrayList();
            parameters.addAll((Collection)request.getHelmCommand());
            if (request.getChartDirName() != null) {
                parameters.add(request.getChartDirName());
            }
            Object $this$flatMapTo$iv = request.getHelmParameters().getValuesFiles();
            boolean $i$f$flatMapTo = false;
            Object object = $this$flatMapTo$iv.iterator();
            while (object.hasNext()) {
                Object object2;
                block12: {
                    block11: {
                        Object element$iv = object.next();
                        VirtualFile valuesFile2 = (VirtualFile)element$iv;
                        boolean bl3 = false;
                        object2 = FileUtil.getRelativePath((String)request.getWorkingDir().getPath(), (String)valuesFile2.getPath(), (char)'/');
                        if (object2 == null) break block11;
                        String it = object2;
                        boolean bl4 = false;
                        Object[] objectArray = new String[]{"--values", it};
                        List list2 = CollectionsKt.listOf((Object[])objectArray);
                        object2 = list2;
                        if (list2 != null) break block12;
                    }
                    object2 = CollectionsKt.emptyList();
                }
                Iterable list$iv = (Iterable)object2;
                CollectionsKt.addAll((Collection)parameters, (Iterable)list$iv);
            }
            $this$flatMapTo$iv = request.getHelmParameters().getValues();
            if ($this$flatMapTo$iv != null) {
                char[] cArray;
                Object object3;
                Object p0 = object = $this$flatMapTo$iv;
                boolean bl5 = false;
                Object object4 = object3 = !StringsKt.isBlank((CharSequence)((CharSequence)p0)) ? object : null;
                if (object3 != null && (object = StringsKt.replace$default((String)object3, (String)"\r", (String)"", (boolean)false, (int)4, null)) != null && (p0 = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{'\n'}), (boolean)false, (int)0, (int)6, null)) != null) {
                    List list3;
                    List list4;
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable bl3 = (Iterable)p0;
                    boolean $i$f$map22 = false;
                    void bl4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p02;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl6 = false;
                        collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)p02))).toString());
                    }
                    Iterable $i$f$map22 = (List)destination$iv$iv;
                    boolean $i$f$filter = false;
                    destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String p03 = (String)element$iv$iv;
                        boolean bl7 = false;
                        boolean bl8 = ((CharSequence)p03).length() > 0;
                        if (!bl8) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List p04 = list4 = (List)destination$iv$iv2;
                    boolean bl9 = false;
                    List list5 = list3 = !((Collection)p04).isEmpty() ? list4 : null;
                    if (list3 != null) {
                        List it = list3;
                        boolean bl10 = false;
                        parameters.add("--set");
                        parameters.add(CollectionsKt.joinToString$default((Iterable)it, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                    }
                }
            }
            WslOrNativePath helmPath = KubernetesApiGlobalSettings.Companion.getInstance().getHelmPath$intellij_clouds_kubernetes();
            List list6 = WslOrNativePathKt.toGeneralCommandLine$default(helmPath, parameters, null, 2, null).getCommandLineList(null);
            List $this$createCommandLine_u24lambda_u248 = list6 = new GeneralCommandLine(request, list6){
                final /* synthetic */ ExecutionRequest $request;
                {
                    this.$request = $request;
                    super($super_call_param$1);
                }

                public String getCommandLineString() {
                    String string = this.$request.getCommandLineMoniker();
                    if (string == null) {
                        String string2 = super.getCommandLineString();
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCommandLineString(...)");
                    }
                    return string;
                }
            };
            boolean bl11 = false;
            $this$createCommandLine_u24lambda_u248.setWorkDirectory(request.getWorkingDir().getPath());
            return (GeneralCommandLine)list6;
        }

        public static final /* synthetic */ CapturingProcessHandler access$createProcessHandler(Companion $this, GeneralCommandLine commandLine, String stdin) {
            return $this.createProcessHandler(commandLine, stdin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001BQ\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/kubernetes/helm/HelmExecutionManager$ExecutionRequest;", "", "taskTitle", "", "helmCommand", "", "helmParameters", "Lcom/intellij/kubernetes/helm/chart/EffectiveHelmParameters;", "workingDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "chartDirName", "commandLineMoniker", "stdin", "<init>", "(Ljava/lang/String;Ljava/util/List;Lcom/intellij/kubernetes/helm/chart/EffectiveHelmParameters;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getTaskTitle", "()Ljava/lang/String;", "getHelmCommand", "()Ljava/util/List;", "getHelmParameters", "()Lcom/intellij/kubernetes/helm/chart/EffectiveHelmParameters;", "getWorkingDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getChartDirName", "getCommandLineMoniker", "getStdin", "intellij.clouds.kubernetes"})
    public static final class ExecutionRequest {
        @NotNull
        private final String taskTitle;
        @NotNull
        private final List<String> helmCommand;
        @NotNull
        private final EffectiveHelmParameters helmParameters;
        @NotNull
        private final VirtualFile workingDir;
        @Nullable
        private final String chartDirName;
        @Nullable
        private final String commandLineMoniker;
        @Nullable
        private final String stdin;

        public ExecutionRequest(@Nls @NotNull String taskTitle, @NotNull List<String> helmCommand, @NotNull EffectiveHelmParameters helmParameters, @NotNull VirtualFile workingDir, @Nullable String chartDirName, @Nullable String commandLineMoniker, @Nullable String stdin) {
            Intrinsics.checkNotNullParameter((Object)taskTitle, (String)"taskTitle");
            Intrinsics.checkNotNullParameter(helmCommand, (String)"helmCommand");
            Intrinsics.checkNotNullParameter((Object)helmParameters, (String)"helmParameters");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            this.taskTitle = taskTitle;
            this.helmCommand = helmCommand;
            this.helmParameters = helmParameters;
            this.workingDir = workingDir;
            this.chartDirName = chartDirName;
            this.commandLineMoniker = commandLineMoniker;
            this.stdin = stdin;
        }

        public /* synthetic */ ExecutionRequest(String string, List list2, EffectiveHelmParameters effectiveHelmParameters, VirtualFile virtualFile, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                string3 = null;
            }
            if ((n & 0x40) != 0) {
                string4 = null;
            }
            this(string, list2, effectiveHelmParameters, virtualFile, string2, string3, string4);
        }

        @NotNull
        public final String getTaskTitle() {
            return this.taskTitle;
        }

        @NotNull
        public final List<String> getHelmCommand() {
            return this.helmCommand;
        }

        @NotNull
        public final EffectiveHelmParameters getHelmParameters() {
            return this.helmParameters;
        }

        @NotNull
        public final VirtualFile getWorkingDir() {
            return this.workingDir;
        }

        @Nullable
        public final String getChartDirName() {
            return this.chartDirName;
        }

        @Nullable
        public final String getCommandLineMoniker() {
            return this.commandLineMoniker;
        }

        @Nullable
        public final String getStdin() {
            return this.stdin;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J+\u0010\u000f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/kubernetes/helm/HelmExecutionManager$HelmConfig;", "", "env", "", "", "version", "Lcom/intellij/util/text/SemVer;", "<init>", "(Ljava/util/Map;Lcom/intellij/util/text/SemVer;)V", "getEnv", "()Ljava/util/Map;", "getVersion", "()Lcom/intellij/util/text/SemVer;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clouds.kubernetes"})
    private static final class HelmConfig {
        @NotNull
        private final Map<String, String> env;
        @Nullable
        private final SemVer version;

        public HelmConfig(@NotNull Map<String, String> env, @Nullable SemVer version) {
            Intrinsics.checkNotNullParameter(env, (String)"env");
            this.env = env;
            this.version = version;
        }

        @NotNull
        public final Map<String, String> getEnv() {
            return this.env;
        }

        @Nullable
        public final SemVer getVersion() {
            return this.version;
        }

        @NotNull
        public final Map<String, String> component1() {
            return this.env;
        }

        @Nullable
        public final SemVer component2() {
            return this.version;
        }

        @NotNull
        public final HelmConfig copy(@NotNull Map<String, String> env, @Nullable SemVer version) {
            Intrinsics.checkNotNullParameter(env, (String)"env");
            return new HelmConfig(env, version);
        }

        public static /* synthetic */ HelmConfig copy$default(HelmConfig helmConfig, Map map2, SemVer semVer, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = helmConfig.env;
            }
            if ((n & 2) != 0) {
                semVer = helmConfig.version;
            }
            return helmConfig.copy(map2, semVer);
        }

        @NotNull
        public String toString() {
            return "HelmConfig(env=" + this.env + ", version=" + this.version + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.env).hashCode();
            result2 = result2 * 31 + (this.version == null ? 0 : this.version.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HelmConfig)) {
                return false;
            }
            HelmConfig helmConfig = (HelmConfig)other;
            if (!Intrinsics.areEqual(this.env, helmConfig.env)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.version, (Object)helmConfig.version);
        }
    }
}

