/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.dependencies;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.kubernetes.DownloadManager;
import com.intellij.kubernetes.EventuallyConsistentExpiringLazy;
import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.StampBasedCache;
import com.intellij.kubernetes.helm.HelmExecutionManager;
import com.intellij.kubernetes.helm.dependencies.HelmIndex;
import com.intellij.kubernetes.helm.dependencies.HelmIndexKt;
import com.intellij.kubernetes.helm.dependencies.dto.HelmHubDtoKt;
import com.intellij.kubernetes.helm.dependencies.dto.HelmRepoDtoKt;
import com.intellij.kubernetes.helm.dependencies.dto.HubChartDto;
import com.intellij.kubernetes.helm.dependencies.dto.HubRepoDto;
import com.intellij.kubernetes.helm.dependencies.dto.RepoChartDto;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.util.CSVReader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.OperationNotSupportedException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 32\u00020\u0001:\u000234B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0016J\u0018\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016J\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0016J\u001e\u0010!\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u00162\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rJ\u0016\u0010&\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00162\u0006\u0010#\u001a\u00020\rJ\u0012\u0010'\u001a\u0004\u0018\u00010%2\u0006\u0010#\u001a\u00020\rH\u0002J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*H\u0007J\u0016\u0010+\u001a\u00020\u00132\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J\u0018\u0010-\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\n2\u0006\u0010.\u001a\u00020/H\u0002J\u001e\u00100\u001a\u0004\u0018\u00010*2\b\u00101\u001a\u0004\u0018\u0001022\b\b\u0002\u0010.\u001a\u00020/H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R \u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\n0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010$\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/kubernetes/helm/dependencies/HelmIndex;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "addedRepos", "Lcom/intellij/kubernetes/EventuallyConsistentExpiringLazy;", "", "Lcom/intellij/kubernetes/helm/dependencies/dto/HubRepoDto;", "chartIndexUrl", "", "helmExecutionManager", "Lcom/intellij/kubernetes/helm/HelmExecutionManager;", "getHelmExecutionManager", "()Lcom/intellij/kubernetes/helm/HelmExecutionManager;", "reset", "", "forceUpdateAddedReposCache", "getAddedRepos", "", "calculateAddedRepos", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getAllCharts", "Lcom/intellij/kubernetes/helm/dependencies/dto/HubChartDto;", "getDownloadedOnlyCharts", "repoChartsCache", "Lcom/intellij/kubernetes/StampBasedCache;", "Lcom/intellij/kubernetes/helm/dependencies/HelmIndex$RepoChartsCacheKey;", "Lcom/intellij/kubernetes/helm/dependencies/dto/RepoChartDto;", "getChartsFromRepo", "chartName", "repoUrl", "repoChartNamesCache", "Ljava/nio/file/Path;", "getChartNamesFromRepo", "getLocalCacheRepoIndex", "setChartIndexSource", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "setAddedRepos", "repos", "getCharts", "skipDownload", "", "getDownloadedFile", "url", "Lcom/intellij/util/Url;", "Companion", "RepoChartsCacheKey", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmIndex.kt\ncom/intellij/kubernetes/helm/dependencies/HelmIndex\n+ 2 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n141#2,14:215\n141#2,14:236\n141#2,14:250\n141#2,14:265\n1557#3:229\n1628#3,3:230\n774#3:233\n865#3,2:234\n1#4:264\n*S KotlinDebug\n*F\n+ 1 HelmIndex.kt\ncom/intellij/kubernetes/helm/dependencies/HelmIndex\n*L\n60#1:215,14\n106#1:236,14\n127#1:250,14\n159#1:265,14\n75#1:229\n75#1:230,3\n76#1:233\n76#1:234,2\n*E\n"})
public final class HelmIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EventuallyConsistentExpiringLazy<List<HubRepoDto>> addedRepos;
    @NotNull
    private String chartIndexUrl;
    @NotNull
    private final StampBasedCache<RepoChartsCacheKey, List<RepoChartDto>> repoChartsCache;
    @NotNull
    private final StampBasedCache<Path, List<String>> repoChartNamesCache;
    private static final long ADDED_REPOS_UPDATE_TIMEOUT = 10000L;
    @NotNull
    private static final String CHART_INDEX_URL = "https://artifacthub.io/api/v1/helm-exporter";
    @NotNull
    private static final Logger log;

    public HelmIndex(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        String string = KubernetesBundle.message("HelmIndex.refresh.helm.repository.list.task.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.addedRepos = MiscUtilKt.eventuallyUpdatedInBackgroundLazy(10000L, this.project, string, arg_0 -> HelmIndex.addedRepos$lambda$0(this, arg_0));
        this.chartIndexUrl = CHART_INDEX_URL;
        this.repoChartsCache = new StampBasedCache(HelmIndex::repoChartsCache$lambda$4, HelmIndex::repoChartsCache$lambda$5, null, 100L, Duration.ofMinutes(10L), 4, null);
        this.repoChartNamesCache = new StampBasedCache(HelmIndex::repoChartNamesCache$lambda$7, repoChartNamesCache.2.INSTANCE, repoChartNamesCache.3.INSTANCE, 100L, Duration.ofMinutes(100L));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final HelmExecutionManager getHelmExecutionManager() {
        return HelmExecutionManager.Companion.getInstance(this.project);
    }

    public final void reset() {
        this.chartIndexUrl = CHART_INDEX_URL;
        this.addedRepos.reset();
        this.getHelmExecutionManager().resetConfig();
    }

    public final void forceUpdateAddedReposCache() {
        this.getHelmExecutionManager().forceUpdateConfigAndWait();
        this.addedRepos.requestUpdateAndWait(10000L);
    }

    @Nullable
    public final Collection<HubRepoDto> getAddedRepos() {
        return (Collection)this.addedRepos.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<HubRepoDto> calculateAddedRepos(ProgressIndicator progressIndicator) {
        try {
            List list2;
            ProcessOutput output;
            void blockName$iv;
            Object object;
            long t0$iv;
            Logger logger$iv;
            block25: {
                block26: {
                    ProcessOutput processOutput2;
                    block24: {
                        String string = "calculateAddedRepos";
                        logger$iv = log;
                        boolean $i$f$withDurationLogged = false;
                        t0$iv = System.currentTimeMillis();
                        boolean bl = false;
                        object = new String[]{"repo", "list", "-o", "table"};
                        if (this.getHelmExecutionManager().executeServiceCommand(CollectionsKt.listOf((Object[])object), progressIndicator) != null) break block24;
                        List<HubRepoDto> list3 = null;
                        long l = System.currentTimeMillis() - t0$iv;
                        Lazy lazy = LazyKt.lazy((Function0)((Function0)new Function0<String>(l, (String)blockName$iv){
                            final /* synthetic */ long $t1;
                            final /* synthetic */ String $blockName;
                            {
                                this.$t1 = $t1;
                                this.$blockName = $blockName;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final String invoke() {
                                String string;
                                void condition$iv;
                                String string2 = this.$t1 + " ms";
                                boolean bl = this.$blockName != null;
                                String string3 = this.$blockName;
                                boolean $i$f$transformIf = false;
                                if (condition$iv != false) {
                                    void $this$transformIf$iv;
                                    void it = $this$transformIf$iv;
                                    boolean bl2 = false;
                                    string = string3 + " took " + (String)it;
                                } else {
                                    string = string2;
                                }
                                return string;
                            }
                        }));
                        if (logger$iv != null) {
                            if (logger$iv.isTraceEnabled()) {
                                logger$iv.trace((String)lazy.getValue());
                            }
                        } else {
                            System.out.println(lazy.getValue());
                        }
                        return list3;
                    }
                    output = processOutput2;
                    if (!output.isExitCodeSet() || output.getExitCode() == 0) break block25;
                    String string = output.getStderr();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Error: no repositories to show", (boolean)false, (int)2, null)) break block26;
                    List list4 = CollectionsKt.emptyList();
                    long l = System.currentTimeMillis() - t0$iv;
                    Lazy lazy = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
                    if (logger$iv != null) {
                        if (logger$iv.isTraceEnabled()) {
                            logger$iv.trace((String)lazy.getValue());
                        }
                    } else {
                        System.out.println(lazy.getValue());
                    }
                    return list4;
                }
                log.warn("error executing \"helm repo list\": " + output.getStderr());
                List<HubRepoDto> list5 = null;
                long l = System.currentTimeMillis() - t0$iv;
                Lazy lazy = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
                if (logger$iv != null) {
                    if (logger$iv.isTraceEnabled()) {
                        logger$iv.trace((String)lazy.getValue());
                    }
                } else {
                    System.out.println(lazy.getValue());
                }
                return list5;
            }
            try {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                HubRepoDto it;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                CSVReader csvReader = new CSVReader(new StringReader(output.getStdout()), '\t');
                csvReader.readNext();
                List<String[]> list6 = csvReader.readAll();
                Intrinsics.checkNotNullExpressionValue(list6, (String)"readAll(...)");
                object = list6;
                boolean $i$f$map = false;
                void var12_24 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String[] stringArray = (String[])item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    String string = (String)ArraysKt.getOrNull((Object[])it, (int)0);
                    String string2 = (String)ArraysKt.getOrNull((Object[])it, (int)1);
                    collection.add(new HubRepoDto(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null, string2 != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (HubRepoDto)element$iv$iv;
                    boolean bl = false;
                    CharSequence charSequence = it.getUrl();
                    if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !((charSequence = (CharSequence)it.getName()) == null || StringsKt.isBlank((CharSequence)charSequence)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            }
            catch (Throwable throwable) {
                long t1$iv = System.currentTimeMillis() - t0$iv;
                Lazy message$iv = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
                if (logger$iv != null) {
                    if (logger$iv.isTraceEnabled()) {
                        logger$iv.trace((String)message$iv.getValue());
                    }
                } else {
                    System.out.println(message$iv.getValue());
                }
                throw throwable;
            }
            long l = System.currentTimeMillis() - t0$iv;
            Lazy lazy = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
            if (logger$iv != null) {
                if (logger$iv.isTraceEnabled()) {
                    logger$iv.trace((String)lazy.getValue());
                }
            } else {
                System.out.println(lazy.getValue());
            }
            return list2;
        }
        catch (ExecutionException e) {
            log.warn("Couldn't execute Helm command", (Throwable)e);
            return null;
        }
    }

    @NotNull
    public final Collection<HubChartDto> getAllCharts() {
        List<HubChartDto> list2 = this.getCharts(false);
        if (list2 == null) {
            return CollectionsKt.emptyList();
        }
        return list2;
    }

    @Nullable
    public final Collection<HubChartDto> getDownloadedOnlyCharts() {
        return this.getCharts(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Collection<RepoChartDto> getChartsFromRepo(@NotNull String chartName, @NotNull String repoUrl) {
        Collection collection;
        Path path;
        void blockName$iv;
        long t0$iv;
        Logger logger$iv;
        block11: {
            Intrinsics.checkNotNullParameter((Object)chartName, (String)"chartName");
            Intrinsics.checkNotNullParameter((Object)repoUrl, (String)"repoUrl");
            String string = "getChartsFromRepo(" + chartName + ", " + repoUrl + ")";
            logger$iv = log;
            boolean $i$f$withDurationLogged = false;
            t0$iv = System.currentTimeMillis();
            boolean bl = false;
            if (this.getLocalCacheRepoIndex(repoUrl) != null) break block11;
            Collection<RepoChartDto> collection2 = null;
            {
                catch (Throwable throwable) {
                    long t1$iv = System.currentTimeMillis() - t0$iv;
                    Lazy message$iv = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
                    if (logger$iv != null) {
                        if (!logger$iv.isTraceEnabled()) throw throwable;
                        logger$iv.trace((String)message$iv.getValue());
                        throw throwable;
                    }
                    System.out.println(message$iv.getValue());
                    throw throwable;
                }
            }
            long l = System.currentTimeMillis() - t0$iv;
            Lazy lazy = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
            if (logger$iv != null) {
                if (!logger$iv.isTraceEnabled()) return collection2;
                logger$iv.trace((String)lazy.getValue());
                return collection2;
            }
            System.out.println(lazy.getValue());
            return collection2;
        }
        Path contentFile = path;
        try {
            collection = this.repoChartsCache.get(new RepoChartsCacheKey(contentFile, chartName));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to parse chart index from helm repository " + repoUrl, (Throwable)e);
            }
            Collection<RepoChartDto> collection3 = null;
            long l = System.currentTimeMillis() - t0$iv;
            Lazy lazy = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
            if (logger$iv != null) {
                if (!logger$iv.isTraceEnabled()) return collection3;
                logger$iv.trace((String)lazy.getValue());
                return collection3;
            }
            System.out.println(lazy.getValue());
            return collection3;
        }
        long l = System.currentTimeMillis() - t0$iv;
        Lazy lazy = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        if (logger$iv != null) {
            if (!logger$iv.isTraceEnabled()) return collection;
            logger$iv.trace((String)lazy.getValue());
            return collection;
        }
        System.out.println(lazy.getValue());
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Collection<String> getChartNamesFromRepo(@NotNull String repoUrl) {
        Collection collection;
        Path path;
        void blockName$iv;
        long t0$iv;
        Logger logger$iv;
        block11: {
            Intrinsics.checkNotNullParameter((Object)repoUrl, (String)"repoUrl");
            String string = "getChartNamesFromRepo(" + repoUrl + ")";
            logger$iv = log;
            boolean $i$f$withDurationLogged = false;
            t0$iv = System.currentTimeMillis();
            boolean bl = false;
            if (this.getLocalCacheRepoIndex(repoUrl) != null) break block11;
            Collection<String> collection2 = null;
            {
                catch (Throwable throwable) {
                    long t1$iv = System.currentTimeMillis() - t0$iv;
                    Lazy message$iv = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
                    if (logger$iv != null) {
                        if (!logger$iv.isTraceEnabled()) throw throwable;
                        logger$iv.trace((String)message$iv.getValue());
                        throw throwable;
                    }
                    System.out.println(message$iv.getValue());
                    throw throwable;
                }
            }
            long l = System.currentTimeMillis() - t0$iv;
            Lazy lazy = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
            if (logger$iv != null) {
                if (!logger$iv.isTraceEnabled()) return collection2;
                logger$iv.trace((String)lazy.getValue());
                return collection2;
            }
            System.out.println(lazy.getValue());
            return collection2;
        }
        Path contentFile = path;
        try {
            collection = this.repoChartNamesCache.get(contentFile);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to parse chart index from helm repository " + repoUrl, (Throwable)e);
            }
            Collection<String> collection3 = null;
            long l = System.currentTimeMillis() - t0$iv;
            Lazy lazy = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
            if (logger$iv != null) {
                if (!logger$iv.isTraceEnabled()) return collection3;
                logger$iv.trace((String)lazy.getValue());
                return collection3;
            }
            System.out.println(lazy.getValue());
            return collection3;
        }
        long l = System.currentTimeMillis() - t0$iv;
        Lazy lazy = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        if (logger$iv != null) {
            if (!logger$iv.isTraceEnabled()) return collection;
            logger$iv.trace((String)lazy.getValue());
            return collection;
        }
        System.out.println(lazy.getValue());
        return collection;
    }

    private final Path getLocalCacheRepoIndex(String repoUrl) {
        Object object;
        Object it;
        Object object2;
        Object object3;
        block6: {
            block5: {
                object3 = HelmIndexKt.findAddedRepoByUrl(this, repoUrl);
                if (object3 == null) break block5;
                it = object2 = object3;
                boolean bl = false;
                object3 = ((HubRepoDto)it).getName() != null ? object2 : null;
                if (object3 != null) break block6;
            }
            return null;
        }
        HubRepoDto repo = object3;
        Path path = this.getHelmExecutionManager().getRepositoryCachePath();
        if (path != null && (path = path.resolve(repo.getName() + "-index.yaml")) != null) {
            it = object2 = path;
            boolean bl = false;
            object = Files.exists((Path)it, new LinkOption[0]) ? object2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @TestOnly
    public final void setChartIndexSource(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new OperationNotSupportedException();
        }
        this.chartIndexUrl = file.getUrl();
    }

    @TestOnly
    public final void setAddedRepos(@NotNull List<HubRepoDto> repos) {
        Intrinsics.checkNotNullParameter(repos, (String)"repos");
        this.addedRepos.setNeverExpiringValue(repos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List<HubChartDto> getCharts(boolean skipDownload) {
        List<HubChartDto> list2;
        VirtualFile virtualFile;
        void blockName$iv;
        long t0$iv;
        Logger logger$iv;
        block11: {
            String string = "getCharts";
            logger$iv = log;
            boolean $i$f$withDurationLogged = false;
            t0$iv = System.currentTimeMillis();
            boolean bl = false;
            Url url = Urls.parse((String)this.chartIndexUrl, (boolean)false);
            Intrinsics.checkNotNull((Object)url);
            Url chartsUrl = url;
            if (this.getDownloadedFile(chartsUrl, skipDownload) != null) break block11;
            List<HubChartDto> list3 = null;
            {
                catch (Throwable throwable) {
                    long t1$iv = System.currentTimeMillis() - t0$iv;
                    Lazy message$iv = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
                    if (logger$iv != null) {
                        if (!logger$iv.isTraceEnabled()) throw throwable;
                        logger$iv.trace((String)message$iv.getValue());
                        throw throwable;
                    }
                    System.out.println(message$iv.getValue());
                    throw throwable;
                }
            }
            long l = System.currentTimeMillis() - t0$iv;
            Lazy lazy = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
            if (logger$iv != null) {
                if (!logger$iv.isTraceEnabled()) return list3;
                logger$iv.trace((String)lazy.getValue());
                return list3;
            }
            System.out.println(lazy.getValue());
            return list3;
        }
        VirtualFile contentFile = virtualFile;
        try {
            list2 = HelmHubDtoKt.readHubCharts(contentFile);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to parse chart index from hub.helm.sh", (Throwable)e);
            }
            List<HubChartDto> list4 = null;
            long l = System.currentTimeMillis() - t0$iv;
            Lazy lazy = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
            if (logger$iv != null) {
                if (!logger$iv.isTraceEnabled()) return list4;
                logger$iv.trace((String)lazy.getValue());
                return list4;
            }
            System.out.println(lazy.getValue());
            return list4;
        }
        long l = System.currentTimeMillis() - t0$iv;
        Lazy lazy = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        if (logger$iv != null) {
            if (!logger$iv.isTraceEnabled()) return list2;
            logger$iv.trace((String)lazy.getValue());
            return list2;
        }
        System.out.println(lazy.getValue());
        return list2;
    }

    private final VirtualFile getDownloadedFile(Url url, boolean skipDownload) {
        DownloadManager downloadManager;
        block6: {
            if (url == null) {
                return null;
            }
            downloadManager = DownloadManager.Companion.getInstance();
            if (!skipDownload) {
                try {
                    downloadManager.download(url, ProgressManager.getGlobalProgressIndicator(), false);
                }
                catch (Exception e) {
                    String string;
                    if (!log.isDebugEnabled()) break block6;
                    try {
                        string = url.toString();
                    }
                    catch (Exception e2) {
                        string = "<malformed>";
                    }
                    String urlString = string;
                    log.debug("Unable to get file from " + urlString, (Throwable)e);
                }
            }
        }
        DownloadManager.LocalFileInfo localFileInfo = downloadManager.getLocalFileInfo(url);
        return localFileInfo != null ? localFileInfo.getContentFile() : null;
    }

    static /* synthetic */ VirtualFile getDownloadedFile$default(HelmIndex helmIndex, Url url, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return helmIndex.getDownloadedFile(url, bl);
    }

    private static final List addedRepos$lambda$0(HelmIndex this$0, ProgressIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.calculateAddedRepos(it);
    }

    private static final long repoChartsCache$lambda$4(RepoChartsCacheKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Files.getLastModifiedTime(it.getContentFile(), new LinkOption[0]).toMillis();
    }

    private static final List repoChartsCache$lambda$5(RepoChartsCacheKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HelmRepoDtoKt.readRepoCharts(it.getContentFile(), it.getChartName());
    }

    private static final long repoChartNamesCache$lambda$7(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Files.getLastModifiedTime(it, new LinkOption[0]).toMillis();
    }

    static {
        Logger logger = Logger.getInstance(HelmIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/helm/dependencies/HelmIndex$Companion;", "", "<init>", "()V", "ADDED_REPOS_UPDATE_TIMEOUT", "", "CHART_INDEX_URL", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/helm/dependencies/HelmIndex$RepoChartsCacheKey;", "", "contentFile", "Ljava/nio/file/Path;", "chartName", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "getContentFile", "()Ljava/nio/file/Path;", "getChartName", "()Ljava/lang/String;", "toString", "intellij.clouds.kubernetes"})
    private static final class RepoChartsCacheKey {
        @NotNull
        private final Path contentFile;
        @NotNull
        private final String chartName;

        public RepoChartsCacheKey(@NotNull Path contentFile, @NotNull String chartName) {
            Intrinsics.checkNotNullParameter((Object)contentFile, (String)"contentFile");
            Intrinsics.checkNotNullParameter((Object)chartName, (String)"chartName");
            this.contentFile = contentFile;
            this.chartName = chartName;
        }

        @NotNull
        public final Path getContentFile() {
            return this.contentFile;
        }

        @NotNull
        public final String getChartName() {
            return this.chartName;
        }

        @NotNull
        public String toString() {
            return this.contentFile + "!" + this.chartName;
        }
    }
}

