/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.gotpl.inspections;

import com.goide.template.GoTemplateTypes;
import com.goide.template.psi.GoTemplateLiteral;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.helm.HelmUtilKt;
import com.intellij.kubernetes.helm.gotpl.GoTemplateUtilKt;
import com.intellij.kubernetes.helm.gotpl.i18n.ChartsGoTemplateBundle;
import com.intellij.kubernetes.helm.gotpl.model.HelmGoTemplateResolver;
import com.intellij.kubernetes.helm.model.HelmObject;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/helm/gotpl/inspections/HelmUnknownValuesInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.clouds.kubernetes.charts.gotpl"})
@SourceDebugExtension(value={"SMAP\nHelmUnknownValuesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmUnknownValuesInspection.kt\ncom/intellij/kubernetes/helm/gotpl/inspections/HelmUnknownValuesInspection\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,45:1\n31#2,2:46\n*S KotlinDebug\n*F\n+ 1 HelmUnknownValuesInspection.kt\ncom/intellij/kubernetes/helm/gotpl/inspections/HelmUnknownValuesInspection\n*L\n18#1:46,2\n*E\n"})
public final class HelmUnknownValuesInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<HelmGoTemplateResolver> serviceClass$iv = HelmGoTemplateResolver.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        HelmGoTemplateResolver resolver = (HelmGoTemplateResolver)object;
        return new PsiElementVisitor(resolver, holder){
            final /* synthetic */ HelmGoTemplateResolver $resolver;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$resolver = $resolver;
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!Intrinsics.areEqual((Object)element.getNode().getElementType(), (Object)GoTemplateTypes.IDENTIFIER) || !HelmUtilKt.isChartsTemplateElement(element)) {
                    return;
                }
                if (element.getParent() instanceof GoTemplateLiteral && GoTemplateUtilKt.isStandardGoTemplateFunction(element.getText())) {
                    return;
                }
                PsiElement psiElement = this.$resolver.extractIdentifier(element);
                if (psiElement == null) {
                    return;
                }
                PsiElement id = psiElement;
                Collection resolved = HelmGoTemplateResolver.resolveObjectsByReference$default(this.$resolver, element, false, 2, null);
                if (resolved.isEmpty()) {
                    this.$holder.registerProblem(id, ChartsGoTemplateBundle.message("HelmUnknownValuesInspection.unknown.identifier.message", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                } else if (((HelmObject)CollectionsKt.first((Iterable)resolved)).getMustHaveValueDefinition()) {
                    void $this$flatMapTo$iv$iv;
                    Iterable $this$flatMap$iv = resolved;
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        HelmObject it = (HelmObject)element$iv$iv;
                        boolean bl = false;
                        Iterable list$iv$iv = it.getDefinitionElements();
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    if (((List)destination$iv$iv).isEmpty()) {
                        this.$holder.registerProblem(id, ChartsGoTemplateBundle.message("HelmUnknownValuesInspection.no.value.defined.message", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                    }
                }
            }
        };
    }
}

