/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.helm.model.HelmNavigationTargetProviderMixin;
import com.intellij.kubernetes.helm.model.HelmResolveTarget;
import com.intellij.kubernetes.helm.model.HelmResolveUtilKt;
import com.intellij.kubernetes.helm.model.HelmResolverKt;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.kubernetes.helm.references.RegularHelmValueReference;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.YamlReferenceType;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/helm/model/DependencyAliasMetaClass;", "Lorg/jetbrains/yaml/meta/model/YamlReferenceType;", "Lcom/intellij/kubernetes/helm/model/HelmNavigationTargetProviderMixin;", "def", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "<init>", "(Lcom/intellij/kubernetes/helm/model/spec/Definition;)V", "getReferencesFromValue", "", "Lcom/intellij/psi/PsiReference;", "valueScalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "(Lorg/jetbrains/yaml/psi/YAMLScalar;)[Lcom/intellij/psi/PsiReference;", "getResolveTarget", "Lcom/intellij/kubernetes/helm/model/HelmResolveTarget;", "value", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmMetaClassDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/DependencyAliasMetaClass\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,585:1\n31#2,2:586\n31#2,2:589\n1#3:588\n*S KotlinDebug\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/DependencyAliasMetaClass\n*L\n330#1:586,2\n339#1:589,2\n*E\n"})
public final class DependencyAliasMetaClass
extends YamlReferenceType
implements HelmNavigationTargetProviderMixin {
    public DependencyAliasMetaClass(@NotNull Definition def) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        super(YamlStringType.getInstance().getTypeName());
    }

    @NotNull
    public PsiReference[] getReferencesFromValue(@NotNull YAMLScalar valueScalar) {
        PsiReference[] psiReferenceArray;
        Intrinsics.checkNotNullParameter((Object)valueScalar, (String)"valueScalar");
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)valueScalar);
        if (virtualFile == null) {
            return new PsiReference[0];
        }
        VirtualFile vfsFile = virtualFile;
        String string = valueScalar.getTextValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextValue(...)");
        String aliasName = string;
        Project project = valueScalar.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ChartManager chartManager = (ChartManager)object;
        VirtualFile virtualFile2 = vfsFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
        Chart chart = chartManager.findChartByBaseDir(virtualFile2);
        if (chart == null) {
            return new PsiReference[0];
        }
        Chart thisChart = chart;
        Chart.Dependency dependency = thisChart.getDependencies().get(aliasName);
        if (dependency == null) {
            return new PsiReference[0];
        }
        Chart.Dependency dependency2 = dependency;
        Chart chart2 = dependency2.getChart();
        if (chart2 != null) {
            Chart it = chart2;
            boolean bl = false;
            RegularHelmValueReference it2 = new RegularHelmValueReference((PsiElement)valueScalar, new PathInChart(HelmResolveUtilKt.getObjectPath(dependency2), thisChart));
            boolean bl2 = false;
            PsiReference[] psiReferenceArray2 = new PsiReference[]{it2};
            psiReferenceArray = psiReferenceArray2;
        } else {
            psiReferenceArray = new PsiReference[]{};
        }
        return psiReferenceArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public HelmResolveTarget getResolveTarget(@NotNull YAMLScalar value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Project project = value2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ChartManager chartManager = (ChartManager)object;
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)value2);
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile virtualFile2 = virtualFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
        Chart chart = chartManager.findChartByBaseDir(virtualFile2);
        if (chart == null) return null;
        String[] stringArray = new String[]{value2.getTextValue()};
        PathInChart pathInChart = HelmResolverKt.newPathInChart(chart, HelmResolveUtilKt.getVALUES_ROOT().append(stringArray));
        if (pathInChart == null) return null;
        HelmResolveTarget helmResolveTarget = HelmResolverKt.resolveTarget(pathInChart);
        return helmResolveTarget;
    }
}

