/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.install.kubectl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettings;
import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettingsKt;
import com.intellij.kubernetes.install.BinaryInstaller;
import com.intellij.kubernetes.install.InstallationResult;
import com.intellij.kubernetes.install.SuccessfulInstallation;
import com.intellij.kubernetes.install.kubectl.InstallKubectlAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.system.CpuArch;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\b\u0010\u0011\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\b\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"KUBECTL_BASE_URL", "", "KUBECTL_VERSION_ENDPOINT", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "installKubectl", "", "project", "Lcom/intellij/openapi/project/Project;", "resultHandler", "Lkotlin/Function1;", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "clearKubectlPathIfMismatch", "installedPath", "Ljava/nio/file/Path;", "getBinaryName", "getDownloadUrl", "getOSName", "getArchName", "downloadChecksum", "downloadUrl", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nInstallKubectlAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallKubectlAction.kt\ncom/intellij/kubernetes/install/kubectl/InstallKubectlActionKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,123:1\n15#2:124\n*S KotlinDebug\n*F\n+ 1 InstallKubectlAction.kt\ncom/intellij/kubernetes/install/kubectl/InstallKubectlActionKt\n*L\n27#1:124\n*E\n"})
public final class InstallKubectlActionKt {
    @NotNull
    private static final String KUBECTL_BASE_URL = "https://dl.k8s.io/release";
    @NotNull
    private static final String KUBECTL_VERSION_ENDPOINT = "https://dl.k8s.io/release/stable.txt";
    @NotNull
    private static final Logger LOG;

    public static final void installKubectl(@NotNull Project project, @NotNull Function1<? super Boolean, Unit> resultHandler, @Nullable ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT().log(project, "install-kubectl");
        BinaryInstaller.Companion.create(project).withBinaryName((Function0<String>)((Function0)InstallKubectlActionKt::installKubectl$lambda$1)).withDownloadUrl((Function1<? super BinaryInstaller.Configuration, String>)((Function1)InstallKubectlActionKt::installKubectl$lambda$2)).withChecksum((Function1<? super BinaryInstaller.Configuration, String>)((Function1)InstallKubectlActionKt::installKubectl$lambda$3)).withProgressIndicator(progressIndicator).withResultHandler((Function1<? super InstallationResult, Unit>)((Function1)arg_0 -> InstallKubectlActionKt.installKubectl$lambda$4(resultHandler, arg_0))).install();
    }

    public static /* synthetic */ void installKubectl$default(Project project, Function1 function1, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = InstallKubectlActionKt::installKubectl$lambda$0;
        }
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        InstallKubectlActionKt.installKubectl(project, (Function1<? super Boolean, Unit>)function1, progressIndicator);
    }

    private static final void clearKubectlPathIfMismatch(Path installedPath) {
        try {
            Path path;
            String string = KubernetesApiGlobalSettings.Companion.getInstance().getKubectlPathString();
            if (!Intrinsics.areEqual(string != null && (path = NioPathUtil.toNioPathOrNull((String)string)) != null ? path.toAbsolutePath() : null, (Object)installedPath)) {
                KubernetesApiGlobalSettings.Companion.getInstance().setKubectlPathString(null);
            }
        }
        catch (Exception exception) {
            KubernetesApiGlobalSettings.Companion.getInstance().setKubectlPathString(null);
        }
    }

    private static final String getBinaryName() {
        return SystemInfoRt.isWindows ? "kubectl.exe" : "kubectl";
    }

    private static final String getDownloadUrl() {
        String string = HttpRequests.request((String)KUBECTL_VERSION_ENDPOINT).productNameAsUserAgent().readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String latestStableVersion = string;
        return "https://dl.k8s.io/release/" + latestStableVersion + "/bin/" + InstallKubectlActionKt.getOSName() + "/" + InstallKubectlActionKt.getArchName() + "/" + InstallKubectlActionKt.getBinaryName();
    }

    private static final String getOSName() {
        return SystemInfoRt.isWindows ? "windows" : (SystemInfoRt.isLinux ? "linux" : (SystemInfoRt.isMac ? "darwin" : null));
    }

    private static final String getArchName() {
        return CpuArch.isArm64() ? "arm64" : "amd64";
    }

    private static final String downloadChecksum(String downloadUrl) {
        String string;
        String string2 = downloadUrl;
        if (string2 == null) {
            string2 = InstallKubectlActionKt.getDownloadUrl();
        }
        String checksumFileDownloadUrl = string2 + ".sha256";
        try {
            string = HttpRequests.request((String)checksumFileDownloadUrl).productNameAsUserAgent().readString();
        }
        catch (Exception e) {
            LOG.error("Failed to download kubectl checksum file from: " + checksumFileDownloadUrl, (Throwable)e);
            string = null;
        }
        return string;
    }

    private static final Unit installKubectl$lambda$0(boolean it) {
        return Unit.INSTANCE;
    }

    private static final String installKubectl$lambda$1() {
        return InstallKubectlActionKt.getBinaryName();
    }

    private static final String installKubectl$lambda$2(BinaryInstaller.Configuration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return InstallKubectlActionKt.getDownloadUrl();
    }

    private static final String installKubectl$lambda$3(BinaryInstaller.Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return InstallKubectlActionKt.downloadChecksum(configuration.getDownloadUrl());
    }

    private static final Unit installKubectl$lambda$4(Function1 $resultHandler, InstallationResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (result2 instanceof SuccessfulInstallation) {
            Path installedPath = ((SuccessfulInstallation)result2).getBinary().toAbsolutePath();
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance(...)");
            KubernetesApiGlobalSettingsKt.setKubectlPath(propertiesComponent, ((Object)installedPath).toString());
            Intrinsics.checkNotNull((Object)installedPath);
            InstallKubectlActionKt.clearKubectlPathIfMismatch(installedPath);
        }
        $resultHandler.invoke((Object)(result2 instanceof SuccessfulInstallation));
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(InstallKubectlAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

