/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.kubernetes.logs.KubernetesFastLogProvider;
import com.intellij.kubernetes.logs.KubernetesLogEntryKt;
import com.intellij.kubernetes.logs.LogEntry;
import com.intellij.kubernetes.logs.LogLineEntry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DEFAULT_LOG_EDITOR_SIZE_LINES", "", "DEFAULT_LOG_PAGES_UP", "DEFAULT_LOG_PAGES_DOWN", "TOTAL_PAGES", "colorLogLine", "", "lineIndex", "logLine", "Lcom/intellij/kubernetes/logs/LogLineEntry;", "markupModel", "Lcom/intellij/openapi/editor/markup/MarkupModel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesLargeLogsEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLargeLogsEditor.kt\ncom/intellij/kubernetes/logs/KubernetesLargeLogsEditorKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,352:1\n15#2:353\n*S KotlinDebug\n*F\n+ 1 KubernetesLargeLogsEditor.kt\ncom/intellij/kubernetes/logs/KubernetesLargeLogsEditorKt\n*L\n34#1:353\n*E\n"})
public final class KubernetesLargeLogsEditorKt {
    @NotNull
    private static final Logger LOG;
    public static final int DEFAULT_LOG_EDITOR_SIZE_LINES = 50;
    public static final int DEFAULT_LOG_PAGES_UP = 2;
    public static final int DEFAULT_LOG_PAGES_DOWN = 2;
    public static final int TOTAL_PAGES = 5;

    public static final void colorLogLine(int lineIndex, @NotNull LogLineEntry logLine, @NotNull MarkupModel markupModel, @NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)logLine, (String)"logLine");
        Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int startOffset = editor.getDocument().getLineStartOffset(lineIndex);
        for (LogEntry entry : logLine.getLogEntries()) {
            entry.setHighlighter(markupModel.addRangeHighlighter(startOffset, startOffset + entry.getMessage().length(), 3000, ((ConsoleViewContentType)entry.getContentType().getValue()).getAttributes(), HighlighterTargetArea.EXACT_RANGE));
            if (entry.getHyperlinkInfo() != null) {
                RangeHighlighter rangeHighlighter = entry.getHighlighter();
                if (rangeHighlighter != null) {
                    rangeHighlighter.putUserData(KubernetesLogEntryKt.getHYPERLINK_INFO_KEY(), (Object)entry.getHyperlinkInfo());
                }
            }
            startOffset += entry.getMessage().length();
        }
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesFastLogProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

