/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.logs.AnsiSegment;
import com.intellij.kubernetes.logs.KubernetesAnsiParsingException;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u000e0\u000e0\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\"2\u0010\u0014\u001a$\u0012 \u0012\u001e \u0012*\u000e\u0018\u00010\u000e\u00a2\u0006\u0002\b\u0015\u00a2\u0006\u0002\b\u00160\u000e\u00a2\u0006\u0002\b\u0015\u00a2\u0006\u0002\b\u00160\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\"\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u0018"}, d2={"ansiCsiRegexCapturingCsiParameter", "Lkotlin/text/Regex;", "ansiSetTitleOscSequence", "stripAnsiSetTitleOscSequence", "", "input", "stripAnsiCsi", "containsAnsiCsi", "", "string", "parseStringWithAnsiCsi", "", "Lcom/intellij/kubernetes/logs/AnsiSegment;", "ansiCsiToJColor", "Ljava/awt/Color;", "ansiString", "basicAnsiColors", "", "kotlin.jvm.PlatformType", "[Ljava/awt/Color;", "brightAnsiColors", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "xterm256Colors", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesLogAnsiSegment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogAnsiSegment.kt\ncom/intellij/kubernetes/logs/KubernetesLogAnsiSegmentKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1611#2,9:162\n1863#2:171\n1864#2:173\n1620#2:174\n1#3:172\n*S KotlinDebug\n*F\n+ 1 KubernetesLogAnsiSegment.kt\ncom/intellij/kubernetes/logs/KubernetesLogAnsiSegmentKt\n*L\n97#1:162,9\n97#1:171\n97#1:173\n97#1:174\n97#1:172\n*E\n"})
public final class KubernetesLogAnsiSegmentKt {
    @NotNull
    private static final Regex ansiCsiRegexCapturingCsiParameter;
    @NotNull
    private static final Regex ansiSetTitleOscSequence;
    @NotNull
    private static final Color[] basicAnsiColors;
    @NotNull
    private static final Color[] brightAnsiColors;
    @NotNull
    private static final Color[] xterm256Colors;

    @NotNull
    public static final String stripAnsiSetTitleOscSequence(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return ansiSetTitleOscSequence.replace((CharSequence)input, "");
    }

    @NotNull
    public static final String stripAnsiCsi(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        CharSequence charSequence = input;
        Regex regex = ansiCsiRegexCapturingCsiParameter;
        String string = "";
        return regex.replace(charSequence, string);
    }

    public static final boolean containsAnsiCsi(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return ansiCsiRegexCapturingCsiParameter.containsMatchIn((CharSequence)string);
    }

    @NotNull
    public static final List<AnsiSegment> parseStringWithAnsiCsi(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Sequence matches = Regex.findAll$default((Regex)ansiCsiRegexCapturingCsiParameter, (CharSequence)input, (int)0, (int)2, null);
        List result2 = new ArrayList();
        int lastIndex = 0;
        String lastCode = "\u001b[0m";
        try {
            for (MatchResult match : matches) {
                int start2 = match.getRange().getFirst();
                if (start2 > lastIndex) {
                    String string = input.substring(lastIndex, start2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    result2.add(new AnsiSegment(lastCode, string));
                }
                lastCode = match.getValue();
                lastIndex = match.getRange().getLast() + 1;
            }
            if (lastIndex < input.length()) {
                String string = input.substring(lastIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                result2.add(new AnsiSegment(lastCode, string));
            }
        }
        catch (IllegalArgumentException e) {
            throw new KubernetesAnsiParsingException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new KubernetesAnsiParsingException(e);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Color ansiCsiToJColor(String ansiString) {
        void $this$mapNotNullTo$iv$iv;
        String match = (String)SequencesKt.single((Sequence)SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)ansiCsiRegexCapturingCsiParameter, (CharSequence)ansiString, (int)0, (int)2, null), KubernetesLogAnsiSegmentKt::ansiCsiToJColor$lambda$0));
        Color textColor = null;
        String[] stringArray = new String[]{";"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)match, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (StringsKt.toIntOrNull((String)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List codes = (List)destination$iv$iv;
        int n = ((Collection)codes).size();
        for (int i = 0; i < n; ++i) {
            int n2 = ((Number)codes.get(i)).intValue();
            boolean bl = 30 <= n2 ? n2 < 38 : false;
            if (bl) {
                textColor = basicAnsiColors[((Number)codes.get(i)).intValue() - 30];
                continue;
            }
            boolean bl4 = 90 <= n2 ? n2 < 98 : false;
            if (bl4) {
                textColor = brightAnsiColors[((Number)codes.get(i)).intValue() - 90];
                continue;
            }
            if (n2 == 38) {
                if (i + 2 < codes.size() && ((Number)codes.get(i + 1)).intValue() == 5) {
                    int colorIndex = ((Number)codes.get(i + 2)).intValue();
                    textColor = xterm256Colors[colorIndex];
                    continue;
                }
                if (i + 4 >= codes.size() || ((Number)codes.get(i + 1)).intValue() != 2) continue;
                int r = ((Number)codes.get(i + 2)).intValue();
                int g = ((Number)codes.get(i + 3)).intValue();
                int b = ((Number)codes.get(i + 4)).intValue();
                textColor = (Color)new JBColor(new Color(r, g, b), new Color(r, g, b));
                continue;
            }
            if (n2 != 0) continue;
            textColor = null;
        }
        return textColor;
    }

    private static final String ansiCsiToJColor$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MatchGroup matchGroup = it.getGroups().get(1);
        return matchGroup != null ? matchGroup.getValue() : null;
    }

    public static final /* synthetic */ Color access$ansiCsiToJColor(String ansiString) {
        return KubernetesLogAnsiSegmentKt.ansiCsiToJColor(ansiString);
    }

    static {
        int i;
        Color[] colorArray;
        ansiCsiRegexCapturingCsiParameter = new Regex("\u001b\\[([;\\d]*)m");
        ansiSetTitleOscSequence = new Regex("\u001b]0;.*?\u0007");
        Color[] colorArray2 = new Color[]{JBColor.BLACK, JBColor.RED, JBColor.GREEN, JBColor.YELLOW, JBColor.BLUE, JBColor.MAGENTA, JBColor.CYAN, JBColor.WHITE};
        basicAnsiColors = colorArray2;
        colorArray2 = new Color[]{JBColor.DARK_GRAY, JBColor.RED.brighter(), JBColor.GREEN.brighter(), JBColor.YELLOW.brighter(), JBColor.BLUE.brighter(), JBColor.MAGENTA.brighter(), JBColor.CYAN.brighter(), JBColor.WHITE.brighter()};
        brightAnsiColors = colorArray2;
        int n = 0;
        Color[] colorArray3 = new Color[256];
        while (n < 256) {
            int n2 = n++;
            Intrinsics.checkNotNullExpressionValue((Object)JBColor.BLACK, (String)"BLACK");
        }
        Color[] $this$xterm256Colors_u24lambda_u242 = colorArray = colorArray3;
        boolean bl = false;
        for (i = 0; i < 16; ++i) {
            Intrinsics.checkNotNullExpressionValue((Object)((Color[])ArraysKt.plus((Object[])basicAnsiColors, (Object[])brightAnsiColors))[i], (String)"get(...)");
        }
        for (int r = 0; r < 6; ++r) {
            for (int g = 0; g < 6; ++g) {
                for (int b = 0; b < 6; ++b) {
                    int index = 16 + r * 36 + g * 6 + b;
                    $this$xterm256Colors_u24lambda_u242[index] = new JBColor(new Color(r * 51, g * 51, b * 51), new Color(r * 51, g * 51, b * 51));
                }
            }
        }
        for (i = 0; i < 24; ++i) {
            $this$xterm256Colors_u24lambda_u242[232 + i] = new JBColor(new Color(i * 11, i * 11, i * 11), new Color(i * 11, i * 11, i * 11));
        }
        new JBColor(123, 123);
        xterm256Colors = colorArray;
    }
}

