/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.logs.KubernetesContextLog;
import com.intellij.kubernetes.logs.KubernetesContextLogsManager;
import com.intellij.kubernetes.logs.KubernetesLogFilterModel;
import com.intellij.kubernetes.logs.KubernetesLogPresentationSettings;
import com.intellij.kubernetes.logs.KubernetesLogUtilsKt;
import com.intellij.kubernetes.logs.ui.LogContainerNodeLeafDescriptor;
import com.intellij.kubernetes.view.nodes.workloads.EventContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.ui.actions.contexts.ContextsTreeDialogKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.CheckedTreeNode;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001:B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u00109\u001a\u00020&H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R,\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c0\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0011R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020*0%X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010(R\u0014\u0010,\u001a\u00020-X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020201X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u000206X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006;"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesLogStateManager;", "Lcom/intellij/openapi/Disposable;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesApiModel;)V", "getApiModel$intellij_clouds_kubernetes", "()Lcom/intellij/kubernetes/api/KubernetesApiModel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope$intellij_clouds_kubernetes", "()Lkotlinx/coroutines/CoroutineScope;", "currentContainers", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "getCurrentContainers$intellij_clouds_kubernetes", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "addClusterEventsAsLogs", "", "getAddClusterEventsAsLogs$intellij_clouds_kubernetes", "presentationSettingsStateFlow", "Lcom/intellij/kubernetes/logs/KubernetesLogPresentationSettings;", "getPresentationSettingsStateFlow$intellij_clouds_kubernetes", "largeLogsSizeFlow", "", "getLargeLogsSizeFlow$intellij_clouds_kubernetes", "myTreeLogContainerLeafNodeDescriptorRegistry", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/kubernetes/logs/ui/LogContainerNodeLeafDescriptor;", "Lcom/intellij/ui/CheckedTreeNode;", "getMyTreeLogContainerLeafNodeDescriptorRegistry$intellij_clouds_kubernetes", "()Ljava/util/concurrent/ConcurrentHashMap;", "streamingLogsStatusFlow", "", "getStreamingLogsStatusFlow$intellij_clouds_kubernetes", "updateTimePeriodAndSourcesFieldsFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "getUpdateTimePeriodAndSourcesFieldsFlow$intellij_clouds_kubernetes", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "jumpToTimestampFlow", "Ljava/time/Instant;", "getJumpToTimestampFlow$intellij_clouds_kubernetes", "filterModel", "Lcom/intellij/kubernetes/logs/KubernetesLogFilterModel;", "getFilterModel$intellij_clouds_kubernetes", "()Lcom/intellij/kubernetes/logs/KubernetesLogFilterModel;", "logs", "Ljava/util/concurrent/ConcurrentSkipListSet;", "Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "getLogs$intellij_clouds_kubernetes", "()Ljava/util/concurrent/ConcurrentSkipListSet;", "hyperlinkEntryRegistry", "Lcom/intellij/kubernetes/logs/KubernetesLogStateManager$HyperLinkCachedCreator;", "getHyperlinkEntryRegistry$intellij_clouds_kubernetes", "()Lcom/intellij/kubernetes/logs/KubernetesLogStateManager$HyperLinkCachedCreator;", "dispose", "HyperLinkCachedCreator", "intellij.clouds.kubernetes"})
public final class KubernetesLogStateManager
implements Disposable {
    @NotNull
    private final KubernetesApiModel apiModel;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MutableStateFlow<List<KubernetesContainerObject>> currentContainers;
    @NotNull
    private final MutableStateFlow<Boolean> addClusterEventsAsLogs;
    @NotNull
    private final MutableStateFlow<KubernetesLogPresentationSettings> presentationSettingsStateFlow;
    @NotNull
    private final MutableStateFlow<Long> largeLogsSizeFlow;
    @NotNull
    private final ConcurrentHashMap<KubernetesContainerObject, ConcurrentHashMap<LogContainerNodeLeafDescriptor, CheckedTreeNode>> myTreeLogContainerLeafNodeDescriptorRegistry;
    @NotNull
    private final MutableStateFlow<Integer> streamingLogsStatusFlow;
    @NotNull
    private final MutableSharedFlow<Unit> updateTimePeriodAndSourcesFieldsFlow;
    @NotNull
    private final MutableSharedFlow<Instant> jumpToTimestampFlow;
    @NotNull
    private final KubernetesLogFilterModel filterModel;
    @NotNull
    private final ConcurrentSkipListSet<KubernetesContextLog> logs;
    @NotNull
    private final HyperLinkCachedCreator hyperlinkEntryRegistry;

    public KubernetesLogStateManager(@NotNull KubernetesApiModel apiModel2) {
        HyperLinkCachedCreator hyperLinkCachedCreator;
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        this.apiModel = apiModel2;
        this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.apiModel.getCoroutineScope(), (String)"k8s.log.manager.model", null, (boolean)false, (int)6, null);
        this.currentContainers = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.addClusterEventsAsLogs = StateFlowKt.MutableStateFlow((Object)false);
        this.presentationSettingsStateFlow = StateFlowKt.MutableStateFlow((Object)new KubernetesLogPresentationSettings(false, false, false, 7, null));
        this.largeLogsSizeFlow = StateFlowKt.MutableStateFlow((Object)0L);
        this.myTreeLogContainerLeafNodeDescriptorRegistry = new ConcurrentHashMap();
        this.streamingLogsStatusFlow = StateFlowKt.MutableStateFlow((Object)0);
        this.updateTimePeriodAndSourcesFieldsFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.jumpToTimestampFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.filterModel = new KubernetesLogFilterModel(this);
        this.logs = new ConcurrentSkipListSet();
        HyperLinkCachedCreator hyperLinkCachedCreator2 = hyperLinkCachedCreator = new HyperLinkCachedCreator(this.apiModel);
        KubernetesLogStateManager kubernetesLogStateManager = this;
        boolean bl = false;
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ KubernetesLogStateManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getCurrentContainers$intellij_clouds_kubernetes().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ KubernetesLogStateManager this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(List<? extends KubernetesContainerObject> it, Continuation<? super Unit> $completion) {
                                this.this$0.getHyperlinkEntryRegistry$intellij_clouds_kubernetes().clearCache$intellij_clouds_kubernetes();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        kubernetesLogStateManager.hyperlinkEntryRegistry = hyperLinkCachedCreator;
        Disposer.register((Disposable)((Disposable)this.apiModel.getApiProvider$intellij_clouds_kubernetes()), (Disposable)this);
    }

    @NotNull
    public final KubernetesApiModel getApiModel$intellij_clouds_kubernetes() {
        return this.apiModel;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope$intellij_clouds_kubernetes() {
        return this.coroutineScope;
    }

    @NotNull
    public final MutableStateFlow<List<KubernetesContainerObject>> getCurrentContainers$intellij_clouds_kubernetes() {
        return this.currentContainers;
    }

    @NotNull
    public final MutableStateFlow<Boolean> getAddClusterEventsAsLogs$intellij_clouds_kubernetes() {
        return this.addClusterEventsAsLogs;
    }

    @NotNull
    public final MutableStateFlow<KubernetesLogPresentationSettings> getPresentationSettingsStateFlow$intellij_clouds_kubernetes() {
        return this.presentationSettingsStateFlow;
    }

    @NotNull
    public final MutableStateFlow<Long> getLargeLogsSizeFlow$intellij_clouds_kubernetes() {
        return this.largeLogsSizeFlow;
    }

    @NotNull
    public final ConcurrentHashMap<KubernetesContainerObject, ConcurrentHashMap<LogContainerNodeLeafDescriptor, CheckedTreeNode>> getMyTreeLogContainerLeafNodeDescriptorRegistry$intellij_clouds_kubernetes() {
        return this.myTreeLogContainerLeafNodeDescriptorRegistry;
    }

    @NotNull
    public final MutableStateFlow<Integer> getStreamingLogsStatusFlow$intellij_clouds_kubernetes() {
        return this.streamingLogsStatusFlow;
    }

    @NotNull
    public final MutableSharedFlow<Unit> getUpdateTimePeriodAndSourcesFieldsFlow$intellij_clouds_kubernetes() {
        return this.updateTimePeriodAndSourcesFieldsFlow;
    }

    @NotNull
    public final MutableSharedFlow<Instant> getJumpToTimestampFlow$intellij_clouds_kubernetes() {
        return this.jumpToTimestampFlow;
    }

    @NotNull
    public final KubernetesLogFilterModel getFilterModel$intellij_clouds_kubernetes() {
        return this.filterModel;
    }

    @NotNull
    public final ConcurrentSkipListSet<KubernetesContextLog> getLogs$intellij_clouds_kubernetes() {
        return this.logs;
    }

    @NotNull
    public final HyperLinkCachedCreator getHyperlinkEntryRegistry$intellij_clouds_kubernetes() {
        return this.hyperlinkEntryRegistry;
    }

    public void dispose() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesLogStateManager$HyperLinkCachedCreator;", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesApiModel;)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModel;", "cache", "Ljava/util/concurrent/ConcurrentSkipListMap;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "getHyperlinkInfoForLog", "log", "Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "getHyperlinkInfoForLog$intellij_clouds_kubernetes", "clearCache", "", "clearCache$intellij_clouds_kubernetes", "onContainerHyperlinkClick", "container", "onEventHyperlinkClick", "buildHyperLink", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesLogStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogStateManager.kt\ncom/intellij/kubernetes/logs/KubernetesLogStateManager$HyperLinkCachedCreator\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n72#2,2:99\n1#3:101\n*S KotlinDebug\n*F\n+ 1 KubernetesLogStateManager.kt\ncom/intellij/kubernetes/logs/KubernetesLogStateManager$HyperLinkCachedCreator\n*L\n54#1:99,2\n54#1:101\n*E\n"})
    public static final class HyperLinkCachedCreator {
        @NotNull
        private final KubernetesApiModel apiModel;
        @NotNull
        private final ConcurrentSkipListMap<KubernetesContainerObject, HyperlinkInfo> cache;

        public HyperLinkCachedCreator(@NotNull KubernetesApiModel apiModel2) {
            Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
            this.apiModel = apiModel2;
            this.cache = new ConcurrentSkipListMap();
        }

        @NotNull
        public final KubernetesApiModel getApiModel() {
            return this.apiModel;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final HyperlinkInfo getHyperlinkInfoForLog$intellij_clouds_kubernetes(@NotNull KubernetesContextLog log2) {
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
            ConcurrentMap concurrentMap = this.cache;
            KubernetesContainerObject key$iv = log2.getSourceContainerObject();
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl = false;
                HyperlinkInfo default$iv = this.buildHyperLink(log2);
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
            return (HyperlinkInfo)object;
        }

        public final void clearCache$intellij_clouds_kubernetes() {
            this.cache.clear();
            ContextsTreeDialogKt.getLOG().info("Cleanup log hyperlink entry registry");
        }

        private final void onContainerHyperlinkClick(KubernetesApiModel apiModel2, KubernetesContainerObject container) {
            KubernetesContextLogsManager logManager = new KubernetesContextLogsManager(apiModel2);
            logManager.getStateManager$intellij_clouds_kubernetes().getCurrentContainers$intellij_clouds_kubernetes().setValue((Object)CollectionsKt.listOf((Object)container));
            KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(logManager.getApiModel().getProject(), "logs-highlight-navigation-action");
            KubernetesLogUtilsKt.openLogsInEditor(apiModel2.getProject(), apiModel2, (Disposable)apiModel2.getApiProvider$intellij_clouds_kubernetes(), logManager, this, container.getName() + " logs");
        }

        private final void onEventHyperlinkClick(KubernetesApiModel apiModel2) {
            KubernetesContextLogsManager logManager = new KubernetesContextLogsManager(apiModel2);
            logManager.getStateManager$intellij_clouds_kubernetes().getCurrentContainers$intellij_clouds_kubernetes().setValue((Object)CollectionsKt.emptyList());
            logManager.getStateManager$intellij_clouds_kubernetes().getAddClusterEventsAsLogs$intellij_clouds_kubernetes().setValue((Object)true);
            KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(logManager.getApiModel().getProject(), "logs-highlight-navigation-action");
            KubernetesLogUtilsKt.openLogsInEditor(apiModel2.getProject(), apiModel2, (Disposable)apiModel2.getApiProvider$intellij_clouds_kubernetes(), logManager, this, "Cluster events");
        }

        private final HyperlinkInfo buildHyperLink(KubernetesContextLog log2) {
            return new HyperlinkInfo(log2, this){
                final /* synthetic */ KubernetesContextLog $log;
                final /* synthetic */ HyperLinkCachedCreator this$0;
                {
                    this.$log = $log;
                    this.this$0 = $receiver;
                }

                public void navigate(Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    if (!Intrinsics.areEqual((Object)this.$log.getSourceContainerObject(), (Object)EventContainerObject.INSTANCE)) {
                        HyperLinkCachedCreator.access$onContainerHyperlinkClick(this.this$0, this.this$0.getApiModel(), this.$log.getSourceContainerObject());
                    } else {
                        HyperLinkCachedCreator.access$onEventHyperlinkClick(this.this$0, this.this$0.getApiModel());
                    }
                }
            };
        }

        public static final /* synthetic */ void access$onContainerHyperlinkClick(HyperLinkCachedCreator $this, KubernetesApiModel apiModel2, KubernetesContainerObject container) {
            $this.onContainerHyperlinkClick(apiModel2, container);
        }

        public static final /* synthetic */ void access$onEventHyperlinkClick(HyperLinkCachedCreator $this, KubernetesApiModel apiModel2) {
            $this.onEventHyperlinkClick(apiModel2);
        }
    }
}

