/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.logs.KubernetesFastLogProvider;
import com.intellij.kubernetes.logs.KubernetesLargeLogsEditorKt;
import com.intellij.kubernetes.logs.KubernetesLogEntryKt;
import com.intellij.kubernetes.logs.LogEditorModel;
import com.intellij.kubernetes.logs.LogLineEntry;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0013J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0080@\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001c\u0010\u001a\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0082@\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010\u001d\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0082@\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u001c\u0010 \u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0082@\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010!\u001a\u00020\u0013H\u0082@\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/kubernetes/logs/LogEditorModel;", "", "logProvider", "Lcom/intellij/kubernetes/logs/KubernetesFastLogProvider;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/kubernetes/logs/KubernetesFastLogProvider;Lcom/intellij/openapi/editor/ex/EditorEx;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/project/Project;)V", "linesPerPage", "", "lastLogs", "", "Lcom/intellij/kubernetes/logs/LogLineEntry;", "scrollEventsFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "startLogCollection", "handleNewLogsList", "newLogsList", "Lcom/intellij/kubernetes/logs/KubernetesFastLogProvider$ColoredLogContextListWithScrollingDirection;", "handleNewLogsList$intellij_clouds_kubernetes", "(Lcom/intellij/kubernetes/logs/KubernetesFastLogProvider$ColoredLogContextListWithScrollingDirection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replaceWholeLogs", "newLogs", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replaceLogAndScrollDown", "doScroll", "newY", "replaceLogsAndScrollUp", "onScrollEvent", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
public final class LogEditorModel {
    @NotNull
    private final KubernetesFastLogProvider logProvider;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Project project;
    private final int linesPerPage;
    @NotNull
    private List<LogLineEntry> lastLogs;
    @NotNull
    private final MutableSharedFlow<Unit> scrollEventsFlow;

    public LogEditorModel(@NotNull KubernetesFastLogProvider logProvider, @NotNull EditorEx editor, @NotNull CoroutineScope coroutineScope, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)logProvider, (String)"logProvider");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.logProvider = logProvider;
        this.editor = editor;
        this.coroutineScope = coroutineScope;
        this.project = project;
        this.linesPerPage = 50;
        this.lastLogs = CollectionsKt.emptyList();
        this.scrollEventsFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
    }

    public final void startLogCollection() {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LogEditorModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = LogEditorModel.access$getScrollEventsFlow$p(this.this$0).collect(new FlowCollector(this.this$0){
                            final /* synthetic */ LogEditorModel this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                Object object = LogEditorModel.access$onScrollEvent(this.this$0, $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.editor.getScrollingModel().addVisibleAreaListener(arg_0 -> LogEditorModel.startLogCollection$lambda$0(this, arg_0));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object handleNewLogsList$intellij_clouds_kubernetes(@NotNull KubernetesFastLogProvider.ColoredLogContextListWithScrollingDirection var1_1, @NotNull Continuation<? super Unit> $completion) {
        block12: {
            if (!($completion instanceof handleNewLogsList.1)) ** GOTO lbl-1000
            var8_3 = $completion;
            if ((var8_3.label & -2147483648) != 0) {
                var8_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ LogEditorModel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.handleNewLogsList$intellij_clouds_kubernetes(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    newLogs = newLogsList.getLogs();
                    if (!this.lastLogs.isEmpty() && !newLogs.isEmpty() && !newLogsList.getReplaceWholeList()) break;
                    $continuation.L$0 = this;
                    $continuation.L$1 = newLogs;
                    $continuation.label = 1;
                    v0 = this.replaceWholeLogs(newLogs, (Continuation<? super Unit>)$continuation);
                    if (v0 == var9_5) {
                        return var9_5;
                    }
                    ** GOTO lbl26
                }
                case 1: {
                    newLogs = (List<LogLineEntry>)$continuation.L$1;
                    this = (LogEditorModel)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    this.lastLogs = newLogs;
                    return Unit.INSTANCE;
                }
            }
            hadToScrollDown = newLogsList.getScrollDown();
            newFullyCovers = ((LogLineEntry)CollectionsKt.first(this.lastLogs)).getTimestamp$intellij_clouds_kubernetes().compareTo(((LogLineEntry)CollectionsKt.first(newLogs)).getTimestamp$intellij_clouds_kubernetes()) >= 0 && ((LogLineEntry)CollectionsKt.last(this.lastLogs)).getTimestamp$intellij_clouds_kubernetes().compareTo(((LogLineEntry)CollectionsKt.last(newLogs)).getTimestamp$intellij_clouds_kubernetes()) <= 0;
            v1 = isScrollDown = ((LogLineEntry)CollectionsKt.first(this.lastLogs)).getTimestamp$intellij_clouds_kubernetes().compareTo(((LogLineEntry)CollectionsKt.first(newLogs)).getTimestamp$intellij_clouds_kubernetes()) <= 0;
            if (!newFullyCovers && isScrollDown != hadToScrollDown) {
                KubernetesLargeLogsEditorKt.access$getLOG$p().warn("WARN: Old request comes");
                return Unit.INSTANCE;
            }
            if (!hadToScrollDown) break block12;
            $continuation.L$0 = this;
            $continuation.L$1 = newLogs;
            $continuation.label = 2;
            v2 = this.replaceLogAndScrollDown(newLogs, (Continuation<? super Unit>)$continuation);
            if (v2 == var9_5) {
                return var9_5;
            }
            ** GOTO lbl61
            {
                case 2: {
                    newLogs = (List)$continuation.L$1;
                    this = (LogEditorModel)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                    ** GOTO lbl61
                }
            }
        }
        $continuation.L$0 = this;
        $continuation.L$1 = newLogs;
        $continuation.label = 3;
        v3 = this.replaceLogsAndScrollUp(newLogs, (Continuation<? super Unit>)$continuation);
        if (v3 == var9_5) {
            return var9_5;
        }
        ** GOTO lbl61
        {
            case 3: {
                newLogs = (List)$continuation.L$1;
                this = (LogEditorModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl61:
                // 4 sources

                this.lastLogs = newLogs;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object replaceWholeLogs(List<LogLineEntry> newLogs, Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.edtWriteAction(() -> LogEditorModel.replaceWholeLogs$lambda$1(this, newLogs), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object replaceLogAndScrollDown(List<LogLineEntry> var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof replaceLogAndScrollDown.1)) ** GOTO lbl-1000
        var15_3 = $completion;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ LogEditorModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LogEditorModel.access$replaceLogAndScrollDown(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_6 = CollectionsKt.withIndex((Iterable)this.lastLogs);
                for (Object var8_9 : var6_6) {
                    it = (IndexedValue)var8_9;
                    $i$a$-find-LogEditorModel$replaceLogAndScrollDown$dropPrefixLinesSize$1 = false;
                    if (!Intrinsics.areEqual((Object)((LogLineEntry)it.getValue()).getOriginalLog(), (Object)((LogLineEntry)CollectionsKt.first((List)newLogs)).getOriginalLog())) continue;
                    v0 = var8_9;
                    ** GOTO lbl20
                }
                v0 = null;
lbl20:
                // 2 sources

                var4_14 = v0;
                dropPrefixLinesSize = var4_14 != null ? var4_14.getIndex() : this.lastLogs.size();
                dropTextOffset = new Ref.IntRef();
                dropTextOffset.element = this.editor.getDocument().getLineStartOffset(dropPrefixLinesSize);
                commonBodySize = new Ref.IntRef();
                var7_8 = CollectionsKt.withIndex((Iterable)CollectionsKt.drop((Iterable)this.lastLogs, (int)dropPrefixLinesSize));
                var13_17 = commonBodySize;
                var8_9 = var7_8;
                var9_11 = var8_9.iterator();
                while (var9_11.hasNext()) {
                    var10_13 = var9_11.next();
                    it = (IndexedValue)var10_13;
                    $i$a$-find-LogEditorModel$replaceLogAndScrollDown$commonBodySize$1 = false;
                    v1 = (LogLineEntry)CollectionsKt.getOrNull((List)newLogs, (int)it.getIndex());
                    if (!(Intrinsics.areEqual((Object)((LogLineEntry)it.getValue()).getOriginalLog(), (Object)(v1 != null ? v1.getOriginalLog() : null)) == false)) continue;
                    v2 = var10_13;
                    ** GOTO lbl38
                }
                v2 = null;
lbl38:
                // 2 sources

                var6_6 = v2;
                v3 = var13_17.element = var6_6 != null ? var6_6.getIndex() : this.lastLogs.size() - dropPrefixLinesSize;
                if (commonBodySize.element == 0) {
                    KubernetesLargeLogsEditorKt.access$getLOG$p().warn("Full logs replacement happens in scroll down");
                }
                commonOffsetInOldText = this.editor.getDocument().getLineStartOffset(dropPrefixLinesSize + commonBodySize.element);
                newTextForReplacement = commonBodySize.element == newLogs.size() ? "" : KubernetesLogEntryKt.joinToString(CollectionsKt.drop((Iterable)newLogs, (int)commonBodySize.element));
                $continuation.L$0 = this;
                $continuation.L$1 = newLogs;
                $continuation.L$2 = dropTextOffset;
                $continuation.L$3 = commonBodySize;
                $continuation.L$4 = newTextForReplacement;
                $continuation.I$0 = dropPrefixLinesSize;
                $continuation.I$1 = commonOffsetInOldText;
                $continuation.label = 1;
                v4 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(this, dropTextOffset, null){
                    int label;
                    final /* synthetic */ LogEditorModel this$0;
                    final /* synthetic */ Ref.IntRef $dropTextOffset;
                    {
                        this.this$0 = $receiver;
                        this.$dropTextOffset = $dropTextOffset;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                int oldY = LogEditorModel.access$getEditor$p(this.this$0).getScrollingModel().getVerticalScrollOffset();
                                Point point = LogEditorModel.access$getEditor$p(this.this$0).offsetToXY(this.$dropTextOffset.element);
                                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
                                Point gap = point;
                                int newY2 = oldY - gap.y;
                                return Boxing.boxInt((int)newY2);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v4 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl66
            }
            case 1: {
                commonOffsetInOldText = $continuation.I$1;
                dropPrefixLinesSize = $continuation.I$0;
                newTextForReplacement = (String)$continuation.L$4;
                commonBodySize = (Ref.IntRef)$continuation.L$3;
                dropTextOffset = (Ref.IntRef)$continuation.L$2;
                newLogs = (List)$continuation.L$1;
                this = (LogEditorModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl66:
                // 2 sources

                newY = ((Number)v4).intValue();
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.label = 2;
                v5 = CoroutinesKt.edtWriteAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, replaceLogAndScrollDown$lambda$5(com.intellij.kubernetes.logs.LogEditorModel int kotlin.jvm.internal.Ref$IntRef java.util.List kotlin.jvm.internal.Ref$IntRef int int java.lang.String ), ()Lkotlin/Unit;)((LogEditorModel)this, (int)dropPrefixLinesSize, (Ref.IntRef)commonBodySize, (List)newLogs, (Ref.IntRef)dropTextOffset, (int)commonOffsetInOldText, (int)newY, (String)newTextForReplacement), (Continuation)$continuation);
                if (v5 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl80
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl80:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void doScroll(int newY2) {
        ScrollingModelEx scrollingModelEx = this.editor.getScrollingModel();
        ScrollingModelImpl scrollingModelImpl = scrollingModelEx instanceof ScrollingModelImpl ? (ScrollingModelImpl)scrollingModelEx : null;
        boolean isAnimationEnabled = !(scrollingModelImpl != null ? !scrollingModelImpl.isAnimationEnabled() : false);
        this.editor.getScrollingModel().disableAnimation();
        this.editor.getScrollingModel().scrollVertically(newY2);
        if (isAnimationEnabled) {
            this.editor.getScrollingModel().enableAnimation();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object replaceLogsAndScrollUp(List<LogLineEntry> var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof replaceLogsAndScrollUp.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                final /* synthetic */ LogEditorModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LogEditorModel.access$replaceLogsAndScrollUp(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_6 = CollectionsKt.withIndex((Iterable)newLogs);
                for (Object var8_9 : var6_6) {
                    it /* !! */  = (IndexedValue)var8_9;
                    $i$a$-find-LogEditorModel$replaceLogsAndScrollUp$newPrefixSize$1 = false;
                    if (!Intrinsics.areEqual((Object)((LogLineEntry)it /* !! */ .getValue()).getOriginalLog(), (Object)((LogLineEntry)CollectionsKt.first(this.lastLogs)).getOriginalLog())) continue;
                    v0 = var8_9;
                    ** GOTO lbl20
                }
                v0 = null;
lbl20:
                // 2 sources

                var4_14 = v0;
                newPrefixSize = var4_14 != null ? var4_14.getIndex() : this.lastLogs.size();
                var7_7 = CollectionsKt.withIndex((Iterable)CollectionsKt.drop((Iterable)newLogs, (int)newPrefixSize));
                var8_9 = var7_7.iterator();
                while (var8_9.hasNext()) {
                    it /* !! */  = it /* !! */  = var8_9.next();
                    $i$a$-find-LogEditorModel$replaceLogsAndScrollUp$commonBodySize$1 = false;
                    v1 = (LogLineEntry)CollectionsKt.getOrNull(this.lastLogs, (int)it /* !! */ .getIndex());
                    if (!(Intrinsics.areEqual((Object)((LogLineEntry)it /* !! */ .getValue()).getOriginalLog(), (Object)(v1 != null ? v1.getOriginalLog() : null)) == false)) continue;
                    v2 /* !! */  = it /* !! */ ;
                    ** GOTO lbl32
                }
                v2 /* !! */  = null;
lbl32:
                // 2 sources

                var5_18 = v2 /* !! */ ;
                v3 = commonBodySize = var5_18 != null ? var5_18.getIndex() : newLogs.size() - newPrefixSize;
                if (commonBodySize == 0) {
                    KubernetesLargeLogsEditorKt.access$getLOG$p().warn("Full logs replacement happens in scroll up");
                }
                newPrefixText = newPrefixSize == 0 ? "" : KubernetesLogEntryKt.joinToString(CollectionsKt.take((Iterable)newLogs, (int)newPrefixSize));
                newTail = newPrefixSize + commonBodySize != newLogs.size() ? KubernetesLogEntryKt.joinToString(CollectionsKt.drop((Iterable)newLogs, (int)(newPrefixSize + commonBodySize))) : "";
                if (((CharSequence)newTail).length() > 0) {
                    KubernetesLargeLogsEditorKt.access$getLOG$p().warn("new tail size " + newTail.length());
                }
                commonOffset = commonBodySize + 1 == this.editor.getDocument().getLineCount() ? this.editor.getDocument().getTextLength() : this.editor.getDocument().getLineStartOffset(commonBodySize);
                commonOffsetInNewText = commonOffset + newPrefixText.length();
                $continuation.L$0 = this;
                $continuation.L$1 = newLogs;
                $continuation.L$2 = newPrefixText;
                $continuation.L$3 = newTail;
                $continuation.I$0 = newPrefixSize;
                $continuation.I$1 = commonBodySize;
                $continuation.I$2 = commonOffsetInNewText;
                $continuation.label = 1;
                v4 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, null){
                    int label;
                    final /* synthetic */ LogEditorModel this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return LogEditorModel.access$getEditor$p(this.this$0).getDocument().getText();
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v4 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl64
            }
            case 1: {
                commonOffsetInNewText = $continuation.I$2;
                commonBodySize = $continuation.I$1;
                newPrefixSize = $continuation.I$0;
                newTail = (String)$continuation.L$3;
                newPrefixText = (String)$continuation.L$2;
                newLogs = (List)$continuation.L$1;
                this = (LogEditorModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl64:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"withContext(...)");
                textSnapshot = (String)v4;
                $continuation.L$0 = this;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.I$0 = newPrefixSize;
                $continuation.label = 2;
                v5 = CoroutinesKt.edtWriteAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, replaceLogsAndScrollUp$lambda$9(com.intellij.kubernetes.logs.LogEditorModel int java.util.List java.lang.String java.lang.String java.lang.String int int ), ()Lkotlin/Unit;)((LogEditorModel)this, (int)commonBodySize, (List)newLogs, (String)textSnapshot, (String)newPrefixText, (String)newTail, (int)commonOffsetInNewText, (int)newPrefixSize), (Continuation)$continuation);
                if (v5 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl81
            }
            case 2: {
                newPrefixSize = $continuation.I$0;
                this = (LogEditorModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl81:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.label = 3;
                v6 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, newPrefixSize, null){
                    int label;
                    final /* synthetic */ LogEditorModel this$0;
                    final /* synthetic */ int $newPrefixSize;
                    {
                        this.this$0 = $receiver;
                        this.$newPrefixSize = $newPrefixSize;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                int oldY = LogEditorModel.access$getEditor$p(this.this$0).getScrollingModel().getVerticalScrollOffset();
                                int newPrefixOffset = LogEditorModel.access$getEditor$p(this.this$0).getDocument().getLineStartOffset(this.$newPrefixSize);
                                int gapY = LogEditorModel.access$getEditor$p((LogEditorModel)this.this$0).offsetToXY((int)newPrefixOffset).y;
                                int newY2 = oldY + gapY;
                                LogEditorModel.access$doScroll(this.this$0, newY2);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v6 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl90
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl90:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object onScrollEvent(Continuation<? super Unit> $completion) {
        if (!($completion instanceof onScrollEvent.1)) ** GOTO lbl-1000
        var12_2 = $completion;
        if ((var12_2.label & -2147483648) != 0) {
            var12_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ LogEditorModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LogEditorModel.access$onScrollEvent(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                visibleStartPosition = new Ref.ObjectRef();
                visibleEndPosition = new Ref.ObjectRef();
                linesInEditor = new Ref.IntRef();
                $continuation.L$0 = this;
                $continuation.L$1 = visibleStartPosition;
                $continuation.L$2 = visibleEndPosition;
                $continuation.L$3 = linesInEditor;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(linesInEditor, this, (Ref.ObjectRef<LogicalPosition>)visibleStartPosition, (Ref.ObjectRef<LogicalPosition>)visibleEndPosition, null){
                    int label;
                    final /* synthetic */ Ref.IntRef $linesInEditor;
                    final /* synthetic */ LogEditorModel this$0;
                    final /* synthetic */ Ref.ObjectRef<LogicalPosition> $visibleStartPosition;
                    final /* synthetic */ Ref.ObjectRef<LogicalPosition> $visibleEndPosition;
                    {
                        this.$linesInEditor = $linesInEditor;
                        this.this$0 = $receiver;
                        this.$visibleStartPosition = $visibleStartPosition;
                        this.$visibleEndPosition = $visibleEndPosition;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.$linesInEditor.element = LogEditorModel.access$getEditor$p(this.this$0).getDocument().getLineCount();
                                Rectangle rectangle = LogEditorModel.access$getEditor$p(this.this$0).getScrollingModel().getVisibleArea();
                                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
                                Rectangle visibleArea = rectangle;
                                this.$visibleStartPosition.element = LogEditorModel.access$getEditor$p(this.this$0).xyToLogicalPosition(visibleArea.getLocation());
                                this.$visibleEndPosition.element = LogEditorModel.access$getEditor$p(this.this$0).xyToLogicalPosition(new Point(visibleArea.x + visibleArea.width, visibleArea.y + visibleArea.height));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var13_4) {
                    return var13_4;
                }
                ** GOTO lbl31
            }
            case 1: {
                linesInEditor = (Ref.IntRef)$continuation.L$3;
                visibleEndPosition = (Ref.ObjectRef)$continuation.L$2;
                visibleStartPosition = (Ref.ObjectRef)$continuation.L$1;
                this = (LogEditorModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 2 sources

                visibleStartLine = ((LogicalPosition)visibleStartPosition.element).line;
                visibleEndLine = ((LogicalPosition)visibleEndPosition.element).line;
                middlePageStartLine = this.linesPerPage * 2;
                middlePageEndLine = this.linesPerPage * 4 - 1;
                bufferLines = this.linesPerPage;
                if (visibleEndLine >= linesInEditor.element) {
                    v1 = (LogLineEntry)CollectionsKt.lastOrNull(this.lastLogs);
                    if (v1 == null || (v1 = v1.getTimestamp$intellij_clouds_kubernetes()) == null) {
                        v1 = Instant.now();
                    }
                    var10_13 = v1;
                    Intrinsics.checkNotNull((Object)var10_13);
                    this.logProvider.startStreamingLogs((Instant)var10_13);
                } else if (visibleStartLine < middlePageStartLine - bufferLines) {
                    this.logProvider.stopStreamingLogs();
                    v2 = (LogLineEntry)CollectionsKt.firstOrNull(this.lastLogs);
                    if (v2 == null || (v2 = v2.getTimestamp$intellij_clouds_kubernetes()) == null) {
                        v2 = Instant.now();
                    }
                    timestamp = v2;
                    Intrinsics.checkNotNull((Object)timestamp);
                    this.logProvider.scrollNLogsUpRequest((Instant)timestamp);
                } else if (visibleEndLine >= middlePageEndLine + bufferLines) {
                    this.logProvider.stopStreamingLogs();
                    v3 = (LogLineEntry)CollectionsKt.lastOrNull(this.lastLogs);
                    if (v3 == null || (v3 = v3.getTimestamp$intellij_clouds_kubernetes()) == null) {
                        v3 = Instant.now();
                    }
                    timestamp = v3;
                    Intrinsics.checkNotNull((Object)timestamp);
                    this.logProvider.scrollNLogsDownRequest((Instant)timestamp);
                } else {
                    this.logProvider.stopStreamingLogs();
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void startLogCollection$lambda$0(LogEditorModel this$0, VisibleAreaEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.scrollEventsFlow.tryEmit((Object)Unit.INSTANCE);
    }

    private static final Unit replaceWholeLogs$lambda$1(LogEditorModel this$0, List $newLogs) {
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)((Document)this$0.editor.getDocument()), (Project)this$0.project, (boolean)false);
        KubernetesLogEntryKt.disposeHighlighting(this$0.lastLogs);
        this$0.editor.getDocument().setText((CharSequence)KubernetesLogEntryKt.joinToString($newLogs));
        Iterator iterator = ((Iterable)$newLogs).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int lineIndex = n++;
            LogLineEntry logLine = (LogLineEntry)iterator.next();
            Intrinsics.checkNotNull((Object)markupModel);
            KubernetesLargeLogsEditorKt.colorLogLine(lineIndex, logLine, markupModel, this$0.editor);
        }
        return Unit.INSTANCE;
    }

    private static final void replaceLogAndScrollDown$lambda$5$lambda$4(LogEditorModel this$0, int $commonOffsetInOldText, String $newTextForReplacement, Ref.IntRef $dropTextOffset) {
        this$0.editor.getDocument().replaceString($commonOffsetInOldText, this$0.editor.getDocument().getTextLength(), (CharSequence)$newTextForReplacement);
        this$0.editor.getDocument().deleteString(0, $dropTextOffset.element);
    }

    private static final Unit replaceLogAndScrollDown$lambda$5(LogEditorModel this$0, int $dropPrefixLinesSize, Ref.IntRef $commonBodySize, List $newLogs, Ref.IntRef $dropTextOffset, int $commonOffsetInOldText, int $newY, String $newTextForReplacement) {
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)((Document)this$0.editor.getDocument()), (Project)this$0.project, (boolean)false);
        String string = this$0.editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String textSnapshot2 = string;
        KubernetesLogEntryKt.disposeHighlighting(CollectionsKt.drop((Iterable)this$0.lastLogs, (int)($dropPrefixLinesSize + $commonBodySize.element)));
        KubernetesLogEntryKt.disposeHighlighting(CollectionsKt.take((Iterable)$newLogs, (int)$dropPrefixLinesSize));
        CommandProcessor.getInstance().executeCommand(this$0.project, () -> LogEditorModel.replaceLogAndScrollDown$lambda$5$lambda$4(this$0, $commonOffsetInOldText, $newTextForReplacement, $dropTextOffset), "LogTextReplacement", (Object)UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION);
        if (!Intrinsics.areEqual((Object)this$0.editor.getDocument().getText(), (Object)KubernetesLogEntryKt.joinToString($newLogs))) {
            KubernetesLargeLogsEditorKt.access$getLOG$p().error("editor.document.text != newLogs, snapshot len: " + textSnapshot2.length() + " new doc len: " + this$0.editor.getDocument().getTextLength() + " logs text len: " + KubernetesLogEntryKt.joinToString($newLogs).length() + " drop off: " + $dropTextOffset.element + " common off in old text: " + $commonOffsetInOldText);
        }
        for (IndexedValue indexedValue : CollectionsKt.drop((Iterable)CollectionsKt.withIndex((Iterable)$newLogs), (int)$commonBodySize.element)) {
            int lineIndex = indexedValue.component1();
            LogLineEntry logLine = (LogLineEntry)indexedValue.component2();
            Intrinsics.checkNotNull((Object)markupModel);
            KubernetesLargeLogsEditorKt.colorLogLine(lineIndex, logLine, markupModel, this$0.editor);
        }
        if (this$0.logProvider.getCurrentStreamingJob$intellij_clouds_kubernetes().get() != null) {
            return Unit.INSTANCE;
        }
        this$0.doScroll($newY);
        return Unit.INSTANCE;
    }

    private static final void replaceLogsAndScrollUp$lambda$9$lambda$8(LogEditorModel this$0, String $newPrefixText, int $commonOffsetInNewText, String $newTail) {
        this$0.editor.getDocument().insertString(0, (CharSequence)$newPrefixText);
        this$0.editor.getDocument().replaceString($commonOffsetInNewText, this$0.editor.getDocument().getTextLength(), (CharSequence)$newTail);
    }

    private static final Unit replaceLogsAndScrollUp$lambda$9(LogEditorModel this$0, int $commonBodySize, List $newLogs, String $textSnapshot, String $newPrefixText, String $newTail, int $commonOffsetInNewText, int $newPrefixSize) {
        LogLineEntry logLine;
        int lineIndex;
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)((Document)this$0.editor.getDocument()), (Project)this$0.project, (boolean)false);
        KubernetesLogEntryKt.disposeHighlighting(CollectionsKt.drop((Iterable)this$0.lastLogs, (int)$commonBodySize));
        CommandProcessor.getInstance().executeCommand(this$0.project, () -> LogEditorModel.replaceLogsAndScrollUp$lambda$9$lambda$8(this$0, $newPrefixText, $commonOffsetInNewText, $newTail), "LogTextReplacement", (Object)UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION);
        if (!Intrinsics.areEqual((Object)this$0.editor.getDocument().getText(), (Object)KubernetesLogEntryKt.joinToString($newLogs))) {
            KubernetesLargeLogsEditorKt.access$getLOG$p().error("editor.document.text != newLogs, snapshot len: " + $textSnapshot.length() + " new doc len: " + this$0.editor.getDocument().getTextLength() + " logs text len: " + KubernetesLogEntryKt.joinToString($newLogs).length() + " newPrefixText len: " + $newPrefixText.length() + " newTail len: " + $newTail.length() + " common off: " + $commonOffsetInNewText);
        }
        for (IndexedValue indexedValue : CollectionsKt.take((Iterable)CollectionsKt.withIndex((Iterable)$newLogs), (int)$newPrefixSize)) {
            lineIndex = indexedValue.component1();
            logLine = (LogLineEntry)indexedValue.component2();
            Intrinsics.checkNotNull((Object)markupModel);
            KubernetesLargeLogsEditorKt.colorLogLine(lineIndex, logLine, markupModel, this$0.editor);
        }
        for (IndexedValue indexedValue : CollectionsKt.drop((Iterable)CollectionsKt.withIndex((Iterable)$newLogs), (int)($newPrefixSize + $commonBodySize))) {
            lineIndex = indexedValue.component1();
            logLine = (LogLineEntry)indexedValue.component2();
            Intrinsics.checkNotNull((Object)markupModel);
            KubernetesLargeLogsEditorKt.colorLogLine(lineIndex, logLine, markupModel, this$0.editor);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MutableSharedFlow access$getScrollEventsFlow$p(LogEditorModel $this) {
        return $this.scrollEventsFlow;
    }

    public static final /* synthetic */ Object access$onScrollEvent(LogEditorModel $this, Continuation $completion) {
        return $this.onScrollEvent((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$replaceWholeLogs(LogEditorModel $this, List newLogs, Continuation $completion) {
        return $this.replaceWholeLogs(newLogs, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$replaceLogAndScrollDown(LogEditorModel $this, List newLogs, Continuation $completion) {
        return $this.replaceLogAndScrollDown(newLogs, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ EditorEx access$getEditor$p(LogEditorModel $this) {
        return $this.editor;
    }

    public static final /* synthetic */ Object access$replaceLogsAndScrollUp(LogEditorModel $this, List newLogs, Continuation $completion) {
        return $this.replaceLogsAndScrollUp(newLogs, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$doScroll(LogEditorModel $this, int newY2) {
        $this.doScroll(newY2);
    }
}

