/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.logs.KubernetesContextLog;
import com.intellij.kubernetes.logs.LogEntry;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J-\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/intellij/kubernetes/logs/LogLineEntry;", "", "lineIndex", "", "logEntries", "", "Lcom/intellij/kubernetes/logs/LogEntry;", "originalLog", "Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "<init>", "(ILjava/util/List;Lcom/intellij/kubernetes/logs/KubernetesContextLog;)V", "getLineIndex", "()I", "getLogEntries", "()Ljava/util/List;", "getOriginalLog", "()Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "timestamp", "Ljava/time/Instant;", "getTimestamp$intellij_clouds_kubernetes", "()Ljava/time/Instant;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.clouds.kubernetes"})
public final class LogLineEntry {
    private final int lineIndex;
    @NotNull
    private final List<LogEntry> logEntries;
    @NotNull
    private final KubernetesContextLog originalLog;

    public LogLineEntry(int lineIndex, @NotNull List<LogEntry> logEntries, @NotNull KubernetesContextLog originalLog) {
        Intrinsics.checkNotNullParameter(logEntries, (String)"logEntries");
        Intrinsics.checkNotNullParameter((Object)originalLog, (String)"originalLog");
        this.lineIndex = lineIndex;
        this.logEntries = logEntries;
        this.originalLog = originalLog;
    }

    public final int getLineIndex() {
        return this.lineIndex;
    }

    @NotNull
    public final List<LogEntry> getLogEntries() {
        return this.logEntries;
    }

    @NotNull
    public final KubernetesContextLog getOriginalLog() {
        return this.originalLog;
    }

    @NotNull
    public final Instant getTimestamp$intellij_clouds_kubernetes() {
        return this.originalLog.getTimestamp();
    }

    public final int component1() {
        return this.lineIndex;
    }

    @NotNull
    public final List<LogEntry> component2() {
        return this.logEntries;
    }

    @NotNull
    public final KubernetesContextLog component3() {
        return this.originalLog;
    }

    @NotNull
    public final LogLineEntry copy(int lineIndex, @NotNull List<LogEntry> logEntries, @NotNull KubernetesContextLog originalLog) {
        Intrinsics.checkNotNullParameter(logEntries, (String)"logEntries");
        Intrinsics.checkNotNullParameter((Object)originalLog, (String)"originalLog");
        return new LogLineEntry(lineIndex, logEntries, originalLog);
    }

    public static /* synthetic */ LogLineEntry copy$default(LogLineEntry logLineEntry, int n, List list2, KubernetesContextLog kubernetesContextLog, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = logLineEntry.lineIndex;
        }
        if ((n2 & 2) != 0) {
            list2 = logLineEntry.logEntries;
        }
        if ((n2 & 4) != 0) {
            kubernetesContextLog = logLineEntry.originalLog;
        }
        return logLineEntry.copy(n, list2, kubernetesContextLog);
    }

    @NotNull
    public String toString() {
        return "LogLineEntry(lineIndex=" + this.lineIndex + ", logEntries=" + this.logEntries + ", originalLog=" + this.originalLog + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.lineIndex);
        result2 = result2 * 31 + ((Object)this.logEntries).hashCode();
        result2 = result2 * 31 + this.originalLog.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LogLineEntry)) {
            return false;
        }
        LogLineEntry logLineEntry = (LogLineEntry)other;
        if (this.lineIndex != logLineEntry.lineIndex) {
            return false;
        }
        if (!Intrinsics.areEqual(this.logEntries, logLineEntry.logEntries)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.originalLog, (Object)logLineEntry.originalLog);
    }
}

