/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.logs.ILogSubscribableConsistentCache;
import com.intellij.kubernetes.logs.KubernetesContextLog;
import com.intellij.kubernetes.logs.LogConsistentCache;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0001H\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\u0017\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0096\u0002R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00010\u00010\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kubernetes/logs/LogSubscribableConsistentCache;", "Lcom/intellij/kubernetes/logs/LogConsistentCache;", "Lcom/intellij/kubernetes/logs/ILogSubscribableConsistentCache;", "<init>", "()V", "subscribers", "Lcom/intellij/util/containers/ConcurrentList;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addSubscriber", "", "anotherCache", "removeSubscriber", "subscriber", "clear", "plusAssign", "newLogs", "", "Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "intellij.clouds.kubernetes"})
public class LogSubscribableConsistentCache
extends LogConsistentCache
implements ILogSubscribableConsistentCache {
    @NotNull
    private final ConcurrentList<LogConsistentCache> subscribers;

    public LogSubscribableConsistentCache() {
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.subscribers = concurrentList;
    }

    @Override
    public void addSubscriber(@NotNull LogConsistentCache anotherCache) {
        Intrinsics.checkNotNullParameter((Object)anotherCache, (String)"anotherCache");
        this.subscribers.add((Object)anotherCache);
        anotherCache.plusAssign((Collection<? extends KubernetesContextLog>)this.getLogsCache());
    }

    @Override
    public void removeSubscriber(@NotNull LogConsistentCache subscriber) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        this.subscribers.remove((Object)subscriber);
    }

    @Override
    public void clear() {
        super.clear();
        for (LogConsistentCache cache : this.subscribers) {
            cache.clear();
        }
    }

    @Override
    public void plusAssign(@NotNull Collection<? extends KubernetesContextLog> newLogs) {
        Intrinsics.checkNotNullParameter(newLogs, (String)"newLogs");
        super.plusAssign(newLogs);
        for (LogConsistentCache cache : this.subscribers) {
            cache.plusAssign(newLogs);
        }
    }
}

