/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.GenericFileReferenceType;
import com.intellij.kubernetes.model.SchemaSpecInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kubernetes/model/KustomizeJsonPatchReferenceType;", "Lcom/intellij/kubernetes/model/GenericFileReferenceType;", "typeName", "", "specInfo", "Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "<init>", "(Ljava/lang/String;Lcom/intellij/kubernetes/model/SchemaSpecInfo;)V", "getFileFilter", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/psi/PsiFileSystemItem;", "element", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "validateScalarValue", "", "scalarValue", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKustomizeDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KustomizeDefinitions.kt\ncom/intellij/kubernetes/model/KustomizeJsonPatchReferenceType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n1#2:273\n*E\n"})
public final class KustomizeJsonPatchReferenceType
extends GenericFileReferenceType {
    public KustomizeJsonPatchReferenceType(@NotNull String typeName, @Nullable SchemaSpecInfo specInfo) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        super(typeName, specInfo);
    }

    @Override
    @NotNull
    protected Condition<PsiFileSystemItem> getFileFilter(@NotNull YAMLScalar element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KustomizeJsonPatchReferenceType::getFileFilter$lambda$0;
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        PsiFile targetFile;
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        VirtualFile virtualFile3 = YamlUtilKt.getVfsFile((PsiElement)scalarValue);
        if (virtualFile3 != null && (virtualFile2 = virtualFile3.getParent()) != null && (virtualFile = virtualFile2.findFileByRelativePath(YamlUtilKt.getEffectiveText((YAMLValue)scalarValue))) != null) {
            VirtualFile virtualFile4 = virtualFile;
            PsiManager psiManager = PsiManager.getInstance((Project)scalarValue.getProject());
            VirtualFile p0 = virtualFile4;
            boolean bl = false;
            v0 = psiManager.findFile(p0);
        } else {
            v0 = targetFile = null;
        }
        if (!KubernetesUtilKt.isJsonOrNonK8sFile(targetFile)) {
            holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message("KubernetesModelDefinition.json.file.expected.error", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static final boolean getFileFilter$lambda$0(PsiFileSystemItem it) {
        return it instanceof PsiDirectory || KubernetesUtilKt.isJsonOrNonK8sFile(it instanceof PsiFile ? (PsiFile)it : null);
    }
}

