/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.references;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.kubernetes.KubernetesLabelUtilKt;
import com.intellij.kubernetes.KubernetesResolver;
import com.intellij.kubernetes.references.KubernetesLabelValueFindUsagesHandlerFactory;
import com.intellij.kubernetes.references.LabelValueReference;
import com.intellij.kubernetes.references.LabelValueSelfReference;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/references/KubernetesLabelValueFindUsagesHandlerFactory;", "Lcom/intellij/find/findUsages/FindUsagesHandlerFactory;", "<init>", "()V", "canFindUsages", "", "element", "Lcom/intellij/psi/PsiElement;", "createFindUsagesHandler", "Lcom/intellij/find/findUsages/FindUsagesHandler;", "forHighlightUsages", "intellij.clouds.kubernetes"})
public final class KubernetesLabelValueFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof YAMLScalar)) {
            return false;
        }
        return KubernetesLabelUtilKt.getObjectLabel(element) != null;
    }

    @Nullable
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!this.canFindUsages(element)) {
            return null;
        }
        return new FindUsagesHandler(element){
            private final KubernetesResolver resolver;
            final /* synthetic */ PsiElement $element;
            {
                this.$element = $element;
                super($element);
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<KubernetesResolver> serviceClass$iv = KubernetesResolver.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                this.resolver = (KubernetesResolver)object;
            }

            public final KubernetesResolver getResolver() {
                return this.resolver;
            }

            /*
             * WARNING - void declaration
             */
            public PsiElement[] getSecondaryElements() {
                void $this$toTypedArray$iv;
                void $this$filterTo$iv$iv;
                Collection $this$filter$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Pair<String, String> pair = KubernetesLabelUtilKt.getObjectLabel(this.$element);
                if (pair == null) {
                    return new PsiElement[0];
                }
                Pair<String, String> pair2 = pair;
                String name = (String)pair2.component1();
                String value2 = (String)pair2.component2();
                Iterable iterable = this.resolver.findTargetLabelDeclarationsForUsages(this.$element, name, value2);
                boolean $i$f$mapNotNull22 = false;
                void var6_8 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    YAMLValue it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    YAMLKeyValue it = (YAMLKeyValue)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getValue() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                PsiElement $i$f$mapNotNull22 = this.$element;
                boolean $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    YAMLValue it = (YAMLValue)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)$i$f$mapNotNull22))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new PsiElement[0]);
            }

            public boolean processElementUsages(PsiElement element, Processor<? super UsageInfo> processor, FindUsagesOptions options) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter(processor, (String)"processor");
                Intrinsics.checkNotNullParameter((Object)options, (String)"options");
                if (!Intrinsics.areEqual((Object)element, (Object)this.getPsiElement())) {
                    return true;
                }
                Object object = ReadAction.compute(() -> createFindUsagesHandler.1.processElementUsages$lambda$3(element, this, options, processor));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
                return (Boolean)object;
            }

            /*
             * WARNING - void declaration
             */
            public Collection<PsiReference> findReferencesToHighlight(PsiElement target, SearchScope searchScope) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
                if (!(target instanceof YAMLScalar)) {
                    List<T> list2 = Collections.emptyList();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyList(...)");
                    return list2;
                }
                Pair<String, String> pair = KubernetesLabelUtilKt.getObjectLabel(target);
                if (pair == null) {
                    List<T> list3 = Collections.emptyList();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"emptyList(...)");
                    return list3;
                }
                Pair<String, String> pair2 = pair;
                String name = (String)pair2.component1();
                String value2 = (String)pair2.component2();
                Iterable iterable = this.resolver.findLabelReferrers(searchScope, target, name, value2);
                boolean $i$f$mapNotNull = false;
                void var8_8 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    LabelValueReference labelValueReference;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    YAMLKeyValue it = (YAMLKeyValue)element$iv$iv;
                    boolean bl2 = false;
                    YAMLValue yAMLValue = it.getValue();
                    if ((yAMLValue instanceof YAMLScalar ? (YAMLScalar)yAMLValue : null) != null) {
                        YAMLScalar scalarValue;
                        scalarValue = scalarValue;
                        boolean bl3 = false;
                        labelValueReference = new LabelValueReference(scalarValue);
                    } else {
                        labelValueReference = null;
                    }
                    if (labelValueReference == null) continue;
                    LabelValueReference it$iv$iv = labelValueReference;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return CollectionsKt.toMutableList((Collection)CollectionsKt.union((Iterable)((List)destination$iv$iv), (Iterable)CollectionsKt.listOfNotNull(((YAMLScalar)target).getContainingFile() != null && searchScope.contains(((YAMLScalar)target).getContainingFile().getVirtualFile()) ? new LabelValueSelfReference((YAMLScalar)target) : null)));
            }

            protected boolean isSearchForTextOccurrencesAvailable(PsiElement psiElement, boolean isSingleFile) {
                Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
                return false;
            }

            /*
             * WARNING - void declaration
             */
            private static final Boolean processElementUsages$lambda$3(PsiElement $element, createFindUsagesHandler.1 this$0, FindUsagesOptions $options, Processor $processor) {
                void $this$forEach$iv;
                Pair<String, String> pair = KubernetesLabelUtilKt.getObjectLabel($element);
                if (pair == null) {
                    return true;
                }
                Pair<String, String> pair2 = pair;
                String name = (String)pair2.component1();
                String value2 = (String)pair2.component2();
                KubernetesResolver kubernetesResolver = this$0.resolver;
                SearchScope searchScope = $options.searchScope;
                Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"searchScope");
                Iterable iterable = kubernetesResolver.findLabelReferrers(searchScope, $element, name, value2);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    YAMLScalar valueElem;
                    YAMLKeyValue it = (YAMLKeyValue)element$iv;
                    boolean bl = false;
                    YAMLValue yAMLValue = it.getValue();
                    YAMLScalar yAMLScalar = yAMLValue instanceof YAMLScalar ? (YAMLScalar)yAMLValue : null;
                    if (yAMLScalar == null || $processor.process((Object)new UsageInfo((PsiElement)(valueElem = yAMLScalar)))) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

