/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.HelmDependencyRepository;
import com.intellij.kubernetes.helm.HelmUtilKt;
import com.intellij.kubernetes.helm.RemoteHelmDependencyRepository;
import com.intellij.kubernetes.helm.model.RepositoryMetaClass;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H&\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kubernetes/ui/intentions/HelmDependencyRepositoryIntentionActionBase;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "flags", "", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailableFor", "repo", "Lcom/intellij/kubernetes/helm/RemoteHelmDependencyRepository;", "intellij.clouds.kubernetes"})
public abstract class HelmDependencyRepositoryIntentionActionBase
extends PsiElementBaseIntentionAction
implements Iconable {
    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = KubernetesIcons.Helm;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Helm");
        return icon;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        YamlMetaTypeProvider yamlMetaTypeProvider = HelmUtilKt.getHelmMetaTypeProvider(psiFile);
        if (yamlMetaTypeProvider == null) {
            return false;
        }
        YamlMetaTypeProvider metaTypeProvider = yamlMetaTypeProvider;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = metaTypeProvider.getMetaTypeProxy(element);
        if (metaTypeProxy == null) {
            return false;
        }
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy2 = metaTypeProxy;
        if (!(metaTypeProxy2.getMetaType() instanceof RepositoryMetaClass)) {
            return false;
        }
        YAMLValue yAMLValue = metaTypeProvider.getMetaOwner(element);
        RemoteHelmDependencyRepository remoteHelmDependencyRepository = HelmDependencyRepository.Companion.getRemote(project, yAMLValue != null ? YamlUtilKt.getEffectiveText(yAMLValue) : null);
        if (remoteHelmDependencyRepository == null) {
            return false;
        }
        RemoteHelmDependencyRepository repo = remoteHelmDependencyRepository;
        return this.isAvailableFor(project, repo);
    }

    public abstract boolean isAvailableFor(@NotNull Project var1, @NotNull RemoteHelmDependencyRepository var2);
}

