/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes.configuration;

import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.nodes.KubernetesKeyValueServiceViewDescriptor;
import com.intellij.kubernetes.view.nodes.KubernetesNamespacedKeyValueResourceServiceViewContributor;
import com.intellij.kubernetes.view.nodes.configuration.KubernetesSecretKeyValueServiceViewDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Secret;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B1\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0014R\u001e\u0010\r\u001a\u00120\u000eR\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0016*\u00020\u00028TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lcom/intellij/kubernetes/view/nodes/configuration/KubernetesSecretServiceViewContributor;", "Lcom/intellij/kubernetes/view/nodes/KubernetesNamespacedKeyValueResourceServiceViewContributor;", "Lio/kubernetes/client/openapi/models/V1Secret;", "", "resource", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "parentCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "<init>", "(Lio/kubernetes/client/openapi/models/V1Secret;Lcom/intellij/kubernetes/api/KubernetesApiModel;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;)V", "descriptor", "Lcom/intellij/kubernetes/view/nodes/KubernetesNamespacedKeyValueResourceServiceViewContributor$KubernetesNamespacedKeyValueResourceServiceViewDescriptor;", "createCustomActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "getViewDescriptor", "Lcom/intellij/execution/services/ServiceViewDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "dataMap", "", "", "getDataMap", "(Lio/kubernetes/client/openapi/models/V1Secret;)Ljava/util/Map;", "createService", "Lcom/intellij/kubernetes/view/nodes/KubernetesKeyValueServiceViewDescriptor;", "key", "value", "intellij.clouds.kubernetes"})
public final class KubernetesSecretServiceViewContributor
extends KubernetesNamespacedKeyValueResourceServiceViewContributor<V1Secret, byte[]> {
    @NotNull
    private final KubernetesNamespacedKeyValueResourceServiceViewContributor.KubernetesNamespacedKeyValueResourceServiceViewDescriptor descriptor;

    public KubernetesSecretServiceViewContributor(@NotNull V1Secret resource, @NotNull KubernetesApiModel apiModel2, @NotNull CoroutineScope parentCoroutineScope, @NotNull KubernetesResourceMapper<V1Secret, ?> mapper) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentCoroutineScope, (String)"parentCoroutineScope");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        super((KubernetesObject)resource, apiModel2, parentCoroutineScope, mapper);
        KubernetesNamespacedKeyValueResourceServiceViewContributor kubernetesNamespacedKeyValueResourceServiceViewContributor = this;
        V1ObjectMeta v1ObjectMeta = resource.getMetadata();
        Intrinsics.checkNotNull((Object)v1ObjectMeta);
        String string = v1ObjectMeta.getName();
        Intrinsics.checkNotNull((Object)string);
        this.descriptor = kubernetesNamespacedKeyValueResourceServiceViewContributor.new KubernetesNamespacedKeyValueResourceServiceViewContributor.KubernetesNamespacedKeyValueResourceServiceViewDescriptor(string, AllIcons.Ide.Readonly);
    }

    @Override
    @NotNull
    protected DefaultActionGroup createCustomActions() {
        AnAction[] anActionArray = new AnAction[]{ActionManager.getInstance().getAction("Kubernetes.EditSecret"), Separator.create()};
        return new DefaultActionGroup(anActionArray);
    }

    @Override
    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ServiceViewDescriptor)this.descriptor;
    }

    @Override
    @Nullable
    protected Map<String, byte[]> getDataMap(@NotNull V1Secret $this$dataMap) {
        Intrinsics.checkNotNullParameter((Object)$this$dataMap, (String)"<this>");
        return $this$dataMap.getData();
    }

    @Override
    @NotNull
    protected KubernetesKeyValueServiceViewDescriptor<V1Secret> createService(@NotNull String key, @Nullable byte[] value2) {
        String string;
        Object it;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value2 != null) {
            String string2;
            it = value2;
            boolean bl = false;
            try {
                string2 = new String((byte[])it, Charsets.UTF_8);
            }
            catch (Throwable throwable) {
                String string3 = KubernetesBundle.message("KubernetesSecretServiceViewContributor.binaryData.message", new Object[0]);
                Intrinsics.checkNotNull((Object)string3);
                string2 = string3;
            }
            string = string2;
        } else {
            string = null;
        }
        String stringValue = string;
        KubernetesSecretKeyValueServiceViewDescriptor kubernetesSecretKeyValueServiceViewDescriptor = new KubernetesSecretKeyValueServiceViewDescriptor(key, stringValue, this.getApiModel$intellij_clouds_kubernetes(), this.getCoroutineScope(), (V1Secret)this.getResource$intellij_clouds_kubernetes(), this.getMapper$intellij_clouds_kubernetes());
        it = kubernetesSecretKeyValueServiceViewDescriptor;
        boolean bl = false;
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)it));
        return kubernetesSecretKeyValueServiceViewDescriptor;
    }
}

