/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes.workloads;

import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.KubernetesRefreshable;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerServiceViewDescriptorKt;
import com.intellij.kubernetes.view.ui.KubernetesResourceInformationPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.util.ui.JBUI;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u000f\b\u0002\u0010\u001f\u001a\t\u0018\u00010 \u00a2\u0006\u0002\b!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\b\u0010$\u001a\u00020#H\u0016R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerContent;", "Lcom/intellij/kubernetes/view/KubernetesRefreshable;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "Lcom/intellij/openapi/Disposable;", "resource", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "parentDisposable", "<init>", "(Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;Lcom/intellij/kubernetes/api/KubernetesApiModel;Lcom/intellij/openapi/Disposable;)V", "getResource", "()Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModel;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "manager", "Lcom/intellij/ui/content/ContentManager;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "informationPanel", "Lcom/intellij/kubernetes/view/ui/KubernetesResourceInformationPanel;", "getInformationPanel$annotations", "()V", "content", "Lcom/intellij/ui/content/Content;", "addTab", "displayName", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "refresh", "", "dispose", "intellij.clouds.kubernetes"})
public final class KubernetesContainerContent
implements KubernetesRefreshable<KubernetesContainerObject>,
Disposable {
    @NotNull
    private final KubernetesContainerObject resource;
    @NotNull
    private final KubernetesApiModel apiModel;
    @NotNull
    private final ContentManager manager;
    @Nullable
    private final JComponent component;
    @NotNull
    private final KubernetesResourceInformationPanel<KubernetesContainerObject> informationPanel;
    @NotNull
    private Content content;

    public KubernetesContainerContent(@NotNull KubernetesContainerObject resource, @NotNull KubernetesApiModel apiModel2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.resource = resource;
        this.apiModel = apiModel2;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.manager = (ContentManager)new ContentManagerImpl(ServiceViewUIUtils.getServicesAlignedTabbedPaneContentUI(), true, this.getProject());
        this.component = this.manager.getComponent();
        this.informationPanel = new KubernetesResourceInformationPanel<KubernetesContainerObject>(this.resource, this, KubernetesContainerServiceViewDescriptorKt.access$getColumnDescriptors(this.apiModel));
        this.content = this.addTab(this.informationPanel, KubernetesBundle.message("KubernetesResourceContent.informationContent.displayName", new Object[0]));
        this.content.getDisplayName();
        this.content.setCloseable(false);
    }

    @NotNull
    public final KubernetesContainerObject getResource() {
        return this.resource;
    }

    @NotNull
    public final KubernetesApiModel getApiModel() {
        return this.apiModel;
    }

    private final Project getProject() {
        return this.apiModel.getProject();
    }

    @Nullable
    public final JComponent getComponent() {
        return this.component;
    }

    private static /* synthetic */ void getInformationPanel$annotations() {
    }

    private final Content addTab(JComponent component2, String displayName) {
        Content content2;
        block0: {
            Content content3 = this.manager.getFactory().createContent(component2, displayName, true);
            Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"createContent(...)");
            content2 = content3;
            this.manager.addContent(content2);
            Container container = component2.getParent();
            JComponent jComponent = container instanceof JComponent ? (JComponent)container : null;
            if (jComponent == null) break block0;
            jComponent.setBorder((Border)JBUI.Borders.empty());
        }
        return content2;
    }

    static /* synthetic */ Content addTab$default(KubernetesContainerContent kubernetesContainerContent, JComponent jComponent, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return kubernetesContainerContent.addTab(jComponent, string);
    }

    @Override
    public void refresh(@NotNull KubernetesContainerObject resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.informationPanel.refresh(resource);
    }

    public void dispose() {
    }
}

