/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes.workloads;

import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesApiModelKt;
import com.intellij.kubernetes.logs.actions.KubernetesOpenLogsTabActionKt;
import com.intellij.kubernetes.logs.actions.ServiceObjectContainersLoader;
import com.intellij.kubernetes.view.KubernetesRefreshable;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerContent;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesEphemeralContainerObjectImpl;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesInitContainerObjectImpl;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.ui.LayeredIcon;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\n\u0010$\u001a\u0004\u0018\u00010#H\u0016J\b\u0010%\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00030\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u00030\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerServiceViewDescriptor;", "Lcom/intellij/execution/services/SimpleServiceViewDescriptor;", "Lcom/intellij/kubernetes/view/KubernetesRefreshable;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "resourceContainer", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;Lcom/intellij/kubernetes/api/KubernetesApiModel;Lcom/intellij/openapi/Disposable;)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModel;", "currentContainer", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "resource", "getResource$intellij_clouds_kubernetes", "()Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "_presentation", "Lcom/intellij/navigation/ItemPresentation;", "content", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerContent;", "getContent", "()Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerContent;", "content$delegate", "Lkotlin/Lazy;", "getContentComponent", "Ljavax/swing/JComponent;", "getPresentation", "refresh", "", "newResource", "getPopupActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getToolbarActions", "getContainerActions", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.clouds.kubernetes"})
public final class KubernetesContainerServiceViewDescriptor
extends SimpleServiceViewDescriptor
implements KubernetesRefreshable<KubernetesContainerObject>,
UiDataProvider {
    @NotNull
    private final KubernetesApiModel apiModel;
    @NotNull
    private final AtomicReference<KubernetesContainerObject> currentContainer;
    @NotNull
    private ItemPresentation _presentation;
    @NotNull
    private final Lazy content$delegate;

    public KubernetesContainerServiceViewDescriptor(@NotNull KubernetesContainerObject resourceContainer, @NotNull KubernetesApiModel apiModel2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)resourceContainer, (String)"resourceContainer");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(resourceContainer.getName(), null);
        this.apiModel = apiModel2;
        this.currentContainer = new AtomicReference<KubernetesContainerObject>(resourceContainer);
        this._presentation = (ItemPresentation)new PresentationData(this.getResource$intellij_clouds_kubernetes().getName(), null, null, null);
        Icon icon = this.getResource$intellij_clouds_kubernetes() instanceof KubernetesEphemeralContainerObjectImpl ? (this.getResource$intellij_clouds_kubernetes().isRunning() ? KubernetesIcons.EphemeralContainer : KubernetesIcons.EphemeralStoppedContainer) : (this.getResource$intellij_clouds_kubernetes().isRunning() ? KubernetesIcons.SingleRunningContainer : KubernetesIcons.SingleStoppedContainer);
        Intrinsics.checkNotNull((Object)icon);
        Icon finalIcon = icon;
        this._presentation = (ItemPresentation)new PresentationData(this.getResource$intellij_clouds_kubernetes().getName(), null, finalIcon, null);
        this.content$delegate = LazyKt.lazy(() -> KubernetesContainerServiceViewDescriptor.content_delegate$lambda$0(this, parentDisposable));
    }

    @NotNull
    public final KubernetesApiModel getApiModel() {
        return this.apiModel;
    }

    public final KubernetesContainerObject getResource$intellij_clouds_kubernetes() {
        return this.currentContainer.get();
    }

    @NotNull
    public final KubernetesContainerContent getContent() {
        Lazy lazy = this.content$delegate;
        return (KubernetesContainerContent)lazy.getValue();
    }

    @Nullable
    public JComponent getContentComponent() {
        return this.getContent().getComponent();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return this._presentation;
    }

    @Override
    public void refresh(@NotNull KubernetesContainerObject newResource) {
        Intrinsics.checkNotNullParameter((Object)newResource, (String)"newResource");
        this.currentContainer.set(newResource);
        Lazy statusIcon = LazyKt.lazy(() -> KubernetesContainerServiceViewDescriptor.refresh$lambda$1(newResource));
        KubernetesContainerObject kubernetesContainerObject = newResource;
        Icon icon = kubernetesContainerObject instanceof KubernetesEphemeralContainerObjectImpl ? (this.getResource$intellij_clouds_kubernetes().isRunning() ? KubernetesIcons.EphemeralContainer : KubernetesIcons.EphemeralStoppedContainer) : (kubernetesContainerObject instanceof KubernetesInitContainerObjectImpl ? (Icon)LayeredIcon.Companion.layeredIcon(() -> KubernetesContainerServiceViewDescriptor.refresh$lambda$2(statusIcon)) : (Icon)statusIcon.getValue());
        Intrinsics.checkNotNull((Object)icon);
        Icon finalIcon = icon;
        this._presentation = (ItemPresentation)new PresentationData(newResource.getName(), null, finalIcon, null);
        this.getContent().refresh(newResource);
    }

    @NotNull
    public ActionGroup getPopupActions() {
        return this.getContainerActions();
    }

    @Nullable
    public ActionGroup getToolbarActions() {
        return this.getContainerActions();
    }

    private final ActionGroup getContainerActions() {
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup $this$getContainerActions_u24lambda_u243 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$getContainerActions_u24lambda_u243.add(ActionManager.getInstance().getAction("Kubernetes.Open.Logs.Tab.For.Resource.Action"));
        DefaultActionGroup containerActions = defaultActionGroup;
        return (ActionGroup)containerActions;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(KubernetesOpenLogsTabActionKt.getKUBERNETES_SERVICE_CONTAINERS_LOADER(), (Object)new ServiceObjectContainersLoader(this){
            final /* synthetic */ KubernetesContainerServiceViewDescriptor this$0;
            {
                this.this$0 = $receiver;
            }

            public Object getContainers(Continuation<? super List<? extends KubernetesContainerObject>> $completion) {
                return CollectionsKt.listOf((Object)this.this$0.getResource$intellij_clouds_kubernetes());
            }
        });
        sink.set(KubernetesApiModelKt.getKUBERNETES_API_MODEL(), (Object)this.apiModel);
    }

    private static final KubernetesContainerContent content_delegate$lambda$0(KubernetesContainerServiceViewDescriptor this$0, Disposable $parentDisposable) {
        KubernetesContainerObject kubernetesContainerObject = this$0.getResource$intellij_clouds_kubernetes();
        Intrinsics.checkNotNullExpressionValue((Object)kubernetesContainerObject, (String)"<get-resource>(...)");
        return new KubernetesContainerContent(kubernetesContainerObject, this$0.apiModel, $parentDisposable);
    }

    private static final Icon refresh$lambda$1(KubernetesContainerObject $newResource) {
        return $newResource.isRunning() ? KubernetesIcons.SingleRunningContainer : KubernetesIcons.SingleStoppedContainer;
    }

    private static final Icon[] refresh$lambda$2(Lazy $statusIcon) {
        Icon[] iconArray = new Icon[]{$statusIcon.getValue(), AllIcons.Nodes.ProcessMark};
        return iconArray;
    }
}

