/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.ide.DeleteProvider;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettings;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.nodes.KubernetesContextServiceViewContributor;
import com.intellij.kubernetes.view.notification.KubernetesNotificationManager;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeletableServiceViewDescriptor;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeleteResourceProviderKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareActionKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesResourceActionBaseKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesResourceService;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.util.ArrayUtil;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.CoreV1Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J.\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u001c\u0010\r\u001a\u0018\u0012\u0004\u0012\u00020\u000f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000f\u0012\u0002\b\u00030\u00100\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001d\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u000b\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018H\u0002J\u001d\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u000b\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesDeleteResourceProvider;", "Lcom/intellij/ide/DeleteProvider;", "<init>", "()V", "canDeleteElement", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "deleteElement", "", "deleteResources", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "resourcesToMappers", "", "Lio/kubernetes/client/common/KubernetesObject;", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "askDeleteDialog", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "Lorg/jetbrains/annotations/Nls;", "askHideDialog", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesDeleteResourceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesDeleteResourceProvider.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesDeleteResourceProvider\n+ 2 actionUtils.kt\ncom/intellij/kubernetes/view/ui/actions/ActionUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,154:1\n15#2,2:155\n15#2,2:163\n12567#3,2:157\n12567#3,2:159\n12567#3,2:161\n4135#3,11:165\n11476#3,9:180\n13402#3:189\n13403#3:191\n11485#3:192\n11476#3,9:193\n13402#3:202\n13403#3:206\n11485#3:207\n1557#4:176\n1628#4,3:177\n1#5:190\n1#5:205\n19#6:203\n19#6:204\n15#7:208\n*S KotlinDebug\n*F\n+ 1 KubernetesDeleteResourceProvider.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesDeleteResourceProvider\n*L\n36#1:155,2\n48#1:163,2\n39#1:157,2\n41#1:159,2\n42#1:161,2\n49#1:165,11\n61#1:180,9\n61#1:189\n61#1:191\n61#1:192\n81#1:193,9\n81#1:202\n81#1:206\n81#1:207\n52#1:176\n52#1:177,3\n61#1:190\n81#1:205\n82#1:203\n83#1:204\n94#1:208\n*E\n"})
public final class KubernetesDeleteResourceProvider
implements DeleteProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final DataProvider dataProvider = KubernetesDeleteResourceProvider::dataProvider$lambda$10;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        Object it;
        Object element$iv;
        int n;
        Object[] selectedItems;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = KubernetesDeleteResourceProviderKt.access$getProject(dataContext);
        if (project == null) {
            return false;
        }
        Project project2 = project;
        DataContext $this$selectedItems$iv = dataContext;
        boolean $i$f$getSelectedItems = false;
        Object[] objectArray = (Object[])$this$selectedItems$iv.getData(PlatformCoreDataKeys.SELECTED_ITEMS);
        if (objectArray == null) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
        }
        Object[] $this$any$iv = selectedItems = objectArray;
        boolean $i$f$any = false;
        int n2 = $this$any$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (!(KubernetesResourceActionBaseKt.getResource(it) instanceof CoreV1Event)) continue;
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        $this$any$iv = selectedItems;
        $i$f$any = false;
        n2 = $this$any$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$any$iv[n];
            boolean bl2 = false;
            if (it instanceof ServiceViewContributor && ((ServiceViewContributor)it).getViewDescriptor(project2) instanceof KubernetesDeletableServiceViewDescriptor) {
                return true;
            }
            boolean bl3 = false;
            if (!bl3) continue;
            return true;
        }
        boolean bl4 = false;
        if (bl4) return true;
        if (KubernetesModelBasedDumbAwareActionKt.getApiModel(dataContext) == null) return false;
        $this$any$iv = selectedItems;
        $i$f$any = false;
        n = 0;
        n2 = $this$any$iv.length;
        while (n < n2) {
            it = element$iv = $this$any$iv[n];
            boolean bl5 = false;
            if (KubernetesResourceActionBaseKt.getResource(it) != null) {
                return true;
            }
            boolean bl6 = false;
            if (bl6) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteElement(@NotNull DataContext dataContext) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        Object[] $this$mapTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Object[] selectedItems;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = KubernetesDeleteResourceProviderKt.access$getProject(dataContext);
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        DataContext $this$selectedItems$iv = dataContext;
        boolean $i$f$getSelectedItems = false;
        Object[] objectArray = (Object[])$this$selectedItems$iv.getData(PlatformCoreDataKeys.SELECTED_ITEMS);
        if (objectArray == null) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
        }
        Object[] $this$filterIsInstance$iv = selectedItems = objectArray;
        boolean $i$f$filterIsInstance22 = false;
        Object[] objectArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void var12_26 : $this$filterIsInstanceTo$iv$iv) {
            if (!(var12_26 instanceof KubernetesContextServiceViewContributor)) continue;
            destination$iv$iv.add(var12_26);
        }
        List serviceViewContributors = (List)destination$iv$iv;
        if (!((Collection)serviceViewContributors).isEmpty()) {
            void $this$map$iv;
            Iterable $i$f$filterIsInstance22 = serviceViewContributors;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                void it;
                KubernetesContextServiceViewContributor kubernetesContextServiceViewContributor = (KubernetesContextServiceViewContributor)t;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getApiModel$intellij_clouds_kubernetes().getCurrentContextObject$intellij_clouds_kubernetes());
            }
            List contexts2 = (List)destination$iv$iv2;
            if (this.askHideDialog(project2, CollectionsKt.joinToString$default((Iterable)contexts2, null, null, null, (int)0, null, KubernetesDeleteResourceProvider::deleteElement$lambda$4, (int)31, null))) {
                KubernetesApiProvider.Companion.getInstance(project2).removeContexts$intellij_clouds_kubernetes(contexts2);
            }
            return;
        }
        Object[] $this$mapNotNull$iv = selectedItems;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        Object[] destination$iv$iv3 = (Object[])new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean bl = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int it = 0; it < n; ++it) {
            Pair pair;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[it];
            boolean bl2 = false;
            void item = element$iv$iv;
            boolean bl22 = false;
            if (KubernetesResourceActionBaseKt.getResource(item) != null) {
                KubernetesObject it2;
                boolean bl3 = false;
                KubernetesResourceMapper<?, ?> kubernetesResourceMapper = KubernetesResourceActionBaseKt.getMapper(item);
                Intrinsics.checkNotNull(kubernetesResourceMapper);
                pair = TuplesKt.to((Object)it2, kubernetesResourceMapper);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        Map resourcesToMappers = MapsKt.toMap((Iterable)((List)destination$iv$iv3));
        if (!resourcesToMappers.isEmpty()) {
            String displayableNames = CollectionsKt.joinToString$default((Iterable)resourcesToMappers.entrySet(), null, null, null, (int)0, null, KubernetesDeleteResourceProvider::deleteElement$lambda$7, (int)31, null);
            if (this.askDeleteDialog(project2, displayableNames)) {
                KubernetesApiModel kubernetesApiModel = KubernetesModelBasedDumbAwareActionKt.getApiModel(dataContext);
                Intrinsics.checkNotNull((Object)kubernetesApiModel);
                this.deleteResources(kubernetesApiModel, resourcesToMappers);
            }
            return;
        }
        Object[] $this$mapNotNull$iv2 = selectedItems;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv3 = $this$mapNotNull$iv2;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void var12_30 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        int n2 = ((void)var12_30).length;
        for (n = 0; n < n2; ++n) {
            KubernetesDeletableServiceViewDescriptor kubernetesDeletableServiceViewDescriptor;
            ServiceViewDescriptor serviceViewDescriptor;
            ServiceViewContributor serviceViewContributor;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var12_30[n];
            boolean bl3 = false;
            void it = element$iv$iv;
            boolean bl5 = false;
            void $this$asSafely$iv = it;
            boolean $i$f$asSafely22 = false;
            Object v5 = $this$asSafely$iv;
            if (!(v5 instanceof ServiceViewContributor)) {
                v5 = null;
            }
            if ((serviceViewContributor = (ServiceViewContributor)v5) != null && (serviceViewDescriptor = serviceViewContributor.getViewDescriptor(project2)) != null) {
                void $this$asSafely$iv2;
                ServiceViewDescriptor $i$f$asSafely22 = serviceViewDescriptor;
                boolean $i$f$asSafely3 = false;
                Object v6 = $this$asSafely$iv2;
                if (!(v6 instanceof KubernetesDeletableServiceViewDescriptor)) {
                    v6 = null;
                }
                kubernetesDeletableServiceViewDescriptor = v6;
            } else {
                kubernetesDeletableServiceViewDescriptor = null;
            }
            if (kubernetesDeletableServiceViewDescriptor == null) continue;
            KubernetesDeletableServiceViewDescriptor it$iv$iv = kubernetesDeletableServiceViewDescriptor;
            boolean bl6 = false;
            destination$iv$iv4.add(it$iv$iv);
        }
        List deletables = (List)destination$iv$iv4;
        if (!((Collection)deletables).isEmpty()) {
            String toDelete = CollectionsKt.joinToString$default((Iterable)deletables, null, null, null, (int)0, null, KubernetesDeleteResourceProvider::deleteElement$lambda$9, (int)31, null);
            if (this.askHideDialog(project2, toDelete)) {
                for (KubernetesDeletableServiceViewDescriptor deletable : deletables) {
                    Runnable remover = deletable.getRemover();
                    if (remover != null) {
                        remover.run();
                        continue;
                    }
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(KubernetesDeleteResourceProvider.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("failed to delete " + deletable + " of " + deletable.getClass());
                }
            }
            return;
        }
    }

    private final void deleteResources(KubernetesApiModel apiModel2, Map<KubernetesObject, ? extends KubernetesResourceMapper<KubernetesObject, ?>> resourcesToMappers) {
        Project project = apiModel2.getProject();
        KubernetesResourceService kubernetesResourceService = KubernetesResourceService.Companion.getInstance(project);
        String string = KubernetesBundle.message("KubectlExecutor.delete.progressTitle", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        kubernetesResourceService.schedule(string, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(resourcesToMappers, apiModel2, project, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ Map<KubernetesObject, KubernetesResourceMapper<KubernetesObject, ?>> $resourcesToMappers;
            final /* synthetic */ KubernetesApiModel $apiModel;
            final /* synthetic */ Project $project;
            {
                this.$resourcesToMappers = $resourcesToMappers;
                this.$apiModel = $apiModel;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        messages = new ArrayList<E>();
                        try {
                            var3_4 = this.$resourcesToMappers.entrySet().iterator();
                        }
                        catch (Throwable var3_5) {
                            if (((Collection)messages).isEmpty() == false == false) throw var3_6;
                            KubernetesNotificationManager.Companion.getInstance(this.$project).reportWarning(CollectionsKt.joinToString$default((Iterable)messages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                            if (KubernetesApiGlobalSettings.Companion.getInstance().getRefreshResourcesAfterActionConfig() == false) throw var3_6;
                            this.L$0 = var3_5;
                            this.L$1 = null;
                            this.L$2 = null;
                            this.label = 3;
                            v0 = this.$apiModel.refresh$intellij_clouds_kubernetes((Continuation<? super Unit>)((Continuation)this));
                            v1 = v0;
                            if (v0 != var8_2) throw var3_6;
                            return var8_2;
                        }
lbl22:
                        // 2 sources

                        while (var3_4.hasNext()) {
                            var4_7 = var3_4.next();
                            resource = var4_7.getKey();
                            mapper = var4_7.getValue();
                            var7_10 = messages;
                            this.L$0 = messages;
                            this.L$1 = var3_4;
                            this.L$2 = var7_10;
                            this.label = 1;
                            v2 = this.$apiModel.delete(resource, mapper.getEntity$intellij_clouds_kubernetes(), (Continuation<? super String>)((Continuation)this));
                            if (v2 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl43
                        }
                        ** GOTO lbl46
                    }
                    case 1: {
                        var7_10 = (Collection)this.L$2;
                        var3_4 = (Iterator<Map.Entry<KubernetesObject, KubernetesResourceMapper<KubernetesObject, ?>>>)this.L$1;
                        messages = (List)this.L$0;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl43:
                            // 2 sources

                            var7_10.add(v2);
                            ** GOTO lbl22
                        }
                    }
lbl46:
                    // 1 sources

                    if (((Collection)messages).isEmpty() == false == false) return Unit.INSTANCE;
                    KubernetesNotificationManager.Companion.getInstance(this.$project).reportWarning(CollectionsKt.joinToString$default((Iterable)messages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                    if (KubernetesApiGlobalSettings.Companion.getInstance().getRefreshResourcesAfterActionConfig() == false) return Unit.INSTANCE;
                    this.L$0 = null;
                    this.L$1 = null;
                    this.L$2 = null;
                    this.label = 2;
                    v3 = this.$apiModel.refresh$intellij_clouds_kubernetes((Continuation<? super Unit>)((Continuation)this));
                    v4 = v3;
                    if (v3 != var8_2) return Unit.INSTANCE;
                    return var8_2;
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        return Unit.INSTANCE;
                    }
                    case 3: {
                        var3_6 = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        throw var3_6;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final boolean askDeleteDialog(Project project, String text) {
        String string = KubernetesBundle.message("action.Kubernetes.DeleteResource.confirmation.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{text};
        String string2 = KubernetesBundle.message("action.Kubernetes.DeleteResource.confirmation.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        OkCancelDialogBuilder okCancelDialogBuilder = MessageDialogBuilder.Companion.okCancel(string, string2);
        String string3 = KubernetesBundle.message("action.Kubernetes.DeleteResource.confirmation.yes", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        return ((OkCancelDialogBuilder)okCancelDialogBuilder.yesText(string3)).ask(project);
    }

    private final boolean askHideDialog(Project project, String text) {
        String string = KubernetesBundle.message("action.Kubernetes.hide.confirmation.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{text};
        String string2 = KubernetesBundle.message("action.Kubernetes.hide.confirmation.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        OkCancelDialogBuilder okCancelDialogBuilder = MessageDialogBuilder.Companion.okCancel(string, string2);
        String string3 = KubernetesBundle.message("action.Kubernetes.hide.confirmation.yes", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        return ((OkCancelDialogBuilder)okCancelDialogBuilder.yesText(string3)).ask(project);
    }

    private static final CharSequence deleteElement$lambda$4(Context it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence deleteElement$lambda$7(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        KubernetesObject resource = (KubernetesObject)entry.getKey();
        KubernetesResourceMapper mapper = (KubernetesResourceMapper)entry.getValue();
        return mapper.getResourceDisplayableName(resource);
    }

    private static final CharSequence deleteElement$lambda$9(KubernetesDeletableServiceViewDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDeletableName();
    }

    private static final Object dataProvider$lambda$10(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(it) ? new KubernetesDeleteResourceProvider() : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesDeleteResourceProvider$Companion;", "", "<init>", "()V", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

