/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareToggleAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0014\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016R\u0019\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesNamespaceAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesModelBasedDumbAwareToggleAction;", "namespace", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;)V", "getNamespace$intellij_clouds_kubernetes", "()Ljava/lang/String;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "intellij.clouds.kubernetes"})
public final class KubernetesNamespaceAction
extends KubernetesModelBasedDumbAwareToggleAction {
    @NotNull
    private final String namespace;

    public KubernetesNamespaceAction(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.namespace = namespace;
    }

    @NotNull
    public final String getNamespace$intellij_clouds_kubernetes() {
        return this.namespace;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        if (!presentation2.isVisible()) {
            return;
        }
        presentation2.setText(this.namespace);
        Object[] objectArray = new Object[]{this.namespace};
        presentation2.setDescription(KubernetesBundle.messagePointer("action.Kubernetes.Namespace.description", objectArray));
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesApiModel kubernetesApiModel = this.getApiModel(e);
        Intrinsics.checkNotNull((Object)kubernetesApiModel);
        return Intrinsics.areEqual((Object)kubernetesApiModel.getNamespaceForRequest(), (Object)this.namespace);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesApiModel kubernetesApiModel = this.getApiModel(e);
        Intrinsics.checkNotNull((Object)kubernetesApiModel);
        KubernetesApiModel apiModel2 = kubernetesApiModel;
        apiModel2.scheduleSetNamespace(this.namespace);
    }
}

