/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.secret;

import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.ui.secret.AnnotationDataTable;
import com.intellij.kubernetes.view.ui.secret.KubernetesCreateNewSecretDialogKt;
import com.intellij.kubernetes.view.ui.secret.SecretDataTable;
import com.intellij.kubernetes.view.ui.secret.SecretEntry;
import com.intellij.kubernetes.view.ui.secret.SecretInfo;
import com.intellij.kubernetes.view.ui.secret.UtilsKt;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0011\u0010\u0005\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00040\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0003H\u0014J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0014R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u001b\u0010&\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\r\u00a8\u0006("}, d2={"Lcom/intellij/kubernetes/view/ui/secret/KubernetesCreateNewSecretDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "currentNamespace", "", "Lcom/intellij/openapi/util/NlsSafe;", "namespaces", "", "<init>", "(Ljava/lang/String;Ljava/util/Set;)V", "nameField", "Ljavax/swing/JTextField;", "name", "getName$intellij_clouds_kubernetes", "()Ljava/lang/String;", "namespaceField", "Lcom/intellij/openapi/ui/ComboBox;", "namespace", "getNamespace$intellij_clouds_kubernetes", "typeField", "type", "getType$intellij_clouds_kubernetes", "stringDataTable", "Lcom/intellij/kubernetes/view/ui/secret/SecretDataTable;", "stringData", "", "Lcom/intellij/kubernetes/view/ui/secret/SecretEntry;", "getStringData$intellij_clouds_kubernetes", "()Ljava/util/List;", "annotationTable", "Lcom/intellij/kubernetes/view/ui/secret/AnnotationDataTable;", "annotations", "getAnnotations$intellij_clouds_kubernetes", "getInitialSize", "Ljava/awt/Dimension;", "getDimensionServiceKey", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "createCenterPanel", "selectedNamespace", "getSelectedNamespace", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesCreateNewSecretDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesCreateNewSecretDialog.kt\ncom/intellij/kubernetes/view/ui/secret/KubernetesCreateNewSecretDialog\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n37#2:152\n36#2,3:153\n1#3:156\n*S KotlinDebug\n*F\n+ 1 KubernetesCreateNewSecretDialog.kt\ncom/intellij/kubernetes/view/ui/secret/KubernetesCreateNewSecretDialog\n*L\n92#1:152\n92#1:153,3\n*E\n"})
public final class KubernetesCreateNewSecretDialog
extends DialogWrapper {
    @NotNull
    private final String currentNamespace;
    @NotNull
    private final Set<String> namespaces;
    private JTextField nameField;
    private ComboBox<String> namespaceField;
    private ComboBox<String> typeField;
    private SecretDataTable stringDataTable;
    private AnnotationDataTable annotationTable;

    public KubernetesCreateNewSecretDialog(@NotNull String currentNamespace, @NotNull Set<String> namespaces2) {
        Intrinsics.checkNotNullParameter((Object)currentNamespace, (String)"currentNamespace");
        Intrinsics.checkNotNullParameter(namespaces2, (String)"namespaces");
        super(true);
        this.currentNamespace = currentNamespace;
        this.namespaces = namespaces2;
        this.setTitle(KubernetesBundle.message("KubernetesCreateNewSecretDialog.title", new Object[0]));
        this.setOKButtonText(KubernetesBundle.message("KubernetesCreateNewSecretDialog.dialog.create", new Object[0]));
        this.init();
        this.pack();
    }

    @NotNull
    public final String getName$intellij_clouds_kubernetes() {
        JTextField jTextField = this.nameField;
        if (jTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nameField");
            jTextField = null;
        }
        String string = jTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Nullable
    public final String getNamespace$intellij_clouds_kubernetes() {
        ComboBox<String> comboBox = this.namespaceField;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"namespaceField");
            comboBox = null;
        }
        Object object = comboBox.getSelectedItem();
        return object != null ? object.toString() : null;
    }

    @Nullable
    public final String getType$intellij_clouds_kubernetes() {
        ComboBox<String> comboBox = this.typeField;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"typeField");
            comboBox = null;
        }
        Object object = comboBox.getSelectedItem();
        return object != null ? object.toString() : null;
    }

    @NotNull
    public final List<SecretEntry> getStringData$intellij_clouds_kubernetes() {
        SecretDataTable secretDataTable = this.stringDataTable;
        if (secretDataTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stringDataTable");
            secretDataTable = null;
        }
        return secretDataTable.getData();
    }

    @NotNull
    public final List<SecretEntry> getAnnotations$intellij_clouds_kubernetes() {
        AnnotationDataTable annotationDataTable = this.annotationTable;
        if (annotationDataTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationTable");
            annotationDataTable = null;
        }
        return annotationDataTable.getData();
    }

    @NotNull
    public Dimension getInitialSize() {
        return new Dimension(550, 600);
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "com.intellij.kubernetes.view.ui.secret.dimension";
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JTextField jTextField = this.nameField;
        if (jTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nameField");
            jTextField = null;
        }
        return jTextField;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> KubernetesCreateNewSecretDialog.createCenterPanel$lambda$13(this, arg_0));
    }

    private final String getSelectedNamespace() {
        return this.namespaces.contains(this.currentNamespace) ? this.currentNamespace : (this.namespaces.contains("default") ? "default" : null);
    }

    private static final ValidationInfo createCenterPanel$lambda$13$lambda$1$lambda$0(KubernetesCreateNewSecretDialog this$0, ValidationInfoBuilder $this$validationOnApply, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JTextField jTextField = this$0.nameField;
        if (jTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nameField");
            jTextField = null;
        }
        String string = jTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        ValidationInfo validationInfo = UtilsKt.validateValueNotBlank($this$validationOnApply, string, "KubernetesCreateNewSecretDialog.secret.name.validation");
        if (validationInfo == null) {
            JTextField jTextField2 = this$0.nameField;
            if (jTextField2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"nameField");
                jTextField2 = null;
            }
            String string2 = jTextField2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            validationInfo = UtilsKt.validateDNSName$default($this$validationOnApply, string2, null, 2, null);
        }
        return validationInfo;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$1(KubernetesCreateNewSecretDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.nameField = (JTextField)TextFieldKt.columns((Cell)$this$row.textField().validationOnApply((arg_0, arg_1) -> KubernetesCreateNewSecretDialog.createCenterPanel$lambda$13$lambda$1$lambda$0(this$0, arg_0, arg_1)), (int)25).getComponent();
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$lambda$13$lambda$4$lambda$3(KubernetesCreateNewSecretDialog this$0, ItemEvent event2) {
        SecretInfo secretInfo = (SecretInfo)KubernetesCreateNewSecretDialogKt.access$getSECRET_MAP$p().get(event2.getItem());
        if (secretInfo == null) {
            return;
        }
        SecretInfo info = secretInfo;
        switch (event2.getStateChange()) {
            case 1: {
                SecretDataTable secretDataTable = this$0.stringDataTable;
                if (secretDataTable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"stringDataTable");
                    secretDataTable = null;
                }
                secretDataTable.addKeysWithEmptyValues(info.getRequiredDataKeys());
                AnnotationDataTable annotationDataTable = this$0.annotationTable;
                if (annotationDataTable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"annotationTable");
                    annotationDataTable = null;
                }
                annotationDataTable.addKeysWithEmptyValues(info.getRequiredAnnotations());
                break;
            }
            case 2: {
                SecretDataTable secretDataTable = this$0.stringDataTable;
                if (secretDataTable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"stringDataTable");
                    secretDataTable = null;
                }
                secretDataTable.removeKeysWithEmptyValues(info.getRequiredDataKeys());
                AnnotationDataTable annotationDataTable = this$0.annotationTable;
                if (annotationDataTable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"annotationTable");
                    annotationDataTable = null;
                }
                annotationDataTable.removeKeysWithEmptyValues(info.getRequiredAnnotations());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$13$lambda$4(KubernetesCreateNewSecretDialog this$0, Row $this$row) {
        void $this$createCenterPanel_u24lambda_u2413_u24lambda_u244_u24lambda_u242;
        DefaultComboBoxModel<String> defaultComboBoxModel;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Collection $this$toTypedArray$iv = KubernetesCreateNewSecretDialogKt.access$getSECRET_MAP$p().keySet();
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        DefaultComboBoxModel<String> $i$f$toTypedArray22 = defaultComboBoxModel = new DefaultComboBoxModel<String>(thisCollection$iv.toArray(new String[0]));
        Row row = $this$row;
        KubernetesCreateNewSecretDialog kubernetesCreateNewSecretDialog = this$0;
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u2413_u24lambda_u244_u24lambda_u242.setSelectedItem("Opaque");
        Unit unit = Unit.INSTANCE;
        kubernetesCreateNewSecretDialog.typeField = (ComboBox)ComboBoxKt.columns((Cell)Row.comboBox$default((Row)row, (ComboBoxModel)defaultComboBoxModel, null, (int)2, null), (int)25).getComponent();
        ComboBox<String> comboBox = this$0.typeField;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"typeField");
            comboBox = null;
        }
        comboBox.setEditable(true);
        ComboBox<String> comboBox2 = this$0.typeField;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"typeField");
            comboBox2 = null;
        }
        comboBox2.addItemListener(arg_0 -> KubernetesCreateNewSecretDialog.createCenterPanel$lambda$13$lambda$4$lambda$3(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$6(KubernetesCreateNewSecretDialog this$0, Row $this$row) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            this$0.namespaceField = (ComboBox)ComboBoxKt.columns((Cell)Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)new SortedComboBoxModel((Collection)this$0.namespaces, StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE))), null, (int)2, null), (int)25).getComponent();
            ComboBox<String> comboBox = this$0.namespaceField;
            if (comboBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"namespaceField");
                comboBox = null;
            }
            comboBox.setEditable(true);
            String string = this$0.getSelectedNamespace();
            if (string == null) break block2;
            String it = string;
            boolean bl = false;
            ComboBox<String> comboBox2 = this$0.namespaceField;
            if (comboBox2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"namespaceField");
                comboBox2 = null;
            }
            comboBox2.setSelectedItem((Object)it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$7(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createCenterPanel$lambda$13$lambda$9$lambda$8(KubernetesCreateNewSecretDialog this$0, ValidationInfoBuilder $this$validationOnApply, JPanel it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SecretDataTable secretDataTable = this$0.stringDataTable;
        if (secretDataTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stringDataTable");
            secretDataTable = null;
        }
        return secretDataTable.validateOnApply();
    }

    private static final Unit createCenterPanel$lambda$13$lambda$9(KubernetesCreateNewSecretDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.stringDataTable = new SecretDataTable(null, 1, null);
        SecretDataTable secretDataTable = this$0.stringDataTable;
        if (secretDataTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stringDataTable");
            secretDataTable = null;
        }
        $this$row.cell((JComponent)secretDataTable.createDecoratorPanel()).align((Align)AlignX.FILL.INSTANCE).align((Align)AlignY.FILL.INSTANCE).validationOnApply((arg_0, arg_1) -> KubernetesCreateNewSecretDialog.createCenterPanel$lambda$13$lambda$9$lambda$8(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$10(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createCenterPanel$lambda$13$lambda$12$lambda$11(KubernetesCreateNewSecretDialog this$0, ValidationInfoBuilder $this$validationOnApply, JPanel it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AnnotationDataTable annotationDataTable = this$0.annotationTable;
        if (annotationDataTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationTable");
            annotationDataTable = null;
        }
        return annotationDataTable.validateOnApply();
    }

    private static final Unit createCenterPanel$lambda$13$lambda$12(KubernetesCreateNewSecretDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.annotationTable = new AnnotationDataTable();
        AnnotationDataTable annotationDataTable = this$0.annotationTable;
        if (annotationDataTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationTable");
            annotationDataTable = null;
        }
        $this$row.cell((JComponent)annotationDataTable.createDecoratorPanel()).align((Align)AlignX.FILL.INSTANCE).align((Align)AlignY.FILL.INSTANCE).validationOnApply((arg_0, arg_1) -> KubernetesCreateNewSecretDialog.createCenterPanel$lambda$13$lambda$12$lambda$11(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13(KubernetesCreateNewSecretDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> KubernetesCreateNewSecretDialog.createCenterPanel$lambda$13$lambda$1(this$0, arg_0));
        String string2 = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.type", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> KubernetesCreateNewSecretDialog.createCenterPanel$lambda$13$lambda$4(this$0, arg_0));
        String string3 = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.namespace", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(string3, arg_0 -> KubernetesCreateNewSecretDialog.createCenterPanel$lambda$13$lambda$6(this$0, arg_0));
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        String string4 = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.stringData", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        $this$panel.row(string4, KubernetesCreateNewSecretDialog::createCenterPanel$lambda$13$lambda$7);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> KubernetesCreateNewSecretDialog.createCenterPanel$lambda$13$lambda$9(this$0, arg_0), (int)1, null).resizableRow();
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        String string5 = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.annotations", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        $this$panel.row(string5, KubernetesCreateNewSecretDialog::createCenterPanel$lambda$13$lambda$10);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> KubernetesCreateNewSecretDialog.createCenterPanel$lambda$13$lambda$12(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }
}

