/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.vfs;

import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.view.vfs.KubernetesVirtualFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.io.Sanitize_nameKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u001a\u0014\u0010\f\u001a\u00020\u0006*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0001\u001a\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0013H\u0000\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"(\u0010\u0007\u001a\u00020\u0006*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00068B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000b\"\u0018\u0010\f\u001a\u00020\u0006*\u00020\b8AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0014"}, d2={"IS_PLAIN_KUBERNETES_FILE_CACHED", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "value", "", "isPlainKubernetesFileCached", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)Z", "setPlainKubernetesFileCached", "(Lcom/intellij/psi/PsiFile;Z)V", "isPlainKubernetesFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "isKubernetesFile", "file", "sanitizeFileName", "", "intellij.clouds.kubernetes"})
public final class UtilsKt {
    @NotNull
    private static final Key<Unit> IS_PLAIN_KUBERNETES_FILE_CACHED;

    private static final boolean isPlainKubernetesFileCached(PsiFile $this$isPlainKubernetesFileCached) {
        return $this$isPlainKubernetesFileCached.getUserData(IS_PLAIN_KUBERNETES_FILE_CACHED) != null;
    }

    private static final void setPlainKubernetesFileCached(PsiFile $this$isPlainKubernetesFileCached, boolean value2) {
        $this$isPlainKubernetesFileCached.putUserData(IS_PLAIN_KUBERNETES_FILE_CACHED, value2 ? Unit.INSTANCE : null);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    public static final boolean isPlainKubernetesFile(@NotNull PsiFile $this$isPlainKubernetesFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isPlainKubernetesFile, (String)"<this>");
        if (!$this$isPlainKubernetesFile.isValid()) {
            return false;
        }
        Project project = $this$isPlainKubernetesFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            bl = UtilsKt.isPlainKubernetesFileCached($this$isPlainKubernetesFile);
        } else {
            void var1_1;
            boolean value2 = KubernetesUtilKt.isKubernetesYaml($this$isPlainKubernetesFile) && !KubernetesUtilKt.isKustomizationPsiFile($this$isPlainKubernetesFile) && !KubernetesUtilKt.isKustomizeStrategicMergePatch($this$isPlainKubernetesFile) && Chart.Companion.getChartByTemplateElement((PsiElement)$this$isPlainKubernetesFile) == null;
            UtilsKt.setPlainKubernetesFileCached($this$isPlainKubernetesFile, value2);
            bl = var1_1;
        }
        return bl;
    }

    @RequiresReadLock
    public static final boolean isPlainKubernetesFile(@NotNull VirtualFile $this$isPlainKubernetesFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$isPlainKubernetesFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!$this$isPlainKubernetesFile.isValid()) {
            return false;
        }
        if ($this$isPlainKubernetesFile instanceof LightVirtualFile && !($this$isPlainKubernetesFile instanceof KubernetesVirtualFile)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile($this$isPlainKubernetesFile);
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        return UtilsKt.isPlainKubernetesFile(psiFile2);
    }

    public static final boolean isKubernetesFile(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (file instanceof KubernetesVirtualFile) {
            return true;
        }
        Object object = ReadAction.compute(() -> UtilsKt.isKubernetesFile$lambda$0(file, project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (Boolean)object;
    }

    @NotNull
    public static final String sanitizeFileName(@NotNull String $this$sanitizeFileName) {
        Intrinsics.checkNotNullParameter((Object)$this$sanitizeFileName, (String)"<this>");
        return Sanitize_nameKt.sanitizeFileName$default((String)$this$sanitizeFileName, null, (boolean)false, null, (int)14, null);
    }

    private static final Boolean isKubernetesFile$lambda$0(VirtualFile $file, Project $project) {
        return UtilsKt.isPlainKubernetesFile($file, $project);
    }

    static {
        Key key = Key.create((String)"IS_PLAIN_KUBERNETES_FILE_CACHED");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        IS_PLAIN_KUBERNETES_FILE_CACHED = key;
    }
}

