/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IngressPortStatus represents the error condition of a service port")
public class V1IngressPortStatus {
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private String error;
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    private Integer port;
    public static final String SERIALIZED_NAME_PROTOCOL = "protocol";
    @SerializedName(value="protocol")
    private String protocol;

    public V1IngressPortStatus error(String error2) {
        this.error = error2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use   CamelCase names - cloud provider specific error values must have names that comply with the   format foo.example.com/CamelCase.")
    public String getError() {
        return this.error;
    }

    public void setError(String error2) {
        this.error = error2;
    }

    public V1IngressPortStatus port(Integer port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(required=true, value="port is the port number of the ingress port.")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public V1IngressPortStatus protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @ApiModelProperty(required=true, value="protocol is the protocol of the ingress port. The supported values are: \"TCP\", \"UDP\", \"SCTP\"")
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1IngressPortStatus v1IngressPortStatus = (V1IngressPortStatus)o;
        return Objects.equals(this.error, v1IngressPortStatus.error) && Objects.equals(this.port, v1IngressPortStatus.port) && Objects.equals(this.protocol, v1IngressPortStatus.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.port, this.protocol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1IngressPortStatus {\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

