/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generator.ErrorsCollector;
import com.intellij.indexing.shared.generator.IndexedFileHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedHashesSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/indexing/shared/generator/IndexesExporterHasher;", "", "providers", "", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "errorsCollector", "Lcom/intellij/indexing/shared/generator/ErrorsCollector;", "<init>", "(Ljava/util/List;Lcom/intellij/indexing/shared/generator/ErrorsCollector;)V", "generators", "", "[Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "computeHash", "Lcom/intellij/indexing/shared/generator/IndexedFileHash;", "fileContent", "Lcom/intellij/util/indexing/FileContentImpl;", "computeHashImpl", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nIndexesExporterHasher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexesExporterHasher.kt\ncom/intellij/indexing/shared/generator/IndexesExporterHasher\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,97:1\n37#2:98\n36#2,3:99\n*S KotlinDebug\n*F\n+ 1 IndexesExporterHasher.kt\ncom/intellij/indexing/shared/generator/IndexesExporterHasher\n*L\n27#1:98\n27#1:99,3\n*E\n"})
public final class IndexesExporterHasher {
    @NotNull
    private final ErrorsCollector errorsCollector;
    @NotNull
    private final SharedIndexContentHashProvider[] generators;

    public IndexesExporterHasher(@NotNull List<? extends SharedIndexContentHashProvider> providers, @NotNull ErrorsCollector errorsCollector) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)errorsCollector, (String)"errorsCollector");
        this.errorsCollector = errorsCollector;
        Collection $this$toTypedArray$iv = providers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.generators = thisCollection$iv.toArray(new SharedIndexContentHashProvider[0]);
    }

    @NotNull
    public final IndexedFileHash computeHash(@NotNull FileContentImpl fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        return (IndexedFileHash)ActionsKt.runReadAction(() -> IndexesExporterHasher.computeHash$lambda$0(this, fileContent));
    }

    private final IndexedFileHash computeHashImpl(FileContentImpl fileContent) {
        HashMap hashMap = new HashMap();
        for (SharedIndexContentHashProvider generator : this.generators) {
            byte[] byArray;
            try {
                if (generator.computeHash((IndexedFile)fileContent) == null) continue;
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                this.errorsCollector.fileHashError((FileContent)fileContent, "Failed to compute hash with " + generator.getInfo().getProviderId(), t);
                continue;
            }
            byte[] hash = byArray;
            ((Map)hashMap).put(generator.getInfo(), hash);
        }
        byte[] byArray = IndexedHashesSupport.getOrInitIndexedHash((FileContentImpl)fileContent);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getOrInitIndexedHash(...)");
        byte[] legacyHash = byArray;
        return new IndexedFileHash(legacyHash, hashMap);
    }

    private static final IndexedFileHash computeHash$lambda$0(IndexesExporterHasher this$0, FileContentImpl $fileContent) {
        return this$0.computeHashImpl($fileContent);
    }
}

