/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.util.HtmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HtmlFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(@NotNull Project project2, @NotNull VirtualFile vFile) {
        PsiFile file;
        Module module;
        if (project2 == null) {
            HtmlFileReferenceHelper.$$$reportNull$$$0(0);
        }
        if (vFile == null) {
            HtmlFileReferenceHelper.$$$reportNull$$$0(1);
        }
        Module module2 = module = (file = PsiManager.getInstance((Project)project2).findFile(vFile)) != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)file) : null;
        if (module == null || !(file instanceof XmlFile)) {
            List<PsiFileSystemItem> list2 = Collections.emptyList();
            if (list2 == null) {
                HtmlFileReferenceHelper.$$$reportNull$$$0(2);
            }
            return list2;
        }
        String basePath = HtmlUtil.getHrefBase((XmlFile)file);
        if (basePath != null && !HtmlUtil.hasHtmlPrefix(basePath)) {
            for (VirtualFile virtualFile : this.getBaseRoots(module)) {
                VirtualFile base = virtualFile.findFileByRelativePath(basePath);
                PsiDirectory result2 = base != null ? PsiManager.getInstance((Project)project2).findDirectory(base) : null;
                if (result2 == null) continue;
                List<PsiDirectory> list3 = Collections.singletonList(result2);
                if (list3 == null) {
                    HtmlFileReferenceHelper.$$$reportNull$$$0(3);
                }
                return list3;
            }
        }
        List<PsiFileSystemItem> list4 = Collections.emptyList();
        if (list4 == null) {
            HtmlFileReferenceHelper.$$$reportNull$$$0(4);
        }
        return list4;
    }

    protected Collection<VirtualFile> getBaseRoots(Module module) {
        return Arrays.asList(ModuleRootManager.getInstance((Module)module).getContentRoots());
    }

    public boolean isMine(@NotNull Project project2, @NotNull VirtualFile file) {
        if (project2 == null) {
            HtmlFileReferenceHelper.$$$reportNull$$$0(5);
        }
        if (file == null) {
            HtmlFileReferenceHelper.$$$reportNull$$$0(6);
        }
        if (!ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(file)) {
            return false;
        }
        FileType fileType = file.getFileType();
        return fileType == HtmlFileType.INSTANCE || fileType == XHtmlFileType.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HtmlFileReferenceHelper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HtmlFileReferenceHelper";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

