/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.generators;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import java.util.TreeSet;
import org.jetbrains.annotations.ApiStatus;

public final class LoremGenerator {
    @ApiStatus.Internal
    public static final String[] COMMON_P = "lorem ipsum dolor sit amet consectetur adipisicing elit".split(" ");
    private static final String[] WORDS = new String[]{"exercitationem", "perferendis", "perspiciatis", "laborum", "eveniet", "sunt", "iure", "nam", "nobis", "eum", "cum", "officiis", "excepturi", "odio", "consectetur", "quasi", "aut", "quisquam", "vel", "eligendi", "itaque", "non", "odit", "tempore", "quaerat", "dignissimos", "facilis", "neque", "nihil", "expedita", "vitae", "vero", "ipsum", "nisi", "animi", "cumque", "pariatur", "velit", "modi", "natus", "iusto", "eaque", "sequi", "illo", "sed", "ex", "et", "voluptatibus", "tempora", "veritatis", "ratione", "assumenda", "incidunt", "nostrum", "placeat", "aliquid", "fuga", "provident", "praesentium", "rem", "necessitatibus", "suscipit", "adipisci", "quidem", "possimus", "voluptas", "debitis", "sint", "accusantium", "unde", "sapiente", "voluptate", "qui", "aspernatur", "laudantium", "soluta", "amet", "quo", "aliquam", "saepe", "culpa", "libero", "ipsa", "dicta", "reiciendis", "nesciunt", "doloribus", "autem", "impedit", "minima", "maiores", "repudiandae", "ipsam", "obcaecati", "ullam", "enim", "totam", "delectus", "ducimus", "quis", "voluptates", "dolores", "molestiae", "harum", "dolorem", "quia", "voluptatem", "molestias", "magni", "distinctio", "omnis", "illum", "dolorum", "voluptatum", "ea", "quas", "quam", "corporis", "quae", "blanditiis", "atque", "deserunt", "laboriosam", "earum", "consequuntur", "hic", "cupiditate", "quibusdam", "accusamus", "ut", "rerum", "error", "minus", "eius", "ab", "ad", "nemo", "fugit", "officia", "at", "in", "id", "quos", "reprehenderit", "numquam", "iste", "fugiat", "sit", "inventore", "beatae", "repellendus", "magnam", "recusandae", "quod", "explicabo", "doloremque", "aperiam", "consequatur", "asperiores", "commodi", "optio", "dolor", "labore", "temporibus", "repellat", "veniam", "architecto", "est", "esse", "mollitia", "nulla", "a", "similique", "eos", "alias", "dolore", "tenetur", "deleniti", "porro", "facere", "maxime", "corrupti"};
    private final Random random = new Random();

    public String generate(int wordsCount, boolean startWithCommon) {
        String[] words2;
        LinkedList<String> sentences2 = new LinkedList<String>();
        int totalWords = 0;
        if (startWithCommon) {
            words2 = Arrays.copyOf(COMMON_P, Math.min(wordsCount, COMMON_P.length));
            if (words2.length > 5) {
                words2[4] = words2[4] + ",";
            }
            totalWords += words2.length;
            sentences2.add(LoremGenerator.sentence(words2, '.'));
        }
        while (totalWords < wordsCount) {
            words2 = this.sample(WORDS, Math.min(this.rand(3, 12) * this.rand(1, 5), wordsCount - totalWords));
            totalWords += words2.length;
            this.insertCommas(words2);
            sentences2.add(this.sentence(words2));
        }
        return StringUtil.join(sentences2, (String)" ");
    }

    private void insertCommas(String[] words2) {
        if (words2.length <= 1) {
            return;
        }
        for (int totalCommas = (len = words2.length) > 3 && len <= 6 ? this.rand(0, 1) : (len > 6 && len <= 12 ? this.rand(0, 2) : this.rand(1, 4)); totalCommas > 0; --totalCommas) {
            int i = this.rand(0, words2.length - 1);
            String word = words2[i];
            if (StringUtil.endsWithChar((CharSequence)word, (char)',')) continue;
            words2[i] = word + ",";
        }
    }

    private String sentence(String[] words2) {
        return LoremGenerator.sentence(words2, this.choice("?!..."));
    }

    private static String sentence(String[] words2, char endChar) {
        if (words2.length > 0) {
            words2[0] = StringUtil.capitalize((String)words2[0]);
        }
        return StringUtil.join((String[])words2, (String)" ") + endChar;
    }

    private int rand(int from, int to) {
        return this.random.nextInt(to - from) + from;
    }

    private String[] sample(String[] words2, int wordsCount) {
        int len = words2.length;
        int iterations = Math.min(len, wordsCount);
        TreeSet<String> result2 = new TreeSet<String>();
        while (result2.size() < iterations) {
            int i = this.rand(0, len - 1);
            result2.add(words2[i]);
        }
        return ArrayUtilRt.toStringArray(result2);
    }

    private char choice(String values) {
        return values.charAt(this.rand(0, values.length() - 1));
    }
}

