/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.utils;

import com.intellij.rml.dfa.utils.RmlLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aH\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00012\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\n0\tH\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u001a\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u001a\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0003\u001aF\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00180\t\"\u0004\b\u0000\u0010\u0019\"\u0004\b\u0001\u0010\u0018*\b\u0012\u0004\u0012\u0002H\u00190\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00012\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u00180\u001f\" \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"formatNumber", "", "num", "", "decimals", "", "baseThresholdMultiplier", "baseUnit", "units", "", "Lkotlin/Pair;", "NUMBER_UNITS", "MEMORY_SIZE_UNITS", "formatMemorySize", "bytes", "DURATION_UNITS", "formatDuration", "millis", "logProgress", "", "completed", "total", "startTime", "mapWithLogging", "R", "T", "", "loggingEnabled", "", "message", "mapper", "Lkotlin/Function1;", "intellij.rml.dfa"})
@SourceDebugExtension(value={"SMAP\nFormatHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatHelper.kt\ncom/intellij/rml/dfa/utils/FormatHelperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1#2:106\n1797#3,3:107\n1557#3:110\n1628#3,3:111\n*S KotlinDebug\n*F\n+ 1 FormatHelper.kt\ncom/intellij/rml/dfa/utils/FormatHelperKt\n*L\n8#1:107,3\n87#1:110\n87#1:111,3\n*E\n"})
public final class FormatHelperKt {
    @NotNull
    private static final List<Pair<Integer, String>> NUMBER_UNITS;
    @NotNull
    private static final List<Pair<Integer, String>> MEMORY_SIZE_UNITS;
    @NotNull
    private static final List<Pair<Integer, String>> DURATION_UNITS;

    /*
     * WARNING - void declaration
     */
    private static final String formatNumber(long num, int decimals, int baseThresholdMultiplier, String baseUnit, List<Pair<Integer, String>> units) {
        void $this$fold$iv;
        if (!(0 <= decimals ? decimals < 7 : false)) {
            boolean $i$a$-require-FormatHelperKt$formatNumber$22 = false;
            String $i$a$-require-FormatHelperKt$formatNumber$22 = "decimals must be not negative or too big, but was " + decimals;
            throw new IllegalArgumentException($i$a$-require-FormatHelperKt$formatNumber$22.toString());
        }
        Iterable $i$a$-require-FormatHelperKt$formatNumber$22 = (Iterable)RangesKt.until((int)0, (int)decimals);
        int initial$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        Iterator iterator = $this$fold$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv = ((IntIterator)iterator).nextInt();
            int a = accumulator$iv;
            boolean bl = false;
            accumulator$iv = a * 10;
        }
        int fractionMultiplier = accumulator$iv;
        long number = num;
        int fraction = 0;
        String suffix = baseUnit;
        int thresholdMultiplier = baseThresholdMultiplier;
        for (Pair<Integer, String> pair : units) {
            int divider = ((Number)pair.component1()).intValue();
            String name = (String)pair.component2();
            if (number <= (long)(divider * thresholdMultiplier)) break;
            fraction = (int)(number % (long)divider * (long)fractionMultiplier / (long)divider);
            number /= (long)divider;
            thresholdMultiplier = 1;
            suffix = name;
        }
        return fraction == 0 ? number + suffix : number + "." + StringsKt.padStart((String)String.valueOf(fraction), (int)decimals, (char)'0') + suffix;
    }

    static /* synthetic */ String formatNumber$default(long l, int n, int n2, String string2, List list2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 2;
        }
        if ((n3 & 4) != 0) {
            n2 = 4;
        }
        if ((n3 & 8) != 0) {
            string2 = "";
        }
        return FormatHelperKt.formatNumber(l, n, n2, string2, list2);
    }

    @JvmOverloads
    @NotNull
    public static final String formatNumber(long num, int decimals) {
        return FormatHelperKt.formatNumber$default(num, decimals, 0, null, NUMBER_UNITS, 12, null);
    }

    public static /* synthetic */ String formatNumber$default(long l, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        return FormatHelperKt.formatNumber(l, n);
    }

    @JvmOverloads
    @NotNull
    public static final String formatMemorySize(long bytes, int decimals) {
        return FormatHelperKt.formatNumber$default(bytes, decimals, 0, null, MEMORY_SIZE_UNITS, 12, null);
    }

    public static /* synthetic */ String formatMemorySize$default(long l, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        return FormatHelperKt.formatMemorySize(l, n);
    }

    @JvmOverloads
    @NotNull
    public static final String formatDuration(long millis, int decimals) {
        return FormatHelperKt.formatNumber$default(millis, decimals, 0, " ms", DURATION_UNITS, 4, null);
    }

    public static /* synthetic */ String formatDuration$default(long l, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        return FormatHelperKt.formatDuration(l, n);
    }

    public static final void logProgress(int completed, int total, long startTime) {
        int n;
        if (total == 0) {
            return;
        }
        long duration2 = System.currentTimeMillis() - startTime;
        if (duration2 > 60000L) {
            n = 100;
        } else if (duration2 > 3000L) {
            n = 10;
        } else {
            return;
        }
        int fraction = n;
        int prevPart = (completed - 1) * fraction / total;
        int part = completed * fraction / total;
        if (completed == 0 || part > prevPart) {
            RmlLogger.Companion.getLOG().warn(part * (100 / fraction) + "% - " + FormatHelperKt.formatDuration$default(duration2, 0, 2, null));
        }
        if (completed + 1 == total) {
            RmlLogger.Companion.getLOG().warn("100% - " + FormatHelperKt.formatDuration$default(duration2, 0, 2, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, R> List<R> mapWithLogging(@NotNull Collection<? extends T> $this$mapWithLogging, boolean loggingEnabled, @NotNull String message, @NotNull Function1<? super T, ? extends R> mapper) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$mapWithLogging, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        long startTime = System.currentTimeMillis();
        if (loggingEnabled) {
            RmlLogger.Companion.getLOG().warn(message + " started");
        }
        Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)$this$mapWithLogging);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            Object value = indexedValue.component2();
            if (loggingEnabled) {
                FormatHelperKt.logProgress(index, $this$mapWithLogging.size(), startTime);
            }
            collection.add(mapper.invoke(value));
        }
        List result2 = (List)destination$iv$iv;
        if (loggingEnabled) {
            RmlLogger.Companion.getLOG().warn(message + " finished");
        }
        return result2;
    }

    @JvmOverloads
    @NotNull
    public static final String formatNumber(long num) {
        return FormatHelperKt.formatNumber$default(num, 0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final String formatMemorySize(long bytes) {
        return FormatHelperKt.formatMemorySize$default(bytes, 0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final String formatDuration(long millis) {
        return FormatHelperKt.formatDuration$default(millis, 0, 2, null);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)1000, (Object)"K"), TuplesKt.to((Object)1000, (Object)"M"), TuplesKt.to((Object)1000, (Object)"G")};
        NUMBER_UNITS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)1024, (Object)" KiB"), TuplesKt.to((Object)1024, (Object)" MiB"), TuplesKt.to((Object)1024, (Object)" GiB")};
        MEMORY_SIZE_UNITS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)1000, (Object)" sec"), TuplesKt.to((Object)60, (Object)" min"), TuplesKt.to((Object)60, (Object)" hr"), TuplesKt.to((Object)24, (Object)" days")};
        DURATION_UNITS = CollectionsKt.listOf((Object[])objectArray);
    }
}

