/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.utils.graph;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.rml.dfa.utils.graph.IntGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\u0004H\u0016J\u0015\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\u001a\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u001a0\u0018H\u0016J\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/intellij/rml/dfa/utils/graph/GraphImpl;", "T", "Lcom/intellij/rml/dfa/utils/graph/Graph;", "graph", "Lcom/intellij/rml/dfa/utils/graph/IntGraph;", "nodeToId", "", "", "idToNode", "<init>", "(Lcom/intellij/rml/dfa/utils/graph/IntGraph;Ljava/util/Map;Ljava/util/Map;)V", "toIntGraph", "getIdByNode", "node", "(Ljava/lang/Object;)I", "getNodeById", "id", "(I)Ljava/lang/Object;", "nodesCnt", "getNodesCnt", "()I", "edgesCnt", "getEdgesCnt", "nodes", "", "edges", "Lkotlin/Pair;", "outgoingNodes", "(Ljava/lang/Object;)Ljava/util/Set;", "incomingNodes", "intellij.rml.dfa"})
@SourceDebugExtension(value={"SMAP\nGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Graph.kt\ncom/intellij/rml/dfa/utils/graph/GraphImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1557#2:231\n1628#2,3:232\n1557#2:235\n1628#2,3:236\n1557#2:239\n1628#2,3:240\n1557#2:243\n1628#2,3:244\n*S KotlinDebug\n*F\n+ 1 Graph.kt\ncom/intellij/rml/dfa/utils/graph/GraphImpl\n*L\n58#1:231\n58#1:232,3\n62#1:235\n62#1:236,3\n66#1:239\n66#1:240,3\n70#1:243\n70#1:244,3\n*E\n"})
public final class GraphImpl<T>
implements Graph<T> {
    @NotNull
    private final IntGraph graph;
    @NotNull
    private final Map<T, Integer> nodeToId;
    @NotNull
    private final Map<Integer, T> idToNode;
    private final int nodesCnt;
    private final int edgesCnt;

    public GraphImpl(@NotNull IntGraph graph, @NotNull Map<T, Integer> nodeToId, @NotNull Map<Integer, ? extends T> idToNode) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(nodeToId, (String)"nodeToId");
        Intrinsics.checkNotNullParameter(idToNode, (String)"idToNode");
        this.graph = graph;
        this.nodeToId = nodeToId;
        this.idToNode = idToNode;
        if (!(CollectionsKt.toSet((Iterable)this.nodeToId.values()).size() == this.nodeToId.size() && Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)this.nodeToId.values()), this.graph.nodes()))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.nodesCnt = this.graph.getNodesCnt();
        this.edgesCnt = this.graph.getEdgesCnt();
    }

    @Override
    @NotNull
    public IntGraph toIntGraph() {
        return this.graph;
    }

    @Override
    public int getIdByNode(T node) {
        Integer n = this.nodeToId.get(node);
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    @Override
    public T getNodeById(int id) {
        T t = this.idToNode.get(id);
        if (t == null) {
            throw new DfaInternalException("Node with id=" + id + " doesn't exist");
        }
        return t;
    }

    @Override
    public int getNodesCnt() {
        return this.nodesCnt;
    }

    @Override
    public int getEdgesCnt() {
        return this.edgesCnt;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<T> nodes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.graph.nodes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getNodeById((int)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Pair<T, T>> edges() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.graph.edges();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair(this.getNodeById(((Number)it.getFirst()).intValue()), this.getNodeById(((Number)it.getSecond()).intValue())));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<T> outgoingNodes(T node) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.graph.get(this.getIdByNode(node));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getNodeById((int)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<T> incomingNodes(T node) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.graph.incomingNodes(this.getIdByNode(node));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getNodeById((int)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

