/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.ide.impl.ProjectUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ReportValue;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.serialization.SerializationException;
import com.intellij.tasks.BranchInfo;
import com.intellij.tasks.ChangeListInfo;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskListener;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.context.WorkingContextManager;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.TaskManagementUsageCollector;
import com.intellij.tasks.impl.TaskProjectConfiguration;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import javax.swing.Timer;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

@State(name="TaskManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class TaskManagerImpl
extends TaskManager
implements PersistentStateComponent<Config>,
Disposable {
    private static final Logger LOG = Logger.getInstance(TaskManagerImpl.class);
    private static final DecimalFormat LOCAL_TASK_ID_FORMAT = new DecimalFormat("LOCAL-00000");
    public static final Comparator<Task> TASK_UPDATE_COMPARATOR = (o1, o2) -> {
        int i = Comparing.compare((Comparable)o2.getUpdated(), (Comparable)o1.getUpdated());
        return i == 0 ? Comparing.compare((Comparable)o2.getCreated(), (Comparable)o1.getCreated()) : i;
    };
    private static final Convertor<Task, String> KEY_CONVERTOR = o -> o.getId();
    private final Project myProject;
    private final Map<String, Task> myIssueCache;
    private final Map<String, LocalTaskImpl> myTasks;
    @NotNull
    private LocalTaskImpl myActiveTask;
    private Timer myCacheRefreshTimer;
    private volatile boolean myUpdating;
    private final Config myConfig;
    private final ChangeListAdapter myChangeListListener;
    private final List<TaskRepository> myRepositories;
    private final EventDispatcher<TaskListener> myDispatcher;
    private final Set<TaskRepository> myBadRepositories;

    public TaskManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(0);
        }
        this.myIssueCache = Collections.synchronizedMap(new LinkedHashMap());
        this.myTasks = Collections.synchronizedMap(new LinkedHashMap<String, LocalTaskImpl>(){

            @Override
            public LocalTaskImpl put(String key2, LocalTaskImpl task) {
                LocalTaskImpl result2 = super.put(key2, task);
                if (this.size() > TaskManagerImpl.this.myConfig.taskHistoryLength) {
                    ArrayList list2 = new ArrayList(this.entrySet());
                    list2.sort((o1, o2) -> TASK_UPDATE_COMPARATOR.compare((Task)o2.getValue(), (Task)o1.getValue()));
                    for (Map.Entry oldest : list2) {
                        LocalTask value = (LocalTask)oldest.getValue();
                        if (value.isDefault() || !value.isClosed()) continue;
                        this.remove(oldest.getKey());
                        break;
                    }
                }
                return result2;
            }
        });
        this.myActiveTask = TaskManagerImpl.createDefaultTask();
        this.myConfig = new Config();
        this.myRepositories = new ArrayList<TaskRepository>();
        this.myDispatcher = EventDispatcher.create(TaskListener.class);
        this.myBadRepositories = ConcurrentCollectionFactory.createConcurrentSet();
        this.myProject = project2;
        this.myChangeListListener = new ChangeListAdapter(){

            @Override
            public void changeListRemoved(ChangeList list2) {
                LocalTask task = TaskManagerImpl.this.getAssociatedTask((LocalChangeList)list2);
                if (task != null) {
                    for (ChangeListInfo info : task.getChangeLists()) {
                        if (!Objects.equals(info.id, ((LocalChangeList)list2).getId())) continue;
                        info.id = "";
                    }
                }
            }

            @Override
            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList, boolean automatic) {
                if (automatic) {
                    return;
                }
                LocalTask associatedTask = TaskManagerImpl.this.getAssociatedTask((LocalChangeList)newDefaultList);
                if (associatedTask != null && !TaskManagerImpl.this.getActiveTask().equals(associatedTask)) {
                    ApplicationManager.getApplication().invokeLater(() -> TaskManagerImpl.this.activateTask(associatedTask, true), TaskManagerImpl.this.myProject.getDisposed());
                }
            }
        };
        TaskRepositoryType.addEPListChangeListener(this, () -> {
            List<TaskRepository> repositories = this.myRepositories;
            List<Class<?>> possibleRepositoryClasses = TaskRepositoryType.getRepositoryClasses();
            boolean removed = repositories.removeIf(repository -> !ContainerUtil.exists((Iterable)possibleRepositoryClasses, clazz -> clazz.isAssignableFrom(repository.getClass())));
            if (removed) {
                this.setRepositories(repositories);
            }
        });
    }

    @TestOnly
    public void prepareForNextTest() {
        this.myTasks.clear();
        LocalTaskImpl defaultTask = TaskManagerImpl.createDefaultTask();
        this.addTask(defaultTask);
        this.myActiveTask = defaultTask;
        this.setRepositories(Collections.emptyList());
    }

    @Override
    public TaskRepository[] getAllRepositories() {
        return this.myRepositories.toArray(new TaskRepository[0]);
    }

    public <T extends TaskRepository> void setRepositories(@NotNull List<T> repositories) {
        if (repositories == null) {
            TaskManagerImpl.$$$reportNull$$$0(1);
        }
        HashSet<TaskRepository> set = new HashSet<TaskRepository>(this.myRepositories);
        repositories.forEach(set::remove);
        this.myBadRepositories.removeAll(set);
        this.myIssueCache.clear();
        this.myRepositories.clear();
        this.myRepositories.addAll(repositories);
        List<TaskProjectConfiguration.SharedServer> servers = this.getProjectConfiguration().servers;
        servers.clear();
        block0: for (TaskRepository repository : repositories) {
            if (!repository.isShared() || repository.getUrl() == null) continue;
            TaskRepositoryType type = repository.getRepositoryType();
            for (TaskProjectConfiguration.SharedServer server : servers) {
                if (!repository.getUrl().equals(server.url) || !type.getName().equals(server.type)) continue;
                continue block0;
            }
            TaskProjectConfiguration.SharedServer server = new TaskProjectConfiguration.SharedServer();
            server.type = type.getName();
            server.url = repository.getUrl();
            servers.add(server);
        }
        this.clearNonExistentRepositoriesFromTasks();
    }

    private void clearNonExistentRepositoriesFromTasks() {
        for (LocalTaskImpl task : this.myTasks.values()) {
            TaskRepository repository = task.getRepository();
            if (repository == null || this.myRepositories.contains(repository)) continue;
            task.setRepository(null);
        }
    }

    @Override
    public void removeTask(@NotNull LocalTask task) {
        if (task == null) {
            TaskManagerImpl.$$$reportNull$$$0(2);
        }
        if (task.isDefault()) {
            return;
        }
        if (this.myActiveTask.equals(task)) {
            this.activateTask(this.myTasks.get("Default"), true);
        }
        this.myTasks.remove(task.getId());
        ((TaskListener)this.myDispatcher.getMulticaster()).taskRemoved(task);
        WorkingContextManager.getInstance(this.myProject).removeContext(task);
    }

    @Override
    public void addTaskListener(@NotNull TaskListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            TaskManagerImpl.$$$reportNull$$$0(4);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    @NotNull
    public LocalTask getActiveTask() {
        LocalTaskImpl localTaskImpl = this.myActiveTask;
        if (localTaskImpl == null) {
            TaskManagerImpl.$$$reportNull$$$0(5);
        }
        return localTaskImpl;
    }

    @Override
    @Nullable
    public LocalTaskImpl findTask(String id) {
        return this.myTasks.get(id);
    }

    @Override
    @NotNull
    public @Unmodifiable List<Task> getIssues(@Nullable String query) {
        List<Task> list2 = this.getIssues(query, true);
        if (list2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    public @Unmodifiable List<Task> getIssues(@Nullable String query, boolean forceRequest) {
        return this.getIssues(query, 0, 50, true, (ProgressIndicator)new EmptyProgressIndicator(), forceRequest);
    }

    @Override
    public @Unmodifiable List<Task> getIssues(@Nullable String query, int offset, int limit, boolean withClosed, @NotNull ProgressIndicator indicator, boolean forceRequest) {
        List<Task> tasks;
        if (indicator == null) {
            TaskManagerImpl.$$$reportNull$$$0(7);
        }
        if ((tasks = this.getIssuesFromRepositories(query, offset, limit, withClosed, forceRequest, indicator)) == null) {
            return this.getCachedIssues(withClosed);
        }
        this.myIssueCache.putAll(ContainerUtil.newMapFromValues(tasks.iterator(), KEY_CONVERTOR));
        return ContainerUtil.filter(tasks, task -> withClosed || !task.isClosed());
    }

    @Override
    public @Unmodifiable List<Task> getCachedIssues() {
        return this.getCachedIssues(true);
    }

    @Override
    public @Unmodifiable List<Task> getCachedIssues(boolean withClosed) {
        return ContainerUtil.filter(this.myIssueCache.values(), task -> withClosed || !task.isClosed());
    }

    private void updateIssue(@NotNull String id) {
        if (id == null) {
            TaskManagerImpl.$$$reportNull$$$0(8);
        }
        for (TaskRepository repository : this.getAllRepositories()) {
            if (repository.extractId(id) == null) continue;
            try {
                LOG.info("Searching for task '" + id + "' in " + String.valueOf(repository));
                Task issue = repository.findTask(id);
                if (issue == null) continue;
                LocalTaskImpl localTask = this.findTask(id);
                if (localTask != null) {
                    ((LocalTask)localTask).updateFromIssue(issue);
                    return;
                }
                return;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
    }

    @Override
    public @Unmodifiable List<LocalTask> getLocalTasks() {
        return this.getLocalTasks(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Unmodifiable List<LocalTask> getLocalTasks(boolean withClosed) {
        Map<String, LocalTaskImpl> map = this.myTasks;
        synchronized (map) {
            return ContainerUtil.filter(this.myTasks.values(), task -> withClosed || !this.isLocallyClosed((LocalTask)task));
        }
    }

    @Override
    public LocalTask addTask(@NotNull Task issue) {
        if (issue == null) {
            TaskManagerImpl.$$$reportNull$$$0(9);
        }
        LocalTaskImpl task = issue instanceof LocalTaskImpl ? (LocalTaskImpl)issue : new LocalTaskImpl(issue);
        this.addTask(task);
        return task;
    }

    @Override
    public LocalTaskImpl createLocalTask(@NotNull @Nls String summary2) {
        if (summary2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(10);
        }
        return TaskManagerImpl.createTask(LOCAL_TASK_ID_FORMAT.format(this.myConfig.localTasksCounter++), summary2);
    }

    private static LocalTaskImpl createTask(@NotNull String id, @NotNull @Nls String summary2) {
        if (id == null) {
            TaskManagerImpl.$$$reportNull$$$0(11);
        }
        if (summary2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(12);
        }
        LocalTaskImpl task = new LocalTaskImpl(id, summary2);
        Date date = new Date();
        task.setCreated(date);
        task.setUpdated(date);
        return task;
    }

    @Override
    public LocalTask activateTask(@NotNull Task origin, boolean clearContext) {
        if (origin == null) {
            TaskManagerImpl.$$$reportNull$$$0(13);
        }
        return this.activateTask(origin, clearContext, false);
    }

    public LocalTask activateTask(@NotNull Task origin, boolean clearContext, boolean newTask) {
        LocalTask activeTask;
        if (origin == null) {
            TaskManagerImpl.$$$reportNull$$$0(14);
        }
        if (origin.equals(activeTask = this.getActiveTask())) {
            return activeTask;
        }
        this.saveActiveTask();
        LocalTask task = this.doActivate(origin, true);
        Runnable restore = () -> {
            WorkingContextManager contextManager = WorkingContextManager.getInstance(this.myProject);
            if (clearContext) {
                contextManager.clearContext();
            }
            contextManager.restoreContext(origin);
        };
        boolean switched = false;
        if (this.isVcsEnabled()) {
            this.restoreVcsContext(task, newTask);
            if (!newTask) {
                switched = this.switchBranch(task, restore);
            }
        }
        if (!switched) {
            restore.run();
        }
        return task;
    }

    private void restoreVcsContext(LocalTask task, boolean newTask) {
        List<ChangeListInfo> changeLists = task.getChangeLists();
        ChangeListManager changeListManager = ChangeListManager.getInstance(this.myProject);
        if (changeLists.isEmpty() || !changeListManager.areChangeListsEnabled()) {
            task.getChangeLists().clear();
            task.addChangelist(new ChangeListInfo(changeListManager.getDefaultChangeList()));
        } else {
            ChangeListInfo info = changeLists.get(0);
            LocalChangeList changeList = changeListManager.getChangeList(info.id);
            if (changeList == null) {
                changeList = changeListManager.addChangeList(info.name, info.comment);
                info.id = changeList.getId();
            }
            changeListManager.setDefaultChangeList(changeList);
        }
        this.unshelveChanges(task);
    }

    private boolean switchBranch(LocalTask task, Runnable invokeAfter) {
        List<BranchInfo> branches = task.getBranches(false);
        MultiMap multiMap = new MultiMap();
        for (BranchInfo branch : branches) {
            multiMap.putValue((Object)branch.repository, (Object)branch);
        }
        block1: for (String repo : multiMap.keySet()) {
            Collection infos = multiMap.get((Object)repo);
            if (infos.size() <= 1) continue;
            List<BranchInfo> existing = this.getAllBranches(repo);
            Iterator iterator = infos.iterator();
            while (iterator.hasNext()) {
                BranchInfo info = (BranchInfo)iterator.next();
                if (existing.contains(info)) continue;
                iterator.remove();
                if (infos.size() != 1) continue;
                continue block1;
            }
        }
        VcsTaskHandler.TaskInfo info = TaskManagerImpl.fromBranches(new ArrayList(multiMap.values()));
        VcsTaskHandler[] handlers = VcsTaskHandler.getAllHandlers(this.myProject);
        boolean switched = false;
        for (VcsTaskHandler handler2 : handlers) {
            switched |= handler2.switchToTask(info, invokeAfter);
        }
        return switched;
    }

    public void shelveChanges(LocalTask task, @NotNull String shelfName) {
        Collection<Change> changes;
        if (shelfName == null) {
            TaskManagerImpl.$$$reportNull$$$0(15);
        }
        if ((changes = ChangeListManager.getInstance(this.myProject).getDefaultChangeList().getChanges()).isEmpty()) {
            return;
        }
        try {
            ShelveChangesManager.getInstance((Project)this.myProject).shelveChanges(changes, shelfName, true);
            task.setShelfName(shelfName);
        }
        catch (Exception e) {
            LOG.warn("Can't shelve changes", (Throwable)e);
        }
    }

    private void unshelveChanges(LocalTask task) {
        String name = task.getShelfName();
        if (name != null) {
            ShelveChangesManager manager = ShelveChangesManager.getInstance((Project)this.myProject);
            for (ShelvedChangeList list2 : manager.getShelvedChangeLists()) {
                if (!name.equals(list2.getDescription())) continue;
                manager.unshelveChangeList(list2, null, list2.getBinaryFiles(), null, true);
                return;
            }
        }
    }

    private List<BranchInfo> getAllBranches(String repo) {
        VcsTaskHandler[] handlers;
        ArrayList<BranchInfo> infos = new ArrayList<BranchInfo>();
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers(this.myProject)) {
            VcsTaskHandler.TaskInfo[] tasks;
            for (VcsTaskHandler.TaskInfo info : tasks = handler2.getAllExistingTasks()) {
                infos.addAll(ContainerUtil.filter(BranchInfo.fromTaskInfo(info, false), info1 -> Objects.equals(info1.repository, repo)));
            }
        }
        return infos;
    }

    private static VcsTaskHandler.TaskInfo fromBranches(List<? extends BranchInfo> branches) {
        if (branches.isEmpty()) {
            return new VcsTaskHandler.TaskInfo(null, Collections.emptyList());
        }
        MultiMap map = new MultiMap();
        for (BranchInfo branchInfo : branches) {
            map.putValue((Object)branchInfo.name, (Object)branchInfo.repository);
        }
        Map.Entry next = (Map.Entry)map.entrySet().iterator().next();
        return new VcsTaskHandler.TaskInfo((String)next.getKey(), (Collection)next.getValue());
    }

    public void createBranch(LocalTask task, LocalTask previousActive, String name, @Nullable VcsTaskHandler.TaskInfo branchFrom) {
        VcsTaskHandler[] handlers;
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers(this.myProject)) {
            VcsTaskHandler.TaskInfo[] info = handler2.getCurrentTasks();
            if (previousActive != null && previousActive.getBranches(false).isEmpty()) {
                TaskManagerImpl.addBranches(previousActive, info, false);
            }
            TaskManagerImpl.addBranches(task, info, true);
            if (info.length == 0 && branchFrom != null) {
                TaskManagerImpl.addBranches(task, new VcsTaskHandler.TaskInfo[]{branchFrom}, true);
            }
            TaskManagerImpl.addBranches(task, new VcsTaskHandler.TaskInfo[]{handler2.startNewTask(name)}, false);
        }
    }

    public void mergeBranch(LocalTask task) {
        VcsTaskHandler[] handlers;
        VcsTaskHandler.TaskInfo original = TaskManagerImpl.fromBranches(task.getBranches(true));
        VcsTaskHandler.TaskInfo feature = TaskManagerImpl.fromBranches(task.getBranches(false));
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers(this.myProject)) {
            handler2.closeTask(feature, original);
        }
    }

    public static void addBranches(LocalTask task, VcsTaskHandler.TaskInfo[] info, boolean original) {
        for (VcsTaskHandler.TaskInfo taskInfo : info) {
            List<BranchInfo> branchInfos = BranchInfo.fromTaskInfo(taskInfo, original);
            for (BranchInfo branchInfo : branchInfos) {
                task.addBranch(branchInfo);
            }
        }
    }

    private void saveActiveTask() {
        WorkingContextManager.getInstance(this.myProject).saveContext(this.myActiveTask);
        this.myActiveTask.setUpdated(new Date());
        String shelfName = this.myActiveTask.getShelfName();
        if (shelfName != null) {
            this.shelveChanges(this.myActiveTask, shelfName);
        }
    }

    private LocalTask doActivate(Task origin, boolean explicitly) {
        LocalTaskImpl oldActiveTask;
        LocalTaskImpl task;
        LocalTaskImpl localTaskImpl = task = origin instanceof LocalTaskImpl ? (LocalTaskImpl)origin : new LocalTaskImpl(origin);
        if (explicitly) {
            TaskManagementUsageCollector.logExplicitlyActivatedTask(this.myProject);
            task.setUpdated(new Date());
        }
        this.myActiveTask.setActive(false);
        task.setActive(true);
        this.addTask(task);
        if (task.isIssue()) {
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> ProgressManager.getInstance().run((com.intellij.openapi.progress.Task)new Task.Backgroundable(this.myProject, TaskBundle.message("progress.title.updating", task.getPresentableId())){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    TaskManagerImpl.this.updateIssue(task.getId());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/impl/TaskManagerImpl$3", "run"));
                }
            }));
        }
        boolean isChanged = !task.equals(oldActiveTask = this.myActiveTask);
        this.myActiveTask = task;
        if (isChanged) {
            ((TaskListener)this.myDispatcher.getMulticaster()).taskDeactivated(oldActiveTask);
            ((TaskListener)this.myDispatcher.getMulticaster()).taskActivated(task);
        }
        return task;
    }

    private void addTask(@NotNull LocalTaskImpl task) {
        if (task == null) {
            TaskManagerImpl.$$$reportNull$$$0(16);
        }
        this.myTasks.put(task.getId(), task);
        ((TaskListener)this.myDispatcher.getMulticaster()).taskAdded(task);
    }

    @Override
    public boolean testConnection(final TaskRepository repository) {
        TestConnectionTask task = new TestConnectionTask(TaskBundle.message("dialog.title.test.connection", new Object[0])){

            /*
             * Unable to fully structure code
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                indicator.setText(TaskBundle.message("progress.text.connecting.to", new Object[]{repository.getUrl()}));
                indicator.setFraction(0.0);
                indicator.setIndeterminate(true);
                try {
                    this.myConnection = repository.createCancellableConnection();
                    if (this.myConnection != null) {
                        future = ApplicationManager.getApplication().executeOnPooledThread((Callable)this.myConnection);
                        while (true) lbl-1000:
                        // 2 sources

                        {
                            try {
                                this.myException = (Exception)future.get(100L, TimeUnit.MILLISECONDS);
                                return;
                            }
                            catch (TimeoutException ignore) {
                                try {
                                    indicator.checkCanceled();
                                    continue;
                                }
                                catch (ProcessCanceledException e) {
                                    this.myException = e;
                                    this.myConnection.cancel();
                                    return;
                                }
                            }
                            ** while (true)
                            catch (Exception e) {
                                this.myException = e;
                                return;
                            }
                            break;
                        }
                    }
                    try {
                        repository.testConnection();
                    }
                    catch (Exception e) {
                        TaskManagerImpl.LOG.info((Throwable)e);
                        this.myException = e;
                    }
                }
                catch (Exception e) {
                    this.myException = e;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/impl/TaskManagerImpl$4", "run"));
            }
        };
        ProgressManager.getInstance().run((com.intellij.openapi.progress.Task)task);
        Exception e = task.myException;
        if (e == null) {
            this.myBadRepositories.remove(repository);
            Messages.showMessageDialog((Project)this.myProject, (String)TaskBundle.message("dialog.message.connection.successful", new Object[0]), (String)TaskBundle.message("dialog.title.connection", new Object[0]), (Icon)Messages.getInformationIcon());
        } else if (!(e instanceof ProcessCanceledException)) {
            String message = e.getMessage();
            if (e instanceof UnknownHostException) {
                message = TaskBundle.message("dialog.message.unknown.host", message);
            }
            if (message == null) {
                LOG.error((Throwable)e);
                message = TaskBundle.message("dialog.message.unknown.error", new Object[0]);
            }
            Messages.showErrorDialog((Project)this.myProject, (String)StringUtil.capitalize((String)message), (String)TaskBundle.message("dialog.title.error", new Object[0]));
        }
        return e == null;
    }

    @NotNull
    public Config getState() {
        this.myConfig.tasks = ContainerUtil.map(this.myTasks.values(), task -> new LocalTaskImpl((Task)task));
        this.myConfig.servers = XmlSerializer.serialize((Object)this.getAllRepositories());
        Config config = this.myConfig;
        if (config == null) {
            TaskManagerImpl.$$$reportNull$$$0(17);
        }
        return config;
    }

    public void loadState(@NotNull Config config) {
        if (config == null) {
            TaskManagerImpl.$$$reportNull$$$0(18);
        }
        config.branchNameFormat = TaskUtil.updateToVelocity(config.branchNameFormat);
        config.changelistNameFormat = TaskUtil.updateToVelocity(config.changelistNameFormat);
        XmlSerializerUtil.copyBean((Object)config, (Object)this.myConfig);
        this.myRepositories.clear();
        Element element = config.servers;
        ArrayList<TaskRepository> repositories = TaskManagerImpl.loadRepositories(element);
        this.myRepositories.addAll(repositories);
        this.myTasks.clear();
        for (LocalTaskImpl task : config.tasks) {
            String url;
            if (task.getRepository() == null && (url = task.getIssueUrl()) != null) {
                for (TaskRepository repository : repositories) {
                    if (repository.getUrl() == null || !url.startsWith(repository.getUrl())) continue;
                    task.setRepository(repository);
                }
            }
            this.addTask(task);
        }
    }

    public static ArrayList<TaskRepository> loadRepositories(@NotNull Element element) {
        if (element == null) {
            TaskManagerImpl.$$$reportNull$$$0(19);
        }
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        if (element.getChildren().isEmpty()) {
            return repositories;
        }
        for (TaskRepositoryType<?> repositoryType : TaskRepositoryType.getRepositoryTypes()) {
            for (Element o : element.getChildren(repositoryType.getName())) {
                try {
                    TaskRepository repository = (TaskRepository)XmlSerializer.deserialize((Element)o, repositoryType.getRepositoryClass());
                    repository.setRepositoryType(repositoryType);
                    repository.initializeRepository();
                    repositories.add(repository);
                }
                catch (SerializationException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return repositories;
    }

    @TestOnly
    public void callProjectOpened() {
        this.projectOpened();
    }

    void projectOpened() {
        TaskProjectConfiguration projectConfiguration = this.getProjectConfiguration();
        block0: for (TaskProjectConfiguration.SharedServer server : projectConfiguration.servers) {
            if (server.type == null || server.url == null) continue;
            for (TaskRepositoryType<?> repositoryType : TaskRepositoryType.getRepositoryTypes()) {
                if (!repositoryType.getName().equals(server.type)) continue;
                for (TaskRepository repository : this.myRepositories) {
                    if (!repositoryType.equals(repository.getRepositoryType()) || !server.url.equals(repository.getUrl())) continue;
                    continue block0;
                }
                TaskRepository repository = repositoryType.createRepository();
                repository.setUrl(server.url);
                repository.setShared(true);
                this.myRepositories.add(repository);
            }
        }
        LocalTaskImpl defaultTask = this.findTask("Default");
        ChangeListManager changeListManager = ChangeListManager.getInstance(this.myProject);
        LocalChangeList defaultList = changeListManager.findChangeList(LocalChangeList.getDefaultName());
        if (defaultList != null && defaultTask != null) {
            ChangeListInfo listInfo = new ChangeListInfo(defaultList);
            if (!((LocalTask)defaultTask).getChangeLists().contains(listInfo)) {
                ((LocalTask)defaultTask).addChangelist(listInfo);
            }
        }
        for (LocalTask localTask : this.getLocalTasks()) {
            Iterator<ChangeListInfo> iterator = localTask.getChangeLists().iterator();
            while (iterator.hasNext()) {
                ChangeListInfo changeListInfo = iterator.next();
                if (changeListManager.getChangeList(changeListInfo.id) != null) continue;
                iterator.remove();
            }
        }
        changeListManager.addChangeListListener(this.myChangeListListener, (Disposable)this.myProject);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ProjectUtilKt.executeOnPooledThread((Project)this.myProject, () -> WorkingContextManager.getInstance(this.myProject).pack(200, 50));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.startRefreshTimer();
        }
    }

    private TaskProjectConfiguration getProjectConfiguration() {
        return (TaskProjectConfiguration)this.myProject.getService(TaskProjectConfiguration.class);
    }

    public void initializeComponent() {
        LocalTaskImpl defaultTask = this.findTask("Default");
        if (defaultTask == null) {
            defaultTask = TaskManagerImpl.createDefaultTask();
            this.addTask(defaultTask);
        }
        LocalTaskImpl activeTask = null;
        List tasks = ContainerUtil.map((Collection)ContainerUtil.sorted(this.getLocalTasks(), TASK_UPDATE_COMPARATOR), task -> (LocalTaskImpl)task);
        for (LocalTaskImpl task2 : tasks) {
            if (activeTask == null) {
                if (!task2.isActive()) continue;
                activeTask = task2;
                continue;
            }
            task2.setActive(false);
        }
        if (activeTask == null) {
            activeTask = defaultTask;
        }
        this.myActiveTask = activeTask;
        this.doActivate(this.myActiveTask, false);
        ((TaskListener)this.myDispatcher.getMulticaster()).taskActivated(this.myActiveTask);
    }

    void startRefreshTimer() {
        this.myCacheRefreshTimer = TimerUtil.createNamedTimer((String)"TaskManager refresh", (int)(this.myConfig.updateInterval * 60 * 1000), (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (TaskManagerImpl.this.myConfig.updateEnabled && !TaskManagerImpl.this.myUpdating) {
                    LOG.debug("Updating issues cache (every " + TaskManagerImpl.this.myConfig.updateInterval + " min)");
                    TaskManagerImpl.this.updateIssues(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/impl/TaskManagerImpl$5", "actionPerformed"));
            }
        });
        this.myCacheRefreshTimer.setInitialDelay(0);
        this.myCacheRefreshTimer.start();
    }

    @NotNull
    private static LocalTaskImpl createDefaultTask() {
        LocalTaskImpl task = new LocalTaskImpl("Default", TaskBundle.message("default.task", new Object[0]));
        Date date = new Date();
        task.setCreated(date);
        task.setUpdated(date);
        LocalTaskImpl localTaskImpl = task;
        if (localTaskImpl == null) {
            TaskManagerImpl.$$$reportNull$$$0(20);
        }
        return localTaskImpl;
    }

    public void dispose() {
        if (this.myCacheRefreshTimer != null) {
            this.myCacheRefreshTimer.stop();
        }
    }

    @Override
    public void updateIssues(@Nullable Runnable onComplete) {
        TaskRepository first = (TaskRepository)ContainerUtil.find((Object[])this.getAllRepositories(), repository -> repository.isConfigured());
        if (first == null) {
            this.myIssueCache.clear();
            if (onComplete != null) {
                onComplete.run();
            }
            return;
        }
        this.myUpdating = true;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doUpdate(onComplete);
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.doUpdate(onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(@Nullable Runnable onComplete) {
        try {
            List<Task> issues = this.getIssuesFromRepositories(null, 0, this.myConfig.updateIssuesCount, false, false, (ProgressIndicator)new EmptyProgressIndicator());
            if (issues == null) {
                return;
            }
            Map<String, Task> map = this.myIssueCache;
            synchronized (map) {
                this.myIssueCache.clear();
                for (Task task : issues) {
                    this.myIssueCache.put(task.getId(), task);
                }
            }
            map = this.myTasks;
            synchronized (map) {
                for (Map.Entry entry2 : this.myTasks.entrySet()) {
                    Task issue = this.myIssueCache.get(entry2.getKey());
                    if (issue == null) continue;
                    ((LocalTaskImpl)entry2.getValue()).updateFromIssue(issue);
                }
            }
        }
        finally {
            if (onComplete != null) {
                onComplete.run();
            }
            this.myUpdating = false;
        }
    }

    @Nullable
    private List<Task> getIssuesFromRepositories(@Nullable String request, int offset, int limit, boolean withClosed, boolean forceRequest, @NotNull ProgressIndicator cancelled) {
        if (cancelled == null) {
            TaskManagerImpl.$$$reportNull$$$0(21);
        }
        ArrayList<Task> issues = null;
        for (TaskRepository repository : this.getAllRepositories()) {
            if (!repository.isConfigured() || !forceRequest && this.myBadRepositories.contains(repository)) continue;
            try {
                long start2 = System.currentTimeMillis();
                TaskManagementUsageCollector.logCollectRemoteTasks(this.myProject, repository);
                Object[] tasks = repository.getIssues(request, offset, limit, withClosed, cancelled);
                long timeSpent = System.currentTimeMillis() - start2;
                LOG.debug(String.format("Total %s ms to download %d issues from '%s' (pattern '%s')", timeSpent, tasks.length, repository.getUrl(), request));
                this.myBadRepositories.remove(repository);
                if (issues == null) {
                    issues = new ArrayList<Task>(tasks.length);
                }
                if (!repository.isSupported(16) && request != null) {
                    List<Task> filteredTasks = TaskUtil.filterTasks(request, Arrays.asList(tasks));
                    issues.addAll(filteredTasks);
                    continue;
                }
                ContainerUtil.addAll(issues, (Object[])tasks);
            }
            catch (ProcessCanceledException start2) {
            }
            catch (Exception e) {
                String reason = "";
                if (e.getClass() == Exception.class || e instanceof RequestFailedException) {
                    reason = e.getMessage();
                }
                if (e instanceof SocketTimeoutException || e instanceof HttpRequests.HttpStatusException) {
                    LOG.warn("Can't connect to " + String.valueOf(repository) + ": " + e.getMessage());
                } else {
                    LOG.warn("Cannot connect to " + String.valueOf(repository), (Throwable)e);
                }
                this.myBadRepositories.add(repository);
                if (!forceRequest) continue;
                throw new RequestFailedException(repository, reason);
            }
        }
        return issues;
    }

    @Override
    public boolean isVcsEnabled() {
        return ProjectLevelVcsManager.getInstance(this.myProject).getAllActiveVcss().length > 0;
    }

    @Override
    public AbstractVcs getActiveVcs() {
        AbstractVcs[] vcss = ProjectLevelVcsManager.getInstance(this.myProject).getAllActiveVcss();
        if (vcss.length == 0) {
            return null;
        }
        for (AbstractVcs vcs : vcss) {
            if (vcs.getType() != VcsType.distributed) continue;
            return vcs;
        }
        return vcss[0];
    }

    @Override
    public boolean isLocallyClosed(@NotNull LocalTask localTask) {
        if (localTask == null) {
            TaskManagerImpl.$$$reportNull$$$0(22);
        }
        if (!this.isVcsEnabled()) {
            return false;
        }
        List<ChangeListInfo> lists = localTask.getChangeLists();
        return lists.isEmpty() || ContainerUtil.exists(lists, list2 -> StringUtil.isEmpty((String)list2.id));
    }

    @Override
    @Nullable
    public LocalTask getAssociatedTask(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(23);
        }
        if (TaskManagerImpl.hasChangelist(this.getActiveTask(), list2)) {
            return this.getActiveTask();
        }
        for (LocalTask task : this.getLocalTasks()) {
            if (!TaskManagerImpl.hasChangelist(task, list2)) continue;
            return task;
        }
        return null;
    }

    private static boolean hasChangelist(LocalTask task, LocalChangeList list2) {
        for (ChangeListInfo changeListInfo : new ArrayList<ChangeListInfo>(task.getChangeLists())) {
            if (!changeListInfo.id.equals(list2.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void trackContext(@NotNull LocalChangeList changeList) {
        if (changeList == null) {
            TaskManagerImpl.$$$reportNull$$$0(24);
        }
        ChangeListInfo changeListInfo = new ChangeListInfo(changeList);
        String changeListName = changeList.getName();
        LocalTaskImpl task = this.createLocalTask(changeListName);
        task.addChangelist(changeListInfo);
        this.addTask(task);
        if (changeList.isDefault()) {
            this.activateTask(task, false);
        }
    }

    public void createChangeList(@NotNull LocalTask task, String name) {
        if (task == null) {
            TaskManagerImpl.$$$reportNull$$$0(25);
        }
        String comment = TaskUtil.getChangeListComment(task);
        this.createChangeList(task, name, comment);
    }

    private void createChangeList(LocalTask task, String name, @Nullable String comment) {
        ChangeListManager changeListManager = ChangeListManager.getInstance(this.myProject);
        LocalChangeList changeList = changeListManager.findChangeList(name);
        if (changeList == null) {
            changeList = changeListManager.addChangeList(name, comment);
        } else {
            LocalTask associatedTask = this.getAssociatedTask(changeList);
            if (associatedTask != null) {
                associatedTask.removeChangelist(new ChangeListInfo(changeList));
            }
            changeListManager.editComment(name, comment);
        }
        task.addChangelist(new ChangeListInfo(changeList));
        changeListManager.setDefaultChangeList(changeList);
    }

    public String getChangelistName(Task task) {
        String name = TaskUtil.formatTask(task, this.myConfig.changelistNameFormat);
        return StringUtil.shortenTextWithEllipsis((String)(name.isEmpty() ? task.getSummary() : name), (int)100, (int)0);
    }

    @NotNull
    public String suggestBranchName(@NotNull Task task, String separator) {
        String name;
        if (task == null) {
            TaskManagerImpl.$$$reportNull$$$0(26);
        }
        if (!(name = this.constructDefaultBranchName(task)).isEmpty()) {
            String string2 = name.replace(" ", separator);
            if (string2 == null) {
                TaskManagerImpl.$$$reportNull$$$0(27);
            }
            return string2;
        }
        List words2 = StringUtil.getWordsIn((String)task.getSummary());
        String[] strings = ArrayUtilRt.toStringArray((Collection)words2);
        String string3 = StringUtil.join((String[])strings, (int)0, (int)Math.min(2, strings.length), (String)separator);
        if (string3 == null) {
            TaskManagerImpl.$$$reportNull$$$0(28);
        }
        return string3;
    }

    @NotNull
    public String suggestBranchName(@NotNull Task task) {
        if (task == null) {
            TaskManagerImpl.$$$reportNull$$$0(29);
        }
        String string2 = this.suggestBranchName(task, "-");
        if (string2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(30);
        }
        return string2;
    }

    @NotNull
    public String constructDefaultBranchName(@NotNull Task task) {
        if (task == null) {
            TaskManagerImpl.$$$reportNull$$$0(31);
        }
        String string2 = TaskUtil.formatTask(task, this.myConfig.branchNameFormat);
        if (string2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(32);
        }
        return string2;
    }

    @TestOnly
    public ChangeListAdapter getChangeListListener() {
        return this.myChangeListListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 17, 20, 27, 28, 30, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 2: 
            case 16: 
            case 25: 
            case 26: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 27: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/impl/TaskManagerImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "summary";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelfName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelled";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTask";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/impl/TaskManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveTask";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultTask";
                break;
            }
            case 27: 
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestBranchName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "constructDefaultBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRepositories";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTaskListener";
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 27: 
            case 28: 
            case 30: 
            case 32: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIssues";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateIssue";
                break;
            }
            case 9: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addTask";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLocalTask";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "activateTask";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shelveChanges";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadRepositories";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIssuesFromRepositories";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isLocallyClosed";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedTask";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "trackContext";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createChangeList";
                break;
            }
            case 26: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "suggestBranchName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "constructDefaultBranchName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6, 17, 20, 27, 28, 30, 32 -> new IllegalStateException(string2);
        };
    }

    public static class Config {
        @Property(surroundWithTag=false)
        @XCollection(elementName="task")
        public List<LocalTaskImpl> tasks = new ArrayList<LocalTaskImpl>();
        public int localTasksCounter = 1;
        @ReportValue
        public int taskHistoryLength = 50;
        public boolean updateEnabled = true;
        @ReportValue
        public int updateInterval = 20;
        @ReportValue
        public int updateIssuesCount = 100;
        public boolean clearContext = true;
        public boolean createChangelist = true;
        public boolean createBranch = true;
        public boolean useBranch = false;
        public boolean shelveChanges = false;
        public boolean commitChanges = true;
        public boolean mergeBranch = true;
        public boolean saveContextOnCommit = true;
        public boolean trackContextForNewChangelist = false;
        public String changelistNameFormat = "${id} ${summary}";
        public String branchNameFormat = "${id}";
        public boolean searchClosedTasks = false;
        @Tag(value="servers")
        public Element servers = new Element("servers");
    }

    private abstract class TestConnectionTask
    extends Task.Modal {
        protected Exception myException;
        @Nullable
        protected TaskRepository.CancellableConnection myConnection;

        TestConnectionTask(String title) {
            super(TaskManagerImpl.this.myProject, title, true);
        }

        public void onCancel() {
            if (this.myConnection != null) {
                this.myConnection.cancel();
            }
        }
    }
}

