/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.diff.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.swagger.core.SwSpecificationDetectionKt;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.diff.actions.ComputeSwaggerDiffActionBase;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001e\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/swagger/core/diff/actions/ComputeDiffBetweenPhysicalFilesAction;", "Lcom/intellij/swagger/core/diff/actions/ComputeSwaggerDiffActionBase;", "<init>", "()V", "isAvailable", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "collectSpecifications", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiFile;", "collectSelectedFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.swagger.core"})
public final class ComputeDiffBetweenPhysicalFilesAction
extends ComputeSwaggerDiffActionBase {
    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        Pair<VirtualFile, VirtualFile> pair = this.collectSelectedFiles(e);
        if (pair == null) {
            return false;
        }
        Pair<VirtualFile, VirtualFile> pair2 = pair;
        VirtualFile original = (VirtualFile)pair2.component1();
        VirtualFile modified = (VirtualFile)pair2.component2();
        SwSpecificationType originalKind = SwSpecificationDetectionKt.detectSpecificationType(original, project2);
        SwSpecificationType modifiedKind = SwSpecificationDetectionKt.detectSpecificationType(modified, project2);
        return !(originalKind instanceof SwSpecificationType.NONE) && originalKind instanceof SwSpecificationType.SwaggerLikeRestAPI && Intrinsics.areEqual((Object)modifiedKind, (Object)originalKind);
    }

    @Override
    @Nullable
    protected Pair<PsiFile, PsiFile> collectSpecifications(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Pair<VirtualFile, VirtualFile> pair = this.collectSelectedFiles(e);
        if (pair == null) {
            return null;
        }
        Pair<VirtualFile, VirtualFile> pair2 = pair;
        VirtualFile original = (VirtualFile)pair2.component1();
        VirtualFile modified = (VirtualFile)pair2.component2();
        PsiFile psiFile = (PsiFile)ActionsKt.runReadAction(() -> ComputeDiffBetweenPhysicalFilesAction.collectSpecifications$lambda$0(project2, original));
        if (psiFile == null) {
            return null;
        }
        PsiFile originalPsi = psiFile;
        PsiFile psiFile2 = (PsiFile)ActionsKt.runReadAction(() -> ComputeDiffBetweenPhysicalFilesAction.collectSpecifications$lambda$1(project2, modified));
        if (psiFile2 == null) {
            return null;
        }
        PsiFile modifiedPsi = psiFile2;
        return TuplesKt.to((Object)originalPsi, (Object)modifiedPsi);
    }

    private final Pair<VirtualFile, VirtualFile> collectSelectedFiles(AnActionEvent e) {
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return null;
        }
        VirtualFile[] selectedFiles = virtualFileArray;
        if (selectedFiles.length != 2) {
            return null;
        }
        return TuplesKt.to((Object)selectedFiles[0], (Object)selectedFiles[1]);
    }

    private static final PsiFile collectSpecifications$lambda$0(Project $project, VirtualFile $original) {
        return PsiManager.getInstance((Project)$project).findFile($original);
    }

    private static final PsiFile collectSpecifications$lambda$1(Project $project, VirtualFile $modified) {
        return PsiManager.getInstance((Project)$project).findFile($modified);
    }
}

