/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.summaries;

import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.impl.providers.ProviderType;
import com.intellij.rml.dfa.impl.providers.RMLMutableInstancesProvider;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.repositories.MutableRelationsRepository;
import com.intellij.rml.dfa.impl.symtable.MutableSymbolTable;
import com.intellij.rml.dfa.impl.symtable.SymbolTableWithDependencies;
import com.intellij.rml.dfa.impl.visitors.Visitor;
import com.intellij.rml.dfa.utils.Cancellation;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J&\u0010\u001a\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00052\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/rml/dfa/impl/summaries/MigrateToSummariesVisitor;", "Lcom/intellij/rml/dfa/impl/visitors/Visitor;", "localProvider", "Lcom/intellij/rml/dfa/impl/providers/RMLMutableInstancesProvider;", "summaryRelations", "", "", "<init>", "(Lcom/intellij/rml/dfa/impl/providers/RMLMutableInstancesProvider;Ljava/util/List;)V", "name", "getName", "()Ljava/lang/String;", "outputRelations", "", "Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "getOutputRelations", "()[Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "[Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "collectAttributes", "", "input", "Lcom/intellij/rml/dfa/attributes/DfaTuple;", "symbolTable", "Lcom/intellij/rml/dfa/impl/symtable/MutableSymbolTable;", "cancellation", "Lcom/intellij/rml/dfa/utils/Cancellation;", "collectRelations", "provider", "intellij.rml.dfa.impl"})
public class MigrateToSummariesVisitor
implements Visitor {
    @NotNull
    private final RMLMutableInstancesProvider localProvider;
    @NotNull
    private final List<String> summaryRelations;
    @NotNull
    private final String name;
    @NotNull
    private final RelationSignature[] outputRelations;

    public MigrateToSummariesVisitor(@NotNull RMLMutableInstancesProvider localProvider, @NotNull List<String> summaryRelations) {
        Intrinsics.checkNotNullParameter((Object)localProvider, (String)"localProvider");
        Intrinsics.checkNotNullParameter(summaryRelations, (String)"summaryRelations");
        this.localProvider = localProvider;
        this.summaryRelations = summaryRelations;
        this.name = "Summary collector";
        this.outputRelations = new RelationSignature[0];
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public RelationSignature[] getOutputRelations() {
        return this.outputRelations;
    }

    @Override
    public void collectAttributes(@NotNull List<DfaTuple> input, @NotNull MutableSymbolTable symbolTable, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        SymbolTableWithDependencies cfr_ignored_0 = (SymbolTableWithDependencies)symbolTable;
        MutableRelationsRepository mutableRelationsRepository = this.localProvider.getRelationsRepository();
        Intrinsics.checkNotNullExpressionValue((Object)mutableRelationsRepository, (String)"<get-relationsRepository>(...)");
        MutableRelationsRepository repository = mutableRelationsRepository;
        for (String relationName : this.summaryRelations) {
            IRelation relation;
            Object nameWithSuffix = this.summaryRelations.contains(relationName) ? relationName + "$Summary" : relationName;
            if (!repository.containsRelation((String)nameWithSuffix)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)repository.getRelation((String)nameWithSuffix), (String)"getRelation(...)");
            relation.copyAttributes(relationName, this.localProvider.getSymbolTable(), symbolTable);
        }
    }

    @Override
    public void collectRelations(@NotNull List<DfaTuple> input, @NotNull RMLMutableInstancesProvider provider, @NotNull Cancellation cancellation) {
        boolean isGlobalSummary;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        MutableRelationsRepository mutableRelationsRepository = this.localProvider.getRelationsRepository();
        Intrinsics.checkNotNullExpressionValue((Object)mutableRelationsRepository, (String)"<get-relationsRepository>(...)");
        MutableRelationsRepository repository = mutableRelationsRepository;
        MutableSymbolTable mutableSymbolTable = provider.getSymbolTable();
        Intrinsics.checkNotNullExpressionValue((Object)mutableSymbolTable, (String)"<get-symbolTable>(...)");
        MutableSymbolTable symbolTable = mutableSymbolTable;
        boolean bl = isGlobalSummary = provider.getDescriptor().getType() == ProviderType.GlobalSummary;
        if (!isGlobalSummary && symbolTable instanceof SymbolTableWithDependencies) {
            ((SymbolTableWithDependencies)symbolTable).buildMapRelation(this.localProvider, repository.getRelationsManager(), provider, null, cancellation);
        }
        for (String relationName : this.summaryRelations) {
            String nameWithSuffix = relationName + "$Summary";
            if (!repository.containsRelation(nameWithSuffix)) continue;
            IRelation iRelation = repository.getRelation(nameWithSuffix);
            Intrinsics.checkNotNullExpressionValue((Object)iRelation, (String)"getRelation(...)");
            IRelation relation = iRelation;
            relation = relation.migrate(repository.getRelationsManager(), provider.getRelationsManager(), this.localProvider.getSymbolTable(), symbolTable, !isGlobalSummary, cancellation);
            if (provider.getRelationsRepository().containsRelation(relationName)) {
                relation = relation.unsafeUnite(provider.getRelationsRepository().getRelation(relationName), cancellation);
            }
            provider.getRelationsRepository().addRelation(relationName, relation);
        }
        if (symbolTable instanceof SymbolTableWithDependencies) {
            ((SymbolTableWithDependencies)symbolTable).cleanup();
        }
    }
}

